/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class AliconaReader
extends FormatReader {
    private int textureOffset;
    private int numBytes;

    public AliconaReader() {
        super("Alicona AL3D", "al3d");
        this.blockCheckLen = 16;
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readString(this.blockCheckLen).indexOf("Alicona") != -1;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int pad = (8 - this.getSizeX() % 8) % 8;
        int planeSize = (this.getSizeX() + pad) * this.getSizeY();
        for (int i = 0; i < this.numBytes; ++i) {
            this.in.seek(this.textureOffset + no * planeSize * (i + 1));
            if (this.getSizeX() == w) {
                this.in.read(buf, i * w * h, w * h);
                continue;
            }
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x);
                this.in.read(buf, i * w * h + row * w, w);
                this.in.skipBytes(this.getSizeX() + pad - x - w);
            }
        }
        if (this.numBytes > 1) {
            byte[] tmp = new byte[buf.length];
            for (int i = 0; i < planeSize; ++i) {
                for (int j = 0; j < this.numBytes; ++j) {
                    tmp[i * this.numBytes + j] = buf[planeSize * j + i];
                }
            }
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
            tmp = null;
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.numBytes = 0;
        this.textureOffset = 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("AliconaReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying Alicona format");
        String magicString = this.in.readString(17);
        if (!magicString.trim().equals("AliconaImaging")) {
            throw new FormatException("Invalid magic string : expected 'AliconaImaging', got " + magicString);
        }
        this.status("Reading tags");
        int count = 2;
        boolean hasC = false;
        String voltage = null;
        String magnification = null;
        String workingDistance = null;
        String pntX = null;
        String pntY = null;
        for (int i = 0; i < count; ++i) {
            String key = this.in.readString(20).trim();
            String value = this.in.readString(30).trim();
            this.addMeta(key, value);
            this.in.skipBytes(2);
            if (key.equals("TagCount")) {
                count += Integer.parseInt(value);
                continue;
            }
            if (key.equals("Rows")) {
                this.core[0].sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("Cols")) {
                this.core[0].sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("NumberOfPlanes")) {
                this.core[0].imageCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TextureImageOffset")) {
                this.textureOffset = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TexturePtr") && !value.equals("7")) {
                hasC = true;
                continue;
            }
            if (key.equals("Voltage")) {
                voltage = value;
                continue;
            }
            if (key.equals("Magnification")) {
                magnification = value;
                continue;
            }
            if (key.equals("PixelSizeXMeter")) {
                pntX = value;
                continue;
            }
            if (key.equals("PixelSizeYMeter")) {
                pntY = value;
                continue;
            }
            if (!key.equals("WorkingDistance")) continue;
            workingDistance = value;
        }
        this.status("Populating metadata");
        this.numBytes = (int)(this.in.length() - (long)this.textureOffset) / (this.getSizeX() * this.getSizeY() * this.getImageCount());
        this.core[0].sizeC = hasC ? 3 : 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.getImageCount() / this.getSizeC();
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = true;
        this.core[0].pixelType = this.numBytes == 2 ? 3 : 1;
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setImageName("", 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        if (voltage != null) {
            store.setDetectorSettingsVoltage(new Float(voltage), 0, 0);
            store.setDetectorID("Detector:0", 0, 0);
            store.setDetectorSettingsDetector("Detector:0", 0, 0);
        }
        if (magnification != null) {
            store.setObjectiveCalibratedMagnification(new Float(magnification), 0, 0);
        }
        if (workingDistance != null) {
            store.setObjectiveWorkingDistance(new Float(workingDistance), 0, 0);
        }
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
        if (pntX != null && pntY != null) {
            float pixelSizeX = Float.parseFloat(pntX) / 1000000.0f;
            float pixelSizeY = Float.parseFloat(pntY) / 1000000.0f;
            store.setDimensionsPhysicalSizeX(new Float(pixelSizeX), 0, 0);
            store.setDimensionsPhysicalSizeY(new Float(pixelSizeY), 0, 0);
        }
    }
}

