/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FlexReader
extends BaseTiffReader {
    protected static final int FLEX = 65200;
    protected double[] factors;
    private int binX;
    private int binY;

    public FlexReader() {
        super("Evotec Flex", "flex");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int nBytes = TiffTools.getBitsPerSample(this.ifds[no])[0] / 8;
        byte[] bytes = super.openBytes(no, buf, x, y, w, h);
        if (this.getPixelType() == 1) {
            int num = bytes.length;
            for (int i = num - 1; i >= 0; --i) {
                int q = (int)((double)(bytes[i] & 0xFF) * this.factors[no]);
                bytes[i] = (byte)(q & 0xFF);
            }
        } else if (this.getPixelType() == 3) {
            int num = bytes.length / 2;
            for (int i = num - 1; i >= 0; --i) {
                int q = nBytes == 1 ? (int)((double)(bytes[i] & 0xFF) * this.factors[no]) : (int)((double)DataTools.bytesToInt(bytes, i * 2, 2, this.isLittleEndian()) * this.factors[no]);
                DataTools.unpackBytes(q, bytes, i * 2, 2, this.isLittleEndian());
            }
        } else if (this.getPixelType() == 5) {
            int num = bytes.length / 4;
            for (int i = num - 1; i >= 0; --i) {
                int q = nBytes == 1 ? (int)((double)(bytes[i] & 0xFF) * this.factors[no]) : (int)((double)DataTools.bytesToInt(bytes, i * 4, nBytes, this.isLittleEndian()) * this.factors[no]);
                DataTools.unpackBytes(q, bytes, i * 4, 4, this.isLittleEndian());
            }
        }
        System.arraycopy(bytes, 0, buf, 0, bytes.length);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.factors = null;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        this.core[0].orderCertain = false;
        String xml = (String)TiffTools.getIFDValue(this.ifds[0], 65200, true, String.class);
        byte[] c = xml.getBytes();
        for (int i2 = 0; i2 < c.length; ++i2) {
            if (c[i2] <= 126 && (c[i2] == 9 || c[i2] >= 32)) continue;
            c[i2] = 32;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        store.setInstrumentID("Instrument:0", 0);
        Vector n = new Vector();
        Vector f = new Vector();
        FlexHandler handler = new FlexHandler(n, f, store);
        DataTools.parseXML(c, (DefaultHandler)handler);
        int nsize = n.size();
        int fsize = f.size();
        if (debug && (nsize != fsize || nsize != this.getImageCount())) {
            LogTools.println("Warning: mismatch between image count, names and factors (count=" + this.getImageCount() + ", names=" + nsize + ", factors=" + fsize + ")");
        }
        for (i = 0; i < nsize; ++i) {
            this.addMeta("Name " + i, n.get(i));
        }
        for (i = 0; i < fsize; ++i) {
            this.addMeta("Factor " + i, f.get(i));
        }
        this.factors = new double[this.getImageCount()];
        int max = 0;
        for (int i3 = 0; i3 < fsize; ++i3) {
            double q;
            block10: {
                String factor = (String)f.get(i3);
                q = 1.0;
                try {
                    q = Double.parseDouble(factor);
                }
                catch (NumberFormatException exc) {
                    if (!debug) break block10;
                    LogTools.println("Warning: invalid factor #" + i3 + ": " + factor);
                }
            }
            this.factors[i3] = q;
            if (!(q > this.factors[max])) continue;
            max = i3;
        }
        Arrays.fill(this.factors, fsize, this.factors.length, 1.0);
        if (this.factors[max] > 256.0) {
            this.core[0].pixelType = 5;
        } else if (this.factors[max] > 1.0) {
            this.core[0].pixelType = 3;
        }
    }

    public class FlexHandler
    extends DefaultHandler {
        private Vector names;
        private Vector factors;
        private MetadataStore store;
        private int nextLightSource = 0;
        private int nextLaser = -1;
        private int nextArrayImage = 0;
        private int nextSlider = 0;
        private int nextFilter = 0;
        private int nextCamera = 0;
        private int nextObjective = -1;
        private int nextSublayout = 0;
        private int nextField = 0;
        private int nextStack = 0;
        private int nextPlane = 0;
        private int nextKinetic = 0;
        private int nextDispensing = 0;
        private int nextImage = 0;
        private int nextLightSourceCombination = 0;
        private int nextLightSourceRef = 0;
        private int nextPlate = 0;
        private int nextWell = 0;
        private int nextSliderRef = 0;
        private int nextFilterCombination = 0;
        private String parentQName;
        private String currentQName;

        public FlexHandler(Vector names, Vector factors, MetadataStore store) {
            this.names = names;
            this.factors = factors;
            this.store = store;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentQName.equals("PlateName")) {
                this.store.setPlateName(value, this.nextPlate - 1);
                FlexReader.this.addMeta("Plate " + (this.nextPlate - 1) + " Name", value);
            } else if (this.parentQName.equals("Plate")) {
                FlexReader.this.addMeta("Plate " + (this.nextPlate - 1) + " " + this.currentQName, value);
            } else if (this.parentQName.equals("WellShape")) {
                FlexReader.this.addMeta("Plate " + (this.nextPlate - 1) + " WellShape " + this.currentQName, value);
            } else if (this.currentQName.equals("Wavelength")) {
                this.store.setLaserWavelength(new Integer(value), 0, this.nextLaser);
                FlexReader.this.addMeta("Laser " + this.nextLaser + " Wavelength", value);
            } else if (this.currentQName.equals("Magnification")) {
                this.store.setObjectiveCalibratedMagnification(new Float(value), 0, this.nextObjective);
            } else if (this.currentQName.equals("NumAperture")) {
                this.store.setObjectiveLensNA(new Float(value), 0, this.nextObjective);
            } else if (this.currentQName.equals("Immersion")) {
                this.store.setObjectiveImmersion(value, 0, this.nextObjective);
            } else if (this.currentQName.equals("OffsetX") || this.currentQName.equals("OffsetY")) {
                FlexReader.this.addMeta("Sublayout " + (this.nextSublayout - 1) + " Field " + (this.nextField - 1) + " " + this.currentQName, value);
            } else if (this.currentQName.equals("OffsetZ")) {
                FlexReader.this.addMeta("Stack " + (this.nextStack - 1) + " Plane " + (this.nextPlane - 1) + " OffsetZ", value);
            } else if (this.currentQName.equals("Power")) {
                FlexReader.this.addMeta("LightSourceCombination " + (this.nextLightSourceCombination - 1) + " LightSourceRef " + (this.nextLightSourceRef - 1) + " Power", value);
            } else if (this.parentQName.equals("Image")) {
                FlexReader.this.addMeta("Image " + (this.nextImage - 1) + " " + this.currentQName, value);
                if (this.currentQName.equals("DateTime")) {
                    this.store.setImageCreationDate(value, this.nextImage - 1);
                } else if (this.currentQName.equals("CameraBinningX")) {
                    FlexReader.this.binX = Integer.parseInt(value);
                } else if (this.currentQName.equals("CameraBinningY")) {
                    FlexReader.this.binY = Integer.parseInt(value);
                }
            } else if (this.parentQName.equals("ImageResolutionX")) {
                this.store.setDimensionsPhysicalSizeX(new Float(value), this.nextImage - 1, 0);
            } else if (this.parentQName.equals("ImageResolutionY")) {
                this.store.setDimensionsPhysicalSizeX(new Float(value), this.nextImage - 1, 0);
            } else if (this.parentQName.equals("Well")) {
                FlexReader.this.addMeta("Well " + (this.nextWell - 1) + " " + this.currentQName, value);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            block30: {
                block48: {
                    block49: {
                        block47: {
                            block46: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block42: {
                                                block41: {
                                                    block40: {
                                                        block39: {
                                                            block38: {
                                                                block37: {
                                                                    block36: {
                                                                        block35: {
                                                                            block34: {
                                                                                block33: {
                                                                                    block32: {
                                                                                        block31: {
                                                                                            block29: {
                                                                                                this.currentQName = qName;
                                                                                                if (!qName.equals("Array")) break block29;
                                                                                                int len = attributes.getLength();
                                                                                                for (int i = 0; i < len; ++i) {
                                                                                                    String name = attributes.getQName(i);
                                                                                                    if (name.equals("Name")) {
                                                                                                        this.names.add(attributes.getValue(i));
                                                                                                        this.store.setImageName(attributes.getValue(i), this.nextArrayImage);
                                                                                                        continue;
                                                                                                    }
                                                                                                    if (name.equals("Factor")) {
                                                                                                        this.factors.add(attributes.getValue(i));
                                                                                                        continue;
                                                                                                    }
                                                                                                    if (!name.equals("Description")) continue;
                                                                                                    this.store.setImageDescription(attributes.getValue(i), this.nextArrayImage++);
                                                                                                }
                                                                                                break block30;
                                                                                            }
                                                                                            if (!qName.equals("LightSource")) break block31;
                                                                                            this.parentQName = qName;
                                                                                            String id = attributes.getValue("ID");
                                                                                            String type = attributes.getValue("LightSourceType");
                                                                                            FlexReader.this.addMeta("LightSource " + this.nextLightSource + " ID", id);
                                                                                            FlexReader.this.addMeta("LightSource " + this.nextLightSource + " Type", type);
                                                                                            if (type.equals("Laser")) {
                                                                                                ++this.nextLaser;
                                                                                            }
                                                                                            ++this.nextLightSource;
                                                                                            break block30;
                                                                                        }
                                                                                        if (!qName.equals("Slider")) break block32;
                                                                                        this.parentQName = qName;
                                                                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                            FlexReader.this.addMeta("Slider " + this.nextSlider + " " + attributes.getQName(i), attributes.getValue(i));
                                                                                        }
                                                                                        ++this.nextSlider;
                                                                                        break block30;
                                                                                    }
                                                                                    if (!qName.equals("Filter")) break block33;
                                                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                        FlexReader.this.addMeta("Filter " + this.nextFilter + " " + attributes.getQName(i), attributes.getValue(i));
                                                                                    }
                                                                                    ++this.nextFilter;
                                                                                    break block30;
                                                                                }
                                                                                if (!qName.equals("Camera")) break block34;
                                                                                this.parentQName = qName;
                                                                                for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                    FlexReader.this.addMeta("Camera " + this.nextCamera + " " + attributes.getQName(i), attributes.getValue(i));
                                                                                }
                                                                                ++this.nextCamera;
                                                                                break block30;
                                                                            }
                                                                            if (!qName.startsWith("PixelSize") || !this.parentQName.equals("Camera")) break block35;
                                                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                FlexReader.this.addMeta("Camera " + (this.nextCamera - 1) + " " + qName + " " + attributes.getQName(i), attributes.getValue(i));
                                                                            }
                                                                            break block30;
                                                                        }
                                                                        if (!qName.equals("Objective")) break block36;
                                                                        this.parentQName = qName;
                                                                        ++this.nextObjective;
                                                                        this.store.setObjectiveID("Objective:" + this.nextObjective, 0, 0);
                                                                        this.store.setObjectiveSettingsObjective("Objective:" + this.nextObjective, 0);
                                                                        break block30;
                                                                    }
                                                                    if (!qName.equals("Sublayout")) break block37;
                                                                    this.parentQName = qName;
                                                                    this.nextField = 0;
                                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                                        FlexReader.this.addMeta("Sublayout " + this.nextSublayout + " " + attributes.getQName(i), attributes.getValue(i));
                                                                    }
                                                                    ++this.nextSublayout;
                                                                    break block30;
                                                                }
                                                                if (!qName.equals("Field")) break block38;
                                                                this.parentQName = qName;
                                                                for (int i = 0; i < attributes.getLength(); ++i) {
                                                                    FlexReader.this.addMeta("Sublayout " + (this.nextSublayout - 1) + " Field " + this.nextField + " " + attributes.getQName(i), attributes.getValue(i));
                                                                }
                                                                ++this.nextField;
                                                                break block30;
                                                            }
                                                            if (!qName.equals("Stack")) break block39;
                                                            this.nextPlane = 0;
                                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                                FlexReader.this.addMeta("Stack " + this.nextStack + " " + attributes.getQName(i), attributes.getValue(i));
                                                            }
                                                            ++this.nextStack;
                                                            break block30;
                                                        }
                                                        if (!qName.equals("Plane")) break block40;
                                                        this.parentQName = qName;
                                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                                            FlexReader.this.addMeta("Stack " + (this.nextStack - 1) + " Plane " + this.nextPlane + " " + attributes.getQName(i), attributes.getValue(i));
                                                        }
                                                        ++this.nextPlane;
                                                        break block30;
                                                    }
                                                    if (!qName.equals("Kinetic")) break block41;
                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                        FlexReader.this.addMeta("Kinetic " + this.nextKinetic + " " + attributes.getQName(i), attributes.getValue(i));
                                                    }
                                                    ++this.nextKinetic;
                                                    break block30;
                                                }
                                                if (!qName.equals("Dispensing")) break block42;
                                                for (int i = 0; i < attributes.getLength(); ++i) {
                                                    FlexReader.this.addMeta("Dispensing " + this.nextDispensing + " " + attributes.getQName(i), attributes.getValue(i));
                                                }
                                                ++this.nextDispensing;
                                                break block30;
                                            }
                                            if (!qName.equals("LightSourceCombination")) break block43;
                                            this.nextLightSourceRef = 0;
                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                FlexReader.this.addMeta("LightSourceCombination " + this.nextLightSourceCombination + " " + attributes.getQName(i), attributes.getValue(i));
                                            }
                                            ++this.nextLightSourceCombination;
                                            break block30;
                                        }
                                        if (!qName.equals("LightSourceRef")) break block44;
                                        this.parentQName = qName;
                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                            FlexReader.this.addMeta("LightSourceCombination " + (this.nextLightSourceCombination - 1) + " LightSourceRef " + this.nextLightSourceRef + " " + attributes.getQName(i), attributes.getValue(i));
                                        }
                                        ++this.nextLightSourceRef;
                                        break block30;
                                    }
                                    if (!qName.equals("FilterCombination")) break block45;
                                    this.parentQName = qName;
                                    this.nextSliderRef = 0;
                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                        FlexReader.this.addMeta("FilterCombination " + this.nextFilterCombination + " " + attributes.getQName(i), attributes.getValue(i));
                                    }
                                    ++this.nextFilterCombination;
                                    break block30;
                                }
                                if (!qName.equals("SliderRef")) break block46;
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    FlexReader.this.addMeta("FilterCombination " + (this.nextFilterCombination - 1) + " SliderRef " + this.nextSliderRef + " " + attributes.getQName(i), attributes.getValue(i));
                                }
                                ++this.nextSliderRef;
                                break block30;
                            }
                            if (!qName.equals("Image")) break block47;
                            this.parentQName = qName;
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                FlexReader.this.addMeta("Image " + this.nextImage + " " + attributes.getQName(i), attributes.getValue(i));
                            }
                            this.store.setImageInstrumentRef("Instrument:0", this.nextImage);
                            ++this.nextImage;
                            String x = attributes.getValue("CameraBinningX");
                            String y = attributes.getValue("CameraBinningY");
                            if (x != null) {
                                FlexReader.this.binX = Integer.parseInt(x);
                            }
                            if (y == null) break block30;
                            FlexReader.this.binY = Integer.parseInt(y);
                            break block30;
                        }
                        if (!qName.equals("Plate") && !qName.equals("WellShape") && !qName.equals("Well")) break block48;
                        this.parentQName = qName;
                        if (!qName.equals("Plate")) break block49;
                        ++this.nextPlate;
                        break block30;
                    }
                    if (!qName.equals("Well")) break block30;
                    ++this.nextWell;
                    break block30;
                }
                if (qName.equals("WellCoordinate")) {
                    int ndx = this.nextWell - 1;
                    FlexReader.this.addMeta("Well" + ndx + " Row", attributes.getValue("Row"));
                    FlexReader.this.addMeta("Well" + ndx + " Col", attributes.getValue("Col"));
                    this.store.setWellRow(new Integer(attributes.getValue("Row")), 0, ndx);
                    this.store.setWellColumn(new Integer(attributes.getValue("Col")), 0, ndx);
                } else if (qName.equals("Status")) {
                    FlexReader.this.addMeta("Status", attributes.getValue("StatusString"));
                } else if (qName.equals("ImageResolutionX")) {
                    this.parentQName = qName;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                    }
                } else if (qName.equals("ImageResolutionY")) {
                    this.parentQName = qName;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                    }
                }
            }
        }
    }
}

