/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class KhorosReader
extends FormatReader {
    private byte[] lut;
    private long offset;

    public KhorosReader() {
        super("Khoros XV", "xv");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readShort() == 43777;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null) {
            return null;
        }
        byte[][] table = new byte[3][this.lut.length / 3];
        int next = 0;
        for (int i = 0; i < table[0].length; ++i) {
            for (int j = 0; j < table.length; ++j) {
                table[j][i] = this.lut[next++];
            }
        }
        return table;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int bufSize = this.getSizeX() * this.getSizeY() * bytes;
        this.in.seek(this.offset + (long)(no * bufSize));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.lut = null;
        this.offset = 0L;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.skipBytes(4);
        this.in.order(true);
        int dependency = this.in.readInt();
        this.addMeta("Comment", this.in.readString(512));
        this.in.order(dependency == 4 || dependency == 8);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.in.skipBytes(28);
        this.core[0].imageCount = this.in.readInt();
        if (this.getImageCount() == 0) {
            this.core[0].imageCount = 1;
        }
        this.core[0].sizeC = this.in.readInt();
        int type = this.in.readInt();
        switch (type) {
            case 0: {
                this.core[0].pixelType = 0;
                break;
            }
            case 1: {
                this.core[0].pixelType = 1;
                break;
            }
            case 2: {
                this.core[0].pixelType = 3;
                break;
            }
            case 4: {
                this.core[0].pixelType = 4;
                break;
            }
            case 5: {
                this.core[0].pixelType = 6;
                break;
            }
            case 9: {
                this.core[0].pixelType = 7;
                break;
            }
            default: {
                throw new FormatException("Unsupported pixel type : " + type);
            }
        }
        this.in.skipBytes(12);
        int c = this.in.readInt();
        if (c > 1) {
            this.core[0].sizeC = c;
            int n = this.in.readInt();
            this.lut = new byte[n * c];
            this.in.skipBytes(436);
            for (int i = 0; i < this.lut.length; ++i) {
                int value = this.in.read();
                if (i < n) {
                    this.lut[i * 3] = (byte)value;
                    this.lut[i * 3 + 1] = (byte)value;
                    this.lut[i * 3 + 2] = (byte)value;
                    continue;
                }
                if (i < n * 2) {
                    this.lut[i % n * 3 + 1] = (byte)value;
                    continue;
                }
                if (i >= n * 3) continue;
                this.lut[i % n * 3 + 2] = (byte)value;
            }
        } else {
            this.in.skipBytes(440);
        }
        this.offset = this.in.getFilePointer();
        this.core[0].sizeZ = this.getImageCount();
        this.core[0].sizeT = 1;
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = dependency == 4 || dependency == 8;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].indexed = this.lut != null;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

