/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class NAFReader
extends FormatReader {
    private static final int LUT_SIZE = 263168;
    private long[] offsets;
    private boolean compressed;

    public NAFReader() {
        super("Hamamatsu Aquacosmos", "naf");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return true;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        if (this.in.getFilePointer() + (long)buf.length > this.in.length()) {
            throw new FormatException("Sorry, compressed data is not supported.");
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int plane = this.getSizeX() * this.getSizeY() * bpp;
        this.in.seek(this.offsets[this.series] + (long)(no * plane));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("NAFReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        String endian = this.in.readString(2);
        boolean little = endian.equals("II");
        this.in.order(little);
        this.in.seek(98L);
        int seriesCount = this.in.readInt();
        this.in.seek(192L);
        while (this.in.read() == 0) {
        }
        this.in.readCString();
        while (this.in.readInt() == 0) {
        }
        long fp = this.in.getFilePointer();
        fp = fp % 2L == 0L ? (fp -= 4L) : --fp;
        this.offsets = new long[seriesCount];
        this.core = new CoreMetadata[seriesCount];
        for (int i = 0; i < seriesCount; ++i) {
            int numBits;
            block17: {
                this.in.seek(fp + (long)(i * 256));
                this.core[i] = new CoreMetadata();
                this.core[i].littleEndian = little;
                this.core[i].sizeX = this.in.readInt();
                this.core[i].sizeY = this.in.readInt();
                numBits = this.in.readInt();
                this.core[i].sizeC = this.in.readInt();
                this.core[i].sizeZ = this.in.readInt();
                this.core[i].sizeT = this.in.readInt();
                this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeC * this.core[i].sizeT;
                switch (numBits) {
                    case 8: {
                        this.core[i].pixelType = 1;
                        break;
                    }
                    case 16: {
                        this.core[i].pixelType = 3;
                        break;
                    }
                    case 32: {
                        this.core[i].pixelType = 5;
                        break;
                    }
                    case 64: {
                        this.core[i].pixelType = 7;
                    }
                }
                this.core[i].dimensionOrder = "XYCZT";
                this.core[i].rgb = false;
                this.in.skipBytes(4);
                long pointer = this.in.getFilePointer();
                String name = this.in.readCString();
                if (i == 0) {
                    this.in.skipBytes((int)(92L - this.in.getFilePointer() + pointer));
                    while (true) {
                        int check;
                        if ((long)(check = this.in.readInt()) > this.in.getFilePointer()) {
                            this.offsets[i] = (long)check + 263168L;
                            break block17;
                        }
                        this.in.skipBytes(92);
                    }
                }
                this.offsets[i] = this.offsets[i - 1] + (long)(this.core[i - 1].sizeX * this.core[i - 1].sizeY * this.core[i - 1].imageCount * FormatTools.getBytesPerPixel(this.core[i - 1].pixelType));
            }
            int n = i;
            this.offsets[n] = this.offsets[n] + 352L;
            this.in.seek(this.offsets[i]);
            while (this.in.getFilePointer() + 116L < this.in.length() && this.in.read() == 3 && this.in.read() == 37) {
                this.in.skipBytes(114);
                this.offsets[i] = this.in.getFilePointer();
            }
            this.in.seek(this.in.getFilePointer() - 1L);
            byte[] buf = new byte[0x300000];
            int n2 = this.in.read(buf, 0, 1);
            boolean found = false;
            while (!found && this.in.getFilePointer() < this.in.length()) {
                n2 += this.in.read(buf, 1, buf.length - 1);
                for (int q = 0; q < buf.length - 1; ++q) {
                    if ((buf[q] & 0xFF) != 192 || (buf[q + 1] & 0xFF) != 46) continue;
                    this.offsets[i] = this.in.getFilePointer() - (long)n2 + (long)q;
                    found = true;
                    break;
                }
                buf[0] = buf[buf.length - 1];
                n2 = 1;
            }
            if (found) {
                int n3 = i;
                this.offsets[n3] = this.offsets[n3] + 16063L;
            }
            if (i != this.offsets.length - 1 || this.compressed || i <= 0) continue;
            this.offsets[i] = (int)(this.in.length() - (long)(this.core[i].sizeX * this.core[i].sizeY * this.core[i].imageCount * (numBits / 8)));
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

