/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import java.util.Iterator;
import java.util.List;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;

public class AggregateMetadata
implements IMetadata {
    private List delegates;

    public AggregateMetadata(List delegates) {
        this.delegates = delegates;
    }

    public void addDelegate(MetadataStore delegate) {
        this.delegates.add(delegate);
    }

    public void removeDelegate(MetadataStore delegate) {
        this.delegates.remove(delegate);
    }

    public List getDelegates() {
        return this.delegates;
    }

    public int getChannelComponentCount(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelComponentCount(imageIndex, logicalChannelIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getDetectorCount(int instrumentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getExperimentCount() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getExperimenterCount() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getExperimenterMembershipCount(int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterMembershipCount(experimenterIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getGroupRefCount(int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getGroupRefCount(experimenterIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getImageCount() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getInstrumentCount() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getInstrumentCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getLightSourceCount(int instrumentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getLogicalChannelCount(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getOTFCount(int instrumentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getObjectiveCount(int instrumentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPixelsCount(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlaneCount(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneCount(imageIndex, pixelsIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlateCount() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlateRefCount(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateRefCount(screenIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getROICount(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROICount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getReagentCount(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentCount(screenIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getScreenCount() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getScreenAcquisitionCount(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenAcquisitionCount(screenIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getTiffDataCount(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataCount(imageIndex, pixelsIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getWellCount(int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellCount(plateIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getWellSampleCount(int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            int result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleCount(plateIndex, wellIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public String getUUID() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getUUID()) == null) continue;
            return result;
        }
        return null;
    }

    public String getArcType(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcType(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelComponentColorDomain(int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelComponentColorDomain(imageIndex, logicalChannelIndex, channelComponentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getChannelComponentIndex(int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelComponentIndex(imageIndex, logicalChannelIndex, channelComponentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDetectorGain(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorGain(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorID(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorID(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorManufacturer(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorManufacturer(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorModel(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorModel(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDetectorOffset(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorOffset(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorSerialNumber(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSerialNumber(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorType(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorType(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDetectorVoltage(int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorVoltage(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorSettingsBinning(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsBinning(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorSettingsDetector(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsDetector(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDetectorSettingsGain(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsGain(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDetectorSettingsOffset(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsOffset(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDetectorSettingsReadOutRate(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsReadOutRate(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDetectorSettingsVoltage(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsVoltage(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDimensionsPhysicalSizeX(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDimensionsPhysicalSizeX(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDimensionsPhysicalSizeY(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDimensionsPhysicalSizeY(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDimensionsPhysicalSizeZ(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDimensionsPhysicalSizeZ(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDimensionsTimeIncrement(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDimensionsTimeIncrement(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getDimensionsWaveIncrement(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDimensionsWaveIncrement(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getDimensionsWaveStart(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDimensionsWaveStart(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDisplayOptionsID(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDisplayOptionsID(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getDisplayOptionsZoom(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDisplayOptionsZoom(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getDisplayOptionsProjectionZStart(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDisplayOptionsProjectionZStart(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getDisplayOptionsProjectionZStop(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDisplayOptionsProjectionZStop(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getDisplayOptionsTimeTStart(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDisplayOptionsTimeTStart(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getDisplayOptionsTimeTStop(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDisplayOptionsTimeTStop(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimentDescription(int experimentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentDescription(experimentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimentID(int experimentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentID(experimentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimentType(int experimentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentType(experimentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterEmail(int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterEmail(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterFirstName(int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterFirstName(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterID(int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterID(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterInstitution(int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterInstitution(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterLastName(int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterLastName(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterMembershipGroup(int experimenterIndex, int groupRefIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterMembershipGroup(experimenterIndex, groupRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilamentType(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentType(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageCreationDate(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageCreationDate(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageDefaultPixels(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageDefaultPixels(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageDescription(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageDescription(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageID(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageID(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageInstrumentRef(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageInstrumentRef(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageName(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageName(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getImagingEnvironmentAirPressure(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentAirPressure(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getImagingEnvironmentCO2Percent(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentCO2Percent(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getImagingEnvironmentHumidity(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentHumidity(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getImagingEnvironmentTemperature(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentTemperature(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getInstrumentID(int instrumentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getInstrumentID(instrumentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLaserFrequencyMultiplication(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserFrequencyMultiplication(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserLaserMedium(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserLaserMedium(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserPulse(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserPulse(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getLaserTuneable(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Boolean result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserTuneable(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserType(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserType(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLaserWavelength(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserWavelength(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightSourceID(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceID(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightSourceManufacturer(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceManufacturer(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightSourceModel(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceModel(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getLightSourcePower(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourcePower(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightSourceSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceSerialNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getLightSourceSettingsAttenuation(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceSettingsAttenuation(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightSourceSettingsLightSource(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceSettingsLightSource(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLightSourceSettingsWavelength(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceSettingsWavelength(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelContrastMethod(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelContrastMethod(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLogicalChannelEmWave(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelEmWave(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLogicalChannelExWave(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelExWave(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelFluor(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelFluor(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelID(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelID(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelIlluminationType(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelIlluminationType(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelMode(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelMode(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelName(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelName(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getLogicalChannelNdFilter(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelNdFilter(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelOTF(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelOTF(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLogicalChannelPhotometricInterpretation(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelPhotometricInterpretation(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getLogicalChannelPinholeSize(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelPinholeSize(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLogicalChannelPockelCellSetting(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelPockelCellSetting(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLogicalChannelSamplesPerPixel(int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLogicalChannelSamplesPerPixel(imageIndex, logicalChannelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFID(int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFID(instrumentIndex, otfIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFObjective(int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFObjective(instrumentIndex, otfIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getOTFOpticalAxisAveraged(int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Boolean result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFOpticalAxisAveraged(instrumentIndex, otfIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFPixelType(int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFPixelType(instrumentIndex, otfIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getOTFSizeX(int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFSizeX(instrumentIndex, otfIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getOTFSizeY(int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFSizeY(instrumentIndex, otfIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getObjectiveCalibratedMagnification(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveCalibratedMagnification(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveCorrection(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveCorrection(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveID(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveID(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveImmersion(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveImmersion(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getObjectiveIris(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Boolean result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveIris(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getObjectiveLensNA(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveLensNA(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveManufacturer(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveManufacturer(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveModel(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveModel(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getObjectiveNominalMagnification(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveNominalMagnification(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveSerialNumber(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveSerialNumber(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getObjectiveWorkingDistance(int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveWorkingDistance(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getObjectiveSettingsCorrectionCollar(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveSettingsCorrectionCollar(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveSettingsMedium(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveSettingsMedium(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveSettingsObjective(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveSettingsObjective(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getObjectiveSettingsRefractiveIndex(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveSettingsRefractiveIndex(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getPixelsBigEndian(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Boolean result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsBigEndian(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPixelsDimensionOrder(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsDimensionOrder(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPixelsID(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsID(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPixelsPixelType(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsPixelType(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPixelsSizeC(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeC(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPixelsSizeT(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeT(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPixelsSizeX(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeX(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPixelsSizeY(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeY(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPixelsSizeZ(int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeZ(imageIndex, pixelsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPlaneTheC(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTheC(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPlaneTheT(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTheT(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPlaneTheZ(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTheZ(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getPlaneTimingDeltaT(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTimingDeltaT(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getPlaneTimingExposureTime(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTimingExposureTime(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateDescription(int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateDescription(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateExternalIdentifier(int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateExternalIdentifier(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateID(int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateID(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateName(int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateName(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateStatus(int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateStatus(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateRefID(int screenIndex, int plateRefIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateRefID(screenIndex, plateRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getROIID(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIID(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIT0(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIT0(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIT1(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIT1(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIX0(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIX0(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIX1(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIX1(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIY0(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIY0(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIY1(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIY1(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIZ0(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIZ0(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getROIZ1(int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIZ1(imageIndex, roiIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentDescription(int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentDescription(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentID(int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentID(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentName(int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentName(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentReagentIdentifier(int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentReagentIdentifier(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenID(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenID(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenName(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenName(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenProtocolDescription(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenProtocolDescription(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenProtocolIdentifier(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenProtocolIdentifier(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenReagentSetDescription(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenReagentSetDescription(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenType(int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenType(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenAcquisitionEndTime(int screenIndex, int screenAcquisitionIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenAcquisitionEndTime(screenIndex, screenAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenAcquisitionID(int screenIndex, int screenAcquisitionIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenAcquisitionID(screenIndex, screenAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenAcquisitionStartTime(int screenIndex, int screenAcquisitionIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenAcquisitionStartTime(screenIndex, screenAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getStageLabelName(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelName(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getStageLabelX(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelX(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getStageLabelY(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelY(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getStageLabelZ(int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelZ(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getStagePositionPositionX(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStagePositionPositionX(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getStagePositionPositionY(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStagePositionPositionY(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getStagePositionPositionZ(int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStagePositionPositionZ(imageIndex, pixelsIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTiffDataFileName(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataFileName(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getTiffDataFirstC(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataFirstC(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getTiffDataFirstT(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataFirstT(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getTiffDataFirstZ(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataFirstZ(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getTiffDataIFD(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataIFD(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getTiffDataNumPlanes(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataNumPlanes(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTiffDataUUID(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataUUID(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getWellColumn(int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellColumn(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellExternalDescription(int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellExternalDescription(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellExternalIdentifier(int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellExternalIdentifier(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellID(int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellID(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getWellRow(int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellRow(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellType(int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellType(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellSampleID(int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            String result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleID(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getWellSampleIndex(int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleIndex(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getWellSamplePosX(int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSamplePosX(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Float getWellSamplePosY(int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Float result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSamplePosY(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getWellSampleTimepoint(int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            MetadataRetrieve retrieve;
            Integer result;
            Object o = iter.next();
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleTimepoint(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public void createRoot() {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            ((MetadataStore)o).createRoot();
        }
    }

    public Object getRoot() {
        throw new RuntimeException("Unsupported with AggregateMetadata. Use getDelegates() and getRoot().");
    }

    public void setRoot(Object root) {
        throw new RuntimeException("Unsupported with AggregateMetadata. Use getDelegates() and setRoot().");
    }

    public void setUUID(String uuid) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            ((MetadataStore)o).setUUID(uuid);
        }
    }

    public void setArcType(String type, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcType(type, instrumentIndex, lightSourceIndex);
        }
    }

    public void setChannelComponentColorDomain(String colorDomain, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelComponentColorDomain(colorDomain, imageIndex, logicalChannelIndex, channelComponentIndex);
        }
    }

    public void setChannelComponentIndex(Integer index, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelComponentIndex(index, imageIndex, logicalChannelIndex, channelComponentIndex);
        }
    }

    public void setDetectorGain(Float gain, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorGain(gain, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorID(id, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorManufacturer(manufacturer, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorModel(model, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorOffset(Float offset, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorOffset(offset, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSerialNumber(serialNumber, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorType(String type, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorType(type, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorVoltage(Float voltage, int instrumentIndex, int detectorIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorVoltage(voltage, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorSettingsBinning(String binning, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsBinning(binning, imageIndex, logicalChannelIndex);
        }
    }

    public void setDetectorSettingsDetector(String detector, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsDetector(detector, imageIndex, logicalChannelIndex);
        }
    }

    public void setDetectorSettingsGain(Float gain, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsGain(gain, imageIndex, logicalChannelIndex);
        }
    }

    public void setDetectorSettingsOffset(Float offset, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsOffset(offset, imageIndex, logicalChannelIndex);
        }
    }

    public void setDetectorSettingsReadOutRate(Float readOutRate, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsReadOutRate(readOutRate, imageIndex, logicalChannelIndex);
        }
    }

    public void setDetectorSettingsVoltage(Float voltage, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsVoltage(voltage, imageIndex, logicalChannelIndex);
        }
    }

    public void setDimensionsPhysicalSizeX(Float physicalSizeX, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDimensionsPhysicalSizeX(physicalSizeX, imageIndex, pixelsIndex);
        }
    }

    public void setDimensionsPhysicalSizeY(Float physicalSizeY, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDimensionsPhysicalSizeY(physicalSizeY, imageIndex, pixelsIndex);
        }
    }

    public void setDimensionsPhysicalSizeZ(Float physicalSizeZ, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDimensionsPhysicalSizeZ(physicalSizeZ, imageIndex, pixelsIndex);
        }
    }

    public void setDimensionsTimeIncrement(Float timeIncrement, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDimensionsTimeIncrement(timeIncrement, imageIndex, pixelsIndex);
        }
    }

    public void setDimensionsWaveIncrement(Integer waveIncrement, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDimensionsWaveIncrement(waveIncrement, imageIndex, pixelsIndex);
        }
    }

    public void setDimensionsWaveStart(Integer waveStart, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDimensionsWaveStart(waveStart, imageIndex, pixelsIndex);
        }
    }

    public void setDisplayOptionsID(String id, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDisplayOptionsID(id, imageIndex);
        }
    }

    public void setDisplayOptionsZoom(Float zoom, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDisplayOptionsZoom(zoom, imageIndex);
        }
    }

    public void setDisplayOptionsProjectionZStart(Integer zStart, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDisplayOptionsProjectionZStart(zStart, imageIndex);
        }
    }

    public void setDisplayOptionsProjectionZStop(Integer zStop, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDisplayOptionsProjectionZStop(zStop, imageIndex);
        }
    }

    public void setDisplayOptionsTimeTStart(Integer tStart, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDisplayOptionsTimeTStart(tStart, imageIndex);
        }
    }

    public void setDisplayOptionsTimeTStop(Integer tStop, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDisplayOptionsTimeTStop(tStop, imageIndex);
        }
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimentDescription(description, experimentIndex);
        }
    }

    public void setExperimentID(String id, int experimentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimentID(id, experimentIndex);
        }
    }

    public void setExperimentType(String type, int experimentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimentType(type, experimentIndex);
        }
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterEmail(email, experimenterIndex);
        }
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterFirstName(firstName, experimenterIndex);
        }
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterID(id, experimenterIndex);
        }
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterInstitution(institution, experimenterIndex);
        }
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterLastName(lastName, experimenterIndex);
        }
    }

    public void setExperimenterMembershipGroup(String group, int experimenterIndex, int groupRefIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterMembershipGroup(group, experimenterIndex, groupRefIndex);
        }
    }

    public void setFilamentType(String type, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentType(type, instrumentIndex, lightSourceIndex);
        }
    }

    public void setImageCreationDate(String creationDate, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageCreationDate(creationDate, imageIndex);
        }
    }

    public void setImageDefaultPixels(String defaultPixels, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageDefaultPixels(defaultPixels, imageIndex);
        }
    }

    public void setImageDescription(String description, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageDescription(description, imageIndex);
        }
    }

    public void setImageID(String id, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageID(id, imageIndex);
        }
    }

    public void setImageInstrumentRef(String instrumentRef, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageInstrumentRef(instrumentRef, imageIndex);
        }
    }

    public void setImageName(String name, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageName(name, imageIndex);
        }
    }

    public void setImagingEnvironmentAirPressure(Float airPressure, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentAirPressure(airPressure, imageIndex);
        }
    }

    public void setImagingEnvironmentCO2Percent(Float cO2Percent, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentCO2Percent(cO2Percent, imageIndex);
        }
    }

    public void setImagingEnvironmentHumidity(Float humidity, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentHumidity(humidity, imageIndex);
        }
    }

    public void setImagingEnvironmentTemperature(Float temperature, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentTemperature(temperature, imageIndex);
        }
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setInstrumentID(id, instrumentIndex);
        }
    }

    public void setLaserFrequencyMultiplication(Integer frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserFrequencyMultiplication(frequencyMultiplication, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserLaserMedium(String laserMedium, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserLaserMedium(laserMedium, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserPulse(String pulse, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserPulse(pulse, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserTuneable(tuneable, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserType(String type, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserType(type, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserWavelength(Integer wavelength, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserWavelength(wavelength, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightSourceID(String id, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourceID(id, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightSourceManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourceManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightSourceModel(String model, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourceModel(model, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightSourcePower(Float power, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourcePower(power, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightSourceSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourceSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightSourceSettingsAttenuation(Float attenuation, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourceSettingsAttenuation(attenuation, imageIndex, logicalChannelIndex);
        }
    }

    public void setLightSourceSettingsLightSource(String lightSource, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourceSettingsLightSource(lightSource, imageIndex, logicalChannelIndex);
        }
    }

    public void setLightSourceSettingsWavelength(Integer wavelength, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightSourceSettingsWavelength(wavelength, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelContrastMethod(String contrastMethod, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelContrastMethod(contrastMethod, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelEmWave(Integer emWave, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelEmWave(emWave, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelExWave(Integer exWave, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelExWave(exWave, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelFluor(String fluor, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelFluor(fluor, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelID(String id, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelID(id, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelIlluminationType(String illuminationType, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelIlluminationType(illuminationType, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelMode(String mode, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelMode(mode, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelName(String name, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelName(name, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelNdFilter(Float ndFilter, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelNdFilter(ndFilter, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelOTF(String otf, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelOTF(otf, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelPhotometricInterpretation(String photometricInterpretation, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelPhotometricInterpretation(photometricInterpretation, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelPinholeSize(Float pinholeSize, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelPinholeSize(pinholeSize, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelPockelCellSetting(pockelCellSetting, imageIndex, logicalChannelIndex);
        }
    }

    public void setLogicalChannelSamplesPerPixel(Integer samplesPerPixel, int imageIndex, int logicalChannelIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLogicalChannelSamplesPerPixel(samplesPerPixel, imageIndex, logicalChannelIndex);
        }
    }

    public void setOTFID(String id, int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFID(id, instrumentIndex, otfIndex);
        }
    }

    public void setOTFObjective(String objective, int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFObjective(objective, instrumentIndex, otfIndex);
        }
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFOpticalAxisAveraged(opticalAxisAveraged, instrumentIndex, otfIndex);
        }
    }

    public void setOTFPixelType(String pixelType, int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFPixelType(pixelType, instrumentIndex, otfIndex);
        }
    }

    public void setOTFSizeX(Integer sizeX, int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFSizeX(sizeX, instrumentIndex, otfIndex);
        }
    }

    public void setOTFSizeY(Integer sizeY, int instrumentIndex, int otfIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFSizeY(sizeY, instrumentIndex, otfIndex);
        }
    }

    public void setObjectiveCalibratedMagnification(Float calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveCalibratedMagnification(calibratedMagnification, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveCorrection(String correction, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveCorrection(correction, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveID(id, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveImmersion(String immersion, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveImmersion(immersion, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveIris(iris, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveLensNA(Float lensNA, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveLensNA(lensNA, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveManufacturer(manufacturer, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveModel(model, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveNominalMagnification(Integer nominalMagnification, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveNominalMagnification(nominalMagnification, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveSerialNumber(serialNumber, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveWorkingDistance(Float workingDistance, int instrumentIndex, int objectiveIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveWorkingDistance(workingDistance, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveSettingsCorrectionCollar(Float correctionCollar, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveSettingsCorrectionCollar(correctionCollar, imageIndex);
        }
    }

    public void setObjectiveSettingsMedium(String medium, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveSettingsMedium(medium, imageIndex);
        }
    }

    public void setObjectiveSettingsObjective(String objective, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveSettingsObjective(objective, imageIndex);
        }
    }

    public void setObjectiveSettingsRefractiveIndex(Float refractiveIndex, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveSettingsRefractiveIndex(refractiveIndex, imageIndex);
        }
    }

    public void setPixelsBigEndian(Boolean bigEndian, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsBigEndian(bigEndian, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsDimensionOrder(String dimensionOrder, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsDimensionOrder(dimensionOrder, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsID(String id, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsID(id, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsPixelType(String pixelType, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsPixelType(pixelType, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsSizeC(Integer sizeC, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeC(sizeC, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsSizeT(Integer sizeT, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeT(sizeT, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsSizeX(Integer sizeX, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeX(sizeX, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsSizeY(Integer sizeY, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeY(sizeY, imageIndex, pixelsIndex);
        }
    }

    public void setPixelsSizeZ(Integer sizeZ, int imageIndex, int pixelsIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeZ(sizeZ, imageIndex, pixelsIndex);
        }
    }

    public void setPlaneTheC(Integer theC, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTheC(theC, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setPlaneTheT(Integer theT, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTheT(theT, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setPlaneTheZ(Integer theZ, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTheZ(theZ, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setPlaneTimingDeltaT(Float deltaT, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTimingDeltaT(deltaT, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setPlaneTimingExposureTime(Float exposureTime, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTimingExposureTime(exposureTime, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setPlateDescription(String description, int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateDescription(description, plateIndex);
        }
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateExternalIdentifier(externalIdentifier, plateIndex);
        }
    }

    public void setPlateID(String id, int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateID(id, plateIndex);
        }
    }

    public void setPlateName(String name, int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateName(name, plateIndex);
        }
    }

    public void setPlateStatus(String status, int plateIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateStatus(status, plateIndex);
        }
    }

    public void setPlateRefID(String id, int screenIndex, int plateRefIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateRefID(id, screenIndex, plateRefIndex);
        }
    }

    public void setROIID(String id, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIID(id, imageIndex, roiIndex);
        }
    }

    public void setROIT0(Integer t0, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIT0(t0, imageIndex, roiIndex);
        }
    }

    public void setROIT1(Integer t1, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIT1(t1, imageIndex, roiIndex);
        }
    }

    public void setROIX0(Integer x0, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIX0(x0, imageIndex, roiIndex);
        }
    }

    public void setROIX1(Integer x1, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIX1(x1, imageIndex, roiIndex);
        }
    }

    public void setROIY0(Integer y0, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIY0(y0, imageIndex, roiIndex);
        }
    }

    public void setROIY1(Integer y1, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIY1(y1, imageIndex, roiIndex);
        }
    }

    public void setROIZ0(Integer z0, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIZ0(z0, imageIndex, roiIndex);
        }
    }

    public void setROIZ1(Integer z1, int imageIndex, int roiIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIZ1(z1, imageIndex, roiIndex);
        }
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentDescription(description, screenIndex, reagentIndex);
        }
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentID(id, screenIndex, reagentIndex);
        }
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentName(name, screenIndex, reagentIndex);
        }
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentReagentIdentifier(reagentIdentifier, screenIndex, reagentIndex);
        }
    }

    public void setScreenID(String id, int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenID(id, screenIndex);
        }
    }

    public void setScreenName(String name, int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenName(name, screenIndex);
        }
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenProtocolDescription(protocolDescription, screenIndex);
        }
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenProtocolIdentifier(protocolIdentifier, screenIndex);
        }
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenReagentSetDescription(reagentSetDescription, screenIndex);
        }
    }

    public void setScreenType(String type, int screenIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenType(type, screenIndex);
        }
    }

    public void setScreenAcquisitionEndTime(String endTime, int screenIndex, int screenAcquisitionIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenAcquisitionEndTime(endTime, screenIndex, screenAcquisitionIndex);
        }
    }

    public void setScreenAcquisitionID(String id, int screenIndex, int screenAcquisitionIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenAcquisitionID(id, screenIndex, screenAcquisitionIndex);
        }
    }

    public void setScreenAcquisitionStartTime(String startTime, int screenIndex, int screenAcquisitionIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenAcquisitionStartTime(startTime, screenIndex, screenAcquisitionIndex);
        }
    }

    public void setStageLabelName(String name, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelName(name, imageIndex);
        }
    }

    public void setStageLabelX(Float x, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelX(x, imageIndex);
        }
    }

    public void setStageLabelY(Float y, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelY(y, imageIndex);
        }
    }

    public void setStageLabelZ(Float z, int imageIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelZ(z, imageIndex);
        }
    }

    public void setStagePositionPositionX(Float positionX, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStagePositionPositionX(positionX, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setStagePositionPositionY(Float positionY, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStagePositionPositionY(positionY, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setStagePositionPositionZ(Float positionZ, int imageIndex, int pixelsIndex, int planeIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStagePositionPositionZ(positionZ, imageIndex, pixelsIndex, planeIndex);
        }
    }

    public void setTiffDataFileName(String fileName, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataFileName(fileName, imageIndex, pixelsIndex, tiffDataIndex);
        }
    }

    public void setTiffDataFirstC(Integer firstC, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataFirstC(firstC, imageIndex, pixelsIndex, tiffDataIndex);
        }
    }

    public void setTiffDataFirstT(Integer firstT, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataFirstT(firstT, imageIndex, pixelsIndex, tiffDataIndex);
        }
    }

    public void setTiffDataFirstZ(Integer firstZ, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataFirstZ(firstZ, imageIndex, pixelsIndex, tiffDataIndex);
        }
    }

    public void setTiffDataIFD(Integer ifd, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataIFD(ifd, imageIndex, pixelsIndex, tiffDataIndex);
        }
    }

    public void setTiffDataNumPlanes(Integer numPlanes, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataNumPlanes(numPlanes, imageIndex, pixelsIndex, tiffDataIndex);
        }
    }

    public void setTiffDataUUID(String uuid, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataUUID(uuid, imageIndex, pixelsIndex, tiffDataIndex);
        }
    }

    public void setWellColumn(Integer column, int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellColumn(column, plateIndex, wellIndex);
        }
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellExternalDescription(externalDescription, plateIndex, wellIndex);
        }
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellExternalIdentifier(externalIdentifier, plateIndex, wellIndex);
        }
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellID(id, plateIndex, wellIndex);
        }
    }

    public void setWellRow(Integer row, int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellRow(row, plateIndex, wellIndex);
        }
    }

    public void setWellType(String type, int plateIndex, int wellIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellType(type, plateIndex, wellIndex);
        }
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleID(id, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSampleIndex(Integer index, int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleIndex(index, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSamplePosX(Float posX, int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSamplePosX(posX, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSamplePosY(Float posY, int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSamplePosY(posY, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSampleTimepoint(Integer timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleTimepoint(timepoint, plateIndex, wellIndex, wellSampleIndex);
        }
    }
}

