/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.common.LogTools;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.out.TiffWriter;

public final class ImageConverter {
    private ImageConverter() {
    }

    public static boolean testConvert(IFormatWriter writer, String[] args) throws FormatException, IOException {
        IFormatWriter w;
        String in = null;
        String out = null;
        String compression = null;
        boolean stitch = false;
        boolean separate = false;
        boolean merge = false;
        boolean fill = false;
        boolean bigtiff = false;
        int series = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-") && args.length > 1) {
                    if (args[i].equals("-debug")) {
                        FormatHandler.setDebug(true);
                        continue;
                    }
                    if (args[i].equals("-stitch")) {
                        stitch = true;
                        continue;
                    }
                    if (args[i].equals("-separate")) {
                        separate = true;
                        continue;
                    }
                    if (args[i].equals("-merge")) {
                        merge = true;
                        continue;
                    }
                    if (args[i].equals("-fill")) {
                        fill = true;
                        continue;
                    }
                    if (args[i].equals("-bigtiff")) {
                        bigtiff = true;
                        continue;
                    }
                    if (args[i].equals("-compression")) {
                        compression = args[++i];
                        continue;
                    }
                    if (args[i].equals("-series")) {
                        try {
                            series = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    LogTools.println("Ignoring unknown command flag: " + args[i]);
                    continue;
                }
                if (in == null) {
                    in = args[i];
                    continue;
                }
                if (out == null) {
                    out = args[i];
                    continue;
                }
                LogTools.println("Ignoring unknown argument: " + args[i]);
            }
        }
        if (FormatHandler.debug) {
            LogTools.println("Debugging at level " + FormatHandler.debugLevel);
        }
        if (in == null || out == null) {
            LogTools.println("To convert a file to " + writer.getFormat() + " format, run:");
            LogTools.println("  bfconvert [-debug] in_file out_file");
            return false;
        }
        long start = System.currentTimeMillis();
        LogTools.print(in + " ");
        IFormatReader reader = new ImageReader();
        if (stitch) {
            reader = new FileStitcher(reader);
        }
        if (separate) {
            reader = new ChannelSeparator(reader);
        }
        if (merge) {
            reader = new ChannelMerger(reader);
        }
        if (fill) {
            reader = new ChannelFiller(reader);
        }
        reader.setMetadataFiltered(true);
        reader.setOriginalMetadataPopulated(true);
        MetadataStore store = MetadataTools.createOMEXMLMetadata();
        if (store == null) {
            LogTools.println("OME-Java library not found.");
        } else {
            reader.setMetadataStore(store);
        }
        reader.setId(in);
        LogTools.print("[" + reader.getFormat() + "] -> " + out + " ");
        store = reader.getMetadataStore();
        if (store instanceof MetadataRetrieve) {
            writer.setMetadataRetrieve((MetadataRetrieve)((Object)store));
        }
        if (writer instanceof TiffWriter) {
            ((TiffWriter)writer).setBigTiff(bigtiff);
        } else if (writer instanceof ImageWriter && (w = ((ImageWriter)writer).getWriter(out)) instanceof TiffWriter) {
            ((TiffWriter)w).setBigTiff(bigtiff);
        }
        writer.setId(out);
        if (compression != null) {
            writer.setCompression(compression);
        }
        LogTools.print("[" + writer.getFormat() + "] ");
        long mid = System.currentTimeMillis();
        int num = writer.canDoStacks() ? reader.getSeriesCount() : 1;
        long read = 0L;
        long write = 0L;
        int first = series == -1 ? 0 : series;
        int last = series == -1 ? num : series + 1;
        for (int q = first; q < last; ++q) {
            reader.setSeries(q);
            int numImages = writer.canDoStacks() ? reader.getImageCount() : 1;
            for (int i = 0; i < numImages; ++i) {
                long s = System.currentTimeMillis();
                BufferedImage image = reader.openImage(i);
                long m = System.currentTimeMillis();
                writer.saveImage(image, q, i == numImages - 1, q == num - 1 && i == numImages - 1);
                long e = System.currentTimeMillis();
                LogTools.print(".");
                read += m - s;
                write += e - m;
            }
        }
        long end = System.currentTimeMillis();
        LogTools.println(" [done]");
        float sec = (float)(end - start) / 1000.0f;
        long initial = mid - start;
        float readAvg = (float)read / (float)num;
        float writeAvg = (float)write / (float)num;
        LogTools.println(sec + "s elapsed (" + readAvg + "+" + writeAvg + "ms per image, " + initial + "ms overhead)");
        return true;
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (!ImageConverter.testConvert(new ImageWriter(), args)) {
            System.exit(1);
        }
    }
}

