/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class RecordedImageProcessor
extends ImageProcessor {
    private ImageProcessor proc;
    private boolean doRecording;
    private Vector methodStack;
    private int sliceNumber;
    private int channelNumber;
    private ImageProcessor[] otherChannels;

    public RecordedImageProcessor(ImageProcessor proc, int num) {
        this.proc = proc;
        this.methodStack = new Vector();
        this.doRecording = true;
        this.sliceNumber = num;
    }

    public RecordedImageProcessor(ImageProcessor proc, int num, int channelNum, ImageProcessor[] otherChannels) {
        this.proc = proc;
        this.methodStack = new Vector();
        this.doRecording = true;
        this.sliceNumber = num;
        this.channelNumber = channelNum;
        this.otherChannels = otherChannels;
    }

    public void setDoRecording(boolean doRecording) {
        this.doRecording = doRecording;
    }

    public Vector getMethodStack() {
        return this.methodStack;
    }

    public void applyMethodStack(Vector stack) {
        for (int i = 0; i < stack.size(); ++i) {
            MethodEntry m = (MethodEntry)stack.get(i);
            try {
                m.method.invoke((Object)this.proc, m.args);
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    public ImageProcessor getChild() {
        return this.proc;
    }

    public void abs() {
        this.record("abs", null, (Class)null);
        this.proc.abs();
    }

    public void add(double value) {
        this.record("add", new Double(value), Double.TYPE);
        this.proc.add(value);
    }

    public void add(int value) {
        this.record("add", new Integer(value), Integer.TYPE);
        this.proc.add(value);
    }

    public void and(int value) {
        this.record("and", new Integer(value), Integer.TYPE);
        this.proc.and(value);
    }

    public void applyTable(int[] lut) {
        this.record("applyTable", (Object)lut, [I.class);
        this.proc.applyTable(lut);
    }

    public void autoThreshold() {
        this.record("autoThreshold", null, (Class)null);
        this.proc.autoThreshold();
    }

    public ImageProcessor convertToByte(boolean doScaling) {
        this.record("convertToByte", new Boolean(doScaling), Boolean.TYPE);
        return this.proc.convertToByte(doScaling);
    }

    public ImageProcessor convertToFloat() {
        this.record("convertToFloat", null, (Class)null);
        return this.proc.convertToFloat();
    }

    public ImageProcessor convertToRGB() {
        this.record("convertToRGB", null, (Class)null);
        return this.proc.convertToRGB();
    }

    public ImageProcessor convertToShort(boolean doScaling) {
        this.record("convertToShort", new Boolean(doScaling), Boolean.TYPE);
        return this.proc.convertToShort(doScaling);
    }

    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        this.record("convolve", new Object[]{kernel, new Integer(kernelWidth), new Integer(kernelHeight)}, new Class[]{[F.class, Integer.TYPE, Integer.TYPE});
        this.proc.convolve(kernel, kernelWidth, kernelHeight);
    }

    public void convolve3x3(int[] kernel) {
        this.record("convolve3x3", (Object)kernel, [I.class);
        this.proc.convolve3x3(kernel);
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        this.record("copyBits", new Object[]{ip, new Integer(xloc), new Integer(yloc), new Integer(mode)}, new Class[]{ImageProcessor.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.copyBits(ip, xloc, yloc, mode);
    }

    public Image createImage() {
        if (this.otherChannels == null) {
            return this.proc.createImage();
        }
        int size = this.proc.getWidth() * this.proc.getHeight();
        int[] rgbPixels = new int[size];
        block6: for (int i = 0; i < this.otherChannels.length + 1; ++i) {
            int q;
            int q2;
            ImageProcessor activeProcessor = null;
            activeProcessor = i == this.channelNumber ? this.proc : (i < this.channelNumber ? this.otherChannels[i] : this.otherChannels[i - 1]);
            IndexColorModel cm = (IndexColorModel)activeProcessor.getColorModel();
            int mapSize = cm.getMapSize();
            int[] reds = new int[mapSize];
            int[] greens = new int[mapSize];
            int[] blues = new int[mapSize];
            byte[] tmp = new byte[mapSize];
            cm.getReds(tmp);
            for (q2 = 0; q2 < mapSize; ++q2) {
                reds[q2] = (tmp[q2] & 0xFF) << 16;
            }
            cm.getGreens(tmp);
            for (q2 = 0; q2 < mapSize; ++q2) {
                greens[q2] = (tmp[q2] & 0xFF) << 8;
            }
            cm.getBlues(tmp);
            for (q2 = 0; q2 < mapSize; ++q2) {
                blues[q2] = tmp[q2] & 0xFF;
            }
            byte[] pixels = new byte[size];
            double min = activeProcessor.getMin();
            double max = activeProcessor.getMax();
            double scale = 256.0 / (max - min + 1.0);
            if (activeProcessor instanceof ByteProcessor) {
                pixels = (byte[])activeProcessor.getPixels();
            } else if (activeProcessor instanceof ShortProcessor) {
                short[] s = (short[])activeProcessor.getPixels();
                for (q = 0; q < size; ++q) {
                    int value = (int)((double)(s[q] & 0xFFFF) - min);
                    if (value < 0) {
                        value = 0;
                    }
                    if ((value = (int)((double)value * scale + 0.5)) > 255) {
                        value = 255;
                    }
                    pixels[q] = (byte)value;
                }
            } else if (activeProcessor instanceof FloatProcessor) {
                float[] f = (float[])activeProcessor.getPixels();
                for (q = 0; q < size; ++q) {
                    int ivalue;
                    float value = (float)((double)f[q] - min);
                    if (value < 0.0f) {
                        value = 0.0f;
                    }
                    if ((ivalue = (int)((double)value * scale)) > 255) {
                        ivalue = 255;
                    }
                    pixels[q] = (byte)ivalue;
                }
            }
            switch (i) {
                case 0: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        rgbPixels[q3] = rgbPixels[q3] & 0xFF00FFFF | reds[pixels[q3] & 0xFF];
                    }
                    continue block6;
                }
                case 1: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        rgbPixels[q3] = rgbPixels[q3] & 0xFFFF00FF | greens[pixels[q3] & 0xFF];
                    }
                    continue block6;
                }
                case 2: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        rgbPixels[q3] = rgbPixels[q3] & 0xFFFFFF00 | blues[pixels[q3] & 0xFF];
                    }
                    continue block6;
                }
                case 3: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        int red = reds[pixels[q3] & 0xFF];
                        int green = greens[pixels[q3] & 0xFF];
                        int blue = blues[pixels[q3] & 0xFF];
                        rgbPixels[q3] = red | green | blue;
                    }
                    continue block6;
                }
                default: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        int pixel = rgbPixels[q3];
                        int red = (pixel & 0xFF0000) + reds[pixels[q3] & 0xFF];
                        int green = (pixel & 0xFF00) + greens[pixels[q3] & 0xFF];
                        int blue = (pixel & 0xFF) + blues[pixels[q3] & 0xFF];
                        if (red > 0xFF0000) {
                            red = 0xFF0000;
                        }
                        if (green > 65280) {
                            green = 65280;
                        }
                        if (blue > 255) {
                            blue = 255;
                        }
                        rgbPixels[q3] = red | green | blue;
                    }
                }
            }
        }
        DirectColorModel rgb = new DirectColorModel(32, 0xFF0000, 65280, 255);
        MemoryImageSource src = new MemoryImageSource(this.proc.getWidth(), this.proc.getHeight(), (ColorModel)rgb, rgbPixels, 0, this.proc.getWidth());
        src.setAnimated(true);
        src.setFullBufferUpdates(true);
        return Toolkit.getDefaultToolkit().createImage(src);
    }

    public ImageProcessor createProcessor(int width, int height) {
        this.record("createProcessor", new Object[]{new Integer(width), new Integer(height)}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.createProcessor(width, height);
    }

    public ImageProcessor crop() {
        this.record("crop", null, (Class)null);
        return this.proc.crop();
    }

    public void dilate() {
        this.record("dilate", null, (Class)null);
        this.proc.dilate();
    }

    public void drawDot(int xcenter, int ycenter) {
        this.record("drawDot", new Object[]{new Integer(xcenter), new Integer(ycenter)}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.drawDot(xcenter, ycenter);
    }

    public void drawDot2(int x, int y) {
        this.record("drawDot2", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.drawDot2(x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.record("drawLine", new Object[]{new Integer(x1), new Integer(y1), new Integer(x2), new Integer(y2)}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.record("drawOval", new Object[]{new Integer(x), new Integer(y), new Integer(width), new Integer(height)}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.drawOval(x, y, width, height);
    }

    public void drawPixel(int x, int y) {
        this.record("drawPixel", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.drawPixel(x, y);
    }

    public void drawPolygon(Polygon p) {
        this.record("drawPolygon", p, Polygon.class);
        this.proc.drawPolygon(p);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.record("drawRect", new Object[]{new Integer(x), new Integer(y), new Integer(width), new Integer(height)}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.drawRect(x, y, width, height);
    }

    public void drawString(String s) {
        this.record("drawString", s, String.class);
        this.proc.drawString(s);
    }

    public void drawString(String s, int x, int y) {
        this.record("drawString", new Object[]{s, new Integer(x), new Integer(y)}, new Class[]{String.class, Integer.TYPE, Integer.TYPE});
        this.proc.drawString(s, x, y);
    }

    public ImageProcessor duplicate() {
        this.record("duplicate", null, (Class)null);
        return this.proc.duplicate();
    }

    public void erode() {
        this.record("erode", null, (Class)null);
        this.proc.erode();
    }

    public void exp() {
        this.record("exp", null, (Class)null);
        this.proc.exp();
    }

    public void fill() {
        this.record("fill", null, (Class)null);
        this.proc.fill();
    }

    public void fill(ImageProcessor mask) {
        this.record("fill", mask, ImageProcessor.class);
        this.proc.fill(mask);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.record("fillOval", new Object[]{new Integer(x), new Integer(y), new Integer(width), new Integer(height)}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.fillOval(x, y, width, height);
    }

    public void fillPolygon(Polygon p) {
        this.record("fillPolygon", p, Polygon.class);
        this.proc.fillPolygon(p);
    }

    public void filter(int type) {
        this.record("filter", new Integer(type), Integer.TYPE);
        this.proc.filter(type);
    }

    public void findEdges() {
        this.record("findEdges", null, (Class)null);
        this.proc.findEdges();
    }

    public void flipHorizontal() {
        this.record("flipHorizontal", null, (Class)null);
        this.proc.flipHorizontal();
    }

    public void flipVertical() {
        this.record("flipVertical", null, (Class)null);
        this.proc.flipVertical();
    }

    public void gamma(double value) {
        this.record("gamma", new Double(value), Double.TYPE);
        this.proc.gamma(value);
    }

    public int get(int index) {
        this.record("get", new Integer(index), Integer.TYPE);
        return this.proc.get(index);
    }

    public int get(int x, int y) {
        this.record("get", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.get(x, y);
    }

    public int getAutoThreshold() {
        this.record("getAutoThreshold", null, (Class)null);
        return this.proc.getAutoThreshold();
    }

    public int getAutoThreshold(int[] histogram) {
        this.record("getAutoThreshold", (Object)histogram, [I.class);
        return this.proc.getAutoThreshold(histogram);
    }

    public int getBestIndex(Color c) {
        this.record("getBestIndex", c, Color.class);
        return this.proc.getBestIndex(c);
    }

    public BufferedImage getBufferedImage() {
        this.record("getBufferedImage", null, (Class)null);
        return this.proc.getBufferedImage();
    }

    public float[] getCalibrationTable() {
        this.record("getCalibrationTable", null, (Class)null);
        return this.proc.getCalibrationTable();
    }

    public ColorModel getColorModel() {
        this.record("getColorModel", null, (Class)null);
        return this.proc.getColorModel();
    }

    public void getColumn(int x, int y, int[] data, int length) {
        this.record("getColumn", new Object[]{new Integer(x), new Integer(y), data, new Integer(length)}, new Class[]{Integer.TYPE, Integer.TYPE, [I.class, Integer.TYPE});
        this.proc.getColumn(x, y, data, length);
    }

    public ColorModel getCurrentColorModel() {
        this.record("getCurrentColorModel", null, (Class)null);
        return this.proc.getCurrentColorModel();
    }

    public IndexColorModel getDefaultColorModel() {
        this.record("getDefaultColorModel", null, (Class)null);
        return this.proc.getDefaultColorModel();
    }

    public float getf(int index) {
        this.record("getf", new Integer(index), Integer.TYPE);
        return this.proc.getf(index);
    }

    public float getf(int x, int y) {
        this.record("getf", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.getf(x, y);
    }

    public float[][] getFloatArray() {
        this.record("getFloatArray", null, (Class)null);
        return this.proc.getFloatArray();
    }

    public FontMetrics getFontMetrics() {
        this.record("getFontMetrics", null, (Class)null);
        return this.proc.getFontMetrics();
    }

    public int getHeight() {
        this.record("getHeight", null, (Class)null);
        return this.proc.getHeight();
    }

    public int[] getHistogram() {
        this.record("getHistogram", null, (Class)null);
        return this.proc.getHistogram();
    }

    public double getHistogramMax() {
        this.record("getHistogramMax", null, (Class)null);
        return this.proc.getHistogramMax();
    }

    public double getHistogramMin() {
        this.record("getHistogramMin", null, (Class)null);
        return this.proc.getHistogramMin();
    }

    public int getHistogramSize() {
        this.record("getHistogramSize", null, (Class)null);
        return this.proc.getHistogramSize();
    }

    public int[][] getIntArray() {
        this.record("getIntArray", null, (Class)null);
        return this.proc.getIntArray();
    }

    public boolean getInterpolate() {
        this.record("getInterpolate", null, (Class)null);
        return this.proc.getInterpolate();
    }

    public double getInterpolatedPixel(double x, double y) {
        this.record("getInterpolatedPixel", new Object[]{new Double(x), new Double(y)}, new Class[]{Double.TYPE, Double.TYPE});
        return this.proc.getInterpolatedPixel(x, y);
    }

    public double[] getLine(double x1, double y1, double x2, double y2) {
        this.record("getLine", new Object[]{new Double(x1), new Double(y1), new Double(x2), new Double(y2)}, new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        return this.proc.getLine(x1, y1, x2, y2);
    }

    public int getLutUpdateMode() {
        this.record("getLutUpdateMode", null, (Class)null);
        return this.proc.getLutUpdateMode();
    }

    public ImageProcessor getMask() {
        this.record("getMask", null, (Class)null);
        return this.proc.getMask();
    }

    public byte[] getMaskArray() {
        this.record("getMaskArray", null, (Class)null);
        return this.proc.getMaskArray();
    }

    public double getMax() {
        this.record("getMax", null, (Class)null);
        return this.proc.getMax();
    }

    public double getMaxThreshold() {
        this.record("getMaxThreshold", null, (Class)null);
        return this.proc.getMaxThreshold();
    }

    public double getMin() {
        this.record("getMin", null, (Class)null);
        return this.proc.getMin();
    }

    public double getMinThreshold() {
        this.record("getMinThreshold", null, (Class)null);
        return this.proc.getMinThreshold();
    }

    public int getNChannels() {
        this.record("getNChannels", null, (Class)null);
        return this.proc.getNChannels();
    }

    public int getPixel(int x, int y) {
        this.record("getPixel", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.getPixel(x, y);
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        this.record("getPixel", new Object[]{new Integer(x), new Integer(y), iArray}, new Class[]{Integer.TYPE, Integer.TYPE, [I.class});
        return this.proc.getPixel(x, y, iArray);
    }

    public int getPixelCount() {
        this.record("getPixelCount", null, (Class)null);
        return this.proc.getPixelCount();
    }

    public Object getPixels() {
        this.record("getPixels", null, (Class)null);
        return this.proc.getPixels();
    }

    public Object getPixelsCopy() {
        this.record("getPixelsCopy", null, (Class)null);
        return this.proc.getPixelsCopy();
    }

    public float getPixelValue(int x, int y) {
        this.record("getPixelValue", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.getPixelValue(x, y);
    }

    public Rectangle getRoi() {
        this.record("getRoi", null, (Class)null);
        return this.proc.getRoi();
    }

    public void getRow(int x, int y, int[] data, int length) {
        this.record("getRow", new Object[]{new Integer(x), new Integer(y), data, new Integer(length)}, new Class[]{Integer.TYPE, Integer.TYPE, [I.class, Integer.TYPE});
        this.proc.getRow(x, y, data, length);
    }

    public Object getSnapshotPixels() {
        this.record("getSnapshotPixels", null, (Class)null);
        return this.proc.getSnapshotPixels();
    }

    public int getStringWidth(String s) {
        this.record("getStringWidth", s, String.class);
        return this.proc.getStringWidth(s);
    }

    public int getWidth() {
        this.record("getWidth", null, (Class)null);
        return this.proc.getWidth();
    }

    public void insert(ImageProcessor ip, int xloc, int yloc) {
        this.record("insert", new Object[]{ip, new Integer(xloc), new Integer(yloc)}, new Class[]{ImageProcessor.class, Integer.TYPE, Integer.TYPE});
        this.proc.insert(ip, xloc, yloc);
    }

    public void invert() {
        this.record("invert", null, (Class)null);
        this.proc.invert();
    }

    public void invertLut() {
        this.record("invertLut", null, (Class)null);
        this.proc.invertLut();
    }

    public boolean isColorLut() {
        this.record("isColorLut", null, (Class)null);
        return this.proc.isColorLut();
    }

    public boolean isInvertedLut() {
        this.record("isInvertedLut", null, (Class)null);
        return this.proc.isInvertedLut();
    }

    public boolean isKillable() {
        this.record("isKillable", null, (Class)null);
        return this.proc.isKillable();
    }

    public boolean isPseudoColorLut() {
        this.record("isPseudoColorLut", null, (Class)null);
        return this.proc.isPseudoColorLut();
    }

    public void lineTo(int x2, int y2) {
        this.record("lineTo", new Object[]{new Integer(x2), new Integer(y2)}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.lineTo(x2, y2);
    }

    public void log() {
        this.record("log", null, (Class)null);
        this.proc.log();
    }

    public void max(double value) {
        this.record("max", new Double(value), Double.TYPE);
        this.proc.max(value);
    }

    public double maxValue() {
        this.record("maxValue", null, (Class)null);
        return this.proc.maxValue();
    }

    public void medianFilter() {
        this.record("medianFilter", null, (Class)null);
        this.proc.medianFilter();
    }

    public void min(double value) {
        this.record("min", new Double(value), Double.TYPE);
        this.proc.min(value);
    }

    public double minValue() {
        this.record("minValue", null, (Class)null);
        return this.proc.minValue();
    }

    public void moveTo(int x, int y) {
        this.record("moveTo", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.moveTo(x, y);
    }

    public void multiply(double value) {
        this.record("multiply", new Double(value), Double.TYPE);
        this.proc.multiply(value);
    }

    public void noise(double range) {
        this.record("noise", new Double(range), Double.TYPE);
        this.proc.noise(range);
    }

    public void or(int value) {
        this.record("or", new Integer(value), Integer.TYPE);
        this.proc.or(value);
    }

    public void putColumn(int x, int y, int[] data, int length) {
        this.record("putColumn", new Object[]{new Integer(x), new Integer(y), data, new Integer(length)}, new Class[]{Integer.TYPE, Integer.TYPE, [I.class, Integer.TYPE});
        this.proc.putColumn(x, y, data, length);
    }

    public void putPixel(int x, int y, int value) {
        this.record("putPixel", new Object[]{new Integer(x), new Integer(y), new Integer(value)}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.putPixel(x, y, value);
    }

    public void putPixel(int x, int y, int[] iArray) {
        this.record("putPixel", new Object[]{new Integer(x), new Integer(y), iArray}, new Class[]{Integer.TYPE, Integer.TYPE, [I.class});
        this.proc.putPixel(x, y, iArray);
    }

    public void putPixelValue(int x, int y, double value) {
        this.record("putPixelValue", new Object[]{new Integer(x), new Integer(y), new Double(value)}, new Class[]{Integer.TYPE, Integer.TYPE, Double.TYPE});
        this.proc.putPixelValue(x, y, value);
    }

    public void putRow(int x, int y, int[] data, int length) {
        this.record("putRow", new Object[]{new Integer(x), new Integer(y), data, new Integer(length)}, new Class[]{Integer.TYPE, Integer.TYPE, [I.class, Integer.TYPE});
        this.proc.putRow(x, y, data, length);
    }

    public void reset() {
        this.record("reset", null, (Class)null);
        this.proc.reset();
    }

    public void reset(ImageProcessor mask) {
        this.record("reset", mask, ImageProcessor.class);
        this.proc.reset(mask);
    }

    public void resetBinaryThreshold() {
        this.record("resetBinaryThreshold", null, (Class)null);
        this.proc.resetBinaryThreshold();
    }

    public void resetMinAndMax() {
        this.record("resetMinAndMax", null, (Class)null);
        this.proc.resetMinAndMax();
    }

    public void resetRoi() {
        this.record("resetRoi", null, (Class)null);
        this.proc.resetRoi();
    }

    public void resetThreshold() {
        this.record("resetThreshold", null, (Class)null);
        this.proc.resetThreshold();
    }

    public ImageProcessor resize(int dstWidth) {
        this.record("resize", new Integer(dstWidth), Integer.TYPE);
        return this.proc.resize(dstWidth);
    }

    public ImageProcessor resize(int dstWidth, int dstHeight) {
        this.record("resize", new Object[]{new Integer(dstWidth), new Integer(dstHeight)}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.resize(dstWidth, dstHeight);
    }

    public void rotate(double angle) {
        this.record("rotate", new Double(angle), Double.TYPE);
        this.proc.rotate(angle);
    }

    public ImageProcessor rotateLeft() {
        this.record("rotateLeft", null, (Class)null);
        return this.proc.rotateLeft();
    }

    public ImageProcessor rotateRight() {
        this.record("rotateRight", null, (Class)null);
        return this.proc.rotateRight();
    }

    public void scale(double xScale, double yScale) {
        this.record("scale", new Object[]{new Double(xScale), new Double(yScale)}, new Class[]{Double.TYPE, Double.TYPE});
        this.proc.scale(xScale, yScale);
    }

    public void set(int index, int value) {
        this.record("set", new Object[]{new Integer(index), new Integer(value)}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.set(index, value);
    }

    public void set(int x, int y, int value) {
        this.record("set", new Object[]{new Integer(x), new Integer(y), new Integer(value)}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.set(x, y, value);
    }

    public void setAntialiasedText(boolean antialiased) {
        this.record("setAntialiasedText", new Boolean(antialiased), Boolean.TYPE);
        this.proc.setAntialiasedText(antialiased);
    }

    public void setAutoThreshold(int method, int lutUpdate) {
        this.record("setAutoThreshold", new Object[]{new Integer(method), new Integer(lutUpdate)}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.setAutoThreshold(method, lutUpdate);
    }

    public void setBackgroundValue(double value) {
        this.record("setBackgroundValue", new Double(value), Double.TYPE);
        this.proc.setBackgroundValue(value);
    }

    public void setCalibrationTable(float[] ctable) {
        this.record("setCalibrationTable", (Object)ctable, [F.class);
        this.proc.setCalibrationTable(ctable);
    }

    public void setClipRect(Rectangle clipRect) {
        this.record("setClipRect", clipRect, Rectangle.class);
        this.proc.setClipRect(clipRect);
    }

    public void setColor(Color color) {
        this.record("setColor", color, Color.class);
        this.proc.setColor(color);
    }

    public void setColor(int value) {
        this.record("setColor", new Integer(value), Integer.TYPE);
        this.proc.setColor(value);
    }

    public void setColorModel(ColorModel cm) {
        this.record("setColorModel", cm, ColorModel.class);
        this.proc.setColorModel(cm);
    }

    public void setf(int index, float value) {
        this.record("setf", new Object[]{new Integer(index), new Float(value)}, new Class[]{Integer.TYPE, Float.TYPE});
        this.proc.setf(index, value);
    }

    public void setf(int x, int y, float value) {
        this.record("setf", new Object[]{new Integer(x), new Integer(y), new Float(value)}, new Class[]{Integer.TYPE, Integer.TYPE, Float.TYPE});
        this.proc.setf(x, y, value);
    }

    public void setFloatArray(float[][] a) {
        this.record("setFloatArray", a, [[F.class);
        this.proc.setFloatArray(a);
    }

    public void setFont(Font font) {
        this.record("setFont", font, Font.class);
        this.proc.setFont(font);
    }

    public void setHistogramRange(double histMin, double histMax) {
        this.record("setHistogramRange", new Object[]{new Double(histMin), new Double(histMax)}, new Class[]{Double.TYPE, Double.TYPE});
        this.proc.setHistogramRange(histMin, histMax);
    }

    public void setHistogramSize(int size) {
        this.record("setHistogramSize", new Integer(size), Integer.TYPE);
        this.proc.setHistogramSize(size);
    }

    public void setIntArray(int[][] a) {
        this.record("setIntArray", a, [[I.class);
        this.proc.setIntArray(a);
    }

    public void setInterpolate(boolean interpolate) {
        this.record("setInterpolate", new Boolean(interpolate), Boolean.TYPE);
        this.proc.setInterpolate(interpolate);
    }

    public void setJustification(int justification) {
        this.record("setJustification", new Integer(justification), Integer.TYPE);
        this.proc.setJustification(justification);
    }

    public void setLineWidth(int width) {
        this.record("setLineWidth", new Integer(width), Integer.TYPE);
        this.proc.setLineWidth(width);
    }

    public void setLutAnimation(boolean lutAnimation) {
        this.record("setLutAnimation", new Boolean(lutAnimation), Boolean.TYPE);
        this.proc.setLutAnimation(lutAnimation);
    }

    public void setMask(ImageProcessor mask) {
        this.record("setMask", mask, ImageProcessor.class);
        this.proc.setMask(mask);
    }

    public void setMinAndMax(double min, double max) {
        this.record("setMinAndMax", new Object[]{new Double(min), new Double(max)}, new Class[]{Double.TYPE, Double.TYPE});
        this.proc.setMinAndMax(min, max);
    }

    public void setPixels(int channelNumber, FloatProcessor fp) {
        this.record("setPixels", new Object[]{new Integer(channelNumber), fp}, new Class[]{Integer.TYPE, FloatProcessor.class});
        this.proc.setPixels(channelNumber, fp);
    }

    public void setPixels(Object pixels) {
        this.record("setPixels", pixels, Object.class);
        this.proc.setPixels(pixels);
    }

    public void setProgressBar(ProgressBar pb) {
        this.record("setProgressBar", pb, ProgressBar.class);
        this.proc.setProgressBar(pb);
    }

    public void setRoi(int x, int y, int rwidth, int rheight) {
        this.record("setRoi", new Object[]{new Integer(x), new Integer(y), new Integer(rwidth), new Integer(rheight)}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.setRoi(x, y, rwidth, rheight);
    }

    public void setRoi(Polygon roi) {
        this.record("setRoi", roi, Polygon.class);
        this.proc.setRoi(roi);
    }

    public void setRoi(Rectangle roi) {
        this.record("setRoi", roi, Rectangle.class);
        this.proc.setRoi(roi);
    }

    public void setRoi(Roi roi) {
        this.record("setRoi", roi, Roi.class);
        this.proc.setRoi(roi);
    }

    public void setSnapshotCopyMode(boolean b) {
        this.record("setSnapshotCopyMode", new Boolean(b), Boolean.TYPE);
        this.proc.setSnapshotCopyMode(b);
    }

    public void setSnapshotPixels(Object pixels) {
        this.record("setSnapshotPixels", pixels, Object.class);
        this.proc.setSnapshotPixels(pixels);
    }

    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        this.record("setThreshold", new Object[]{new Double(minThreshold), new Double(maxThreshold), new Integer(lutUpdate)}, new Class[]{Double.TYPE, Double.TYPE, Integer.TYPE});
        this.proc.setThreshold(minThreshold, maxThreshold, lutUpdate);
    }

    public void setValue(double value) {
        this.record("setValue", new Double(value), Double.TYPE);
        this.proc.setValue(value);
    }

    public void sharpen() {
        this.record("sharpen", null, (Class)null);
        this.proc.sharpen();
    }

    public void smooth() {
        this.record("smooth", null, (Class)null);
        this.proc.smooth();
    }

    public void snapshot() {
        this.record("snapshot", null, (Class)null);
        this.proc.snapshot();
    }

    public void sqr() {
        this.record("sqr", null, (Class)null);
        this.proc.sqr();
    }

    public void sqrt() {
        this.record("sqrt", null, (Class)null);
        this.proc.sqrt();
    }

    public void threshold(int level) {
        this.record("threshold", new Integer(level), Integer.TYPE);
        this.proc.threshold(level);
    }

    public FloatProcessor toFloat(int channelNumber, FloatProcessor fp) {
        this.record("toFloat", new Object[]{new Integer(channelNumber), fp}, new Class[]{Integer.TYPE, FloatProcessor.class});
        return this.proc.toFloat(channelNumber, fp);
    }

    public String toString() {
        this.record("toString", null, (Class)null);
        return this.proc.toString();
    }

    public void translate(int xOffset, int yOffset, boolean eraseBackground) {
        this.record("translate", new Object[]{new Integer(xOffset), new Integer(yOffset), new Boolean(eraseBackground)}, new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
        this.proc.translate(xOffset, yOffset, eraseBackground);
    }

    public void updateComposite(int[] rgbPixels, int channel) {
        this.record("updateComposite", new Object[]{rgbPixels, new Integer(channel)}, new Class[]{[I.class, Integer.TYPE});
        this.proc.updateComposite(rgbPixels, channel);
    }

    public void xor(int value) {
        this.record("xor", new Integer(value), Integer.TYPE);
        this.proc.xor(value);
    }

    private void record(String method, Object v, Class c) {
        Class[] classArray;
        Object[] objectArray;
        if (v == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = v;
        }
        if (c == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = c;
        }
        this.record(method, objectArray, classArray);
    }

    private void record(String method, Object[] v, Class[] c) {
        if (!this.doRecording) {
            return;
        }
        MethodEntry m = new MethodEntry();
        m.name = method;
        m.args = v;
        if (v == null && c != null) {
            m.args = new Object[c.length];
            for (int i = 0; i < m.args.length; ++i) {
                m.args[i] = null;
            }
        }
        try {
            m.method = this.proc.getClass().getMethod(method, c);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        this.methodStack.add(m);
    }

    class MethodEntry {
        public String name;
        public Object[] args;
        public Method method;

        MethodEntry() {
        }
    }
}

