/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.ImagePlus;
import ij.ImageStack;
import java.io.IOException;
import java.util.Vector;
import loci.formats.IFormatReader;
import loci.plugins.BFVirtualStack;
import loci.plugins.RecordedImageProcessor;

public class VirtualImagePlus
extends ImagePlus {
    private IFormatReader r;

    public VirtualImagePlus(String title, ImageStack stack) {
        super(title, stack);
    }

    public void setReader(IFormatReader r) {
        this.r = r;
    }

    public synchronized void setSlice(int index) {
        super.setSlice(index);
        BFVirtualStack stack = null;
        if (this.getStack() instanceof BFVirtualStack) {
            stack = (BFVirtualStack)this.getStack();
            RecordedImageProcessor proc = stack.getRecordedProcessor();
            Vector methods = stack.getMethodStack();
            if (methods != null) {
                proc.applyMethodStack(methods);
            }
            this.setProcessor(this.getTitle(), proc.getChild());
            this.ip = proc;
        }
    }

    public void close() {
        super.close();
        try {
            this.r.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

