/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import loci.common.CBZip2InputStream;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RABytes;
import loci.common.RAFile;
import loci.common.RAUrl;

public class RandomAccessStream
extends InputStream
implements DataInput {
    protected static final int MAX_OVERHEAD = 0x100000;
    protected static final int MAX_FILES = 100;
    protected static final int DIS = 0;
    protected static final int RAF = 1;
    protected static final int ARRAY = 2;
    private static Hashtable fileCache = new Hashtable();
    private static int openFiles = 0;
    protected IRandomAccess raf;
    protected DataInputStream dis;
    protected long length;
    protected long fp;
    protected long afp;
    protected long mark;
    protected long nextMark;
    protected String file;
    protected byte[] buf;
    protected boolean littleEndian = false;
    protected int ext = 0;
    protected boolean compressed = false;

    public RandomAccessStream(String file2) throws IOException {
        File f = new File(Location.getMappedId(file2));
        f = f.getAbsoluteFile();
        if (Location.getMappedFile(file2) != null) {
            this.raf = Location.getMappedFile(file2);
            this.length = this.raf.length();
        } else if (f.exists()) {
            this.raf = new RAFile(f, "r");
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(Location.getMappedId(file2)), 0x100000);
            String path = f.getPath().toLowerCase();
            if (path.endsWith(".gz")) {
                int skip;
                this.dis = new DataInputStream(new GZIPInputStream(bis));
                this.compressed = true;
                this.length = 0L;
                while ((skip = this.dis.skipBytes(1024)) > 0) {
                    this.length += (long)skip;
                }
                bis = new BufferedInputStream(new FileInputStream(Location.getMappedId(file2)), 0x100000);
                this.dis = new DataInputStream(new GZIPInputStream(bis));
            } else if (path.endsWith(".zip")) {
                ZipFile zf = new ZipFile(Location.getMappedId(file2));
                String innerId = path.substring(0, path.length() - 4);
                int slash = innerId.lastIndexOf(File.separator);
                if (slash < 0) {
                    slash = innerId.lastIndexOf("/");
                }
                if (slash >= 0) {
                    innerId = innerId.substring(slash + 1);
                }
                ZipEntry entry = null;
                Enumeration<? extends ZipEntry> en = zf.entries();
                while (en.hasMoreElements()) {
                    ZipEntry ze = en.nextElement();
                    if (ze.getName().startsWith(innerId)) {
                        entry = ze;
                        break;
                    }
                    if (entry != null) continue;
                    entry = ze;
                }
                if (entry == null) {
                    throw new IOException("Zip file '" + file2 + "' has no entries");
                }
                this.compressed = true;
                this.length = entry.getSize();
                this.dis = new DataInputStream(new BufferedInputStream(zf.getInputStream(entry), 0x100000));
            } else if (path.endsWith(".bz2")) {
                int skip;
                bis.skip(2L);
                this.dis = new DataInputStream(new CBZip2InputStream(bis));
                this.compressed = true;
                this.length = 0L;
                while ((skip = this.dis.skipBytes(1024)) > 0) {
                    this.length += (long)skip;
                }
                bis = new BufferedInputStream(new FileInputStream(Location.getMappedId(file2)), 0x100000);
                bis.skip(2L);
                this.dis = new DataInputStream(new CBZip2InputStream(bis));
            } else {
                this.dis = new DataInputStream(bis);
            }
            if (!this.compressed) {
                this.length = this.raf.length();
                this.buf = new byte[(int)(this.length < 0x100000L ? this.length : 0x100000L)];
                this.raf.readFully(this.buf);
                this.raf.seek(0L);
                this.nextMark = 0x100000L;
            }
        } else if (file2.startsWith("http")) {
            this.raf = new RAUrl(Location.getMappedId(file2), "r");
            this.length = this.raf.length();
        } else {
            throw new IOException("File not found : " + file2);
        }
        this.file = file2;
        this.fp = 0L;
        this.afp = 0L;
        fileCache.put(this, Boolean.TRUE);
        if (++openFiles > 100) {
            this.cleanCache();
        }
    }

    public RandomAccessStream(byte[] array) throws IOException {
        this.raf = new RABytes(array);
        this.fp = 0L;
        this.afp = 0L;
        this.length = this.raf.length();
    }

    public DataInputStream getInputStream() {
        try {
            if (Boolean.FALSE.equals(fileCache.get(this))) {
                this.reopen();
            }
        }
        catch (IOException e) {
            return null;
        }
        return this.dis;
    }

    public void setExtend(int extend) {
        this.ext = extend;
    }

    public void seek(long pos) throws IOException {
        this.afp = pos;
    }

    public int read() throws IOException {
        byte b = this.readByte();
        if (b == -1 && this.afp >= this.length() && this.ext > 0) {
            return 0;
        }
        return b;
    }

    public long length() throws IOException {
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        return this.length;
    }

    public long getFilePointer() {
        return this.afp;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
        if (this.dis != null) {
            this.dis.close();
        }
        this.dis = null;
        this.buf = null;
        if (Boolean.TRUE.equals(fileCache.get(this))) {
            fileCache.put(this, Boolean.FALSE);
            --openFiles;
        }
    }

    public void order(boolean little) {
        this.littleEndian = little;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        int status = this.checkEfficiency(1);
        long oldAFP = this.afp;
        if (this.afp < this.length - 1L) {
            ++this.afp;
        }
        if (status == 0) {
            byte b = this.dis.readByte();
            ++this.fp;
            return b;
        }
        if (status == 2) {
            return this.buf[(int)oldAFP];
        }
        byte b = this.raf.readByte();
        return b;
    }

    public char readChar() throws IOException {
        return (char)this.readByte();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readInt() throws IOException {
        return DataTools.read4SignedBytes(this, this.littleEndian);
    }

    public String readLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        char c = this.readChar();
        while (c != '\n') {
            sb = sb.append(c);
            c = this.readChar();
        }
        return sb.toString();
    }

    public String readCString() throws IOException {
        StringBuffer sb = new StringBuffer();
        char achar = this.readChar();
        while (achar != '\u0000') {
            sb = sb.append(achar);
            achar = this.readChar();
        }
        return sb.toString();
    }

    public String readString(int n) throws IOException {
        byte[] b = new byte[n];
        this.read(b);
        return new String(b);
    }

    public long readLong() throws IOException {
        return DataTools.read8SignedBytes(this, this.littleEndian);
    }

    public short readShort() throws IOException {
        return DataTools.read2SignedBytes(this, this.littleEndian);
    }

    public int readUnsignedByte() throws IOException {
        return DataTools.readUnsignedByte(this);
    }

    public int readUnsignedShort() throws IOException {
        return DataTools.read2UnsignedBytes(this, this.littleEndian);
    }

    public String readUTF() throws IOException {
        return null;
    }

    public int skipBytes(int n) throws IOException {
        this.afp += (long)n;
        return n;
    }

    public int read(byte[] array) throws IOException {
        int status = this.checkEfficiency(array.length);
        int n = 0;
        if (status == 0) {
            return this.read(array, 0, array.length);
        }
        if (status == 2) {
            n = array.length;
            if ((long)this.buf.length - this.afp < (long)array.length) {
                n = this.buf.length - (int)this.afp;
            }
            System.arraycopy(this.buf, (int)this.afp, array, 0, n);
        } else {
            n = this.raf.read(array);
        }
        this.afp += (long)n;
        if (status == 0) {
            this.fp += (long)n;
        }
        if (n < array.length && this.ext > 0) {
            while (n < array.length && this.ext > 0) {
                ++n;
                --this.ext;
            }
        }
        return n;
    }

    public int read(byte[] array, int offset, int n) throws IOException {
        int toRead = n;
        int status = this.checkEfficiency(n);
        if (status == 0) {
            int p = this.dis.read(array, offset, n);
            if (p == -1) {
                return -1;
            }
            if (p >= 0 && this.fp + (long)p < this.length) {
                int k = p;
                while (k >= 0 && p < n && this.afp + (long)p <= this.length && offset + p < array.length) {
                    k = this.dis.read(array, offset + p, n - p);
                    if (k < 0) continue;
                    p += k;
                }
            }
            n = p;
        } else if (status == 2) {
            if ((long)this.buf.length - this.afp < (long)n) {
                n = this.buf.length - (int)this.afp;
            }
            System.arraycopy(this.buf, (int)this.afp, array, offset, n);
        } else {
            n = this.raf.read(array, offset, n);
        }
        this.afp += (long)n;
        if (status == 0) {
            this.fp += (long)n;
        }
        if (n < toRead && this.ext > 0) {
            while (n < array.length && this.ext > 0) {
                ++n;
                --this.ext;
            }
        }
        return n;
    }

    public void readFully(byte[] array) throws IOException {
        this.readFully(array, 0, array.length);
    }

    public void readFully(byte[] array, int offset, int n) throws IOException {
        int status = this.checkEfficiency(n);
        if (status == 0) {
            this.dis.readFully(array, offset, n);
        } else if (status == 2) {
            System.arraycopy(this.buf, (int)this.afp, array, offset, n);
        } else {
            this.raf.readFully(array, offset, n);
        }
        this.afp += (long)n;
        if (status == 0) {
            this.fp += (long)n;
        }
    }

    public int available() throws IOException {
        int available;
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        int n = available = this.dis != null ? this.dis.available() + this.ext : (int)(this.length() - this.getFilePointer());
        if (available < 0) {
            available = Integer.MAX_VALUE;
        }
        return available;
    }

    public void mark(int readLimit) {
        try {
            if (Boolean.FALSE.equals(fileCache.get(this))) {
                this.reopen();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.compressed) {
            this.dis.mark(readLimit);
        }
    }

    public boolean markSupported() {
        return !this.compressed;
    }

    public void reset() throws IOException {
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        this.dis.reset();
        this.fp = this.length() - (long)this.dis.available();
    }

    protected int checkEfficiency(int toRead) throws IOException {
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        if (this.compressed) {
            if (this.afp < this.fp) {
                if (this.dis != null) {
                    this.dis.close();
                }
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(Location.getMappedId(this.file)), 0x100000);
                String path = Location.getMappedId(this.file).toLowerCase();
                if (path.endsWith(".gz")) {
                    this.dis = new DataInputStream(new GZIPInputStream(bis));
                } else if (path.endsWith(".zip")) {
                    ZipFile zf = new ZipFile(Location.getMappedId(this.file));
                    BufferedInputStream zip = new BufferedInputStream(zf.getInputStream(zf.entries().nextElement()), 0x100000);
                    this.dis = new DataInputStream(zip);
                } else if (path.endsWith(".bz2")) {
                    bis.skip(2L);
                    this.dis = new DataInputStream(new CBZip2InputStream(bis));
                }
                this.fp = 0L;
            }
            int skip = 0;
            do {
                skip = this.dis.skipBytes((int)(this.afp - this.fp));
                this.fp += (long)skip;
            } while (this.fp < this.afp && skip > 0);
            return 0;
        }
        if (this.dis != null && this.raf != null && this.afp + (long)toRead < 0x100000L && this.afp + (long)toRead < this.length() && this.afp + (long)toRead < (long)this.buf.length) {
            return 2;
        }
        if (this.dis != null) {
            if (this.fp < this.length()) {
                while (this.fp > this.length() - (long)this.dis.available()) {
                    while (this.fp - this.length() + (long)this.dis.available() > Integer.MAX_VALUE) {
                        this.dis.skipBytes(Integer.MAX_VALUE);
                    }
                    this.dis.skipBytes((int)(this.fp - (this.length() - (long)this.dis.available())));
                }
            } else {
                this.fp = this.afp;
                this.dis.close();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(Location.getMappedId(this.file)), 0x100000);
                this.dis = new DataInputStream(bis);
                while (this.fp > this.length() - (long)this.dis.available()) {
                    while (this.fp - this.length() + (long)this.dis.available() > Integer.MAX_VALUE) {
                        this.dis.skipBytes(Integer.MAX_VALUE);
                    }
                    this.dis.skipBytes((int)(this.fp - this.length() + (long)this.dis.available()));
                }
            }
        }
        if (this.afp >= this.fp && this.dis != null) {
            while (this.fp < this.afp) {
                while (this.afp - this.fp > Integer.MAX_VALUE) {
                    this.fp += (long)this.dis.skipBytes(Integer.MAX_VALUE);
                }
                int skip = this.dis.skipBytes((int)(this.afp - this.fp));
                if (skip == 0) break;
                this.fp += (long)skip;
            }
            if (this.fp >= this.nextMark) {
                this.dis.mark(0x100000);
            }
            this.nextMark = this.fp + 0x100000L;
            this.mark = this.fp;
            return 0;
        }
        if (this.dis != null && this.afp >= this.mark && this.fp < this.mark) {
            boolean valid = true;
            try {
                this.dis.reset();
            }
            catch (IOException io) {
                valid = false;
            }
            if (valid) {
                this.dis.mark(0x100000);
                this.fp = this.length() - (long)this.dis.available();
                while (this.fp < this.afp) {
                    while (this.afp - this.fp > Integer.MAX_VALUE) {
                        this.fp += (long)this.dis.skipBytes(Integer.MAX_VALUE);
                    }
                    int skip = this.dis.skipBytes((int)(this.afp - this.fp));
                    if (skip == 0) break;
                    this.fp += (long)skip;
                }
                if (this.fp >= this.nextMark) {
                    this.dis.mark(0x100000);
                }
                this.nextMark = this.fp + 0x100000L;
                this.mark = this.fp;
                return 0;
            }
            this.raf.seek(this.afp);
            return 1;
        }
        this.raf.seek(this.afp);
        return 1;
    }

    private void reopen() throws IOException {
        File f = new File(Location.getMappedId(this.file));
        f = f.getAbsoluteFile();
        if (Location.getMappedFile(this.file) != null) {
            this.raf = Location.getMappedFile(this.file);
            this.length = this.raf.length();
        } else if (f.exists()) {
            this.raf = new RAFile(f, "r");
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(Location.getMappedId(this.file)), 0x100000);
            String path = f.getPath().toLowerCase();
            if (this.dis != null) {
                this.dis.close();
            }
            if (path.endsWith(".gz")) {
                this.dis = new DataInputStream(new GZIPInputStream(bis));
                this.compressed = true;
            } else if (path.endsWith(".zip")) {
                ZipFile zf = new ZipFile(Location.getMappedId(this.file));
                BufferedInputStream zip = new BufferedInputStream(zf.getInputStream(zf.entries().nextElement()), 0x100000);
                this.dis = new DataInputStream(zip);
                this.compressed = true;
            } else if (path.endsWith(".bz2")) {
                bis.skip(2L);
                this.dis = new DataInputStream(new CBZip2InputStream(bis));
                this.compressed = true;
            } else {
                this.dis = new DataInputStream(bis);
            }
            if (!this.compressed) {
                this.length = this.raf.length();
                this.buf = new byte[(int)(this.length < 0x100000L ? this.length : 0x100000L)];
                this.raf.readFully(this.buf);
                this.raf.seek(0L);
            }
        } else if (this.file.startsWith("http")) {
            this.raf = new RAUrl(Location.getMappedId(this.file), "r");
            this.length = this.raf.length();
        }
        fileCache.put(this, Boolean.TRUE);
        if (++openFiles > 100) {
            this.cleanCache();
        }
    }

    private void cleanCache() {
        int toClose = 90;
        RandomAccessStream[] files = fileCache.keySet().toArray(new RandomAccessStream[0]);
        int closed = 0;
        int ndx = 0;
        while (closed < toClose) {
            if (!this.equals(files[ndx]) && !fileCache.get(files[ndx]).equals(Boolean.FALSE) && files[ndx].file != null) {
                try {
                    files[ndx].close();
                }
                catch (IOException exc) {
                    LogTools.trace(exc);
                }
                ++closed;
            }
            ++ndx;
        }
    }
}

