/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.math.BigInteger;
import loci.common.Location;
import loci.common.LogTools;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.ImageReader;

public class AxisGuesser {
    public static final int UNKNOWN_AXIS = 0;
    public static final int Z_AXIS = 1;
    public static final int T_AXIS = 2;
    public static final int C_AXIS = 3;
    public static final int S_AXIS = 4;
    protected static final String[] Z = new String[]{"fp", "sec", "z", "zs", "focal", "focalplane"};
    protected static final String[] T = new String[]{"t", "tl", "tp", "time"};
    protected static final String[] C = new String[]{"c", "ch", "w", "wavelength"};
    protected static final String[] S = new String[]{"s", "series", "e"};
    protected static final BigInteger TWO = new BigInteger("2");
    protected static final BigInteger THREE = new BigInteger("3");
    protected FilePattern fp;
    protected String dimOrder;
    protected String newOrder;
    protected int[] axisTypes;
    protected boolean certain;

    public AxisGuesser(FilePattern fp, String dimOrder, int sizeZ, int sizeT, int sizeC, boolean isCertain) {
        char[] ch;
        this.fp = fp;
        this.dimOrder = dimOrder;
        this.newOrder = dimOrder;
        String[] prefixes = fp.getPrefixes();
        String suffix = fp.getSuffix();
        BigInteger[] first = fp.getFirst();
        BigInteger[] last = fp.getLast();
        BigInteger[] step = fp.getStep();
        int[] count = fp.getCount();
        this.axisTypes = new int[count.length];
        boolean foundZ = false;
        boolean foundT = false;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            int j;
            int f;
            int l;
            String p = prefixes[i].toLowerCase();
            ch = p.toCharArray();
            for (l = ch.length - 1; l >= 0 && (ch[l] >= '0' && ch[l] <= '9' || ch[l] == ' ' || ch[l] == '-' || ch[l] == '_' || ch[l] == '.'); --l) {
            }
            for (f = l; f >= 0 && ch[f] >= 'a' && ch[f] <= 'z'; --f) {
            }
            p = p.substring(f + 1, l + 1);
            for (j = 0; j < Z.length; ++j) {
                if (!p.equals(Z[j])) continue;
                this.axisTypes[i] = 1;
                foundZ = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (j = 0; j < T.length; ++j) {
                if (!p.equals(T[j])) continue;
                this.axisTypes[i] = 2;
                foundT = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (j = 0; j < C.length; ++j) {
                if (!p.equals(C[j])) continue;
                this.axisTypes[i] = 3;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (j = 0; j < S.length; ++j) {
                if (!p.equals(S[j])) continue;
                this.axisTypes[i] = 4;
                break;
            }
            if (this.axisTypes[i] != 0 || !first[i].equals(TWO) || !last[i].equals(THREE) || !step[i].equals(BigInteger.ONE) || !suffix.equalsIgnoreCase(".pic")) continue;
            this.axisTypes[i] = 3;
            break;
        }
        if (!isCertain && (foundZ && !foundT && sizeZ > 1 && sizeT == 1 || foundT && !foundZ && sizeT > 1 && sizeZ == 1)) {
            int indexZ = this.newOrder.indexOf(90);
            int indexT = this.newOrder.indexOf(84);
            ch = this.newOrder.toCharArray();
            ch[indexZ] = 84;
            ch[indexT] = 90;
            this.newOrder = new String(ch);
            int sz = sizeT;
            sizeT = sizeZ;
            sizeZ = sz;
        }
        boolean canBeZ = !foundZ && sizeZ == 1;
        boolean canBeT = !foundT && sizeT == 1;
        this.certain = isCertain;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            if (this.axisTypes[i] != 0) continue;
            this.certain = false;
            if (canBeZ) {
                this.axisTypes[i] = 1;
                canBeZ = false;
                continue;
            }
            if (canBeT) {
                this.axisTypes[i] = 2;
                canBeT = false;
                continue;
            }
            this.axisTypes[i] = 3;
        }
    }

    public FilePattern getFilePattern() {
        return this.fp;
    }

    public String getOriginalOrder() {
        return this.dimOrder;
    }

    public String getAdjustedOrder() {
        return this.newOrder;
    }

    public boolean isCertain() {
        return this.certain;
    }

    public int[] getAxisTypes() {
        return this.axisTypes;
    }

    public void setAxisTypes(int[] axes) {
        this.axisTypes = axes;
    }

    public int getAxisCountZ() {
        return this.getAxisCount(1);
    }

    public int getAxisCountT() {
        return this.getAxisCount(2);
    }

    public int getAxisCountC() {
        return this.getAxisCount(3);
    }

    public int getAxisCountS() {
        return this.getAxisCount(4);
    }

    public int getAxisCount(int axisType) {
        int num = 0;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            if (this.axisTypes[i] != axisType) continue;
            ++num;
        }
        return num;
    }

    public static void main(String[] args) throws FormatException, IOException {
        Location file2 = args.length < 1 ? new Location(System.getProperty("user.dir")).listFiles()[0] : new Location(args[0]);
        LogTools.println("File = " + file2.getAbsoluteFile());
        String pat = FilePattern.findPattern(file2);
        if (pat == null) {
            LogTools.println("No pattern found.");
        } else {
            LogTools.println("Pattern = " + pat);
            FilePattern fp = new FilePattern(pat);
            if (fp.isValid()) {
                LogTools.println("Pattern is valid.");
                String id = fp.getFiles()[0];
                if (!new Location(id).exists()) {
                    LogTools.println("File '" + id + "' does not exist.");
                } else {
                    LogTools.print("Reading first file ");
                    ImageReader reader = new ImageReader();
                    reader.setId(id);
                    String dimOrder = reader.getDimensionOrder();
                    int sizeZ = reader.getSizeZ();
                    int sizeT = reader.getSizeT();
                    int sizeC = reader.getSizeC();
                    boolean certain = reader.isOrderCertain();
                    reader.close();
                    LogTools.println("[done]");
                    LogTools.println("\tdimOrder = " + dimOrder + (certain ? " (certain)" : " (uncertain)"));
                    LogTools.println("\tsizeZ = " + sizeZ);
                    LogTools.println("\tsizeT = " + sizeT);
                    LogTools.println("\tsizeC = " + sizeC);
                    AxisGuesser ag = new AxisGuesser(fp, dimOrder, sizeZ, sizeT, sizeC, certain);
                    String[] blocks = fp.getBlocks();
                    String[] prefixes = fp.getPrefixes();
                    int[] axes = ag.getAxisTypes();
                    String newOrder = ag.getAdjustedOrder();
                    boolean isCertain = ag.isCertain();
                    LogTools.println("Axis types:");
                    for (int i = 0; i < blocks.length; ++i) {
                        String axis;
                        switch (axes[i]) {
                            case 1: {
                                axis = "Z";
                                break;
                            }
                            case 2: {
                                axis = "T";
                                break;
                            }
                            case 3: {
                                axis = "C";
                                break;
                            }
                            default: {
                                axis = "?";
                            }
                        }
                        LogTools.println("\t" + blocks[i] + "\t" + axis + " (prefix = " + prefixes[i] + ")");
                    }
                    if (!dimOrder.equals(newOrder)) {
                        LogTools.println("Adjusted dimension order = " + newOrder + (isCertain ? " (certain)" : " (uncertain)"));
                    }
                }
            } else {
                LogTools.println("Pattern is invalid: " + fp.getErrorMessage());
            }
        }
    }
}

