/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.common.RandomAccessStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.TiffIFDEntry;
import loci.formats.TiffRational;
import loci.formats.UnknownTagException;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.LZWCodec;
import loci.formats.codec.LuraWaveCodec;
import loci.formats.codec.NikonCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.ZlibCodec;

public final class TiffTools {
    private static final boolean DEBUG = false;
    public static final int BYTES_PER_ENTRY = 12;
    public static final int BIG_TIFF_BYTES_PER_ENTRY = 20;
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_TIFF = 1;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int LONG8 = 16;
    public static final int SLONG8 = 17;
    public static final int IFD8 = 18;
    public static final int[] BYTES_PER_ELEMENT = new int[]{-1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, -1, -1, -1, 8, 8, 8};
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int SUBFILE_TYPE = 255;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRIC_INTERPRETATION = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELL_WIDTH = 264;
    public static final int CELL_LENGTH = 265;
    public static final int FILL_ORDER = 266;
    public static final int DOCUMENT_NAME = 269;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIP_OFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNTS = 279;
    public static final int MIN_SAMPLE_VALUE = 280;
    public static final int MAX_SAMPLE_VALUE = 281;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int PAGE_NAME = 285;
    public static final int X_POSITION = 286;
    public static final int Y_POSITION = 287;
    public static final int FREE_OFFSETS = 288;
    public static final int FREE_BYTE_COUNTS = 289;
    public static final int GRAY_RESPONSE_UNIT = 290;
    public static final int GRAY_RESPONSE_CURVE = 291;
    public static final int T4_OPTIONS = 292;
    public static final int T6_OPTIONS = 293;
    public static final int RESOLUTION_UNIT = 296;
    public static final int PAGE_NUMBER = 297;
    public static final int TRANSFER_FUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int ARTIST = 315;
    public static final int HOST_COMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITE_POINT = 318;
    public static final int PRIMARY_CHROMATICITIES = 319;
    public static final int COLOR_MAP = 320;
    public static final int HALFTONE_HINTS = 321;
    public static final int TILE_WIDTH = 322;
    public static final int TILE_LENGTH = 323;
    public static final int TILE_OFFSETS = 324;
    public static final int TILE_BYTE_COUNTS = 325;
    public static final int INK_SET = 332;
    public static final int INK_NAMES = 333;
    public static final int NUMBER_OF_INKS = 334;
    public static final int DOT_RANGE = 336;
    public static final int TARGET_PRINTER = 337;
    public static final int EXTRA_SAMPLES = 338;
    public static final int SAMPLE_FORMAT = 339;
    public static final int S_MIN_SAMPLE_VALUE = 340;
    public static final int S_MAX_SAMPLE_VALUE = 341;
    public static final int TRANSFER_RANGE = 342;
    public static final int JPEG_TABLES = 347;
    public static final int JPEG_PROC = 512;
    public static final int JPEG_INTERCHANGE_FORMAT = 513;
    public static final int JPEG_INTERCHANGE_FORMAT_LENGTH = 514;
    public static final int JPEG_RESTART_INTERVAL = 515;
    public static final int JPEG_LOSSLESS_PREDICTORS = 517;
    public static final int JPEG_POINT_TRANSFORMS = 518;
    public static final int JPEG_Q_TABLES = 519;
    public static final int JPEG_DC_TABLES = 520;
    public static final int JPEG_AC_TABLES = 521;
    public static final int Y_CB_CR_COEFFICIENTS = 529;
    public static final int Y_CB_CR_SUB_SAMPLING = 530;
    public static final int Y_CB_CR_POSITIONING = 531;
    public static final int REFERENCE_BLACK_WHITE = 532;
    public static final int COPYRIGHT = 33432;
    public static final int EXIF = 34665;
    public static final int UNCOMPRESSED = 1;
    public static final int CCITT_1D = 2;
    public static final int GROUP_3_FAX = 3;
    public static final int GROUP_4_FAX = 4;
    public static final int LZW = 5;
    public static final int JPEG = 7;
    public static final int PACK_BITS = 32773;
    public static final int PROPRIETARY_DEFLATE = 32946;
    public static final int DEFLATE = 8;
    public static final int THUNDERSCAN = 32809;
    public static final int JPEG_2000 = 33003;
    public static final int ALT_JPEG = 33007;
    public static final int NIKON = 34713;
    public static final int LURAWAVE = 65535;
    public static final int WHITE_IS_ZERO = 0;
    public static final int BLACK_IS_ZERO = 1;
    public static final int RGB = 2;
    public static final int RGB_PALETTE = 3;
    public static final int TRANSPARENCY_MASK = 4;
    public static final int CMYK = 5;
    public static final int Y_CB_CR = 6;
    public static final int CIE_LAB = 8;
    public static final int CFA_ARRAY = 32803;
    public static final int MAGIC_NUMBER = 42;
    public static final int BIG_TIFF_MAGIC_NUMBER = 43;
    public static final int LITTLE = 73;
    public static final int BIG = 77;

    private TiffTools() {
    }

    public static boolean isValidHeader(byte[] block) {
        return TiffTools.checkHeader(block) != null;
    }

    public static boolean isValidHeader(RandomAccessStream stream) {
        try {
            return TiffTools.checkHeader(stream) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Boolean checkHeader(byte[] block) {
        try {
            RandomAccessStream s = new RandomAccessStream(block);
            Boolean result = TiffTools.checkHeader(s);
            s.close();
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Boolean checkHeader(RandomAccessStream stream) throws IOException {
        boolean bigEndian;
        if (stream.length() < 4L) {
            return null;
        }
        stream.seek(0L);
        int endianOne = stream.read();
        int endianTwo = stream.read();
        boolean littleEndian = endianOne == 73 && endianTwo == 73;
        boolean bl = bigEndian = endianOne == 77 && endianTwo == 77;
        if (!littleEndian && !bigEndian) {
            return null;
        }
        stream.order(littleEndian);
        short magic = stream.readShort();
        if (magic != 42 && magic != 43) {
            return null;
        }
        return new Boolean(littleEndian);
    }

    public static boolean isBigTiff(Hashtable ifd) throws FormatException {
        return (Boolean)TiffTools.getIFDValue(ifd, 1, false, Boolean.class);
    }

    public static boolean isLittleEndian(Hashtable ifd) throws FormatException {
        return (Boolean)TiffTools.getIFDValue(ifd, 0, true, Boolean.class);
    }

    public static Hashtable[] getIFDs(RandomAccessStream in) throws IOException {
        Hashtable ifd;
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        in.seek(2L);
        boolean bigTiff = in.readShort() == 43;
        long offset = TiffTools.getFirstOffset(in, bigTiff);
        long ifdMax = (in.length() - 8L) / 18L;
        Vector<Hashtable> v = new Vector<Hashtable>();
        for (long ifdNum = 0L; ifdNum < ifdMax && (ifd = TiffTools.getIFD(in, ifdNum, offset, bigTiff)) != null && ifd.size() > 1; ++ifdNum) {
            v.add(ifd);
            long l = offset = bigTiff ? in.readLong() : (long)in.readInt() & 0xFFFFFFFFL;
            if (offset <= 0L || offset >= in.length()) break;
        }
        Object[] ifds = new Hashtable[v.size()];
        v.copyInto(ifds);
        return ifds;
    }

    public static Hashtable getFirstIFD(RandomAccessStream in) throws IOException {
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        in.seek(2L);
        boolean bigTiff = in.readShort() == 43;
        long offset = TiffTools.getFirstOffset(in, bigTiff);
        Hashtable ifd = TiffTools.getIFD(in, 0L, offset, bigTiff);
        ifd.put(new Integer(1), new Boolean(bigTiff));
        return ifd;
    }

    public static TiffIFDEntry getFirstIFDEntry(RandomAccessStream in, int tag) throws IOException {
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        in.seek(2L);
        boolean bigTiff = in.readShort() == 43;
        long offset = TiffTools.getFirstOffset(in, bigTiff);
        in.seek(offset);
        long numEntries = bigTiff ? in.readLong() : (long)(in.readShort() & 0xFFFF);
        int i = 0;
        while ((long)i < numEntries) {
            in.seek(offset + 2L + (long)((bigTiff ? 20 : 12) * i));
            int entryTag = in.readShort() & 0xFFFF;
            if (entryTag == tag) {
                int valueCount;
                int entryType = in.readShort() & 0xFFFF;
                int n = valueCount = bigTiff ? (int)(in.readLong() & 0xFFFFFFFFFFFFFFFFL) : in.readInt();
                if (valueCount < 0) {
                    throw new RuntimeException("Count of '" + valueCount + "' unexpected.");
                }
                long valueOffset = bigTiff ? in.readLong() : (long)in.readInt();
                return new TiffIFDEntry(entryTag, entryType, valueCount, valueOffset);
            }
            ++i;
        }
        throw new UnknownTagException();
    }

    public static long getFirstOffset(RandomAccessStream in) throws IOException {
        return TiffTools.getFirstOffset(in, false);
    }

    public static long getFirstOffset(RandomAccessStream in, boolean bigTiff) throws IOException {
        if (bigTiff) {
            in.skipBytes(4);
        }
        return bigTiff ? in.readLong() : (long)in.readInt();
    }

    public static Hashtable getIFD(RandomAccessStream in, long ifdNum, long offset) throws IOException {
        return TiffTools.getIFD(in, ifdNum, offset, false);
    }

    public static Hashtable getIFD(RandomAccessStream in, long ifdNum, long offset, boolean bigTiff) throws IOException {
        long numEntries;
        Hashtable<Integer, Comparable<Boolean>> ifd = new Hashtable<Integer, Comparable<Boolean>>();
        ifd.put(new Integer(0), new Boolean(in.isLittleEndian()));
        ifd.put(new Integer(1), new Boolean(bigTiff));
        in.seek(offset);
        long l = numEntries = bigTiff ? in.readLong() : (long)(in.readShort() & 0xFFFF);
        if (numEntries == 0L || numEntries == 1L) {
            return ifd;
        }
        int bytesPerEntry = bigTiff ? 20 : 12;
        int baseOffset = bigTiff ? 8 : 2;
        int threshhold = bigTiff ? 8 : 4;
        int i = 0;
        while ((long)i < numEntries) {
            int j;
            int count;
            in.seek(offset + (long)baseOffset + (long)(bytesPerEntry * i));
            int tag = in.readShort() & 0xFFFF;
            int type = in.readShort() & 0xFFFF;
            int n = count = bigTiff ? (int)(in.readLong() & 0xFFFFFFFFFFFFFFFFL) : in.readInt();
            if (count < 0) {
                return null;
            }
            Object value = null;
            if (type < 0 || type >= BYTES_PER_ELEMENT.length) {
                return null;
            }
            if (count > threshhold / BYTES_PER_ELEMENT[type]) {
                long pointer = bigTiff ? in.readLong() : (long)in.readInt() & 0xFFFFFFFFL;
                in.seek(pointer);
            }
            if (type == 1) {
                if (count == 1) {
                    value = new Short(in.readByte());
                } else {
                    byte[] bytes = new byte[count];
                    in.readFully(bytes);
                    short[] shorts = new short[count];
                    for (j = 0; j < count; ++j) {
                        shorts[j] = (short)(bytes[j] & 0xFF);
                    }
                    value = shorts;
                }
            } else if (type == 2) {
                byte[] ascii = new byte[count];
                in.read(ascii);
                int nullCount = 0;
                for (j = 0; j < count; ++j) {
                    if (ascii[j] != 0 && j != count - 1) continue;
                    ++nullCount;
                }
                String[] strings = nullCount == 1 ? null : new String[nullCount];
                Object s = null;
                int c = 0;
                int ndx = -1;
                for (int j2 = 0; j2 < count; ++j2) {
                    if (ascii[j2] == 0) {
                        s = new String(ascii, ndx + 1, j2 - ndx - 1);
                        ndx = j2;
                    } else {
                        s = j2 == count - 1 ? new String(ascii, ndx + 1, j2 - ndx) : null;
                    }
                    if (strings == null || s == null) continue;
                    strings[c++] = s;
                }
                value = strings == null ? s : strings;
            } else if (type == 3) {
                if (count == 1) {
                    value = new Integer(in.readShort() & 0xFFFF);
                } else {
                    int[] shorts = new int[count];
                    for (int j3 = 0; j3 < count; ++j3) {
                        shorts[j3] = in.readShort() & 0xFFFF;
                    }
                    value = shorts;
                }
            } else if (type == 4) {
                if (count == 1) {
                    value = new Long(in.readInt());
                } else {
                    long[] longs = new long[count];
                    for (int j4 = 0; j4 < count; ++j4) {
                        longs[j4] = in.readInt();
                    }
                    value = longs;
                }
            } else if (type == 16 || type == 17 || type == 18) {
                if (count == 1) {
                    value = new Long(in.readLong());
                } else {
                    long[] longs = new long[count];
                    for (int j5 = 0; j5 < count; ++j5) {
                        longs[j5] = in.readLong();
                    }
                    value = longs;
                }
            } else if (type == 5 || type == 10) {
                if (count == 1) {
                    value = new TiffRational(in.readInt(), in.readInt());
                } else {
                    TiffRational[] rationals = new TiffRational[count];
                    for (int j6 = 0; j6 < count; ++j6) {
                        rationals[j6] = new TiffRational(in.readInt(), in.readInt());
                    }
                    value = rationals;
                }
            } else if (type == 6 || type == 7) {
                if (count == 1) {
                    value = new Byte(in.readByte());
                } else {
                    byte[] sbytes = new byte[count];
                    in.read(sbytes);
                    value = sbytes;
                }
            } else if (type == 8) {
                if (count == 1) {
                    value = new Short(in.readShort());
                } else {
                    short[] sshorts = new short[count];
                    for (int j7 = 0; j7 < count; ++j7) {
                        sshorts[j7] = in.readShort();
                    }
                    value = sshorts;
                }
            } else if (type == 9) {
                if (count == 1) {
                    value = new Integer(in.readInt());
                } else {
                    int[] slongs = new int[count];
                    for (int j8 = 0; j8 < count; ++j8) {
                        slongs[j8] = in.readInt();
                    }
                    value = slongs;
                }
            } else if (type == 11) {
                if (count == 1) {
                    value = new Float(in.readFloat());
                } else {
                    float[] floats = new float[count];
                    for (int j9 = 0; j9 < count; ++j9) {
                        floats[j9] = in.readFloat();
                    }
                    value = floats;
                }
            } else if (type == 12) {
                if (count == 1) {
                    value = new Double(in.readDouble());
                } else {
                    double[] doubles = new double[count];
                    for (int j10 = 0; j10 < count; ++j10) {
                        doubles[j10] = in.readDouble();
                    }
                    value = doubles;
                }
            }
            if (value != null) {
                ifd.put(new Integer(tag), (Comparable<Boolean>)value);
            }
            ++i;
        }
        in.seek(offset + (long)baseOffset + (long)bytesPerEntry * numEntries);
        return ifd;
    }

    public static String getIFDTagName(int tag) {
        return TiffTools.getFieldName(tag);
    }

    public static String getIFDTypeName(int type) {
        return TiffTools.getFieldName(type);
    }

    public static String getFieldName(int value) {
        Field[] fields = TiffTools.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException exc) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "" + value;
    }

    public static Object getIFDValue(Hashtable ifd, int tag) {
        return ifd.get(new Integer(tag));
    }

    public static Object getIFDValue(Hashtable ifd, int tag, boolean checkNull, Class checkClass) throws FormatException {
        Object value = ifd.get(new Integer(tag));
        if (checkNull && value == null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry not found");
        }
        if (checkClass != null && value != null && !checkClass.isInstance(value)) {
            Class<?> cType = checkClass.getComponentType();
            Object array = null;
            if (cType == value.getClass()) {
                array = Array.newInstance(value.getClass(), 1);
                Array.set(array, 0, value);
            }
            if (cType == Boolean.TYPE && value instanceof Boolean) {
                array = Array.newInstance(Boolean.TYPE, 1);
                Array.setBoolean(array, 0, (Boolean)value);
            } else if (cType == Byte.TYPE && value instanceof Byte) {
                array = Array.newInstance(Byte.TYPE, 1);
                Array.setByte(array, 0, (Byte)value);
            } else if (cType == Character.TYPE && value instanceof Character) {
                array = Array.newInstance(Character.TYPE, 1);
                Array.setChar(array, 0, ((Character)value).charValue());
            } else if (cType == Double.TYPE && value instanceof Double) {
                array = Array.newInstance(Double.TYPE, 1);
                Array.setDouble(array, 0, (Double)value);
            } else if (cType == Float.TYPE && value instanceof Float) {
                array = Array.newInstance(Float.TYPE, 1);
                Array.setFloat(array, 0, ((Float)value).floatValue());
            } else if (cType == Integer.TYPE && value instanceof Integer) {
                array = Array.newInstance(Integer.TYPE, 1);
                Array.setInt(array, 0, (Integer)value);
            } else if (cType == Long.TYPE && value instanceof Long) {
                array = Array.newInstance(Long.TYPE, 1);
                Array.setLong(array, 0, (Long)value);
            } else if (cType == Short.TYPE && value instanceof Short) {
                array = Array.newInstance(Short.TYPE, 1);
                Array.setShort(array, 0, (Short)value);
            }
            if (array != null) {
                return array;
            }
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected " + checkClass.getName());
        }
        return value;
    }

    public static long getIFDLongValue(Hashtable ifd, int tag, boolean checkNull, long defaultValue) throws FormatException {
        long value = defaultValue;
        Number number = (Number)TiffTools.getIFDValue(ifd, tag, checkNull, Number.class);
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public static int getIFDIntValue(Hashtable ifd, int tag) {
        int value = -1;
        try {
            value = TiffTools.getIFDIntValue(ifd, tag, false, -1);
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return value;
    }

    public static int getIFDIntValue(Hashtable ifd, int tag, boolean checkNull, int defaultValue) throws FormatException {
        int value = defaultValue;
        Number number = (Number)TiffTools.getIFDValue(ifd, tag, checkNull, Number.class);
        if (number != null) {
            value = number.intValue();
        }
        return value;
    }

    public static TiffRational getIFDRationalValue(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        return (TiffRational)TiffTools.getIFDValue(ifd, tag, checkNull, TiffRational.class);
    }

    public static long[] getIFDLongArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        long[] results = null;
        if (value instanceof long[]) {
            results = (long[])value;
        } else if (value instanceof Number) {
            results = new long[]{((Number)value).longValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new long[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].longValue();
            }
        } else if (value instanceof int[]) {
            int[] integers = (int[])value;
            results = new long[integers.length];
            for (int i = 0; i < integers.length; ++i) {
                results[i] = integers[i];
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, long[], Number[] or int[])");
        }
        return results;
    }

    public static int[] getIFDIntArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        int[] results = null;
        if (value instanceof int[]) {
            results = (int[])value;
        } else if (value instanceof Number) {
            results = new int[]{((Number)value).intValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new int[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].intValue();
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, int[] or Number[])");
        }
        return results;
    }

    public static short[] getIFDShortArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        short[] results = null;
        if (value instanceof short[]) {
            results = (short[])value;
        } else if (value instanceof Number) {
            results = new short[]{((Number)value).shortValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new short[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].shortValue();
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, short[] or Number[])");
        }
        return results;
    }

    public static String getComment(Hashtable ifd) {
        if (ifd == null) {
            return null;
        }
        Object o = TiffTools.getIFDValue(ifd, 270);
        String comment = null;
        if (o instanceof String) {
            comment = (String)o;
        } else if (o instanceof String[]) {
            String[] s = (String[])o;
            if (s.length > 0) {
                comment = s[0];
            }
        } else if (o != null) {
            comment = o.toString();
        }
        if (comment != null) {
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
        }
        return comment;
    }

    public static String getComment(String id) throws FormatException, IOException {
        RandomAccessStream in = new RandomAccessStream(id);
        Hashtable ifd = TiffTools.getFirstIFD(in);
        in.close();
        return TiffTools.getComment(ifd);
    }

    public static byte[][] getSamples(Hashtable ifd, RandomAccessStream in) throws FormatException, IOException {
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        int bpp = TiffTools.getBitsPerSample(ifd)[0];
        while (bpp % 8 != 0) {
            ++bpp;
        }
        long width = TiffTools.getImageWidth(ifd);
        long length = TiffTools.getImageLength(ifd);
        byte[] b = new byte[(int)(width * length * (long)samplesPerPixel * (long)(bpp /= 8))];
        TiffTools.getSamples(ifd, in, b);
        byte[][] samples = new byte[samplesPerPixel][(int)(width * length * (long)bpp)];
        for (int i = 0; i < samplesPerPixel; ++i) {
            System.arraycopy(b, (int)((long)i * width * length * (long)bpp), samples[i], 0, samples[i].length);
        }
        b = null;
        return samples;
    }

    public static byte[] getSamples(Hashtable ifd, RandomAccessStream in, byte[] buf) throws FormatException, IOException {
        long width = TiffTools.getImageWidth(ifd);
        long length = TiffTools.getImageLength(ifd);
        return TiffTools.getSamples(ifd, in, buf, 0, 0, width, length);
    }

    public static byte[] getSamples(Hashtable ifd, RandomAccessStream in, byte[] buf, int x, int y, long width, long height) throws FormatException, IOException {
        boolean lastBitsZero;
        long maxValue;
        boolean littleEndian = TiffTools.isLittleEndian(ifd);
        in.order(littleEndian);
        long imageWidth = TiffTools.getImageWidth(ifd);
        long imageLength = TiffTools.getImageLength(ifd);
        int[] bitsPerSample = TiffTools.getBitsPerSample(ifd);
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        int compression = TiffTools.getCompression(ifd);
        int photoInterp = TiffTools.getPhotometricInterpretation(ifd);
        long[] stripOffsets = TiffTools.getStripOffsets(ifd);
        long[] stripByteCounts = TiffTools.getStripByteCounts(ifd);
        long[] rowsPerStripArray = TiffTools.getRowsPerStrip(ifd);
        boolean fakeByteCounts = stripByteCounts == null;
        boolean fakeRPS = rowsPerStripArray == null;
        boolean isTiled = stripOffsets == null || ifd.get(new Integer(322)) != null;
        long[] maxes = TiffTools.getIFDLongArray(ifd, 281, false);
        long l = maxValue = maxes == null ? 0L : maxes[0];
        if (isTiled) {
            if (stripOffsets == null) {
                stripOffsets = TiffTools.getIFDLongArray(ifd, 324, true);
            }
            if (stripByteCounts == null) {
                stripByteCounts = TiffTools.getIFDLongArray(ifd, 325, true);
            }
            rowsPerStripArray = new long[]{imageLength};
        } else if (fakeByteCounts) {
            stripByteCounts = new long[stripOffsets.length];
            if (stripByteCounts.length == 1) {
                stripByteCounts[0] = imageWidth * imageLength * (long)(bitsPerSample[0] / 8);
            } else {
                stripByteCounts[0] = stripOffsets[0];
                for (int i = 1; i < stripByteCounts.length; ++i) {
                    stripByteCounts[i] = stripOffsets[i] - stripByteCounts[i - 1];
                }
            }
        }
        boolean bl = lastBitsZero = bitsPerSample[bitsPerSample.length - 1] == 0;
        if (fakeRPS && !isTiled) {
            int i;
            rowsPerStripArray = new long[bitsPerSample.length];
            long temp = stripByteCounts[0];
            stripByteCounts = new long[bitsPerSample.length];
            Arrays.fill(stripByteCounts, temp);
            temp = bitsPerSample[0];
            if (temp == 0L) {
                temp = 8L;
            }
            bitsPerSample = new int[bitsPerSample.length];
            Arrays.fill(bitsPerSample, (int)temp);
            temp = stripOffsets[0];
            if (bitsPerSample[0] > 64) {
                bitsPerSample[0] = DataTools.swap(bitsPerSample[0]);
                stripOffsets[0] = DataTools.swap(stripOffsets[0]);
                stripByteCounts[0] = DataTools.swap(stripByteCounts[0]);
            }
            if (rowsPerStripArray.length == 1 && stripByteCounts[0] != imageWidth * imageLength * (long)(bitsPerSample[0] / 8) && compression == 1) {
                for (i = 0; i < stripByteCounts.length; ++i) {
                    stripByteCounts[i] = imageWidth * imageLength * (long)(bitsPerSample[i] / 8);
                    stripOffsets[0] = in.length() - stripByteCounts[0] - 48L * imageWidth;
                    if (i != 0) {
                        stripOffsets[i] = stripOffsets[i - 1] + stripByteCounts[i];
                    }
                    in.seek(stripOffsets[i]);
                    in.read(buf, (int)((long)i * imageWidth), (int)imageWidth);
                    boolean isZero = true;
                    int j = 0;
                    while ((long)j < imageWidth) {
                        if (buf[(int)((long)i * imageWidth + (long)j)] != 0) {
                            isZero = false;
                            break;
                        }
                        ++j;
                    }
                    block5: while (isZero) {
                        int n = i;
                        stripOffsets[n] = stripOffsets[n] - imageWidth;
                        in.seek(stripOffsets[i]);
                        in.read(buf, (int)((long)i * imageWidth), (int)imageWidth);
                        j = 0;
                        while ((long)j < imageWidth) {
                            if (buf[(int)((long)i * imageWidth + (long)j)] != 0) {
                                isZero = false;
                                int n2 = i;
                                stripOffsets[n2] = stripOffsets[n2] - (stripByteCounts[i] - imageWidth);
                                continue block5;
                            }
                            ++j;
                        }
                    }
                }
            }
            for (i = 0; i < bitsPerSample.length; ++i) {
                if (i < bitsPerSample.length) {
                    if (i == samplesPerPixel) {
                        bitsPerSample[i] = 0;
                        lastBitsZero = true;
                    }
                    if (bitsPerSample[i] != 0) {
                        rowsPerStripArray[i] = stripByteCounts[i] / (imageWidth * (long)(bitsPerSample[i] / 8));
                        continue;
                    }
                    if (bitsPerSample[i] == 0 && i > 0) {
                        rowsPerStripArray[i] = stripByteCounts[i] / (imageWidth * (long)(bitsPerSample[i - 1] / 8));
                        bitsPerSample[i] = bitsPerSample[i - 1];
                        continue;
                    }
                    throw new FormatException("BitsPerSample is 0");
                }
                if (i < bitsPerSample.length) continue;
                rowsPerStripArray[i] = stripByteCounts[i] / (imageWidth * (long)(bitsPerSample[bitsPerSample.length - 1] / 8));
            }
            if (compression != 1) {
                i = 0;
                while (i < stripByteCounts.length) {
                    int n = i++;
                    stripByteCounts[n] = stripByteCounts[n] * 2L;
                }
            }
        }
        if (lastBitsZero) {
            bitsPerSample[bitsPerSample.length - 1] = 0;
        }
        TiffRational xResolution = TiffTools.getIFDRationalValue(ifd, 282, false);
        TiffRational yResolution = TiffTools.getIFDRationalValue(ifd, 283, false);
        int planarConfig = TiffTools.getIFDIntValue(ifd, 284, false, 1);
        int resolutionUnit = TiffTools.getIFDIntValue(ifd, 296, false, 2);
        if (xResolution == null || yResolution == null) {
            resolutionUnit = 0;
        }
        int[] colorMap = TiffTools.getIFDIntArray(ifd, 320, false);
        int predictor = TiffTools.getIFDIntValue(ifd, 317, false, 1);
        for (int i = 0; i < samplesPerPixel; ++i) {
            if (bitsPerSample[i] < 1) {
                throw new FormatException("Illegal BitsPerSample (" + bitsPerSample[i] + ")");
            }
            if (bitsPerSample[i] % 2 == 0 || bitsPerSample[i] == 1) continue;
            throw new FormatException("Sorry, unsupported BitsPerSample (" + bitsPerSample[i] + ")");
        }
        if (bitsPerSample.length < samplesPerPixel) {
            throw new FormatException("BitsPerSample length (" + bitsPerSample.length + ") does not match SamplesPerPixel (" + samplesPerPixel + ")");
        }
        if (photoInterp == 4) {
            throw new FormatException("Sorry, Transparency Mask PhotometricInterpretation is not supported");
        }
        if (photoInterp == 8) {
            throw new FormatException("Sorry, CIELAB PhotometricInterpretation is not supported");
        }
        if (photoInterp != 0 && photoInterp != 1 && photoInterp != 2 && photoInterp != 3 && photoInterp != 5 && photoInterp != 6 && photoInterp != 32803) {
            throw new FormatException("Unknown PhotometricInterpretation (" + photoInterp + ")");
        }
        long rowsPerStrip = rowsPerStripArray[0];
        for (int i = 1; i < rowsPerStripArray.length; ++i) {
            if (rowsPerStrip == rowsPerStripArray[i]) continue;
            throw new FormatException("Sorry, non-uniform RowsPerStrip is not supported");
        }
        if (compression == 3) {
            Arrays.fill(bitsPerSample, 8);
        } else if (compression == 7) {
            photoInterp = 2;
        }
        long numStrips = (imageLength + rowsPerStrip - 1L) / rowsPerStrip;
        if (isTiled || fakeRPS) {
            numStrips = stripOffsets.length;
        }
        if (planarConfig == 2) {
            numStrips *= (long)samplesPerPixel;
        }
        if ((long)stripOffsets.length < numStrips && !fakeRPS) {
            throw new FormatException("StripOffsets length (" + stripOffsets.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        if (fakeRPS) {
            numStrips = stripOffsets.length;
        }
        if ((long)stripByteCounts.length < numStrips) {
            throw new FormatException("StripByteCounts length (" + stripByteCounts.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        if (width > Integer.MAX_VALUE || height > Integer.MAX_VALUE || width * height > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth x ImageLength > 2147483647 is not supported (" + width + " x " + height + ")");
        }
        int numSamples = (int)(width * height);
        if (planarConfig != 1 && planarConfig != 2) {
            throw new FormatException("Unknown PlanarConfiguration (" + planarConfig + ")");
        }
        if (photoInterp == 32803) {
            if (colorMap == null && (colorMap = TiffTools.getIFDIntArray(ifd, 320, false)) == null) {
                colorMap = new int[4];
                if (littleEndian) {
                    colorMap[0] = 2;
                    colorMap[1] = 0;
                    colorMap[2] = 2;
                    colorMap[3] = 0;
                } else {
                    colorMap[0] = 0;
                    colorMap[1] = 2;
                    colorMap[2] = 0;
                    colorMap[3] = 2;
                }
            }
            int[] tempMap = new int[colorMap.length + 2];
            System.arraycopy(colorMap, 0, tempMap, 0, colorMap.length);
            tempMap[tempMap.length - 2] = (int)imageWidth;
            tempMap[tempMap.length - 1] = (int)imageLength;
            colorMap = tempMap;
        } else if (photoInterp == 6) {
            colorMap = new int[5 + samplesPerPixel * 2];
            int[] ref = TiffTools.getIFDIntArray(ifd, 532, false);
            if (ref != null) {
                System.arraycopy(ref, 0, colorMap, 0, ref.length);
            } else {
                colorMap[4] = 0;
                colorMap[2] = 0;
                colorMap[0] = 0;
                colorMap[5] = 255;
                colorMap[3] = 255;
                colorMap[1] = 255;
            }
            ref = TiffTools.getIFDIntArray(ifd, 530, false);
            if (ref == null) {
                ref = new int[]{2, 2};
            }
            System.arraycopy(ref, 0, colorMap, samplesPerPixel * 2, ref.length);
            TiffRational[] coeffs = (TiffRational[])TiffTools.getIFDValue(ifd, 529);
            if (coeffs != null) {
                for (int i = 0; i < coeffs.length; ++i) {
                    colorMap[colorMap.length - coeffs.length + i] = (int)(10000.0f * ((float)coeffs[i].getNumerator() / (float)coeffs[i].getDenominator()));
                }
            } else {
                colorMap[colorMap.length - 3] = 2990;
                colorMap[colorMap.length - 2] = 5870;
                colorMap[colorMap.length - 1] = 1140;
            }
        }
        if (stripOffsets.length > 1 && stripOffsets[stripOffsets.length - 1] == stripOffsets[stripOffsets.length - 2]) {
            long[] tmp = stripOffsets;
            stripOffsets = new long[tmp.length - 1];
            System.arraycopy(tmp, 0, stripOffsets, 0, stripOffsets.length);
            --numStrips;
        }
        byte[] jpegTable = null;
        if (compression == 7) {
            jpegTable = (byte[])TiffTools.getIFDValue(ifd, 347);
        }
        CodecOptions options = new CodecOptions();
        options.interleaved = true;
        options.littleEndian = littleEndian;
        if (isTiled) {
            int numTileCols;
            long tileWidth = TiffTools.getIFDLongValue(ifd, 322, true, 0L);
            long tileLength = TiffTools.getIFDLongValue(ifd, 323, true, 0L);
            int numTileRows = (int)(imageLength / tileLength);
            if ((long)numTileRows * tileLength < imageLength) {
                ++numTileRows;
            }
            if ((long)(numTileCols = (int)(imageWidth / tileWidth)) * tileWidth < imageWidth) {
                ++numTileCols;
            }
            Rectangle imageBounds = new Rectangle(x, y, (int)width, (int)height);
            int endX = (int)width + x;
            int endY = (int)height + y;
            int pixel = bitsPerSample[0] / 8;
            int channels = 1;
            if (planarConfig != 2) {
                channels = samplesPerPixel;
            } else {
                pixel *= samplesPerPixel;
            }
            for (int row = 0; row < numTileRows; ++row) {
                for (int col = 0; col < numTileCols; ++col) {
                    int size;
                    Rectangle tileBounds = new Rectangle(col * (int)tileWidth, row * (int)tileLength, (int)tileWidth, (int)tileLength);
                    if (!imageBounds.intersects(tileBounds)) continue;
                    int tileNumber = row * numTileCols + col;
                    byte[] tile = new byte[(int)stripByteCounts[tileNumber]];
                    in.seek(stripOffsets[tileNumber] & 0xFFFFFFFFL);
                    in.read(tile);
                    options.maxBytes = size = (int)(tileWidth * tileLength * (long)pixel * (long)channels);
                    if (jpegTable != null) {
                        byte[] q = new byte[jpegTable.length + tile.length - 4];
                        System.arraycopy(jpegTable, 0, q, 0, jpegTable.length - 2);
                        System.arraycopy(tile, 2, q, jpegTable.length - 2, tile.length - 2);
                        tile = TiffTools.uncompress(q, compression, options);
                    } else {
                        tile = TiffTools.uncompress(tile, compression, options);
                    }
                    TiffTools.undifference(tile, bitsPerSample, tileWidth, planarConfig, predictor, littleEndian);
                    byte[] t = new byte[size];
                    TiffTools.unpackBytes(t, 0, tile, bitsPerSample, photoInterp, colorMap, littleEndian, maxValue, planarConfig, 0, 1, tileWidth);
                    int tileX = Math.max(tileBounds.x, x);
                    int tileY = Math.max(tileBounds.y, y);
                    int realX = tileX % (int)tileWidth;
                    int realY = tileY % (int)tileLength;
                    int twidth = (int)Math.min((long)(endX - tileX), tileWidth - (long)realX);
                    int theight = (int)Math.min((long)(endY - tileY), tileLength - (long)realY);
                    int rowLen = pixel * (int)tileWidth;
                    int copy = pixel * twidth;
                    int tileSize = (int)(tileWidth * tileLength * (long)pixel);
                    int planeSize = (int)(width * height * (long)pixel);
                    for (int q = 0; q < channels; ++q) {
                        for (int tileRow = 0; tileRow < theight; ++tileRow) {
                            int src = q * tileSize + (realY + tileRow) * rowLen + realX * pixel;
                            int dest = (int)((long)(q * planeSize) + (long)(tileY - y + tileRow) * width * (long)pixel + (long)((tileX - x) * pixel));
                            System.arraycopy(t, src, buf, dest, copy);
                        }
                    }
                }
            }
        } else {
            int offset = 0;
            if (rowsPerStrip <= 0L || numStrips <= 0L) {
                numStrips = 1L;
                rowsPerStrip = (int)imageLength;
            }
            int strip = 0;
            int row = 0;
            while ((long)strip < numStrips) {
                if ((long)row % imageLength + rowsPerStrip >= (long)y && (long)row % imageLength < (long)y + height) {
                    try {
                        int size = (int)imageWidth * (bitsPerSample[0] / 8);
                        if (planarConfig != 2) {
                            size *= samplesPerPixel;
                        }
                        int nRows = (int)rowsPerStrip;
                        if ((long)row % imageLength < (long)y) {
                            nRows = (int)((long)nRows - ((long)y - (long)row % imageLength));
                        }
                        if ((long)row % imageLength + rowsPerStrip > (long)y + height) {
                            nRows = (int)((long)nRows - ((long)row % imageLength + rowsPerStrip - height - (long)y));
                        }
                        size = (int)((long)size * rowsPerStrip);
                        if (stripOffsets[strip] < 0L) {
                            stripOffsets[strip] = stripOffsets[strip] & 0xFFFFFFFFL;
                        }
                        in.seek(stripOffsets[strip]);
                        if (stripByteCounts[strip] > Integer.MAX_VALUE) {
                            throw new FormatException("Sorry, StripByteCounts > 2147483647 is not supported");
                        }
                        byte[] bytes = new byte[(int)stripByteCounts[strip]];
                        in.read(bytes);
                        options.maxBytes = size;
                        if (jpegTable != null) {
                            byte[] q = new byte[jpegTable.length + bytes.length - 4];
                            System.arraycopy(jpegTable, 0, q, 0, jpegTable.length - 2);
                            System.arraycopy(bytes, 2, q, jpegTable.length - 2, bytes.length - 2);
                            bytes = TiffTools.uncompress(q, compression, options);
                        } else {
                            bytes = TiffTools.uncompress(bytes, compression, options);
                        }
                        TiffTools.undifference(bytes, bitsPerSample, imageWidth, planarConfig, predictor, littleEndian);
                        if (x != 0 || width != imageWidth || y != 0 || height != imageLength) {
                            byte[] tmp = bytes;
                            int extra = bitsPerSample[0] / 8;
                            if (planarConfig != 2) {
                                extra *= samplesPerPixel;
                            }
                            int rowLen = (int)width * extra;
                            int srcRowLen = (int)imageWidth * extra;
                            bytes = new byte[(int)((long)(nRows * extra) * width)];
                            int startRow = (long)row % imageLength < (long)y ? (int)((long)y - (long)row % imageLength) : 0;
                            int endRow = (int)((long)row % imageLength + rowsPerStrip > (long)y + height ? (long)y + height - (long)row % imageLength : rowsPerStrip);
                            for (int n = startRow; n < endRow; ++n) {
                                int srcOffset = n * srcRowLen + x * extra;
                                System.arraycopy(tmp, srcOffset, bytes, (n - startRow) * rowLen, rowLen);
                            }
                            nRows = endRow - startRow;
                        }
                        TiffTools.unpackBytes(buf, offset, bytes, bitsPerSample, photoInterp, colorMap, littleEndian, maxValue, planarConfig, strip, (int)numStrips, width);
                        int div = bitsPerSample[0] / 8;
                        if (div == 0) {
                            div = 1;
                        }
                        if (bitsPerSample[0] % 8 != 0) {
                            ++div;
                        }
                        if (planarConfig != 2) {
                            div *= samplesPerPixel;
                        }
                        offset += bytes.length / div;
                    }
                    catch (Exception e) {
                        if (strip == 0) {
                            if (e instanceof FormatException) {
                                throw (FormatException)e;
                            }
                            throw new FormatException(e);
                        }
                        byte[] bytes = new byte[numSamples];
                        TiffTools.undifference(bytes, bitsPerSample, imageWidth, planarConfig, predictor, littleEndian);
                        offset = (int)(imageWidth * (long)row);
                        TiffTools.unpackBytes(buf, offset, bytes, bitsPerSample, photoInterp, colorMap, littleEndian, maxValue, planarConfig, strip, (int)numStrips, imageWidth);
                    }
                }
                row = (int)((long)row + rowsPerStrip);
                ++strip;
            }
        }
        return buf;
    }

    public static void planarUnpack(byte[] samples, int startIndex, byte[] bytes, int[] bitsPerSample, int photoInterp, boolean littleEndian, int strip, int numStrips) throws FormatException {
        int numChannels = bitsPerSample.length;
        int numSamples = samples.length / numChannels;
        if (bitsPerSample[bitsPerSample.length - 1] == 0) {
            --numChannels;
        }
        if (numStrips < numChannels) {
            numStrips = numChannels;
        }
        int channelNum = strip / (numStrips / numChannels);
        BitBuffer bb = new BitBuffer(bytes);
        boolean index = false;
        boolean counter = false;
        int numBytes = bitsPerSample[0] / 8;
        if (bitsPerSample[0] % 8 != 0) {
            ++numBytes;
        }
        int realBytes = numBytes;
        if (numBytes == 3) {
            ++numBytes;
        }
        for (int j = 0; j < bytes.length / realBytes; ++j) {
            int value = bb.getBits(bitsPerSample[0]);
            if (photoInterp == 0) {
                value = (int)(Math.pow(2.0, bitsPerSample[0]) - 1.0 - (double)value);
            } else if (photoInterp == 5) {
                value = Integer.MAX_VALUE - value;
            }
            if (numBytes * (startIndex + j) >= samples.length) continue;
            DataTools.unpackBytes(value, samples, numBytes * (startIndex + j), numBytes, littleEndian);
        }
    }

    public static void unpackBytes(byte[] samples, int startIndex, byte[] bytes, int[] bitsPerSample, int photoInterp, int[] colorMap, boolean littleEndian, long maxValue, int planar, int strip, int numStrips, long imageWidth) throws FormatException {
        boolean bps16;
        if (planar == 2) {
            TiffTools.planarUnpack(samples, startIndex, bytes, bitsPerSample, photoInterp, littleEndian, strip, numStrips);
            return;
        }
        int nSamples = samples.length / bitsPerSample.length;
        int nChannels = bitsPerSample.length;
        int totalBits = 0;
        for (int i = 0; i < bitsPerSample.length; ++i) {
            totalBits += bitsPerSample[i];
        }
        int sampleCount = 8 * bytes.length / totalBits;
        if (photoInterp == 6) {
            sampleCount *= 3;
        }
        int bps0 = bitsPerSample[0];
        int numBytes = bps0 / 8;
        boolean noDiv8 = bps0 % 8 != 0;
        boolean bps8 = bps0 == 8;
        boolean bl = bps16 = bps0 == 16;
        if (photoInterp == 32803) {
            imageWidth = colorMap[colorMap.length - 2];
        }
        int row = 0;
        boolean col = false;
        if (imageWidth != 0L) {
            row = startIndex / (int)imageWidth;
        }
        int cw = 0;
        int ch = 0;
        if (photoInterp == 32803) {
            byte[] c = new byte[]{(byte)colorMap[0], (byte)colorMap[1]};
            cw = DataTools.bytesToInt(c, littleEndian);
            c[0] = (byte)colorMap[2];
            c[1] = (byte)colorMap[3];
            ch = DataTools.bytesToInt(c, littleEndian);
            int[] tmp = colorMap;
            colorMap = new int[tmp.length - 6];
            System.arraycopy(tmp, 6, colorMap, 0, colorMap.length);
        }
        int index = 0;
        boolean count = false;
        BitBuffer bb = new BitBuffer(bytes);
        byte[] copyByteArray = new byte[numBytes];
        block1: for (int j = 0; j < sampleCount; ++j) {
            int ndx;
            for (int i = 0; i < nChannels && i * nSamples + (ndx = startIndex + j) < (i + 1) * nSamples; ++i) {
                if (noDiv8) {
                    short s = 0;
                    if (i == 0 && photoInterp == 3 || photoInterp != 32803 && photoInterp != 3) {
                        s = (short)(bb.getBits(bps0) & 0xFFFF);
                        if ((long)ndx % imageWidth == imageWidth - 1L && bps0 < 8) {
                            bb.skipBits(imageWidth * (long)bps0 * (long)sampleCount % 8L);
                        }
                    }
                    if (photoInterp == 0 || photoInterp == 5) {
                        s = (short)(Math.pow(2.0, bitsPerSample[0]) - 1.0 - (double)s);
                    }
                    if (i * nSamples + (ndx + 1) * (numBytes + 1) > samples.length) continue;
                    DataTools.unpackBytes(s, samples, i * nSamples + ndx * (numBytes + 1), numBytes + 1, littleEndian);
                    continue;
                }
                if (bps8) {
                    if (i * nSamples + ndx >= samples.length) continue block1;
                    if (photoInterp != 6) {
                        samples[i * nSamples + ndx] = (byte)(bytes[index++] & 0xFF);
                    }
                    if (photoInterp == 0) {
                        samples[i * nSamples + ndx] = (byte)(255 - samples[i * nSamples + ndx]);
                        continue;
                    }
                    if (photoInterp == 5) {
                        samples[i * nSamples + ndx] = (byte)(Integer.MAX_VALUE - samples[i * nSamples + ndx]);
                        continue;
                    }
                    if (photoInterp != 6 || i != bitsPerSample.length - 1) continue;
                    float lumaRed = colorMap[colorMap.length - 3];
                    float lumaGreen = colorMap[colorMap.length - 2];
                    float lumaBlue = colorMap[colorMap.length - 1];
                    lumaRed /= 10000.0f;
                    lumaGreen /= 10000.0f;
                    lumaBlue /= 10000.0f;
                    int subX = colorMap[colorMap.length - 5];
                    int subY = colorMap[colorMap.length - 4];
                    int block = subX * subY;
                    int lumaIndex = j + 2 * (j / block);
                    int chromaIndex = j / block * (block + 2) + block;
                    if (chromaIndex + 1 >= bytes.length) continue block1;
                    int tile = ndx / block;
                    int pixel = ndx % block;
                    long r = (long)subY * ((long)tile / (imageWidth / (long)subX)) + (long)(pixel / subX);
                    long c = (long)subX * ((long)tile % (imageWidth / (long)subX)) + (long)(pixel % subX);
                    int idx = (int)(r * imageWidth + c);
                    if (idx >= nSamples) continue;
                    int y = (bytes[lumaIndex] & 0xFF) - colorMap[0];
                    int cb = (bytes[chromaIndex] & 0xFF) - colorMap[2];
                    int cr = (bytes[chromaIndex + 1] & 0xFF) - colorMap[4];
                    int red = (int)((float)cr * (2.0f - 2.0f * lumaRed) + (float)y);
                    int blue = (int)((float)cb * (2.0f - 2.0f * lumaBlue) + (float)y);
                    int green = (int)(((float)y - lumaBlue * (float)blue - lumaRed * (float)red) / lumaGreen);
                    samples[idx] = (byte)red;
                    samples[nSamples + idx] = (byte)green;
                    samples[2 * nSamples + idx] = (byte)blue;
                    continue;
                }
                if (bps16) {
                    int nioIndex = numBytes + index < bytes.length ? index : bytes.length - numBytes;
                    short v = DataTools.bytesToShort(bytes, nioIndex, 2, littleEndian);
                    index += numBytes;
                    if (photoInterp == 0) {
                        long max = (long)Math.pow(2.0, numBytes * 8) - 1L;
                        v = (short)(max - (long)v);
                    } else if (photoInterp == 5) {
                        v = (short)(Integer.MAX_VALUE - v);
                    }
                    if (ndx * 2 >= nSamples) continue block1;
                    DataTools.unpackShort(v, samples, i * nSamples + ndx * 2, littleEndian);
                    continue;
                }
                if (numBytes + index < bytes.length) {
                    System.arraycopy(bytes, index, copyByteArray, 0, numBytes);
                } else {
                    System.arraycopy(bytes, bytes.length - numBytes, copyByteArray, 0, numBytes);
                }
                index += numBytes;
                long v = DataTools.bytesToLong(copyByteArray, littleEndian);
                if (photoInterp == 0) {
                    long max = 1L;
                    for (int q = 0; q < numBytes; ++q) {
                        max *= 8L;
                    }
                    v = max - v;
                } else if (photoInterp == 5) {
                    v = Integer.MAX_VALUE - v;
                }
                if (ndx * numBytes >= nSamples) continue block1;
                DataTools.unpackBytes(v, samples, i * nSamples + ndx * numBytes, numBytes, littleEndian);
            }
        }
    }

    public static byte[] uncompress(byte[] input, int compression, CodecOptions options) throws FormatException, IOException {
        if (compression < 0) {
            compression += 65536;
        }
        if (compression == 1) {
            return input;
        }
        if (compression == 2) {
            throw new FormatException("Sorry, CCITT Group 3 1-Dimensional Modified Huffman run length encoding compression mode is not supported");
        }
        if (compression == 3) {
            throw new FormatException("Sorry, CCITT T.4 bi-level encoding (Group 3 Fax) compression mode is not supported");
        }
        if (compression == 4) {
            throw new FormatException("Sorry, CCITT T.6 bi-level encoding (Group 4 Fax) compression mode is not supported");
        }
        if (compression == 5) {
            return new LZWCodec().decompress(input, options);
        }
        if (compression == 7 || compression == 33007) {
            return new JPEGCodec().decompress(input, options);
        }
        if (compression == 33003) {
            return new JPEG2000Codec().decompress(input, options);
        }
        if (compression == 32773) {
            return new PackbitsCodec().decompress(input, options);
        }
        if (compression == 32946 || compression == 8) {
            return new ZlibCodec().decompress(input, options);
        }
        if (compression == 32809) {
            throw new FormatException("Sorry, Thunderscan compression mode is not supported");
        }
        if (compression == 34713) {
            return new NikonCodec().decompress(input, options);
        }
        if (compression == 65535) {
            return new LuraWaveCodec().decompress(input, options);
        }
        throw new FormatException("Unknown Compression type (" + compression + ")");
    }

    public static void undifference(byte[] input, int[] bitsPerSample, long width, int planarConfig, int predictor, boolean little) throws FormatException {
        if (predictor == 2) {
            int len = bitsPerSample.length;
            if (planarConfig == 2 || bitsPerSample[len - 1] == 0) {
                len = 1;
            }
            if (bitsPerSample[0] <= 8) {
                for (int b = 0; b < input.length; ++b) {
                    if ((long)(b / len) % width == 0L) continue;
                    int n = b;
                    input[n] = (byte)(input[n] + input[b - len]);
                }
            } else if (bitsPerSample[0] <= 16) {
                short[] s = (short[])DataTools.makeDataArray(input, 2, false, little);
                for (int b = 0; b < s.length; ++b) {
                    if ((long)(b / len) % width == 0L) continue;
                    int n = b;
                    s[n] = (short)(s[n] + s[b - len]);
                }
                for (int i = 0; i < s.length; ++i) {
                    DataTools.unpackShort(s[i], input, i * 2, little);
                }
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public static void putIFDValue(Hashtable ifd, int tag, Object value) {
        ifd.put(new Integer(tag), value);
    }

    public static void putIFDValue(Hashtable ifd, int tag, short value) {
        TiffTools.putIFDValue(ifd, tag, new Short(value));
    }

    public static void putIFDValue(Hashtable ifd, int tag, int value) {
        TiffTools.putIFDValue(ifd, tag, new Integer(value));
    }

    public static void putIFDValue(Hashtable ifd, int tag, long value) {
        TiffTools.putIFDValue(ifd, tag, new Long(value));
    }

    public static void writeIFDValue(DataOutput ifdOut, ByteArrayOutputStream extraBuf, DataOutputStream extraOut, long offset, int tag, Object value, boolean bigTiff, boolean littleEndian) throws FormatException, IOException {
        if (value instanceof Short) {
            value = new short[]{(Short)value};
        } else if (value instanceof Integer) {
            value = new int[]{(Integer)value};
        } else if (value instanceof Long) {
            value = new long[]{(Long)value};
        } else if (value instanceof TiffRational) {
            value = new TiffRational[]{(TiffRational)value};
        } else if (value instanceof Float) {
            value = new float[]{((Float)value).floatValue()};
        } else if (value instanceof Double) {
            value = new double[]{(Double)value};
        }
        int dataLength = bigTiff ? 8 : 4;
        DataTools.writeShort(ifdOut, tag, littleEndian);
        if (value instanceof short[]) {
            short[] q = (short[])value;
            DataTools.writeShort(ifdOut, 1, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
            }
        } else if (value instanceof String) {
            char[] q = ((String)value).toCharArray();
            DataTools.writeShort(ifdOut, 2, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length + 1, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length + 1, littleEndian);
            }
            if (q.length < dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
                extraOut.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int[] q = (int[])value;
            DataTools.writeShort(ifdOut, 3, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength / 2) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    DataTools.writeShort(ifdOut, q[i], littleEndian);
                }
                for (i = q.length; i < dataLength / 2; ++i) {
                    DataTools.writeShort(ifdOut, 0, littleEndian);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeShort(extraOut, q[i], littleEndian);
                }
            }
        } else if (value instanceof long[]) {
            long[] q = (long[])value;
            if (bigTiff) {
                DataTools.writeShort(ifdOut, 16, littleEndian);
                DataTools.writeLong(ifdOut, q.length, littleEndian);
                if (q.length <= dataLength / 4) {
                    int i;
                    for (i = 0; i < q.length; ++i) {
                        DataTools.writeLong(ifdOut, q[0], littleEndian);
                    }
                    for (i = q.length; i < dataLength / 4; ++i) {
                        DataTools.writeLong(ifdOut, 0L, littleEndian);
                    }
                } else {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                    for (int i = 0; i < q.length; ++i) {
                        DataTools.writeLong(extraOut, q[i], littleEndian);
                    }
                }
            } else {
                DataTools.writeShort(ifdOut, 4, littleEndian);
                DataTools.writeInt(ifdOut, q.length, littleEndian);
                if (q.length <= dataLength / 4) {
                    int i;
                    for (i = 0; i < q.length; ++i) {
                        DataTools.writeInt(ifdOut, (int)q[0], littleEndian);
                    }
                    for (i = q.length; i < dataLength / 4; ++i) {
                        DataTools.writeInt(ifdOut, 0, littleEndian);
                    }
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                    for (int i = 0; i < q.length; ++i) {
                        DataTools.writeInt(extraOut, (int)q[i], littleEndian);
                    }
                }
            }
        } else if (value instanceof TiffRational[]) {
            Object[] q = value;
            DataTools.writeShort(ifdOut, 5, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (bigTiff && q.length == 1) {
                DataTools.writeInt(ifdOut, (int)((TiffRational)q[0]).getNumerator(), littleEndian);
                DataTools.writeInt(ifdOut, (int)((TiffRational)q[0]).getDenominator(), littleEndian);
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeInt(extraOut, (int)((TiffRational)q[i]).getNumerator(), littleEndian);
                    DataTools.writeInt(extraOut, (int)((TiffRational)q[i]).getDenominator(), littleEndian);
                }
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            DataTools.writeShort(ifdOut, 11, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength / 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    DataTools.writeFloat(ifdOut, q[0], littleEndian);
                }
                for (i = q.length; i < dataLength / 4; ++i) {
                    DataTools.writeInt(ifdOut, 0, littleEndian);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeFloat(extraOut, q[i], littleEndian);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            DataTools.writeShort(ifdOut, 12, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (bigTiff) {
                DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
            } else {
                DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
            }
            for (int i = 0; i < q.length; ++i) {
                DataTools.writeDouble(extraOut, q[i], littleEndian);
            }
        } else {
            throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
        }
    }

    public static void overwriteIFDValue(RandomAccessFile raf, int ifd, int tag, Object value) throws FormatException, IOException {
        int i;
        byte[] header = new byte[4];
        raf.seek(0L);
        raf.readFully(header);
        if (!TiffTools.isValidHeader(header)) {
            throw new FormatException("Invalid TIFF header");
        }
        boolean little = header[0] == 73 && header[1] == 73;
        boolean bigTiff = header[2] == 43 || header[3] == 43;
        long offset = bigTiff ? 8L : 4L;
        long num = 0L;
        int baseOffset = bigTiff ? 8 : 2;
        int bytesPerEntry = bigTiff ? 20 : 12;
        raf.seek(offset);
        for (i = 0; i <= ifd; ++i) {
            long l = offset = bigTiff ? DataTools.read8SignedBytes(raf, little) : DataTools.read4UnsignedBytes(raf, little);
            if (offset <= 0L) {
                throw new FormatException("No such IFD (" + ifd + " of " + i + ")");
            }
            raf.seek(offset);
            long l2 = num = bigTiff ? DataTools.read8SignedBytes(raf, little) : (long)DataTools.read2UnsignedBytes(raf, little);
            if (i >= ifd) continue;
            raf.seek(offset + (long)baseOffset + (long)bytesPerEntry * num);
        }
        i = 0;
        while ((long)i < num) {
            long oldOffset;
            int oldTag = DataTools.read2UnsignedBytes(raf, little);
            int oldType = DataTools.read2UnsignedBytes(raf, little);
            int oldCount = bigTiff ? (int)(DataTools.read8SignedBytes(raf, little) & 0xFFFFFFFFFFFFFFFFL) : DataTools.read4SignedBytes(raf, little);
            long l = oldOffset = bigTiff ? DataTools.read8SignedBytes(raf, little) : (long)DataTools.read4SignedBytes(raf, little);
            if (oldTag == tag) {
                long newOffset;
                int newCount;
                ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(bytesPerEntry);
                DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
                ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
                DataOutputStream extraOut = new DataOutputStream(extraBuf);
                TiffTools.writeIFDValue(ifdOut, extraBuf, extraOut, oldOffset, tag, value, bigTiff, little);
                byte[] bytes = ifdBuf.toByteArray();
                byte[] extra = extraBuf.toByteArray();
                int newTag = DataTools.bytesToInt(bytes, 0, 2, little);
                int newType = DataTools.bytesToInt(bytes, 2, 2, little);
                if (bigTiff) {
                    newCount = (int)(DataTools.bytesToLong(bytes, 4, little) & 0xFFFFFFFFFFFFFFFFL);
                    newOffset = DataTools.bytesToLong(bytes, 12, little);
                } else {
                    newCount = DataTools.bytesToInt(bytes, 4, little);
                    newOffset = DataTools.bytesToInt(bytes, 8, little);
                }
                boolean terminate = false;
                if (extra.length != 0) {
                    if (oldOffset + (long)(oldCount * BYTES_PER_ELEMENT[oldType]) == raf.length()) {
                        newOffset = oldOffset;
                        terminate = true;
                    } else {
                        newOffset = newCount <= oldCount ? oldOffset : raf.length();
                    }
                }
                raf.seek(raf.getFilePointer() - (long)(bigTiff ? 18 : 10));
                DataTools.writeShort(raf, newType, little);
                if (bigTiff) {
                    DataTools.writeLong(raf, newCount, little);
                } else {
                    DataTools.writeInt(raf, newCount, little);
                }
                if (bigTiff) {
                    DataTools.writeLong(raf, newOffset, little);
                } else {
                    DataTools.writeInt(raf, (int)newOffset, little);
                }
                if (extra.length > 0) {
                    raf.seek(newOffset);
                    raf.write(extra);
                }
                if (terminate) {
                    raf.setLength(raf.getFilePointer());
                }
                return;
            }
            ++i;
        }
        throw new FormatException("Tag not found (" + TiffTools.getIFDTagName(tag) + ")");
    }

    public static void overwriteComment(String id, Object value) throws FormatException, IOException {
        RandomAccessFile raf = new RandomAccessFile(id, "rw");
        TiffTools.overwriteIFDValue(raf, 0, 270, value);
        raf.close();
    }

    public static long writeImage(BufferedImage img, Hashtable ifd, OutputStream out, long offset, boolean last, boolean bigTiff) throws FormatException, IOException {
        if (img == null) {
            throw new FormatException("Image is null");
        }
        boolean little = TiffTools.isLittleEndian(ifd);
        byte[][] values = AWTImageTools.getPixelBytes(img, little);
        int width = img.getWidth();
        int height = img.getHeight();
        int bytesPerPixel = values[0].length / (width * height);
        if (ifd == null) {
            ifd = new Hashtable();
        }
        TiffTools.putIFDValue(ifd, 256, width);
        TiffTools.putIFDValue(ifd, 257, height);
        if (TiffTools.getIFDValue(ifd, 258) == null) {
            int bps = 8 * bytesPerPixel;
            int[] bpsArray = new int[values.length];
            Arrays.fill(bpsArray, bps);
            TiffTools.putIFDValue(ifd, 258, bpsArray);
        }
        if (img.getRaster().getTransferType() == 4) {
            TiffTools.putIFDValue(ifd, 339, 3);
        }
        if (TiffTools.getIFDValue(ifd, 259) == null) {
            TiffTools.putIFDValue(ifd, 259, 1);
        }
        if (TiffTools.getIFDValue(ifd, 262) == null) {
            TiffTools.putIFDValue(ifd, 262, values.length == 1 ? 1 : 2);
        }
        if (TiffTools.getIFDValue(ifd, 277) == null) {
            TiffTools.putIFDValue(ifd, 277, values.length);
        }
        if (TiffTools.getIFDValue(ifd, 282) == null) {
            TiffTools.putIFDValue(ifd, 282, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 283) == null) {
            TiffTools.putIFDValue(ifd, 283, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 296) == null) {
            TiffTools.putIFDValue(ifd, 296, 1);
        }
        if (TiffTools.getIFDValue(ifd, 305) == null) {
            TiffTools.putIFDValue(ifd, 305, "LOCI Bio-Formats");
        }
        if (TiffTools.getIFDValue(ifd, 270) == null) {
            TiffTools.putIFDValue(ifd, 270, "");
        }
        int compression = TiffTools.getIFDIntValue(ifd, 259, false, 1);
        boolean fullImageCompression = false;
        if (compression == 33003 || compression == 7) {
            fullImageCompression = true;
        }
        int pixels = fullImageCompression ? width * height : width;
        int stripSize = Math.max(8192, pixels * bytesPerPixel * values.length);
        int rowsPerStrip = stripSize / (width * bytesPerPixel * values.length);
        int stripsPerImage = (height + rowsPerStrip - 1) / rowsPerStrip;
        int[] bps = (int[])TiffTools.getIFDValue(ifd, 258, true, [I.class);
        ByteArrayOutputStream[] stripBuf = new ByteArrayOutputStream[stripsPerImage];
        DataOutputStream[] stripOut = new DataOutputStream[stripsPerImage];
        for (int i = 0; i < stripsPerImage; ++i) {
            stripBuf[i] = new ByteArrayOutputStream(stripSize);
            stripOut[i] = new DataOutputStream(stripBuf[i]);
        }
        for (int y = 0; y < height; ++y) {
            int strip = y / rowsPerStrip;
            for (int x = 0; x < width; ++x) {
                int ndx = y * width * bytesPerPixel + x * bytesPerPixel;
                for (int c = 0; c < values.length; ++c) {
                    for (int n = 0; n < bps[c] / 8; ++n) {
                        stripOut[strip].writeByte(values[c][ndx + n]);
                    }
                }
            }
        }
        int planarConfig = TiffTools.getIFDIntValue(ifd, 284, false, 1);
        int predictor = TiffTools.getIFDIntValue(ifd, 317, false, 1);
        byte[][] strips = new byte[stripsPerImage][];
        for (int i = 0; i < stripsPerImage; ++i) {
            strips[i] = stripBuf[i].toByteArray();
            TiffTools.difference(strips[i], bps, width, planarConfig, predictor);
            strips[i] = TiffTools.compress(strips[i], ifd);
        }
        long[] stripByteCounts = new long[stripsPerImage];
        long[] stripOffsets = new long[stripsPerImage];
        TiffTools.putIFDValue(ifd, 273, stripOffsets);
        TiffTools.putIFDValue(ifd, 278, rowsPerStrip);
        TiffTools.putIFDValue(ifd, 279, stripByteCounts);
        Object[] keys = ifd.keySet().toArray();
        Arrays.sort(keys);
        int keyCount = keys.length;
        if (ifd.containsKey(new Integer(0))) {
            --keyCount;
        }
        if (ifd.containsKey(new Integer(1))) {
            --keyCount;
        }
        int ifdBytes = (bigTiff ? 16 : 6) + (bigTiff ? 20 : 12) * keyCount;
        long pixelBytes = 0L;
        for (int i = 0; i < stripsPerImage; ++i) {
            stripByteCounts[i] = strips[i].length;
            stripOffsets[i] = pixelBytes + offset + (long)ifdBytes;
            pixelBytes += stripByteCounts[i];
        }
        ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(ifdBytes);
        DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
        ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
        DataOutputStream extraOut = new DataOutputStream(extraBuf);
        offset += (long)ifdBytes + pixelBytes;
        if (bigTiff) {
            DataTools.writeLong(ifdOut, keyCount, little);
        } else {
            DataTools.writeShort(ifdOut, keyCount, little);
        }
        for (int k = 0; k < keys.length; ++k) {
            Object key = keys[k];
            if (!(key instanceof Integer)) {
                throw new FormatException("Malformed IFD tag (" + key + ")");
            }
            if ((Integer)key == 0 || (Integer)key == 1) continue;
            Object value = ifd.get(key);
            TiffTools.writeIFDValue(ifdOut, extraBuf, extraOut, offset, (Integer)key, value, bigTiff, little);
        }
        if (bigTiff) {
            DataTools.writeLong(ifdOut, last ? 0L : offset + (long)extraBuf.size(), little);
        } else {
            DataTools.writeInt(ifdOut, last ? 0 : (int)(offset + (long)extraBuf.size()), little);
        }
        byte[] ifdArray = ifdBuf.toByteArray();
        byte[] extraArray = extraBuf.toByteArray();
        long numBytes = ifdArray.length + extraArray.length;
        out.write(ifdArray);
        for (int i = 0; i < strips.length; ++i) {
            out.write(strips[i]);
            numBytes += (long)strips[i].length;
        }
        out.write(extraArray);
        out.flush();
        return numBytes;
    }

    public static long getImageWidth(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongValue(ifd, 256, true, 0L);
    }

    public static long getImageLength(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongValue(ifd, 257, true, 0L);
    }

    public static int[] getBitsPerSample(Hashtable ifd) throws FormatException {
        int[] bitsPerSample = TiffTools.getIFDIntArray(ifd, 258, false);
        if (bitsPerSample == null) {
            bitsPerSample = new int[]{1};
        }
        return bitsPerSample;
    }

    public static int getSamplesPerPixel(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 277, false, 1);
    }

    public static int getCompression(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 259, false, 1);
    }

    public static int getPhotometricInterpretation(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 262, true, 0);
    }

    public static long[] getStripOffsets(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongArray(ifd, 273, false);
    }

    public static long[] getStripByteCounts(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongArray(ifd, 279, false);
    }

    public static long[] getRowsPerStrip(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongArray(ifd, 278, false);
    }

    public static byte[] compress(byte[] input, Hashtable ifd) throws FormatException, IOException {
        int compression = TiffTools.getIFDIntValue(ifd, 259, false, 1);
        CodecOptions options = new CodecOptions();
        options.width = (int)TiffTools.getImageWidth(ifd);
        options.height = (int)TiffTools.getImageLength(ifd);
        options.bitsPerSample = TiffTools.getBitsPerSample(ifd)[0];
        options.channels = TiffTools.getSamplesPerPixel(ifd);
        options.littleEndian = TiffTools.isLittleEndian(ifd);
        options.interleaved = true;
        if (compression == 1) {
            return input;
        }
        if (compression == 7) {
            return new JPEGCodec().compress(input, options);
        }
        if (compression == 33003) {
            return new JPEG2000Codec().compress(input, options);
        }
        return TiffTools.compress(input, compression);
    }

    public static byte[] compress(byte[] input, int compression) throws FormatException, IOException {
        if (compression == 1) {
            return input;
        }
        if (compression == 2) {
            throw new FormatException("Sorry, CCITT Group 3 1-Dimensional Modified Huffman run length encoding compression mode is not supported");
        }
        if (compression == 3) {
            throw new FormatException("Sorry, CCITT T.4 bi-level encoding (Group 3 Fax) compression mode is not supported");
        }
        if (compression == 4) {
            throw new FormatException("Sorry, CCITT T.6 bi-level encoding (Group 4 Fax) compression mode is not supported");
        }
        if (compression == 5) {
            LZWCodec c = new LZWCodec();
            return c.compress(input, null);
        }
        if (compression == 7) {
            throw new FormatException("Sorry, JPEG compression mode is not supported");
        }
        if (compression == 32773) {
            throw new FormatException("Sorry, PackBits compression mode is not supported");
        }
        throw new FormatException("Unknown Compression type (" + compression + ")");
    }

    public static void difference(byte[] input, int[] bitsPerSample, long width, int planarConfig, int predictor) throws FormatException {
        if (predictor == 2) {
            for (int b = input.length - 1; b >= 0; --b) {
                if ((long)(b / bitsPerSample.length) % width == 0L) continue;
                int n = b;
                input[n] = (byte)(input[n] - input[b - bitsPerSample.length]);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public static void debug(String message) {
        LogTools.println(System.currentTimeMillis() + ": " + message);
    }
}

