/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import loci.common.LogTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.cache.BufferedImageSource;
import loci.formats.cache.ByteArraySource;
import loci.formats.cache.Cache;
import loci.formats.cache.CacheEvent;
import loci.formats.cache.CacheListener;
import loci.formats.cache.CacheStrategy;
import loci.formats.cache.CrosshairStrategy;
import loci.formats.cache.ICacheSource;
import loci.formats.cache.ICacheStrategy;
import loci.formats.cache.RectangleStrategy;

public final class CacheConsole {
    private CacheConsole() {
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (args.length < 1) {
            LogTools.println("Please specify a filename containing image data.");
            System.exit(1);
        }
        ImageReader reader = new ImageReader();
        String id = args[0];
        LogTools.println("Reading " + id);
        reader.setId(id);
        LogTools.println("Initializing cache");
        final Cache cache = new Cache(new CrosshairStrategy(CacheConsole.getLengths(reader)), new BufferedImageSource(reader), true);
        CacheListener l = new CacheListener(){

            public void cacheUpdated(CacheEvent e) {
                int type = e.getType();
                int ndx = e.getIndex();
                switch (type) {
                    case 1: {
                        CacheConsole.printSource("source ->", cache);
                        break;
                    }
                    case 2: {
                        CacheConsole.printStrategy("strategy ->", cache);
                        break;
                    }
                    case 3: {
                        int[] len = cache.getStrategy().getLengths();
                        int[] pos = FormatTools.rasterToPosition(len, ndx);
                        CacheConsole.printArray("pos ->", pos);
                        break;
                    }
                    case 4: {
                        CacheConsole.printArray("priorities ->", cache.getStrategy().getPriorities());
                        break;
                    }
                    case 5: {
                        CacheConsole.printOrder("order ->", cache);
                        break;
                    }
                    case 6: {
                        CacheConsole.printArray("range ->", cache.getStrategy().getRange());
                        break;
                    }
                    case 7: {
                        int[] len = cache.getStrategy().getLengths();
                        int[] pos = FormatTools.rasterToPosition(len, ndx);
                        CacheConsole.printArray("loaded:", pos);
                        break;
                    }
                    case 8: {
                        int[] len = cache.getStrategy().getLengths();
                        int[] pos = FormatTools.rasterToPosition(len, ndx);
                        CacheConsole.printArray("dropped:", pos);
                    }
                }
            }
        };
        cache.addCacheListener(l);
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        LogTools.println("Entering Bio-Formats caching test console");
        while (true) {
            ICacheStrategy strategy;
            LogTools.print("> ");
            String cmd = r.readLine().trim();
            if (cmd.equals("")) continue;
            if (cmd.startsWith("c")) {
                cache.recache();
                continue;
            }
            if (cmd.startsWith("e") || cmd.startsWith("q")) break;
            if (cmd.startsWith("g")) {
                ReflectedUniverse ru = new ReflectedUniverse();
                try {
                    ru.exec("import loci.formats.gui.CacheComponent");
                    ru.setVar("cache", cache);
                    ru.setVar("doSource", true);
                    ru.setVar("axes", new String[]{"Z", "C", "T"});
                    ru.setVar("id", id);
                    ru.exec("widget = new CacheComponent(cache, axes, id)");
                    ru.exec("import javax.swing.JFrame");
                    ru.exec("frame = new JFrame(\"Cache controls\")");
                    ru.exec("frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE)");
                    ru.exec("frame.setContentPane(widget)");
                    ru.exec("frame.pack()");
                    ru.exec("frame.setVisible(true)");
                }
                catch (ReflectException exc) {
                    LogTools.trace(exc);
                }
                continue;
            }
            if (cmd.startsWith("h")) {
                LogTools.println("Available commands:");
                LogTools.println("  cache    -- begins loading planes into the cache");
                LogTools.println("  gui      -- pops up a GUI to configure the cache");
                LogTools.println("  info     -- displays the cache state");
                LogTools.println("  position -- changes the current position");
                LogTools.println("  strategy -- changes the cache strategy");
                LogTools.println("  source   -- changes the cache source");
                LogTools.println("  priority -- changes the cache priorities");
                LogTools.println("  order    -- changes the cache order");
                LogTools.println("  range    -- changes the cache ranges");
                LogTools.println("  read     -- gets a plane from the cache");
                LogTools.println("  exit     -- quits the interpreter");
                continue;
            }
            if (cmd.startsWith("i")) {
                CacheConsole.printArray("pos =", cache.getCurrentPos());
                ICacheSource source = cache.getSource();
                CacheConsole.printSource("source =", cache);
                LogTools.println("object count = " + source.getObjectCount());
                ICacheStrategy strategy2 = cache.getStrategy();
                CacheConsole.printStrategy("strategy =", cache);
                CacheConsole.printArray("priorities =", strategy2.getPriorities());
                CacheConsole.printOrder("order =", cache);
                CacheConsole.printArray("range =", strategy2.getRange());
                CacheConsole.printArray("lengths =", strategy2.getLengths());
                continue;
            }
            if (cmd.startsWith("o")) {
                LogTools.println("0 => centered");
                LogTools.println("1 => forward");
                LogTools.println("-1 => backward");
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                strategy = cache.getStrategy();
                strategy.setOrder(z, 0);
                strategy.setOrder(c, 1);
                strategy.setOrder(t, 2);
                continue;
            }
            if (cmd.startsWith("po")) {
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                cache.setCurrentPos(new int[]{z, c, t});
                continue;
            }
            if (cmd.startsWith("pr")) {
                LogTools.println("-10 => min priority");
                LogTools.println("-5 => low priority");
                LogTools.println("0 => normal priority");
                LogTools.println("5 => high priority");
                LogTools.println("10 => max priority");
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                strategy = cache.getStrategy();
                strategy.setPriority(z, 0);
                strategy.setPriority(c, 1);
                strategy.setPriority(t, 2);
                continue;
            }
            if (cmd.startsWith("ra")) {
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                cache.getStrategy().setRange(z, 0);
                cache.getStrategy().setRange(c, 1);
                cache.getStrategy().setRange(t, 2);
                continue;
            }
            if (cmd.startsWith("re")) {
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                LogTools.println("Retrieving Z" + z + "-C" + c + "-T" + t);
                Object o = cache.getObject(new int[]{z, c, t});
                LogTools.println(o);
                continue;
            }
            if (cmd.startsWith("so")) {
                LogTools.println("0: BufferedImage");
                LogTools.println("1: byte array");
                LogTools.print("> ");
                int n = Integer.parseInt(r.readLine().trim());
                switch (n) {
                    case 0: {
                        cache.setSource(new BufferedImageSource(reader));
                        break;
                    }
                    case 1: {
                        cache.setSource(new ByteArraySource(reader));
                        break;
                    }
                    default: {
                        LogTools.println("Unknown source: " + n);
                        break;
                    }
                }
                continue;
            }
            if (cmd.startsWith("st")) {
                LogTools.println("0: crosshair");
                LogTools.println("1: rectangle");
                LogTools.print("> ");
                int n = Integer.parseInt(r.readLine().trim());
                int[] zct = CacheConsole.getLengths(reader);
                CacheStrategy strategy3 = null;
                switch (n) {
                    case 0: {
                        strategy3 = new CrosshairStrategy(zct);
                        break;
                    }
                    case 1: {
                        strategy3 = new RectangleStrategy(zct);
                        break;
                    }
                    default: {
                        LogTools.println("Unknown strategy: " + n);
                    }
                }
                if (strategy3 == null) continue;
                ICacheStrategy old = cache.getStrategy();
                int[] priorities = old.getPriorities();
                int[] range = old.getRange();
                int[] order = old.getOrder();
                for (int i = 0; i < zct.length; ++i) {
                    strategy3.setPriority(priorities[i], i);
                    strategy3.setRange(range[i], i);
                    strategy3.setOrder(order[i], i);
                }
                cache.setStrategy(strategy3);
                continue;
            }
            LogTools.println("Unknown command: " + cmd);
        }
        reader.close();
    }

    private static final void printArray(String prefix, int[] array) {
        LogTools.print(prefix);
        if (array == null) {
            LogTools.println(" null");
        } else {
            for (int i = 0; i < array.length; ++i) {
                LogTools.print(" " + array[i]);
            }
            LogTools.println();
        }
    }

    private static final void printSource(String prefix, Cache cache) {
        ICacheSource source = cache.getSource();
        LogTools.print(prefix + " ");
        Class<?> sourceClass = source.getClass();
        if (sourceClass == BufferedImageSource.class) {
            LogTools.println("BufferedImage");
        } else if (sourceClass == ByteArraySource.class) {
            LogTools.println("byte array");
        } else {
            LogTools.println("unknown");
        }
    }

    private static final void printStrategy(String prefix, Cache cache) {
        ICacheStrategy strategy = cache.getStrategy();
        LogTools.print(prefix + " ");
        Class<?> strategyClass = strategy.getClass();
        if (strategyClass == CrosshairStrategy.class) {
            LogTools.println("crosshair");
        } else if (strategyClass == RectangleStrategy.class) {
            LogTools.println("rectangle");
        } else {
            LogTools.println("unknown");
        }
    }

    private static final void printOrder(String prefix, Cache cache) {
        ICacheStrategy strategy = cache.getStrategy();
        int[] order = strategy.getOrder();
        LogTools.print(prefix);
        block5: for (int i = 0; i < order.length; ++i) {
            switch (order[i]) {
                case 0: {
                    LogTools.print(" C");
                    continue block5;
                }
                case 1: {
                    LogTools.print(" F");
                    continue block5;
                }
                case -1: {
                    LogTools.print(" B");
                    continue block5;
                }
                default: {
                    LogTools.print(" ?");
                }
            }
        }
        LogTools.println();
    }

    private static final int[] getLengths(IFormatReader r) {
        return new int[]{r.getSizeZ(), r.getSizeC(), r.getSizeT()};
    }
}

