/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class LuraWaveCodec
extends BaseCodec {
    public static final String LICENSE_PROPERTY = "lurawave.license";
    public static final String NO_LURAWAVE_MSG = "The LuraWave decoding library, lwf_jsdk2.6.jar, is required to decode this file.\r\nPlease make sure it is present in your classpath.";
    public static final String NO_LICENSE_MSG = "No LuraWave license code was specified.\r\nPlease set one in the lurawave.license system property (e.g., with -Dlurawave.license=XXXX from the command line).";
    public static final String INVALID_LICENSE_MSG = "Invalid license code: ";
    protected static boolean noLuraWave;
    protected static String licenseCode;
    protected static ReflectedUniverse r;

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new FormatException("LuraWave compression not supported");
    }

    public byte[] decompress(RandomAccessStream in, CodecOptions options) throws FormatException, IOException {
        byte[] buf = new byte[(int)in.length()];
        in.read(buf);
        return this.decompress(buf, options);
    }

    public byte[] decompress(byte[] buf, CodecOptions options) throws FormatException {
        if (noLuraWave) {
            throw new FormatException(NO_LURAWAVE_MSG);
        }
        licenseCode = System.getProperty(LICENSE_PROPERTY);
        if (licenseCode == null) {
            throw new FormatException(NO_LICENSE_MSG);
        }
        r.setVar("stream", new BufferedInputStream(new ByteArrayInputStream(buf), 4096));
        try {
            r.setVar("licenseCode", licenseCode);
            r.exec("lwf = new lwfDecoder(stream, null, licenseCode)");
        }
        catch (ReflectException exc) {
            throw new FormatException(INVALID_LICENSE_MSG + licenseCode, exc);
        }
        int w = 0;
        int h = 0;
        try {
            w = (Integer)r.exec("lwf.getWidth()");
            h = (Integer)r.exec("lwf.getHeight()");
        }
        catch (ReflectException exc) {
            throw new FormatException("Could not retrieve image dimensions", exc);
        }
        int nbits = 8 * (options.maxBytes / (w * h));
        if (nbits == 8) {
            byte[] image8 = new byte[w * h];
            try {
                r.setVar("image8", image8);
                r.exec("lwf.decodeToMemoryGray8(image8, -1, 1024, 0)");
            }
            catch (ReflectException exc) {
                throw new FormatException("Could not decode LuraWave data", exc);
            }
            return image8;
        }
        if (nbits == 16) {
            short[] image16 = new short[w * h];
            try {
                r.setVar("image16", image16);
                r.setVar("w", w);
                r.setVar("h", h);
                r.exec("lwf.decodeToMemoryGray16(image16, 0, -1, 1024, 0, 1, w, 0, 0, w, h)");
            }
            catch (ReflectException exc) {
                throw new FormatException("Could not decode LuraWave data", exc);
            }
            byte[] output = new byte[w * h * 2];
            for (int i = 0; i < image16.length; ++i) {
                DataTools.unpackShort(image16[i], output, i * 2, true);
            }
            return output;
        }
        throw new FormatException("Unsupported bits per pixel: " + nbits);
    }

    static {
        r = new ReflectedUniverse();
        try {
            r.exec("import com.luratech.lwf.lwfDecoder");
            r.setVar("-1", -1);
            r.setVar("1", 1);
            r.setVar("1024", 1024);
            r.setVar("0", 0);
        }
        catch (ReflectException exc) {
            noLuraWave = true;
        }
    }
}

