/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class PackbitsCodec
extends BaseCodec {
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new FormatException("Packbits Compression not currently supported");
    }

    public byte[] decompress(RandomAccessStream in, CodecOptions options) throws FormatException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        while (output.size() < options.maxBytes && in.getFilePointer() < in.length()) {
            byte n = in.readByte();
            if (n >= 0) {
                byte[] b = new byte[n + 1];
                in.read(b);
                output.write(b);
                b = null;
                continue;
            }
            if (n == -128) continue;
            int len = -n + 1;
            byte inp = in.readByte();
            for (int i = 0; i < len; ++i) {
                output.write(inp);
            }
        }
        return output.toByteArray();
    }
}

