/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;

public class DeltavisionReader
extends FormatReader {
    private static final short LITTLE_ENDIAN = -16224;
    private static final int HEADER_LENGTH = 1024;
    private static final String[] IMAGE_TYPES = new String[]{"normal", "Tilt-series", "Stereo tilt-series", "Averaged images", "Averaged stereo pairs"};
    private int extSize;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[][][] extHdrFields = null;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d"});
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int bytesPerPixel = FormatTools.getBytesPerPixel(this.getPixelType());
        long offset = 1024 + this.extSize;
        long planeOffset = (long)this.getSizeX() * (long)this.getSizeY() * (long)bytesPerPixel * (long)no;
        this.in.seek(offset + planeOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.tSize = 0;
        this.zSize = 0;
        this.wSize = 0;
        this.extSize = 0;
        this.numFloatsPerSection = 0;
        this.numIntsPerSection = 0;
        this.extHdrFields = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String imageSequence;
        String pixel;
        if (debug) {
            this.debug("DeltavisionReader.initFile(" + id + ")");
        }
        super.initFile(id);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        this.in = new RandomAccessStream(id);
        this.status("Reading header");
        this.in.seek(96L);
        this.in.order(true);
        this.core[0].littleEndian = this.in.readShort() == -16224;
        this.in.order(this.isLittleEndian());
        this.in.seek(0L);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].imageCount = this.in.readInt();
        int filePixelType = this.in.readInt();
        this.addMeta("ImageWidth", this.getSizeX());
        this.addMeta("ImageHeight", this.getSizeY());
        this.addMeta("NumberOfImages", this.getImageCount());
        switch (filePixelType) {
            case 0: {
                pixel = "8 bit unsigned integer";
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                pixel = "16 bit signed integer";
                this.core[0].pixelType = 2;
                break;
            }
            case 2: {
                pixel = "32 bit floating point";
                this.core[0].pixelType = 6;
                break;
            }
            case 3: {
                pixel = "16 bit complex";
                this.core[0].pixelType = 2;
                break;
            }
            case 4: {
                pixel = "64 bit complex";
                this.core[0].pixelType = 6;
                break;
            }
            case 6: {
                pixel = "16 bit unsigned integer";
                this.core[0].pixelType = 3;
                break;
            }
            default: {
                pixel = "unknown";
                this.core[0].pixelType = 1;
            }
        }
        this.addMeta("PixelType", pixel);
        this.addMeta("Sub-image starting point (X)", this.in.readInt());
        this.addMeta("Sub-image starting point (Y)", this.in.readInt());
        this.addMeta("Sub-image starting point (Z)", this.in.readInt());
        this.addMeta("Pixel sampling size (X)", this.in.readInt());
        this.addMeta("Pixel sampling size (Y)", this.in.readInt());
        this.addMeta("Pixel sampling size (Z)", this.in.readInt());
        float pixX = this.in.readFloat();
        float pixY = this.in.readFloat();
        float pixZ = this.in.readFloat();
        this.addMeta("X element length (in um)", pixX);
        this.addMeta("Y element length (in um)", pixY);
        this.addMeta("Z element length (in um)", pixZ);
        this.addMeta("X axis angle", this.in.readFloat());
        this.addMeta("Y axis angle", this.in.readFloat());
        this.addMeta("Z axis angle", this.in.readFloat());
        this.addMeta("Column axis sequence", this.in.readInt());
        this.addMeta("Row axis sequence", this.in.readInt());
        this.addMeta("Section axis sequence", this.in.readInt());
        this.in.seek(160L);
        short type = this.in.readShort();
        String imageType = type < IMAGE_TYPES.length ? IMAGE_TYPES[type] : "unknown";
        this.addMeta("Image Type", imageType);
        short lensID = this.in.readShort();
        this.addMeta("Lens ID Number", (int)lensID);
        this.in.seek(180L);
        this.core[0].sizeT = this.in.readShort();
        this.addMeta("Number of timepoints", this.getSizeT());
        short sequence = this.in.readShort();
        switch (sequence) {
            case 0: {
                imageSequence = "ZTW";
                break;
            }
            case 1: {
                imageSequence = "WZT";
                break;
            }
            case 2: {
                imageSequence = "ZWT";
                break;
            }
            case 65536: {
                imageSequence = "WZT";
                break;
            }
            default: {
                imageSequence = "ZTW";
            }
        }
        this.core[0].dimensionOrder = "XY" + imageSequence.replaceAll("W", "C");
        this.addMeta("Image sequence", imageSequence);
        this.addMeta("X axis tilt angle", this.in.readFloat());
        this.addMeta("Y axis tilt angle", this.in.readFloat());
        this.addMeta("Z axis tilt angle", this.in.readFloat());
        this.core[0].sizeC = this.in.readShort();
        this.addMeta("Number of wavelengths", this.getSizeC());
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].sizeZ = this.getImageCount() / (this.getSizeC() * this.getSizeT());
        this.addMeta("Number of focal planes", this.getSizeZ());
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        MetadataTools.populatePixels(store, this, true);
        short[] waves = new short[5];
        for (int i = 0; i < waves.length; ++i) {
            waves[i] = this.in.readShort();
            this.addMeta("Wavelength " + (i + 1) + " (in nm)", waves[i]);
        }
        this.addMeta("X origin (in um)", this.in.readFloat());
        this.addMeta("Y origin (in um)", this.in.readFloat());
        this.addMeta("Z origin (in um)", this.in.readFloat());
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        store.setObjectiveID(String.valueOf(lensID), 0, 0);
        store.setObjectiveSettingsObjective(String.valueOf(lensID), 0);
        this.in.skipBytes(4);
        String title = null;
        for (int i = 1; i <= 10; ++i) {
            title = this.in.readString(80).replaceAll("\u0000", "");
            this.addMeta("Title " + i, title);
        }
        long fp = this.in.getFilePointer();
        this.in.seek(76L);
        this.readWavelength(0, store);
        this.addMeta("Wavelength 1 mean intensity", this.in.readFloat());
        this.addMeta("Space group number", this.in.readInt());
        this.extSize = this.in.readInt();
        this.in.seek(128L);
        this.numIntsPerSection = this.in.readShort();
        this.numFloatsPerSection = this.in.readShort();
        this.addMeta("Number of Sub-resolution sets", this.in.readShort());
        this.addMeta("Z axis reduction quotient", this.in.readShort());
        this.readWavelength(1, store);
        this.readWavelength(2, store);
        this.readWavelength(3, store);
        this.in.seek(172L);
        this.readWavelength(4, store);
        this.status("Reading extended header");
        this.in.seek(fp);
        this.setOffsetInfo(sequence, this.getSizeZ(), this.getSizeC(), this.getSizeT());
        this.extHdrFields = new DVExtHdrFields[this.getSizeZ()][this.getSizeC()][this.getSizeT()];
        store.setDimensionsPhysicalSizeX(new Float(pixX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(pixY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(pixZ), 0, 0);
        store.setImageName("", 0);
        if (title == null) {
            title = "";
        }
        title = title.length() == 0 ? null : title;
        store.setImageDescription(title, 0);
        boolean logFound = this.parseLogFile(store);
        this.parseDeconvolutionLog(store);
        int offset = 1024 + this.numIntsPerSection * 4;
        for (int i = 0; i < this.getImageCount(); ++i) {
            int[] coords = this.getZCTCoords(i);
            int z = coords[0];
            int w = coords[1];
            int t = coords[2];
            this.in.seek(offset + this.getTotalOffset(z, w, t));
            this.extHdrFields[z][w][t] = new DVExtHdrFields(this.in);
            if (!logFound) {
                store.setPlaneTimingDeltaT(new Float(this.extHdrFields[z][w][t].getTimeStampSeconds()), 0, 0, i);
            }
            store.setPlaneTimingExposureTime(new Float(this.extHdrFields[z][w][t].getExpTime() / 1000.0f), 0, 0, i);
            if (logFound) continue;
            store.setStagePositionPositionX(new Float(this.extHdrFields[z][w][t].getStageXCoord()), 0, 0, i);
            store.setStagePositionPositionY(new Float(this.extHdrFields[z][w][t].getStageYCoord()), 0, 0, i);
            store.setStagePositionPositionZ(new Float(this.extHdrFields[z][w][t].getStageZCoord()), 0, 0, i);
        }
        for (int w = 0; w < this.getSizeC(); ++w) {
            store.setLogicalChannelEmWave(new Integer(waves[w]), 0, w);
            store.setLogicalChannelExWave(new Integer((int)this.extHdrFields[0][w][0].getExFilter()), 0, w);
            if (logFound) continue;
            store.setLogicalChannelNdFilter(new Float(this.extHdrFields[0][w][0].getNdFilter()), 0, w);
        }
        this.status("Populating metadata");
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
            }
        }
    }

    private int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    private boolean parseLogFile(MetadataStore store) throws IOException {
        String logFile = this.getCurrentFile() + ".log";
        if (!new Location(logFile).exists()) {
            return false;
        }
        RandomAccessStream s = new RandomAccessStream(logFile);
        String value = "";
        String prefix = "";
        int currentImage = 0;
        while (s.getFilePointer() < s.length() - 1L) {
            String line = s.readLine().trim();
            int colon = line.indexOf(":");
            if (colon != -1) {
                Float z;
                Float y;
                String key;
                if (line.startsWith("Created")) {
                    key = "Created";
                    value = line.substring(7).trim();
                } else {
                    key = line.substring(0, colon).trim();
                    value = line.substring(colon + 1).trim();
                }
                if (value.equals("") && !key.equals("")) {
                    prefix = key;
                }
                this.addMeta(prefix + " " + key, value);
                if (key.equals("Objective")) {
                    int space = value.indexOf(" ");
                    if (space == -1) continue;
                    String manufacturer = value.substring(0, space);
                    String extra = value.substring(space + 1);
                    String[] tokens = extra.split(",");
                    store.setObjectiveManufacturer(manufacturer, 0, 0);
                    String magnification = tokens[0].substring(0, tokens[0].indexOf("X"));
                    String na = tokens[0].substring(tokens[0].indexOf("/") + 1);
                    store.setObjectiveNominalMagnification(new Integer(magnification), 0, 0);
                    store.setObjectiveLensNA(new Float(na), 0, 0);
                    store.setObjectiveCorrection(tokens[1], 0, 0);
                    if (tokens.length <= 3) continue;
                    store.setObjectiveModel(tokens[3], 0, 0);
                    continue;
                }
                if (key.equals("Lens ID")) {
                    store.setObjectiveID(value, 0, 0);
                    store.setObjectiveSettingsObjective(value, 0);
                    continue;
                }
                if (key.equals("Pixel Size")) {
                    String[] pixelSizes = value.split(" ");
                    Float x = new Float(pixelSizes[0].trim());
                    y = new Float(pixelSizes[1].trim());
                    z = new Float(pixelSizes[2].trim());
                    store.setDimensionsPhysicalSizeX(x, 0, 0);
                    store.setDimensionsPhysicalSizeY(y, 0, 0);
                    store.setDimensionsPhysicalSizeZ(z, 0, 0);
                    continue;
                }
                if (key.equals("Binning")) {
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        store.setDetectorSettingsBinning(value, 0, c);
                        store.setDetectorID("Detector:" + c, 0, c);
                        store.setDetectorSettingsDetector("Detector:" + c, 0, c);
                    }
                    continue;
                }
                if (key.equals("Type")) {
                    store.setDetectorModel(value, 0, 0);
                    continue;
                }
                if (key.equals("Gain")) {
                    value = value.replaceAll("X", "");
                    store.setDetectorSettingsGain(new Float(value), 0, 0);
                    continue;
                }
                if (key.equals("Temp Setting")) {
                    value = value.replaceAll("C", "").trim();
                    store.setImagingEnvironmentTemperature(new Float(value), 0);
                    continue;
                }
                if (key.equals("Time Point")) {
                    Float time = new Float(value.substring(0, value.indexOf(" ")));
                    store.setPlaneTimingDeltaT(time, 0, 0, currentImage);
                    continue;
                }
                if (key.equals("EM filter")) {
                    int cIndex = this.getZCTCoords(currentImage)[1];
                    store.setLogicalChannelName(value, 0, cIndex);
                    continue;
                }
                if (key.equals("ND filter")) {
                    try {
                        Float nd = new Float(value);
                        int cIndex = this.getZCTCoords(currentImage)[1];
                        store.setLogicalChannelNdFilter(nd, 0, cIndex);
                    }
                    catch (NumberFormatException exc) {}
                    continue;
                }
                if (!key.equals("Stage coordinates")) continue;
                value = value.substring(1, value.length() - 1);
                String[] coords = value.split(",");
                Float x = new Float(coords[0].trim());
                y = new Float(coords[1].trim());
                z = new Float(coords[2].trim());
                store.setStagePositionPositionX(x, 0, 0, currentImage);
                store.setStagePositionPositionY(y, 0, 0, currentImage);
                store.setStagePositionPositionZ(z, 0, 0, currentImage);
                ++currentImage;
                continue;
            }
            if (line.startsWith("Image")) {
                prefix = line;
                continue;
            }
            if (!line.startsWith("Created")) continue;
            SimpleDateFormat parse = new SimpleDateFormat("EEE MMM  d HH:mm:ss yyyy");
            Date date = parse.parse(line.substring(8).trim(), new ParsePosition(0));
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            store.setImageCreationDate(fmt.format(date), 0);
        }
        s.close();
        return true;
    }

    private void parseDeconvolutionLog(MetadataStore store) throws IOException {
        int dot = this.getCurrentFile().lastIndexOf(".");
        String base = this.getCurrentFile().substring(0, dot);
        if (!new Location(base + "_log.txt").exists()) {
            return;
        }
        RandomAccessStream s = new RandomAccessStream(base + "_log.txt");
        boolean doStatistics = false;
        int cc = 0;
        int tt = 0;
        String previousLine = null;
        while (s.getFilePointer() < s.length() - 1L) {
            int index;
            String line = s.readLine().trim();
            if (line == null || line.length() == 0) continue;
            if (doStatistics) {
                String[] keys = line.split("  ");
                Vector<String> realKeys = new Vector<String>();
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i].trim().length() <= 0) continue;
                    realKeys.add(keys[i].trim());
                }
                keys = realKeys.toArray(new String[0]);
                s.readLine();
                line = s.readLine().trim();
                while (line.length() != 0) {
                    String[] values = line.split(" ");
                    Vector<String> realValues = new Vector<String>();
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i].trim().length() <= 0) continue;
                        realValues.add(values[i].trim());
                    }
                    values = realValues.toArray(new String[0]);
                    int zz = Integer.parseInt(values[0].trim()) - 1;
                    int index2 = this.getIndex(zz, cc, tt);
                    for (int i = 1; i < keys.length; ++i) {
                        this.addMeta("Plane " + index2 + " " + keys[i], values[i]);
                    }
                    line = s.readLine().trim();
                }
            } else {
                int index3 = line.indexOf(".\t");
                if (index3 != -1) {
                    String key = line.substring(0, index3).trim();
                    String value = line.substring(index3 + 2).trim();
                    while (key.endsWith(".")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if (previousLine.endsWith("Deconvolution Results:") || previousLine.endsWith("open OTF")) {
                        this.addMeta(previousLine + " " + key, value);
                    } else {
                        this.addMeta(key, value);
                    }
                }
            }
            if (line.indexOf("correcting time point") != -1 && (index = line.indexOf("time point\t") + 11) > 10) {
                String t = line.substring(index, line.indexOf(",", index));
                tt = Integer.parseInt(t) - 1;
                index = line.indexOf("wavelength\t") + 11;
                if (index > 10) {
                    String c = line.substring(index, line.indexOf(".", index));
                    cc = Integer.parseInt(c) - 1;
                }
            }
            if (line.length() > 0 && line.indexOf(".") == -1) {
                previousLine = line;
            }
            doStatistics = line.endsWith("- reading image data...");
        }
        s.close();
    }

    private void readWavelength(int channel, MetadataStore store) throws FormatException, IOException {
        float min = this.in.readFloat();
        float max = this.in.readFloat();
        this.addMeta("Wavelength " + (channel + 1) + " min. intensity", min);
        this.addMeta("Wavelength " + (channel + 1) + " max. intensity", max);
        if (store instanceof IMinMaxStore) {
            ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(0, min, max, channel);
        }
    }

    private class DVExtHdrFields {
        private int offsetWithInts;
        private float oDFilter;
        private float photosensorReading;
        private float timeStampSeconds;
        private float stageXCoord;
        private float stageYCoord;
        private float stageZCoord;
        private float minInten;
        private float maxInten;
        private float meanInten;
        private float expTime;
        private float ndFilter;
        private float exFilter;
        private float emFilter;
        private float exWavelen;
        private float emWavelen;
        private float intenScaling;
        private float energyConvFactor;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("photosensorReading: ");
            sb.append(this.photosensorReading);
            sb.append("\ntimeStampSeconds: ");
            sb.append(this.timeStampSeconds);
            sb.append("\nstageXCoord: ");
            sb.append(this.stageXCoord);
            sb.append("\nstageYCoord: ");
            sb.append(this.stageYCoord);
            sb.append("\nstageZCoord: ");
            sb.append(this.stageZCoord);
            sb.append("\nminInten: ");
            sb.append(this.minInten);
            sb.append("\nmaxInten: ");
            sb.append(this.maxInten);
            sb.append("\nmeanInten: ");
            sb.append(this.meanInten);
            sb.append("\nexpTime: ");
            sb.append(this.expTime);
            sb.append("\nndFilter: ");
            sb.append(this.ndFilter);
            sb.append("\nexFilter: ");
            sb.append(this.exFilter);
            sb.append("\nemFilter: ");
            sb.append(this.emFilter);
            sb.append("\nexWavelen: ");
            sb.append(this.exWavelen);
            sb.append("\nemWavelen: ");
            sb.append(this.emWavelen);
            sb.append("\nintenScaling: ");
            sb.append(this.intenScaling);
            sb.append("\nenergyConvFactor: ");
            sb.append(this.energyConvFactor);
            return sb.toString();
        }

        protected DVExtHdrFields(RandomAccessStream in) {
            block2: {
                try {
                    this.photosensorReading = in.readFloat();
                    this.timeStampSeconds = in.readFloat();
                    this.stageXCoord = in.readFloat();
                    this.stageYCoord = in.readFloat();
                    this.stageZCoord = in.readFloat();
                    this.minInten = in.readFloat();
                    this.maxInten = in.readFloat();
                    this.expTime = in.readFloat();
                    in.skipBytes(4);
                    this.ndFilter = (float)Math.pow(10.0, -1.0f * in.readFloat());
                    this.exFilter = in.readFloat();
                    this.emFilter = in.readFloat();
                    this.exWavelen = in.readFloat();
                    this.emWavelen = in.readFloat();
                    this.intenScaling = in.readFloat();
                    this.energyConvFactor = in.readFloat();
                }
                catch (IOException e) {
                    if (!FormatHandler.debug) break block2;
                    LogTools.trace(e);
                }
            }
        }

        public float getPhotosensorReading() {
            return this.photosensorReading;
        }

        public float getTimeStampSeconds() {
            return this.timeStampSeconds;
        }

        public float getStageXCoord() {
            return this.stageXCoord;
        }

        public float getStageYCoord() {
            return this.stageYCoord;
        }

        public float getStageZCoord() {
            return this.stageZCoord;
        }

        public float getMinInten() {
            return this.minInten;
        }

        public float getMaxInten() {
            return this.maxInten;
        }

        public float getMeanInten() {
            return this.meanInten;
        }

        public float getExpTime() {
            return this.expTime;
        }

        public float getNdFilter() {
            return this.ndFilter;
        }

        public float getExFilter() {
            return this.exFilter;
        }

        public float getEmFilter() {
            return this.emFilter;
        }

        public float getExWavelen() {
            return this.exWavelen;
        }

        public float getEmWavelen() {
            return this.emWavelen;
        }

        public float getIntenScaling() {
            return this.intenScaling;
        }
    }
}

