/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;

public class FluoviewReader
extends BaseTiffReader {
    private static final String FLUOVIEW_MAGIC_STRING = "FLUOVIEW";
    private static final int MMHEADER = 34361;
    private static final int MMSTAMP = 34362;
    private float voxelX = 1.0f;
    private float voxelY = 1.0f;
    private float voxelZ = 1.0f;
    private float voxelC = 1.0f;
    private float voxelT = 1.0f;
    private BufferedImage zeroImage = null;
    private String[] gains;
    private String[] voltages;
    private String[] offsets;
    private String[] channelNames;
    private String[] lensNA;
    private String mag;
    private String detManu;
    private String objManu;
    private String comment;
    private Double gamma;

    public FluoviewReader() {
        super("Olympus Fluoview/ABD TIFF", new String[]{"tif", "tiff"});
        this.blockCheckLen = 524288;
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        try {
            RandomAccessStream stream = new RandomAccessStream(name);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException e) {
            if (debug) {
                this.trace(e);
            }
            return false;
        }
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        Hashtable ifd = TiffTools.getFirstIFD(stream);
        String com = TiffTools.getComment(ifd);
        if (com == null) {
            com = "";
        }
        if (ifd == null) {
            return false;
        }
        return com.indexOf(FLUOVIEW_MAGIC_STRING) != -1 && ifd.containsKey(new Integer(34361)) || ifd.containsKey(new Integer(34362));
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if ((long)this.getSizeY() == TiffTools.getImageLength(this.ifds[0])) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        super.openBytes(0, buf, x, no, w, h);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.voxelT = 1.0f;
        this.voxelC = 1.0f;
        this.voxelZ = 1.0f;
        this.voxelY = 1.0f;
        this.voxelX = 1.0f;
        this.zeroImage = null;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        short[] s = TiffTools.getIFDShortArray(this.ifds[0], 34361, true);
        byte[] mmheader = new byte[s.length];
        for (int i2 = 0; i2 < mmheader.length; ++i2) {
            mmheader[i2] = (byte)s[i2];
            if (mmheader[i2] >= 0) continue;
            int n = i2;
            mmheader[n] = (byte)(mmheader[n] + 1);
        }
        RandomAccessStream ras = new RandomAccessStream(mmheader);
        ras.order(this.isLittleEndian());
        this.put("Header Flag", ras.readShort());
        this.put("Image Type", ras.readChar());
        this.put("Image name", ras.readString(257));
        ras.skipBytes(4);
        this.put("Number of colors", ras.readInt());
        ras.skipBytes(4);
        ras.skipBytes(4);
        this.put("Comment size", ras.readInt());
        ras.skipBytes(4);
        String[] names = new String[10];
        int[] sizes = new int[10];
        double[] resolutions = new double[10];
        for (int i3 = 0; i3 < 10; ++i3) {
            names[i3] = ras.readString(16);
            sizes[i3] = ras.readInt();
            double origin = ras.readDouble();
            resolutions[i3] = ras.readDouble();
            this.put("Dimension " + (i3 + 1) + " Name", names[i3]);
            this.put("Dimension " + (i3 + 1) + " Size", sizes[i3]);
            this.put("Dimension " + (i3 + 1) + " Origin", origin);
            this.put("Dimension " + (i3 + 1) + " Resolution", resolutions[i3]);
            this.put("Dimension " + (i3 + 1) + " Units", ras.readString(64));
        }
        ras.skipBytes(4);
        this.put("Map type", ras.readShort());
        this.put("Map min", ras.readDouble());
        this.put("Map max", ras.readDouble());
        this.put("Min value", ras.readDouble());
        this.put("Max value", ras.readDouble());
        ras.skipBytes(4);
        this.put("Gamma", ras.readDouble());
        this.put("Offset", ras.readDouble());
        this.put("Gray Channel Name", ras.readString(16));
        this.put("Gray Channel Size", ras.readInt());
        this.put("Gray Channel Origin", ras.readDouble());
        this.put("Gray Channel Resolution", ras.readDouble());
        this.put("Gray Channel Units", ras.readString(64));
        ras.skipBytes(4);
        this.put("Voice field", ras.readInt());
        ras.skipBytes(4);
        double[][] stamps = new double[8][this.ifds.length];
        for (i = 0; i < this.ifds.length; ++i) {
            int j;
            s = TiffTools.getIFDShortArray(this.ifds[i], 34362, true);
            byte[] stamp = new byte[s.length];
            for (j = 0; j < s.length; ++j) {
                stamp[j] = (byte)s[j];
                if (stamp[j] >= 0) continue;
                int n = j;
                stamp[n] = (byte)(stamp[n] + 1);
            }
            ras = new RandomAccessStream(stamp);
            for (j = 0; j < 8; ++j) {
                stamps[j][i] = ras.readDouble();
            }
        }
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeZ = 1;
        this.core[0].dimensionOrder = "XY";
        this.core[0].metadataComplete = true;
        for (i = 0; i < 10; ++i) {
            String name = names[i];
            int size = sizes[i];
            float voxel = (float)resolutions[i];
            if (name == null || size == 0 || (name = name.toLowerCase().trim()).length() == 0) continue;
            if (name.equals("x")) {
                if (this.getSizeX() == 0) {
                    this.core[0].sizeX = size;
                }
                this.voxelX = voxel;
                continue;
            }
            if (name.equals("y")) {
                if (this.getSizeY() == 0) {
                    this.core[0].sizeY = size;
                }
                this.voxelY = voxel;
                continue;
            }
            if (name.equals("z") || name.equals("event")) {
                this.core[0].sizeZ *= size;
                if (this.getDimensionOrder().indexOf("Z") == -1) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                }
                this.voxelZ = voxel;
                continue;
            }
            if (name.equals("ch") || name.equals("wavelength")) {
                this.core[0].sizeC *= size;
                if (this.getDimensionOrder().indexOf("C") == -1) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                }
                this.voxelC = voxel;
                continue;
            }
            this.core[0].sizeT *= size;
            if (this.getDimensionOrder().indexOf("T") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
            }
            this.voxelT = voxel;
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        this.core[0].imageCount = this.ifds.length;
        if (this.getSizeZ() > this.ifds.length) {
            this.core[0].sizeZ = this.ifds.length;
        }
        if (this.getSizeT() > this.ifds.length) {
            this.core[0].sizeT = this.ifds.length;
        }
        if (!(this.getImageCount() != 1 || this.getSizeT() != this.getSizeY() && this.getSizeZ() != this.getSizeY() || this.getSizeT() <= this.getImageCount() && this.getSizeZ() <= this.getImageCount())) {
            this.core[0].sizeY = 1;
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        this.comment = TiffTools.getComment(this.ifds[0]);
        this.gains = new String[this.getSizeC()];
        this.offsets = new String[this.getSizeC()];
        this.voltages = new String[this.getSizeC()];
        this.channelNames = new String[this.getSizeC()];
        this.lensNA = new String[this.getSizeC()];
        if (this.comment != null && this.comment.startsWith("[")) {
            int start = this.comment.indexOf("[Acquisition Parameters]");
            int end = this.comment.indexOf("[Acquisition Parameters End]");
            if (start != -1 && end != -1 && end > start) {
                String parms = this.comment.substring(start + 24, end).trim();
                StringTokenizer st = new StringTokenizer(parms, "\n");
                block6: while (st.hasMoreTokens()) {
                    int i4;
                    String token = st.nextToken();
                    int eq = token.indexOf("=");
                    if (eq == -1) continue;
                    String key = token.substring(0, eq);
                    String value = token.substring(eq + 1);
                    this.addMeta(key, value);
                    if (key.startsWith("Gain Ch")) {
                        for (i4 = 0; i4 < this.gains.length; ++i4) {
                            if (this.gains[i4] != null) continue;
                            this.gains[i4] = value;
                            continue block6;
                        }
                        continue;
                    }
                    if (key.startsWith("PMT Voltage Ch")) {
                        for (i4 = 0; i4 < this.voltages.length; ++i4) {
                            if (this.voltages[i4] != null) continue;
                            this.voltages[i4] = value;
                            continue block6;
                        }
                        continue;
                    }
                    if (key.startsWith("Offset Ch")) {
                        for (i4 = 0; i4 < this.offsets.length; ++i4) {
                            if (this.offsets[i4] != null) continue;
                            this.offsets[i4] = value;
                            continue block6;
                        }
                        continue;
                    }
                    if (key.equals("Magnification")) {
                        this.mag = value;
                        continue;
                    }
                    if (key.equals("System Configuration")) {
                        this.detManu = value;
                        continue;
                    }
                    if (key.equals("Objective Lens")) {
                        this.objManu = value;
                        continue;
                    }
                    if (key.equals("Gamma")) {
                        this.gamma = new Double(value);
                        continue;
                    }
                    if (key.startsWith("Channel ") && key.endsWith("Dye")) {
                        for (i4 = 0; i4 < this.channelNames.length; ++i4) {
                            if (this.channelNames[i4] != null) continue;
                            this.channelNames[i4] = value;
                            continue block6;
                        }
                        continue;
                    }
                    if (!key.startsWith("Confocal Aperture-Ch")) continue;
                    for (i4 = 0; i4 < this.lensNA.length; ++i4) {
                        if (this.lensNA[i4] != null) continue;
                        this.lensNA[i4] = value.substring(0, value.length() - 2);
                        continue block6;
                    }
                }
            }
            start = this.comment.indexOf("[Version Info]");
            end = this.comment.indexOf("[Version Info End]");
            if (start != -1 && end != -1 && end > start) {
                this.comment = this.comment.substring(start + 14, end).trim();
                start = this.comment.indexOf("=") + 1;
                end = this.comment.indexOf("\n");
                this.comment = end > start ? this.comment.substring(start, end).trim() : this.comment.substring(start).trim();
            } else {
                this.comment = "";
            }
        }
        this.addMeta("Comment", this.comment);
    }

    protected void initMetadataStore() throws FormatException {
        int i;
        super.initMetadataStore();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        store.setDimensionsPhysicalSizeX(new Float(this.voxelX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(this.voxelY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(this.voxelZ), 0, 0);
        store.setDimensionsTimeIncrement(new Float(this.voxelT), 0, 0);
        if ((int)this.voxelC > 0) {
            store.setDimensionsWaveIncrement(new Integer((int)this.voxelC), 0, 0);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.channelNames[i] == null) continue;
            store.setLogicalChannelName(this.channelNames[i].trim(), 0, i);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.voltages[i] != null) {
                if (this.detManu != null) {
                    store.setDetectorManufacturer(this.detManu, 0, 0);
                }
                store.setDetectorSettingsVoltage(new Float(this.voltages[i]), 0, 0);
            }
            if (this.gains[i] != null) {
                store.setDetectorSettingsGain(new Float(this.gains[i]), 0, i);
            }
            if (this.offsets[i] != null) {
                store.setDetectorSettingsOffset(new Float(this.offsets[i]), 0, i);
            }
            store.setDetectorID("Detector:" + i, 0, i);
            store.setDetectorSettingsDetector("Detector:" + i, 0, i);
        }
        if (this.mag != null && this.mag.toLowerCase().endsWith("x")) {
            this.mag = this.mag.substring(0, this.mag.length() - 1);
        } else if (this.mag == null) {
            this.mag = "1";
        }
        if (this.objManu != null) {
            store.setObjectiveManufacturer(this.objManu, 0, 0);
        }
        if (this.mag != null) {
            store.setObjectiveCalibratedMagnification(new Float(this.mag), 0, 0);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.lensNA[i] == null) continue;
            store.setObjectiveLensNA(new Float(this.lensNA[i]), 0, i);
        }
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
    }
}

