/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.TiffTools;
import loci.formats.meta.FilterMetadata;

public class IPWReader
extends FormatReader {
    private Hashtable imageFiles;
    private POITools poi;
    private String description;
    private String creationDate;

    public IPWReader() {
        super("Image-Pro Workspace", "ipw");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        RandomAccessStream stream = this.poi.getDocumentStream((String)this.imageFiles.get(new Integer(0)));
        Hashtable[] ifds = TiffTools.getIFDs(stream);
        int[] bits = TiffTools.getBitsPerSample(ifds[0]);
        if (bits[0] <= 8) {
            int[] colorMap = (int[])TiffTools.getIFDValue(ifds[0], 320);
            if (colorMap == null) {
                return null;
            }
            byte[][] table = new byte[3][colorMap.length / 3];
            int next = 0;
            for (int j = 0; j < table.length; ++j) {
                for (int i = 0; i < table[0].length; ++i) {
                    table[j][i] = (byte)(colorMap[next++] >> 8);
                }
            }
            return table;
        }
        return null;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        RandomAccessStream stream = this.poi.getDocumentStream((String)this.imageFiles.get(new Integer(no)));
        Hashtable[] ifds = TiffTools.getIFDs(stream);
        TiffTools.getSamples(ifds[0], stream, buf, x, y, w, h);
        stream.close();
        return buf;
    }

    public void close() throws IOException {
        super.close();
        if (this.poi != null) {
            this.poi.close();
        }
        this.poi = null;
        this.imageFiles = null;
        this.description = null;
        this.creationDate = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("IPWReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.poi = new POITools(Location.getMappedId(this.currentId));
        this.imageFiles = new Hashtable();
        Vector fileList = this.poi.getDocumentList();
        for (int i = 0; i < fileList.size(); ++i) {
            byte[] b;
            String name = (String)fileList.get(i);
            String relativePath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (relativePath.equals("CONTENTS")) {
                this.addMeta("Version", new String(this.poi.getDocumentBytes(name)).trim());
                continue;
            }
            if (relativePath.equals("FrameRate")) {
                b = this.poi.getDocumentBytes(name, 4);
                this.addMeta("Frame Rate", DataTools.bytesToInt(b, true));
                continue;
            }
            if (relativePath.equals("FrameInfo")) {
                b = this.poi.getDocumentBytes(name);
                for (int q = 0; q < b.length / 2; ++q) {
                    this.addMeta("FrameInfo " + q, DataTools.bytesToShort(b, q * 2, 2, true));
                }
                continue;
            }
            if (relativePath.equals("ImageInfo")) {
                this.description = new String(this.poi.getDocumentBytes(name)).trim();
                this.addMeta("Image Description", this.description);
                String timestamp = null;
                if (this.description != null) {
                    StringTokenizer tokenizer = new StringTokenizer(this.description, "\n");
                    while (tokenizer.hasMoreTokens()) {
                        String data;
                        String token = tokenizer.nextToken();
                        String label = "Timestamp";
                        if (token.indexOf("=") != -1) {
                            label = token.substring(0, token.indexOf("=")).trim();
                            data = token.substring(token.indexOf("=") + 1).trim();
                        } else {
                            data = token.trim();
                        }
                        this.addMeta(label, data);
                        if (label.equals("frames")) {
                            this.core[0].sizeZ = Integer.parseInt(data);
                            continue;
                        }
                        if (label.equals("slices")) {
                            this.core[0].sizeT = Integer.parseInt(data);
                            continue;
                        }
                        if (label.equals("channels")) {
                            this.core[0].sizeC = Integer.parseInt(data);
                            continue;
                        }
                        if (!label.equals("Timestamp")) continue;
                        timestamp = data;
                    }
                }
                if (timestamp == null) continue;
                if (timestamp.length() > 26) {
                    timestamp = timestamp.substring(timestamp.length() - 26);
                }
                SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS aa");
                Date d = fmt.parse(timestamp, new ParsePosition(0));
                fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                this.creationDate = fmt.format(d);
                continue;
            }
            if (!relativePath.equals("ImageTIFF")) continue;
            String idx = "0";
            if (!name.substring(0, name.lastIndexOf(File.separator)).equals("Root Entry")) {
                idx = name.substring(21, name.indexOf(File.separator, 22));
            }
            this.imageFiles.put(new Integer(idx), name);
            ++this.core[0].imageCount;
        }
        this.status("Populating metadata");
        RandomAccessStream stream = this.poi.getDocumentStream((String)this.imageFiles.get(new Integer(0)));
        Hashtable[] ifds = TiffTools.getIFDs(stream);
        stream.close();
        boolean bl = this.core[0].rgb = TiffTools.getSamplesPerPixel(ifds[0]) > 1;
        if (!this.isRGB()) {
            boolean bl2 = this.core[0].indexed = TiffTools.getPhotometricInterpretation(ifds[0]) == 3;
        }
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        this.core[0].littleEndian = TiffTools.isLittleEndian(ifds[0]);
        this.addMeta("slices", "1");
        this.addMeta("channels", "1");
        this.addMeta("frames", this.getImageCount());
        Hashtable h = ifds[0];
        this.core[0].sizeX = (int)TiffTools.getImageWidth(h);
        this.core[0].sizeY = (int)TiffTools.getImageLength(h);
        String string = this.core[0].dimensionOrder = this.isRGB() ? "XYCTZ" : "XYTCZ";
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeC() * this.getSizeT() == 1 && this.getImageCount() != 1) {
            this.core[0].sizeZ = this.getImageCount();
        }
        if (this.isRGB()) {
            this.core[0].sizeC *= 3;
        }
        int bitsPerSample = TiffTools.getBitsPerSample(ifds[0])[0];
        int bitFormat = TiffTools.getIFDIntValue(ifds[0], 339);
        while (bitsPerSample % 8 != 0) {
            ++bitsPerSample;
        }
        if (bitsPerSample == 24 || bitsPerSample == 48) {
            bitsPerSample /= 3;
        }
        this.core[0].pixelType = 1;
        if (bitFormat == 3) {
            this.core[0].pixelType = 6;
        } else if (bitFormat == 2) {
            switch (bitsPerSample) {
                case 8: {
                    this.core[0].pixelType = 0;
                    break;
                }
                case 16: {
                    this.core[0].pixelType = 2;
                    break;
                }
                case 32: {
                    this.core[0].pixelType = 4;
                }
            }
        } else {
            switch (bitsPerSample) {
                case 8: {
                    this.core[0].pixelType = 1;
                    break;
                }
                case 16: {
                    this.core[0].pixelType = 3;
                    break;
                }
                case 32: {
                    this.core[0].pixelType = 5;
                }
            }
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        store.setImageDescription(this.description, 0);
        if (this.creationDate != null) {
            store.setImageCreationDate(this.creationDate, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
    }
}

