/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;

public class ImarisTiffReader
extends BaseTiffReader {
    public ImarisTiffReader() {
        super("Bitplane Imaris 3 (TIFF)", "ims");
        this.blockCheckLen = 1024;
        this.suffixSufficient = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("ImarisTiffReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        if (this.in.readShort() == 18761) {
            this.in.order(true);
        }
        this.ifds = TiffTools.getIFDs(this.in);
        if (this.ifds == null) {
            throw new FormatException("No IFDs found");
        }
        this.status("Verifying IFD sanity");
        Vector<Hashtable> tmp = new Vector<Hashtable>();
        for (int i = 1; i < this.ifds.length; ++i) {
            long[] byteCounts = TiffTools.getIFDLongArray(this.ifds[i], 325, false);
            long[] offsets = TiffTools.getIFDLongArray(this.ifds[i], 324, false);
            for (int j = 0; j < byteCounts.length; ++j) {
                Hashtable t = (Hashtable)this.ifds[i].clone();
                TiffTools.putIFDValue(t, 325, byteCounts[j]);
                TiffTools.putIFDValue(t, 324, offsets[j]);
                tmp.add(t);
            }
        }
        String comment = TiffTools.getComment(this.ifds[0]);
        this.status("Populating metadata");
        this.core[0].sizeC = this.ifds.length - 1;
        this.core[0].sizeZ = tmp.size() / this.getSizeC();
        this.core[0].sizeT = 1;
        this.core[0].sizeX = (int)TiffTools.getImageWidth(this.ifds[1]);
        this.core[0].sizeY = (int)TiffTools.getImageLength(this.ifds[1]);
        this.ifds = tmp.toArray(new Hashtable[0]);
        this.core[0].imageCount = this.getSizeC() * this.getSizeZ();
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].interleaved = false;
        this.core[0].rgb = this.getImageCount() != this.getSizeZ() * this.getSizeC() * this.getSizeT();
        this.core[0].pixelType = this.getPixelType(this.ifds[0]);
        this.status("Parsing comment");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        String description = null;
        String creationDate = null;
        Vector<Integer> emWave = new Vector<Integer>();
        Vector<Integer> exWave = new Vector<Integer>();
        Vector<String> channelNames = new Vector<String>();
        if (comment != null && comment.startsWith("[")) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals).trim();
                String value = line.substring(equals + 1).trim();
                this.addMeta(key, value);
                if (key.equals("Description")) {
                    description = value;
                    continue;
                }
                if (key.equals("LSMEmissionWavelength") && !value.equals("0")) {
                    emWave.add(new Integer(value));
                    continue;
                }
                if (key.equals("LSMExcitationWavelength") && !value.equals("0")) {
                    exWave.add(new Integer(value));
                    continue;
                }
                if (key.equals("Name") && !this.currentId.endsWith(value)) {
                    channelNames.add(value);
                    continue;
                }
                if (!key.equals("RecordingDate")) continue;
                value = value.replaceAll(" ", "T");
                creationDate = value.substring(0, value.indexOf("."));
            }
            this.metadata.remove("Comment");
        }
        store.setImageDescription(description, 0);
        store.setImageCreationDate(creationDate, 0);
        for (int i = 0; i < emWave.size(); ++i) {
            store.setLogicalChannelEmWave((Integer)emWave.get(i), 0, i);
            store.setLogicalChannelExWave((Integer)exWave.get(i), 0, i);
            store.setLogicalChannelName((String)channelNames.get(i), 0, i);
        }
    }
}

