/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class LIMReader
extends FormatReader {
    private boolean isCompressed;

    public LIMReader() {
        super("Laboratory Imaging", "lim");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(2379L);
        this.readPlane(this.in, x, y, w, h, buf);
        if (this.isRGB()) {
            for (int i = 0; i < buf.length / 3; ++i) {
                byte tmp = buf[i * 3];
                buf[i * 3] = buf[i * 3 + 2];
                buf[i * 3 + 2] = tmp;
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.isCompressed = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LIMReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.core[0].sizeX = this.in.readShort() & Short.MAX_VALUE;
        this.core[0].sizeY = this.in.readShort();
        int bits = this.in.readShort();
        while (bits % 8 != 0) {
            ++bits;
        }
        switch (bits) {
            case 8: {
                this.core[0].pixelType = 1;
                break;
            }
            case 16: {
                this.core[0].pixelType = 3;
                break;
            }
            case 24: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 3;
                break;
            }
            case 32: {
                this.core[0].pixelType = 5;
                break;
            }
            case 48: {
                this.core[0].pixelType = 3;
                this.core[0].sizeC = 3;
                break;
            }
            default: {
                throw new FormatException("Unsupported bits per pixel : " + bits);
            }
        }
        boolean bl = this.isCompressed = this.in.readShort() != 0;
        if (this.isCompressed) {
            throw new FormatException("Compressed LIM files not supported.");
        }
        this.core[0].imageCount = 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].interleaved = true;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

