/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffIFDEntry;
import loci.formats.TiffRational;
import loci.formats.TiffTools;
import loci.formats.UnknownTagException;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;

public class MetamorphReader
extends BaseTiffReader {
    public static final String[] ND_SUFFIX = new String[]{"nd"};
    public static final String[] STK_SUFFIX = new String[]{"stk", "tif", "tiff"};
    private static final int METAMORPH_ID = 33628;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private String imageName;
    private String imageCreationDate;
    private long[] emWavelength;
    private int mmPlanes;
    private MetamorphReader stkReader;
    private String[][] stks;
    private String ndFilename;

    public MetamorphReader() {
        super("Metamorph STK", new String[]{"stk", "nd"});
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            return 0;
        }
        Location l = new Location(id).getAbsoluteFile();
        String[] files = l.getParentFile().list();
        for (int i = 0; i < files.length; ++i) {
            if (!MetamorphReader.checkSuffix(files[i], ND_SUFFIX) || !id.startsWith(files[i].substring(0, files[i].lastIndexOf(".")))) continue;
            return 0;
        }
        return 2;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null) {
            return super.getUsedFiles();
        }
        Vector<String> v = new Vector<String>();
        if (this.ndFilename != null) {
            v.add(this.ndFilename);
        }
        for (int i = 0; i < this.stks.length; ++i) {
            for (int j = 0; j < this.stks[i].length; ++j) {
                v.add(this.stks[i][j]);
            }
        }
        return v.toArray(new String[0]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null || this.stks[this.series].length == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        int[] coords = FormatTools.getZCTCoords(this, no % this.getSizeZ());
        int ndx = no / this.getSizeZ();
        String file2 = this.stks[this.series][ndx];
        if (this.stkReader == null) {
            this.stkReader = new MetamorphReader();
        }
        this.stkReader.setId(file2);
        return this.stkReader.openBytes(coords[0], buf, x, y, w, h);
    }

    public void close() throws IOException {
        super.close();
        if (this.stkReader != null) {
            this.stkReader.close();
        }
        this.stkReader = null;
        this.imageCreationDate = null;
        this.imageName = null;
        this.emWavelength = null;
        this.stks = null;
        this.mmPlanes = 0;
        this.ndFilename = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            String stkFile = id.substring(0, id.lastIndexOf("."));
            if (stkFile.indexOf(File.separator) != -1) {
                stkFile = stkFile.substring(stkFile.lastIndexOf(File.separator) + 1);
            }
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            String[] dirList = parent.list();
            for (i = 0; i < dirList.length; ++i) {
                if (dirList[i].indexOf(stkFile) == -1 || !MetamorphReader.checkSuffix(dirList[i], STK_SUFFIX)) continue;
                stkFile = new Location(parent.getPath(), dirList[i]).getAbsolutePath();
                break;
            }
            super.initFile(stkFile);
        } else {
            super.initFile(id);
        }
        Location ndfile = null;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            ndfile = new Location(id);
        }
        String creationTime = null;
        if (ndfile != null && ndfile.exists() && (this.fileGroupOption(id) == 0 || this.isGroupFiles())) {
            this.ndFilename = ndfile.getAbsolutePath();
            RandomAccessStream ndStream = new RandomAccessStream(this.ndFilename);
            String line = ndStream.readLine().trim();
            int zc = this.getSizeZ();
            int cc = this.getSizeC();
            int tc = this.getSizeT();
            String z = null;
            String c = null;
            String t = null;
            Vector<Boolean> hasZ = new Vector<Boolean>();
            Vector<String> waveNames = new Vector<String>();
            while (!line.equals("\"EndFile\"")) {
                String key = line.substring(1, line.indexOf(",") - 1).trim();
                String value = line.substring(line.indexOf(",") + 1).trim();
                this.addMeta(key, value);
                if (key.equals("NZSteps")) {
                    z = value;
                } else if (key.equals("NWavelengths")) {
                    c = value;
                } else if (key.equals("NTimePoints")) {
                    t = value;
                } else if (key.startsWith("WaveDoZ")) {
                    hasZ.add(new Boolean(value.toLowerCase()));
                } else if (key.startsWith("WaveName")) {
                    waveNames.add(value);
                } else if (key.startsWith("StartTime")) {
                    creationTime = value;
                }
                line = ndStream.readLine().trim();
            }
            if (z != null) {
                zc = Integer.parseInt(z);
            }
            if (c != null) {
                cc = Integer.parseInt(c);
            }
            if (t != null) {
                tc = Integer.parseInt(t);
            }
            int numFiles = cc * tc;
            int seriesCount = 1;
            for (int i2 = 0; i2 < cc; ++i2) {
                boolean hasZ2;
                boolean hasZ1 = (Boolean)hasZ.get(i2);
                boolean bl = hasZ2 = i2 != 0 && (Boolean)hasZ.get(i2 - 1) != false;
                if (i2 <= 0 || hasZ1 == hasZ2) continue;
                seriesCount = 2;
            }
            int channelsInFirstSeries = cc;
            if (seriesCount == 2) {
                channelsInFirstSeries = 0;
                for (int i3 = 0; i3 < cc; ++i3) {
                    if (!((Boolean)hasZ.get(i3)).booleanValue()) continue;
                    ++channelsInFirstSeries;
                }
            }
            this.stks = new String[seriesCount][];
            if (seriesCount == 1) {
                this.stks[0] = new String[numFiles];
            } else {
                this.stks[0] = new String[channelsInFirstSeries * tc];
                this.stks[1] = new String[(cc - channelsInFirstSeries) * tc];
            }
            String prefix = ndfile.getPath();
            prefix = prefix.substring(prefix.lastIndexOf(File.separator) + 1, prefix.lastIndexOf("."));
            for (int i4 = 0; i4 < cc; ++i4) {
                if (waveNames.get(i4) == null) continue;
                String name = (String)waveNames.get(i4);
                waveNames.setElementAt(name.substring(1, name.length() - 1), i4);
            }
            int[] pt = new int[seriesCount];
            for (int i5 = 0; i5 < tc; ++i5) {
                for (int j = 0; j < cc; ++j) {
                    boolean validZ = (Boolean)hasZ.get(j);
                    int seriesNdx = seriesCount == 1 || validZ ? 0 : 1;
                    this.stks[seriesNdx][pt[seriesNdx]] = prefix;
                    if (waveNames.get(j) != null) {
                        String[] stringArray = this.stks[seriesNdx];
                        int n = pt[seriesNdx];
                        stringArray[n] = stringArray[n] + "_w" + (j + 1) + waveNames.get(j);
                    }
                    String[] stringArray = this.stks[seriesNdx];
                    int n = pt[seriesNdx];
                    stringArray[n] = stringArray[n] + "_t" + (i5 + 1) + ".STK";
                    int n2 = seriesNdx;
                    pt[n2] = pt[n2] + 1;
                }
            }
            ndfile = ndfile.getAbsoluteFile();
            for (int s = 0; s < this.stks.length; ++s) {
                for (int f = 0; f < this.stks[s].length; ++f) {
                    Location l = new Location(ndfile.getParent(), this.stks[s][f]);
                    if (!l.exists()) {
                        if (this.stks[s][f].indexOf("%") != -1) {
                            this.stks[s][f] = this.stks[s][f].replaceAll("%", "-");
                            l = new Location(ndfile.getParent(), this.stks[s][f]);
                            if (!l.exists()) {
                                this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".TIF";
                                l = new Location(ndfile.getParent(), this.stks[s][f]);
                                if (!l.exists()) {
                                    this.stks = null;
                                }
                            }
                        }
                        if (!l.exists()) {
                            this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".TIF";
                            l = new Location(ndfile.getParent(), this.stks[s][f]);
                            if (!l.exists()) {
                                this.stks = null;
                            }
                        }
                    }
                    if (this.stks == null) break;
                    this.stks[s][f] = l.getAbsolutePath();
                }
                if (this.stks == null) break;
            }
            this.core[0].sizeZ = zc;
            this.core[0].sizeC = cc;
            this.core[0].sizeT = tc;
            this.core[0].imageCount = zc * tc * cc;
            this.core[0].dimensionOrder = "XYZCT";
            if (this.stks != null && this.stks.length > 1) {
                CoreMetadata[] newCore = new CoreMetadata[this.stks.length];
                for (int i6 = 0; i6 < this.stks.length; ++i6) {
                    newCore[i6] = new CoreMetadata();
                    newCore[i6].sizeX = this.getSizeX();
                    newCore[i6].sizeY = this.getSizeY();
                    newCore[i6].sizeZ = this.getSizeZ();
                    newCore[i6].sizeC = this.getSizeC();
                    newCore[i6].sizeT = this.getSizeT();
                    newCore[i6].pixelType = this.getPixelType();
                    newCore[i6].imageCount = this.getImageCount();
                    newCore[i6].dimensionOrder = this.getDimensionOrder();
                    newCore[i6].rgb = this.isRGB();
                    newCore[i6].littleEndian = this.isLittleEndian();
                    newCore[i6].interleaved = this.isInterleaved();
                    newCore[i6].orderCertain = true;
                }
                newCore[0].sizeC = this.stks[0].length / newCore[0].sizeT;
                newCore[1].sizeC = this.stks[1].length / newCore[1].sizeT;
                newCore[1].sizeZ = 1;
                newCore[0].imageCount = newCore[0].sizeC * newCore[0].sizeT * newCore[0].sizeZ;
                newCore[1].imageCount = newCore[1].sizeC * newCore[1].sizeT;
                this.core = newCore;
            }
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (creationTime != null) {
                store.setImageCreationDate(DataTools.formatDate(creationTime, "yyyyMMdd HH:mm:ss"), 0);
            } else if (i > 0) {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            store.setImageName("", i);
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        block33: {
            block32: {
                super.initStandardMetadata();
                try {
                    int check;
                    int planes;
                    TiffIFDEntry uic1tagEntry = TiffTools.getFirstIFDEntry(this.in, 33628);
                    TiffIFDEntry uic2tagEntry = TiffTools.getFirstIFDEntry(this.in, 33629);
                    TiffIFDEntry uic4tagEntry = TiffTools.getFirstIFDEntry(this.in, 33631);
                    this.mmPlanes = planes = uic4tagEntry.getValueCount();
                    this.parseUIC2Tags(uic2tagEntry.getValueOffset());
                    this.parseUIC4Tags(uic4tagEntry.getValueOffset());
                    this.parseUIC1Tags(uic1tagEntry.getValueOffset(), uic1tagEntry.getValueCount());
                    this.in.seek(uic4tagEntry.getValueOffset());
                    long[] uic2 = TiffTools.getIFDLongArray(this.ifds[0], 33629, true);
                    this.core[0].imageCount = uic2.length;
                    long[] uic3 = TiffTools.getIFDLongArray(this.ifds[0], 33630, true);
                    for (int i = 0; i < uic3.length; ++i) {
                        this.in.seek(uic3[i]);
                        this.put("Wavelength [" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readLong() / this.in.readLong());
                    }
                    Hashtable[] tempIFDs = new Hashtable[this.getImageCount()];
                    long[] oldOffsets = TiffTools.getStripOffsets(this.ifds[0]);
                    long[] stripByteCounts = TiffTools.getStripByteCounts(this.ifds[0]);
                    int rowsPerStrip = (int)TiffTools.getRowsPerStrip(this.ifds[0])[0];
                    int stripsPerImage = this.getSizeY() / rowsPerStrip;
                    if (stripsPerImage * rowsPerStrip != this.getSizeY()) {
                        ++stripsPerImage;
                    }
                    if ((check = TiffTools.getPhotometricInterpretation(this.ifds[0])) == 3) {
                        TiffTools.putIFDValue(this.ifds[0], 262, 1);
                    }
                    this.emWavelength = TiffTools.getIFDLongArray(this.ifds[0], 33630, true);
                    int pointer = 0;
                    for (int i = 0; i < this.getImageCount(); ++i) {
                        Hashtable<Integer, long[]> temp = new Hashtable<Integer, long[]>(this.ifds[0]);
                        long[] newOffsets = new long[stripsPerImage];
                        if (stripsPerImage * i < oldOffsets.length) {
                            System.arraycopy(oldOffsets, stripsPerImage * i, newOffsets, 0, stripsPerImage);
                        } else {
                            for (int q = 0; q < stripsPerImage; ++q) {
                                newOffsets[q] = oldOffsets[stripsPerImage - 1] + (long)q * stripByteCounts[0];
                            }
                        }
                        temp.put(new Integer(273), newOffsets);
                        long[] newByteCounts = new long[stripsPerImage];
                        if (stripsPerImage * i < stripByteCounts.length) {
                            System.arraycopy(stripByteCounts, stripsPerImage * i, newByteCounts, 0, stripsPerImage);
                        } else {
                            Arrays.fill(newByteCounts, stripByteCounts[0]);
                        }
                        temp.put(new Integer(279), newByteCounts);
                        tempIFDs[pointer] = temp;
                        ++pointer;
                    }
                    this.ifds = tempIFDs;
                }
                catch (UnknownTagException exc) {
                    this.trace(exc);
                }
                catch (NullPointerException exc) {
                    this.trace(exc);
                }
                catch (IOException exc) {
                    this.trace(exc);
                }
                catch (FormatException exc) {
                    this.trace(exc);
                }
                try {
                    super.initStandardMetadata();
                }
                catch (FormatException exc) {
                    if (debug) {
                        this.trace(exc);
                    }
                }
                catch (IOException exc) {
                    if (!debug) break block32;
                    this.trace(exc);
                }
            }
            String descr = TiffTools.getComment(this.ifds[0]);
            if (descr != null) {
                StringTokenizer st = new StringTokenizer(descr, "\n");
                StringBuffer sb = new StringBuffer();
                boolean first = true;
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    int colon = line.indexOf(": ");
                    if (colon < 0) {
                        if (line.trim().length() > 0) {
                            sb.append(line);
                            if (!line.endsWith(".")) {
                                sb.append(".");
                            }
                            sb.append("  ");
                        }
                        first = false;
                        continue;
                    }
                    if (first) {
                        int dot = line.lastIndexOf(".", colon);
                        if (dot >= 0) {
                            String s = line.substring(0, dot + 1);
                            sb.append(s);
                            if (!s.endsWith(".")) {
                                sb.append(".");
                            }
                            sb.append("  ");
                        }
                        line = line.substring(dot + 1);
                        colon -= dot + 1;
                        first = false;
                    }
                    String key = line.substring(0, colon);
                    String value = line.substring(colon + 2);
                    this.put(key, value);
                }
                descr = sb.toString().trim();
                if (descr.equals("")) {
                    this.metadata.remove("Comment");
                } else {
                    this.put("Comment", descr);
                }
            }
            try {
                if (this.getSizeZ() == 0) {
                    this.core[0].sizeZ = TiffTools.getIFDLongArray(this.ifds[0], 33629, true).length;
                }
                if (this.getSizeT() == 0) {
                    this.core[0].sizeT = this.getImageCount() / this.getSizeZ();
                }
            }
            catch (FormatException exc) {
                if (!debug) break block33;
                this.trace(exc);
            }
        }
    }

    void parseUIC2Tags(long uic2offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic2offset);
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int num = this.in.readInt();
            int den = this.in.readInt();
            double zDistance = (double)num / (double)den;
            this.put("zDistance[" + iAsString + "]", zDistance);
            int cDate = this.in.readInt();
            this.put("creationDate[" + iAsString + "]", MetamorphReader.decodeDate(cDate));
            int cTime = this.in.readInt();
            this.put("creationTime[" + iAsString + "]", MetamorphReader.decodeTime(cTime));
            this.in.skip(8L);
        }
        this.in.seek(saveLoc);
    }

    private void parseUIC4Tags(long uic4offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic4offset);
        boolean end = false;
        block8: while (!end) {
            short id = this.in.readShort();
            switch (id) {
                case 0: {
                    end = true;
                    continue block8;
                }
                case 28: {
                    this.readStagePositions();
                    continue block8;
                }
                case 29: {
                    this.readCameraChipOffsets();
                    continue block8;
                }
                case 37: {
                    this.readStageLabels();
                    continue block8;
                }
                case 40: {
                    this.readAbsoluteZ();
                    continue block8;
                }
                case 41: {
                    this.readAbsoluteZValid();
                    continue block8;
                }
            }
        }
        this.in.seek(saveLoc);
    }

    void readStagePositions() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            int nx = this.in.readInt();
            int dx = this.in.readInt();
            int ny = this.in.readInt();
            int dy = this.in.readInt();
            double xPosition = dx == 0 ? Double.NaN : (double)nx / (double)dx;
            double yPosition = dy == 0 ? Double.NaN : (double)ny / (double)dy;
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            this.put("stageX[" + iAsString + "]", xPosition);
            this.put("stageY[" + iAsString + "]", yPosition);
        }
    }

    void readCameraChipOffsets() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int nx = this.in.readInt();
            int dx = this.in.readInt();
            int ny = this.in.readInt();
            int dy = this.in.readInt();
            double cameraXChipOffset = dx == 0 ? Double.NaN : (double)nx / (double)dx;
            double cameraYChipOffset = dy == 0 ? Double.NaN : (double)ny / (double)dy;
            this.put("cameraXChipOffset[" + iAsString + "]", cameraXChipOffset);
            this.put("cameraYChipOffset[" + iAsString + "]", cameraYChipOffset);
        }
    }

    void readStageLabels() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int strlen = this.in.readInt();
            byte[] curlabel = new byte[strlen];
            this.in.read(curlabel);
            this.put("stageLabel[" + iAsString + "]", new String(curlabel));
        }
    }

    void readAbsoluteZ() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            int nz = this.in.readInt();
            int dz = this.in.readInt();
            double absoluteZ = dz == 0 ? Double.NaN : (double)nz / (double)dz;
            this.put("absoluteZ[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", absoluteZ);
        }
    }

    void readAbsoluteZValid() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            this.put("absoluteZValid[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readInt());
        }
    }

    private void parseUIC1Tags(long uic1offset, int uic1count) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic1offset);
        block50: for (int i = 0; i < uic1count; ++i) {
            int currentID = this.in.readInt();
            int valOrOffset = this.in.readInt();
            long lastOffset = this.in.getFilePointer();
            switch (currentID) {
                case 1: {
                    this.put("MinScale", valOrOffset);
                    continue block50;
                }
                case 2: {
                    this.put("MaxScale", valOrOffset);
                    continue block50;
                }
                case 3: {
                    int calib = valOrOffset;
                    String calibration = calib != 0 ? "on" : "off";
                    this.put("Spatial Calibration", calibration);
                    continue block50;
                }
                case 4: {
                    this.put("XCalibration", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 5: {
                    this.put("YCalibration", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 6: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    this.put("CalibrationUnits", this.in.readString(num));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 7: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    this.imageName = this.in.readString(num);
                    this.put("Name", this.imageName);
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 8: {
                    int thresh = valOrOffset;
                    String threshState = "off";
                    if (thresh == 1) {
                        threshState = "inside";
                    } else if (thresh == 2) {
                        threshState = "outside";
                    }
                    this.put("ThreshState", threshState);
                    continue block50;
                }
                case 9: {
                    this.put("ThreshStateRed", valOrOffset);
                    continue block50;
                }
                case 11: {
                    this.put("ThreshStateGreen", valOrOffset);
                    continue block50;
                }
                case 12: {
                    this.put("ThreshStateBlue", valOrOffset);
                    continue block50;
                }
                case 13: {
                    this.put("ThreshStateLo", valOrOffset);
                    continue block50;
                }
                case 14: {
                    this.put("ThreshStateHi", valOrOffset);
                    continue block50;
                }
                case 15: {
                    this.put("Zoom", valOrOffset);
                    continue block50;
                }
                case 16: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.imageCreationDate = thedate + " " + thetime;
                    this.put("DateTime", this.imageCreationDate);
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 17: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.put("LastSavedTime", thedate + " " + thetime);
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 18: {
                    this.put("currentBuffer", valOrOffset);
                    continue block50;
                }
                case 19: {
                    this.put("grayFit", valOrOffset);
                    continue block50;
                }
                case 20: {
                    this.put("grayPointCount", valOrOffset);
                    continue block50;
                }
                case 21: {
                    this.put("grayX", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 22: {
                    this.put("gray", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 23: {
                    this.put("grayMin", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 24: {
                    this.put("grayMax", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 25: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    this.put("grayUnitName", this.in.readString(num));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 26: {
                    String standLUT;
                    this.in.seek(valOrOffset);
                    int standardLUT = this.in.readInt();
                    this.in.seek(lastOffset);
                    switch (standardLUT) {
                        case 0: {
                            standLUT = "monochrome";
                            break;
                        }
                        case 1: {
                            standLUT = "pseudocolor";
                            break;
                        }
                        case 2: {
                            standLUT = "Red";
                            break;
                        }
                        case 3: {
                            standLUT = "Green";
                            break;
                        }
                        case 4: {
                            standLUT = "Blue";
                            break;
                        }
                        case 5: {
                            standLUT = "user-defined";
                            break;
                        }
                        default: {
                            standLUT = "monochrome";
                        }
                    }
                    this.put("StandardLUT", standLUT);
                    continue block50;
                }
                case 27: {
                    this.put("Wavelength", valOrOffset);
                    continue block50;
                }
                case 30: {
                    this.put("OverlayMask", valOrOffset);
                    continue block50;
                }
                case 31: {
                    this.put("OverlayCompress", valOrOffset);
                    continue block50;
                }
                case 32: {
                    this.put("Overlay", valOrOffset);
                    continue block50;
                }
                case 33: {
                    this.put("SpecialOverlayMask", valOrOffset);
                    continue block50;
                }
                case 34: {
                    this.put("SpecialOverlayCompress", this.in.readInt());
                    continue block50;
                }
                case 35: {
                    this.put("SpecialOverlay", valOrOffset);
                    continue block50;
                }
                case 36: {
                    this.put("ImageProperty", valOrOffset);
                    continue block50;
                }
                case 38: {
                    this.put("AutoScaleLoInfo", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 39: {
                    this.put("AutoScaleHiInfo", this.readRational(this.in, valOrOffset));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 42: {
                    this.put("Gamma", valOrOffset);
                    continue block50;
                }
                case 43: {
                    this.put("GammaRed", valOrOffset);
                    continue block50;
                }
                case 44: {
                    this.put("GammaGreen", valOrOffset);
                    continue block50;
                }
                case 45: {
                    this.put("GammaBlue", valOrOffset);
                    continue block50;
                }
                case 46: {
                    this.in.seek(valOrOffset);
                    int xBin = this.in.readInt();
                    int yBin = this.in.readInt();
                    this.put("CameraBin", new String("(" + xBin + "," + yBin + ")"));
                    this.in.seek(lastOffset);
                }
            }
        }
        this.in.seek(saveLoc);
    }

    public static String decodeDate(int julian) {
        long a;
        long z = julian + 1;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a > 1721423L ? a + 1524L : a + 1158L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        short day = (short)(b - d - (long)(30.6001 * (double)e));
        short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
        short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
        return day + "/" + month + "/" + year;
    }

    public static String decodeTime(int millis) {
        int ms = millis % 1000;
        millis -= ms;
        int seconds = (millis /= 1000) % 60;
        millis -= seconds;
        int minutes = (millis /= 60) % 60;
        millis -= minutes;
        int hours = millis /= 60;
        return MetamorphReader.intFormat(hours, 2) + ":" + MetamorphReader.intFormat(minutes, 2) + ":" + MetamorphReader.intFormat(seconds, 2) + "." + MetamorphReader.intFormat(ms, 3);
    }

    public static String intFormat(int myint, int digits) {
        String formatstring = "0";
        while (formatstring.length() < digits) {
            formatstring = formatstring + "0";
        }
        DecimalFormat df = new DecimalFormat(formatstring);
        return df.format(myint);
    }

    public static String intFormatMax(int myint, int maxint) {
        return MetamorphReader.intFormat(myint, new Integer(maxint).toString().length());
    }

    private TiffRational readRational(RandomAccessStream s, long offset) throws IOException {
        s.seek(offset);
        int num = s.readInt();
        int denom = s.readInt();
        return new TiffRational(num, denom);
    }
}

