/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphTiffReader
extends BaseTiffReader {
    private float pixelSizeX;
    private float pixelSizeY;
    private float[] zPositions;
    private int[] wavelengths;
    private int zpPointer;
    private int wavePointer;
    private float temperature;
    private String date;
    private String imageName;
    private Vector timestamps;

    public MetamorphTiffReader() {
        super("Metamorph TIFF", new String[]{"tif", "tiff"});
        this.blockCheckLen = 524288;
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        try {
            RandomAccessStream stream = new RandomAccessStream(name);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException e) {
            if (debug) {
                this.trace(e);
            }
            return false;
        }
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        String comment = TiffTools.getComment(TiffTools.getFirstIFD(stream));
        return comment != null && comment.trim().startsWith("<MetaData>");
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("MetamorphTiffReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.timestamps = new Vector();
        String[] comments = new String[this.ifds.length];
        this.zPositions = new float[this.ifds.length];
        this.wavelengths = new int[this.ifds.length];
        this.zpPointer = 0;
        this.wavePointer = 0;
        MetamorphHandler handler = new MetamorphHandler();
        for (int i = 0; i < comments.length; ++i) {
            comments[i] = TiffTools.getComment(this.ifds[i]);
            DataTools.parseXML(comments[i], (DefaultHandler)handler);
        }
        this.core[0].sizeC = 0;
        Vector<Integer> uniqueC = new Vector<Integer>();
        for (int i = 0; i < this.zPositions.length; ++i) {
            Integer c = new Integer(this.wavelengths[i]);
            if (uniqueC.contains(c)) continue;
            uniqueC.add(c);
            ++this.core[0].sizeC;
        }
        this.core[0].sizeT = this.timestamps.size();
        if (this.core[0].sizeT == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].sizeZ = this.ifds.length / (this.getSizeT() * this.getSizeC());
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setImageName(this.imageName, 0);
        store.setImageDescription("", 0);
        SimpleDateFormat parse = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        Date d = parse.parse(this.date, new ParsePosition(0));
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat tsfmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        for (int i = 0; i < this.timestamps.size(); ++i) {
            Date td = parse.parse((String)this.timestamps.get(i), new ParsePosition(0));
            this.addMeta("timestamp " + i, tsfmt.format(td));
        }
        long startDate = 0L;
        if (this.timestamps.size() > 0) {
            startDate = parse.parse((String)this.timestamps.get(0), new ParsePosition(0)).getTime();
        }
        for (int i = 0; i < this.getImageCount(); ++i) {
            int[] coords = this.getZCTCoords(i);
            if (coords[2] >= this.timestamps.size()) continue;
            String stamp = (String)this.timestamps.get(coords[2]);
            long ms = parse.parse(stamp, new ParsePosition(0)).getTime();
            store.setPlaneTimingDeltaT(new Float(ms - startDate), 0, 0, i);
            store.setPlaneTimingExposureTime(new Float(0.0f), 0, 0, i);
        }
        store.setImageCreationDate(fmt.format(d), 0);
        store.setImagingEnvironmentTemperature(new Float(this.temperature), 0);
        store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), 0, 0);
    }

    class MetamorphHandler
    extends DefaultHandler {
        MetamorphHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String id = attributes.getValue("id");
            String value = attributes.getValue("value");
            String delim = "&#13;&#10;";
            if (id != null && value != null) {
                if (id.equals("Description")) {
                    MetamorphTiffReader.this.metadata.remove("Comment");
                    String k = null;
                    String v = null;
                    if (value.indexOf(delim) != -1) {
                        int currentIndex = -delim.length();
                        while (currentIndex != -1) {
                            int nextIndex = value.indexOf(delim, currentIndex += delim.length());
                            String line = null;
                            line = nextIndex == -1 ? value.substring(currentIndex, value.length()) : value.substring(currentIndex, nextIndex);
                            currentIndex = nextIndex;
                            int colon = line.indexOf(":");
                            if (colon == -1) continue;
                            k = line.substring(0, colon).trim();
                            v = line.substring(colon + 1).trim();
                            MetamorphTiffReader.this.addMeta(k, v);
                            if (!k.equals("Temperature")) continue;
                            MetamorphTiffReader.this.temperature = Float.parseFloat(v.trim());
                        }
                    } else {
                        int colon = value.indexOf(":");
                        while (colon != -1) {
                            k = value.substring(0, colon);
                            int space = value.lastIndexOf(" ", value.indexOf(":", colon + 1));
                            if (space == -1) {
                                space = value.length();
                            }
                            v = value.substring(colon + 1, space);
                            MetamorphTiffReader.this.addMeta(k, v);
                            value = value.substring(space).trim();
                            colon = value.indexOf(":");
                            if (!k.equals("Temperature")) continue;
                            MetamorphTiffReader.this.temperature = Float.parseFloat(v.trim());
                        }
                    }
                } else {
                    MetamorphTiffReader.this.addMeta(id, value);
                }
                if (id.equals("spatial-calibration-x")) {
                    MetamorphTiffReader.this.pixelSizeX = Float.parseFloat(value);
                } else if (id.equals("spatial-calibration-y")) {
                    MetamorphTiffReader.this.pixelSizeY = Float.parseFloat(value);
                } else if (id.equals("z-position")) {
                    ((MetamorphTiffReader)MetamorphTiffReader.this).zPositions[((MetamorphTiffReader)MetamorphTiffReader.this).zpPointer++] = Float.parseFloat(value);
                } else if (id.equals("wavelength")) {
                    ((MetamorphTiffReader)MetamorphTiffReader.this).wavelengths[((MetamorphTiffReader)MetamorphTiffReader.this).wavePointer++] = Integer.parseInt(value);
                } else if (id.equals("acquisition-time-local")) {
                    MetamorphTiffReader.this.date = value;
                    MetamorphTiffReader.this.timestamps.add(MetamorphTiffReader.this.date);
                } else if (id.equals("image-name")) {
                    MetamorphTiffReader.this.imageName = value;
                }
            }
        }
    }
}

