/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Point;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.LegacyND2Reader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ND2Reader
extends FormatReader {
    private long[][] offsets;
    private boolean isJPEG;
    private boolean isLossless;
    private boolean adjustImageCount;
    private Vector zs = new Vector();
    private Vector ts = new Vector();
    private Vector tsT = new Vector();
    private int numSeries;
    private float pixelSizeX;
    private float pixelSizeY;
    private float pixelSizeZ;
    private String gain;
    private String voltage;
    private String mag;
    private String na;
    private LegacyND2Reader legacyReader;
    private boolean legacy = false;

    public ND2Reader() {
        super("Nikon ND2", new String[]{"nd2", "jp2"});
        this.blockCheckLen = 8;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
        if (this.legacy) {
            if (this.legacyReader == null) {
                this.legacyReader = new LegacyND2Reader();
            }
        } else {
            this.legacyReader = null;
        }
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        stream.seek(4L);
        return stream.readInt() == 1783636000;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.legacy) {
            return this.legacyReader.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(this.offsets[this.series][no]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bpp * this.getRGBChannelCount();
        long maxFP = no == this.getImageCount() - 1 ? this.in.length() : this.offsets[this.series][no + 1];
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        options.maxBytes = (int)maxFP;
        if (this.isJPEG) {
            byte[] tmp = new JPEG2000Codec().decompress(this.in, options);
            for (int row = y; row < h + y; ++row) {
                System.arraycopy(tmp, pixel * row * this.getSizeX(), buf, pixel * w * (row - y), pixel * w);
            }
            System.arraycopy(tmp, 0, buf, 0, Math.min(tmp.length, buf.length));
            tmp = null;
        } else if (this.isLossless) {
            int effectiveX = this.getSizeX();
            if (this.getSizeX() % 2 != 0) {
                ++effectiveX;
            }
            byte[] t = new ZlibCodec().decompress(this.in, options);
            for (int row = 0; row < h; ++row) {
                int offset = (row + y) * effectiveX * pixel + x * pixel;
                if (offset + w * pixel > t.length) continue;
                System.arraycopy(t, offset, buf, row * w * pixel, w * pixel);
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void setNormalized(boolean normalize) {
        super.setNormalized(normalize);
        if (this.legacy) {
            this.legacyReader.setNormalized(normalize);
        }
    }

    public void setMetadataCollected(boolean collect) {
        super.setMetadataCollected(collect);
        if (this.legacy) {
            this.legacyReader.setMetadataCollected(collect);
        }
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        super.setOriginalMetadataPopulated(populate);
        if (this.legacy) {
            this.legacyReader.setOriginalMetadataPopulated(populate);
        }
    }

    public void setMetadataFiltered(boolean filter) {
        super.setMetadataFiltered(filter);
        if (this.legacy) {
            this.legacyReader.setMetadataFiltered(filter);
        }
    }

    public void setMetadataStore(MetadataStore store) {
        super.setMetadataStore(store);
        if (this.legacy) {
            this.legacyReader.setMetadataStore(store);
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.legacyReader != null) {
            this.legacyReader.close();
        }
        this.legacyReader = null;
        this.legacy = false;
        this.offsets = null;
        this.zs.clear();
        this.ts.clear();
        this.isLossless = false;
        this.isJPEG = false;
        this.adjustImageCount = false;
        this.numSeries = 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int i2;
        int numBands;
        if (debug) {
            this.debug("ND2Reader.initFile(" + id + ")");
        }
        super.initFile(id);
        if (this.legacy) {
            this.legacyReader.close();
            this.legacyReader.setId(id);
            this.core = this.legacyReader.getCoreMetadata();
            this.metadataStore = this.legacyReader.getMetadataStore();
            return;
        }
        this.in = new RandomAccessStream(id);
        if (this.in.read() == -38 && this.in.read() == -50) {
            int i3;
            int i4;
            char c;
            int j;
            int off;
            byte[] b;
            this.isJPEG = false;
            this.in.seek(0L);
            this.in.order(true);
            Vector<Long> imageOffsets = new Vector<Long>();
            Vector<Point> imageLengths = new Vector<Point>();
            Vector<Long> xmlOffsets = new Vector<Long>();
            Vector<Point> xmlLengths = new Vector<Point>();
            Vector<Long> customDataOffsets = new Vector<Long>();
            Vector<Point> customDataLengths = new Vector<Point>();
            while (this.in.getFilePointer() < this.in.length() && this.in.getFilePointer() >= 0L) {
                while (this.in.read() != -38) {
                }
                this.in.skipBytes(3);
                int lenOne = this.in.readInt();
                int lenTwo = this.in.readInt();
                int len = lenOne + lenTwo;
                this.in.skipBytes(4);
                String blockType = this.in.readString(12);
                long fp = this.in.getFilePointer() - 12L;
                this.in.skipBytes(len - 12);
                if (blockType.startsWith("ImageDataSeq")) {
                    imageOffsets.add(new Long(fp));
                    imageLengths.add(new Point(lenOne, lenTwo));
                    continue;
                }
                if (blockType.startsWith("Image")) {
                    xmlOffsets.add(new Long(fp));
                    xmlLengths.add(new Point(lenOne, lenTwo));
                    continue;
                }
                if (!blockType.startsWith("CustomData|A")) continue;
                customDataOffsets.add(new Long(fp));
                customDataLengths.add(new Point(lenOne, lenTwo));
            }
            ND2Handler handler = new ND2Handler();
            ByteVector xml = new ByteVector();
            for (int i5 = 0; i5 < xmlOffsets.size(); ++i5) {
                long offset = (Long)xmlOffsets.get(i5);
                Point p = (Point)xmlLengths.get(i5);
                int length = p.x + p.y;
                b = new byte[length];
                this.in.seek(offset);
                this.in.read(b);
                off = 0;
                for (j = 0; j < length; ++j) {
                    c = (char)b[j];
                    if (off == 0 && c == '!' || c == '\u0000') {
                        off = j + 1;
                    }
                    if (!Character.isISOControl(c) && Character.isDefined(c)) continue;
                    b[j] = 32;
                }
                if (length - off < 5 || b[off] != 60 || b[off + 1] != 63 || b[off + 2] != 120 || b[off + 3] != 109 || b[off + 4] != 108) continue;
                boolean endBracketFound = false;
                while (!endBracketFound) {
                    if (b[off++] != 62) continue;
                    endBracketFound = true;
                }
                xml.add(b, off, b.length - off);
            }
            String xmlString = new String(xml.toByteArray());
            xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ND2>" + xmlString + "</ND2>";
            DataTools.parseXML(xmlString, (DefaultHandler)handler);
            long planeSize = this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()) * this.getSizeC();
            if (planeSize * (long)this.getImageCount() * (long)this.getSeriesCount() >= this.in.length() && !this.isLossless) {
                int approxPlanes = (int)(this.in.length() / planeSize);
                this.core[0].sizeT = approxPlanes / this.getSeriesCount();
                if (this.getSizeT() * this.getSeriesCount() < approxPlanes) {
                    ++this.core[0].sizeT;
                }
                this.core[0].imageCount = this.getSizeT();
                this.core[0].sizeZ = 1;
            }
            if (customDataOffsets.size() > 0) {
                this.in.seek((Long)customDataOffsets.get(0));
                Point p = (Point)customDataLengths.get(0);
                int len = p.x + p.y;
                b = new byte[len];
                this.in.read(b);
                off = 0;
                for (int i6 = 0; i6 < len; ++i6) {
                    c = (char)b[i6];
                    if (off != 0 || c != '!') continue;
                    off = i6 + 1;
                }
                for (j = off; j < len; j += 8) {
                    double time = DataTools.bytesToDouble(b, j, 8, true);
                    this.tsT.add(new Double(time));
                    this.addMeta("timestamp " + (this.tsT.size() - 1), time);
                }
                b = null;
            }
            if (this.numSeries == 0) {
                this.numSeries = 1;
            }
            this.offsets = new long[this.numSeries][this.getImageCount()];
            if (this.getSizeZ() == 0) {
                for (int i7 = 0; i7 < this.getSeriesCount(); ++i7) {
                    this.core[i7].sizeZ = 1;
                }
            }
            if (this.getSizeT() == 0) {
                for (int i8 = 0; i8 < this.getSeriesCount(); ++i8) {
                    this.core[i8].sizeT = 1;
                }
            }
            for (int i9 = 0; i9 < imageOffsets.size(); ++i9) {
                long offset = (Long)imageOffsets.get(i9);
                Point p = (Point)imageLengths.get(i9);
                int length = p.x + p.y;
                this.in.seek(offset);
                byte[] b2 = new byte[length];
                this.in.read(b2);
                StringBuffer sb = new StringBuffer();
                int pt = 13;
                while (b2[pt] != 33) {
                    sb.append((char)b2[pt++]);
                }
                int ndx = Integer.parseInt(sb.toString());
                if (this.getSizeC() == 0) {
                    int sizeC = length / (this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()));
                    for (int q = 0; q < this.getSeriesCount(); ++q) {
                        this.core[q].sizeC = sizeC;
                    }
                }
                int seriesIndex = ndx / (this.getSizeT() * this.getSizeZ());
                int plane = ndx % (this.getSizeT() * this.getSizeZ());
                this.offsets[seriesIndex][plane] = offset + (long)p.x + 8L;
                b2 = null;
            }
            Vector<long[]> tmpOffsets = new Vector<long[]>();
            for (i4 = 0; i4 < this.offsets.length; ++i4) {
                if (this.offsets[i4][0] <= 0L) continue;
                tmpOffsets.add(this.offsets[i4]);
            }
            this.offsets = new long[tmpOffsets.size()][];
            for (i4 = 0; i4 < tmpOffsets.size(); ++i4) {
                this.offsets[i4] = (long[])tmpOffsets.get(i4);
            }
            if (this.offsets.length != this.getSeriesCount()) {
                int x = this.getSizeX();
                int y = this.getSizeY();
                int c2 = this.getSizeC();
                int pixelType = this.getPixelType();
                boolean rgb = this.isRGB();
                this.core = new CoreMetadata[this.offsets.length];
                for (int i10 = 0; i10 < this.offsets.length; ++i10) {
                    this.core[i10] = new CoreMetadata();
                    this.core[i10].sizeX = x;
                    this.core[i10].sizeY = y;
                    this.core[i10].sizeC = c2 == 0 ? 1 : c2;
                    this.core[i10].pixelType = pixelType;
                    this.core[i10].rgb = rgb;
                    this.core[i10].sizeZ = 1;
                    int invalid = 0;
                    for (int q = 0; q < this.offsets[i10].length; ++q) {
                        if (this.offsets[i10][q] != 0L) continue;
                        ++invalid;
                    }
                    this.core[i10].sizeT = (this.offsets[i10].length - invalid) / this.core[i10].sizeC;
                    if (this.core[i10].sizeT == 0) {
                        this.core[i10].sizeT = 1;
                    }
                    this.core[i10].imageCount = this.offsets[i10].length - invalid;
                }
            } else {
                for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                    this.core[i4].sizeX = this.getSizeX();
                    this.core[i4].sizeY = this.getSizeY();
                    this.core[i4].sizeC = this.getSizeC() == 0 ? 1 : this.getSizeC();
                    this.core[i4].sizeZ = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
                    this.core[i4].sizeT = this.getSizeT() == 0 ? 1 : this.getSizeT();
                    this.core[i4].imageCount = this.getImageCount();
                    this.core[i4].pixelType = this.getPixelType();
                }
            }
            for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                this.core[i4].dimensionOrder = "XYCZT";
                this.core[i4].rgb = this.getSizeC() > 1;
                this.core[i4].littleEndian = true;
                this.core[i4].interleaved = true;
                this.core[i4].indexed = false;
                this.core[i4].falseColor = false;
                this.core[i4].metadataComplete = true;
            }
            this.adjustImageCount = false;
            block18: for (i4 = 0; i4 < this.offsets.length; ++i4) {
                for (int j2 = 1; j2 < this.core[i4].imageCount; ++j2) {
                    if (this.offsets[i4][j2] >= this.offsets[i4][j2 - 1]) continue;
                    this.adjustImageCount = true;
                    continue block18;
                }
            }
            if (this.getSizeC() > 1) {
                if (this.adjustImageCount) {
                    int n = imageOffsets.size() / this.getSeriesCount();
                    for (int i11 = 0; i11 < this.getSeriesCount(); ++i11) {
                        this.core[i11].sizeT = n == 0 ? 1 : n;
                    }
                }
                for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                    this.core[i4].imageCount = this.getSizeT() * this.getSizeZ();
                }
            }
            for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                this.core[i4].imageCount = this.core[i4].sizeZ * this.core[i4].sizeT;
                if (this.core[i4].rgb) continue;
                this.core[i4].imageCount *= this.core[i4].sizeC;
            }
            FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            MetadataTools.populatePixels(store, this);
            for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                store.setImageName("Series " + i3, i3);
                MetadataTools.setDefaultCreationDate(store, id, i3);
            }
            for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                if (this.tsT.size() <= 0) continue;
                this.setSeries(i3);
                for (int n = 0; n < this.getImageCount(); ++n) {
                    int[] coords = this.getZCTCoords(n);
                    float stamp = ((Double)this.tsT.get(coords[2])).floatValue();
                    store.setPlaneTimingDeltaT(new Float(stamp), i3, 0, n);
                }
            }
            this.setSeries(0);
            return;
        }
        this.in.seek(0L);
        this.isJPEG = true;
        this.status("Calculating image offsets");
        Vector<Long> vs = new Vector<Long>();
        long pos = this.in.getFilePointer();
        boolean lastBoxFound = false;
        int length = 0;
        int box = 0;
        int x = 0;
        int y = 0;
        int c = 0;
        int type = 0;
        while (!lastBoxFound) {
            pos = this.in.getFilePointer();
            if (pos + (long)(length = this.in.readInt()) >= this.in.length() || length == 0) {
                lastBoxFound = true;
            }
            box = this.in.readInt();
            pos = this.in.getFilePointer();
            length -= 8;
            if (box == 1785737827) {
                vs.add(new Long(pos));
            } else if (box == 1785737832) {
                this.in.skipBytes(4);
                String s = this.in.readString(4);
                if (s.equals("ihdr")) {
                    y = this.in.readInt();
                    x = this.in.readInt();
                    c = this.in.readShort();
                    type = this.in.readInt();
                    type = type == 252117248 || type == 0xF070000 ? 3 : 1;
                }
            }
            if (lastBoxFound || box == 1785737832) continue;
            this.in.skipBytes(length);
        }
        this.status("Finding XML metadata");
        this.in.seek((Long)vs.get(vs.size() - 1));
        boolean found = false;
        long off = -1L;
        byte[] buf = new byte[8192];
        block27: while (!found && this.in.getFilePointer() < this.in.length()) {
            int read = 0;
            if (this.in.getFilePointer() == ((Long)vs.get(vs.size() - 1)).longValue()) {
                read = this.in.read(buf);
            } else {
                System.arraycopy(buf, buf.length - 10, buf, 0, 10);
                read = this.in.read(buf, 10, buf.length - 10);
            }
            if (read == buf.length) {
                read -= 10;
            }
            for (int i12 = 0; i12 < read + 9; ++i12) {
                if (buf[i12] != -1 || buf[i12 + 1] != -39) continue;
                found = true;
                off = this.in.getFilePointer() - (long)(read + 10) + (long)i12;
                i12 = buf.length;
                continue block27;
            }
        }
        buf = null;
        this.status("Parsing XML");
        if (off > 0L && off < this.in.length() - 5L && this.in.length() - off - 5L > 14L) {
            this.in.seek(off + 5L);
            String xml = this.in.readString((int)(this.in.length() - this.in.getFilePointer()));
            StringTokenizer st = new StringTokenizer(xml, "\n");
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><NIKON>");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.indexOf("<!--") != -1 || token.indexOf("VCAL") != -1 || !token.startsWith("<")) continue;
                sb.append(token);
            }
            sb.append("</NIKON>");
            xml = sb.toString();
            this.status("Finished assembling XML string");
            ND2Handler handler = new ND2Handler();
            int offset = 0;
            byte[] b = xml.getBytes();
            int len = b.length;
            for (int i13 = 0; i13 < len; ++i13) {
                char ch = (char)b[i13];
                if (offset == 0 && ch == '!') {
                    offset = i13 + 1;
                }
                if (!Character.isISOControl(ch) && Character.isDefined(ch)) continue;
                b[i13] = 32;
            }
            DataTools.parseXML(new String(b, offset, len - offset), (DefaultHandler)handler);
            xml = null;
        }
        this.status("Populating metadata");
        if (this.getImageCount() == 0) {
            this.core[0].sizeZ = this.zs.size() == 0 ? vs.size() : this.zs.size();
            this.core[0].sizeT = this.ts.size() == 0 ? 1 : this.ts.size();
            this.core[0].sizeC = (vs.size() + 1) / (this.getSizeT() * this.getSizeZ());
            this.core[0].imageCount = vs.size();
            while (this.getImageCount() % this.getSizeC() != 0) {
                --this.core[0].imageCount;
            }
            while (this.getSizeC() * this.getSizeZ() * this.getSizeT() > this.getImageCount()) {
                if (this.getSizeZ() < this.getSizeT()) {
                    --this.core[0].sizeT;
                    continue;
                }
                --this.core[0].sizeZ;
            }
        }
        if (this.getSizeC() * this.getSizeZ() * this.getSizeT() != this.getImageCount()) {
            this.core[0].sizeZ = this.zs.size();
            this.core[0].sizeT = this.ts.size();
            this.core[0].imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
            if (vs.size() > this.getImageCount()) {
                this.core[0].sizeT = vs.size() / (this.isRGB() ? 1 : this.getSizeC());
                this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
                if (!this.isRGB()) {
                    this.core[0].imageCount *= this.getSizeC();
                }
            }
        }
        if (this.getImageCount() == 0) {
            this.core[0].imageCount = 1;
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        for (int i14 = 0; i14 < this.getSeriesCount(); ++i14) {
            this.core[i14].sizeZ = this.getSizeZ();
            this.core[i14].sizeT = this.getSizeT();
            this.core[i14].imageCount = this.getImageCount();
            this.core[i14].dimensionOrder = "XYCZT";
            this.core[i14].sizeX = x;
            this.core[i14].sizeY = y;
            this.core[i14].interleaved = false;
            this.core[i14].littleEndian = false;
            this.core[i14].metadataComplete = true;
        }
        this.core[0].pixelType = 1;
        this.offsets = new long[1][2];
        this.offsets[0][0] = (Long)vs.get(0);
        if (this.offsets[0].length > 1 && vs.size() > 1) {
            this.offsets[0][1] = (Long)vs.get(1);
        }
        this.in.seek(this.offsets[0][0]);
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        int n = c = (numBands = c) > 1 ? numBands : this.getSizeC();
        if (numBands == 1 && this.getImageCount() == 1) {
            c = 1;
        }
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            this.core[i2].sizeC = c;
            this.core[i2].rgb = numBands > 1;
            this.core[i2].pixelType = type;
        }
        if (this.isRGB() && this.getImageCount() > this.getSizeZ() * this.getSizeT()) {
            if (this.getSizeZ() > 1) {
                this.core[0].sizeZ *= this.getSizeC();
            } else {
                this.core[0].sizeT *= this.getSizeC();
            }
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                this.core[i2].sizeT = this.getSizeT();
                this.core[i2].sizeZ = this.getSizeZ();
            }
        }
        if (vs.size() < this.getImageCount()) {
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                this.core[i2].imageCount = vs.size();
            }
        }
        if (this.numSeries == 0) {
            this.numSeries = 1;
        }
        this.offsets = new long[this.numSeries][this.getImageCount()];
        for (i2 = 0; i2 < this.getSizeT(); ++i2) {
            for (int j = 0; j < this.numSeries; ++j) {
                for (int q = 0; q < this.getSizeZ(); ++q) {
                    for (int k = 0; k < this.getEffectiveSizeC(); ++k) {
                        this.offsets[j][i2 * this.getSizeZ() * this.getEffectiveSizeC() + q * this.getEffectiveSizeC() + k] = (Long)vs.remove(0);
                    }
                }
            }
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setInstrumentID("Instrument:0", 0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName(this.currentId, i);
            store.setImageInstrumentRef("Instrument:0", 0);
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), i, 0);
            store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), i, 0);
            store.setDimensionsPhysicalSizeZ(new Float(this.pixelSizeZ), i, 0);
        }
        if (this.gain != null) {
            store.setDetectorSettingsGain(new Float(this.gain), 0, 0);
        }
        if (this.voltage != null) {
            store.setDetectorSettingsVoltage(new Float(this.voltage), 0, 0);
        }
        store.setDetectorID("Detector:0", 0, 0);
        store.setDetectorSettingsDetector("Detector:0", 0, 0);
        if (this.na != null) {
            store.setObjectiveLensNA(new Float(this.na), 0, 0);
        }
        if (this.mag != null) {
            store.setObjectiveCalibratedMagnification(new Float(this.mag), 0, 0);
        }
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
    }

    private void parseKeyAndValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.addMeta(key, value);
        if (key.endsWith("dCalibration")) {
            this.pixelSizeY = this.pixelSizeX = Float.parseFloat(value);
        } else if (key.endsWith("dAspect")) {
            this.pixelSizeZ = Float.parseFloat(value);
        } else if (key.endsWith("dGain")) {
            this.gain = value;
        } else if (key.endsWith("dLampVoltage")) {
            this.voltage = value;
        } else if (key.endsWith("dObjectiveMag")) {
            this.mag = value;
        } else if (key.endsWith("dObjectiveNA")) {
            this.na = value;
        } else if (key.endsWith("dTimeMSec")) {
            long v = (long)Double.parseDouble(value);
            if (!this.ts.contains(new Long(v))) {
                this.ts.add(new Long(v));
                this.addMeta("number of timepoints", this.ts.size());
            }
        } else if (key.endsWith("dZPos")) {
            long v = (long)Double.parseDouble(value);
            if (!this.zs.contains(new Long(v))) {
                this.zs.add(new Long(v));
            }
        } else if (key.endsWith("uiCount")) {
            if (this.getSizeT() == 0) {
                this.core[0].sizeT = Integer.parseInt(value);
            }
        } else if (key.startsWith("TextInfoItem") || key.endsWith("TextInfoItem")) {
            value = value.replaceAll("&#x000d;&#x000a;", "\n");
            StringTokenizer tokens = new StringTokenizer(value, "\n");
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken().trim();
                if (!t.startsWith("Dimensions:")) continue;
                t = t.substring(11);
                StringTokenizer dims = new StringTokenizer(t, " x ");
                while (dims.hasMoreTokens()) {
                    int i;
                    String dim = dims.nextToken().trim();
                    int idx = dim.indexOf("(");
                    int v = Integer.parseInt(dim.substring(idx + 1, dim.indexOf(")", idx)));
                    if (dim.startsWith("XY")) {
                        this.numSeries = v;
                        if (this.numSeries <= 1) continue;
                        int x = this.getSizeX();
                        int y = this.getSizeY();
                        int z = this.getSizeZ();
                        int tSize = this.getSizeT();
                        int c = this.getSizeC();
                        this.core = new CoreMetadata[this.numSeries];
                        for (int i2 = 0; i2 < this.numSeries; ++i2) {
                            this.core[i2] = new CoreMetadata();
                            this.core[i2].sizeX = x;
                            this.core[i2].sizeY = y;
                            this.core[i2].sizeZ = z == 0 ? 1 : z;
                            this.core[i2].sizeC = c == 0 ? 1 : c;
                            this.core[i2].sizeT = tSize == 0 ? 1 : tSize;
                        }
                        continue;
                    }
                    if (dim.startsWith("T")) {
                        for (i = 0; i < this.getSeriesCount(); ++i) {
                            this.core[i].sizeT = v == 0 ? 1 : v;
                        }
                        continue;
                    }
                    if (dim.startsWith("Z")) {
                        for (i = 0; i < this.getSeriesCount(); ++i) {
                            this.core[i].sizeZ = v == 0 ? 1 : v;
                        }
                        continue;
                    }
                    for (i = 0; i < this.getSeriesCount(); ++i) {
                        this.core[i].sizeC = v == 0 ? 1 : v;
                    }
                }
                int count = this.getSizeZ() * this.getSizeC() * this.getSizeT();
                for (int i = 0; i < this.getSeriesCount(); ++i) {
                    this.core[i].imageCount = count;
                }
            }
        }
    }

    class ND2Handler
    extends DefaultHandler {
        private String prefix = null;

        ND2Handler() {
        }

        public void endElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
                this.prefix = null;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("uiWidth")) {
                ((ND2Reader)ND2Reader.this).core[0].sizeX = Integer.parseInt(attributes.getValue("value"));
            } else if (qName.equals("uiWidthBytes")) {
                int bytes = Integer.parseInt(attributes.getValue("value")) / ND2Reader.this.getSizeX();
                switch (bytes) {
                    case 2: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 3;
                        break;
                    }
                    case 4: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 5;
                        break;
                    }
                    default: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 1;
                        break;
                    }
                }
            } else if (qName.startsWith("item_")) {
                int v = Integer.parseInt(qName.substring(qName.indexOf("_") + 1));
                if (v == ND2Reader.this.numSeries) {
                    ND2Reader.this.numSeries++;
                }
            } else if (qName.equals("uiCompCount")) {
                int v = Integer.parseInt(attributes.getValue("value"));
                ((ND2Reader)ND2Reader.this).core[0].sizeC = Math.max(ND2Reader.this.getSizeC(), v);
            } else if (qName.equals("uiBpcInMemory")) {
                if (attributes.getValue("value") == null) {
                    return;
                }
                int bits = Integer.parseInt(attributes.getValue("value"));
                int bytes = bits / 8;
                switch (bytes) {
                    case 2: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 3;
                        break;
                    }
                    case 4: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 5;
                        break;
                    }
                    default: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 1;
                    }
                }
                ND2Reader.this.parseKeyAndValue(qName, attributes.getValue("value"));
            } else if (qName.equals("uiHeight")) {
                ((ND2Reader)ND2Reader.this).core[0].sizeY = Integer.parseInt(attributes.getValue("value"));
            } else if (qName.equals("uiCount")) {
                int n = Integer.parseInt(attributes.getValue("value"));
                if (ND2Reader.this.getImageCount() == 0) {
                    ((ND2Reader)ND2Reader.this).core[0].imageCount = n;
                    ((ND2Reader)ND2Reader.this).core[0].sizeT = n;
                    ((ND2Reader)ND2Reader.this).core[0].sizeZ = 1;
                }
            } else if (qName.equals("uiSequenceCount")) {
                int n = Integer.parseInt(attributes.getValue("value"));
                if (n > 0 && (ND2Reader.this.getImageCount() == 0 || ND2Reader.this.getSizeT() == 0 || n < ND2Reader.this.getImageCount())) {
                    ((ND2Reader)ND2Reader.this).core[0].imageCount = n;
                    ((ND2Reader)ND2Reader.this).core[0].sizeT = n;
                    ((ND2Reader)ND2Reader.this).core[0].sizeZ = 1;
                }
            } else if (qName.startsWith("TextInfo")) {
                ND2Reader.this.parseKeyAndValue(qName, attributes.getValue("Text"));
                ND2Reader.this.parseKeyAndValue(qName, attributes.getValue("value"));
            } else if (qName.equals("dCompressionParam")) {
                int v = Integer.parseInt(attributes.getValue("value"));
                ND2Reader.this.isLossless = v > 0;
                ND2Reader.this.parseKeyAndValue(qName, attributes.getValue("value"));
            } else if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
                this.prefix = qName + " " + attributes.getValue("_SEQUENCE_INDEX");
            } else {
                StringBuffer sb = new StringBuffer();
                if (this.prefix != null) {
                    sb.append(this.prefix);
                    sb.append(" ");
                }
                sb.append(qName);
                ND2Reader.this.parseKeyAndValue(sb.toString(), attributes.getValue("value"));
            }
        }
    }
}

