/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class PCXReader
extends FormatReader {
    private long offset;
    private int bytesPerLine;
    private int nColorPlanes;

    public PCXReader() {
        super("PCX", "pcx");
        this.blockCheckLen = 1;
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.read() == 10;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(this.offset);
        byte[] b = new byte[this.bytesPerLine * this.getSizeY() * this.nColorPlanes];
        int pt = 0;
        block0: while (pt < b.length) {
            int val = this.in.read() & 0xFF;
            if ((val & 0xC0) >> 6 == 3) {
                int len = val & 0x3F;
                val = this.in.read() & 0xFF;
                for (int q = 0; q < len; ++q) {
                    b[pt++] = (byte)val;
                    if (pt % this.bytesPerLine == 0) continue block0;
                }
                continue;
            }
            b[pt++] = (byte)(val & 0xFF);
        }
        for (int row = 0; row < h; ++row) {
            System.arraycopy(b, (row * this.nColorPlanes + y) * this.bytesPerLine + x, buf, row * w, w);
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.offset = 0L;
        this.bytesPerLine = 0;
        this.nColorPlanes = 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("PCXReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Reading file header");
        this.core[0].littleEndian = true;
        this.in.order(true);
        this.in.seek(1L);
        int version = this.in.read();
        this.in.skipBytes(1);
        int bitsPerPixel = this.in.read();
        short xMin = this.in.readShort();
        short yMin = this.in.readShort();
        short xMax = this.in.readShort();
        short yMax = this.in.readShort();
        this.core[0].sizeX = xMax - xMin;
        this.core[0].sizeY = yMax - yMin;
        short vertDPI = this.in.readShort();
        short horizDPI = version == 5 ? this.in.readShort() : (short)1;
        this.in.skipBytes(49);
        this.nColorPlanes = this.in.read();
        this.bytesPerLine = this.in.readShort();
        short paletteType = this.in.readShort();
        this.offset = this.in.getFilePointer() + 58L;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].rgb = false;
        this.core[0].imageCount = 1;
        this.core[0].pixelType = 1;
        this.core[0].dimensionOrder = "XYCZT";
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

