/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class SEQReader
extends BaseTiffReader {
    private static final int IMAGE_PRO_TAG_1 = 50288;
    private static final int IMAGE_PRO_TAG_2 = 40105;

    public SEQReader() {
        super("Image-Pro Sequence", "seq");
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.core[0].sizeZ = 0;
        this.core[0].sizeT = 0;
        for (int j = 0; j < this.ifds.length; ++j) {
            int tag2;
            short[] tag1 = (short[])TiffTools.getIFDValue(this.ifds[j], 50288);
            if (tag1 != null) {
                String seqId = "";
                for (int i = 0; i < tag1.length; ++i) {
                    seqId = seqId + tag1[i];
                }
                this.addMeta("Image-Pro SEQ ID", seqId);
            }
            if ((tag2 = TiffTools.getIFDIntValue(this.ifds[0], 40105)) != -1) {
                ++this.core[0].sizeZ;
                this.addMeta("Frame Rate", tag2);
            }
            this.addMeta("Number of images", this.getSizeZ());
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() == 1 && this.getSizeT() == 1) {
            this.core[0].sizeZ = this.ifds.length;
        }
        this.addMeta("frames", this.getSizeZ());
        this.addMeta("channels", super.getSizeC());
        this.addMeta("slices", this.getSizeT());
        String descr = TiffTools.getComment(this.ifds[0]);
        this.metadata.remove("Comment");
        if (descr != null) {
            StringTokenizer tokenizer = new StringTokenizer(descr, "\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String label = token.substring(0, token.indexOf("="));
                String data = token.substring(token.indexOf("=") + 1);
                this.addMeta(label, data);
                if (label.equals("channels")) {
                    this.core[0].sizeC = Integer.parseInt(data);
                    continue;
                }
                if (label.equals("frames")) {
                    this.core[0].sizeZ = Integer.parseInt(data);
                    continue;
                }
                if (!label.equals("slices")) continue;
                this.core[0].sizeT = Integer.parseInt(data);
            }
        }
        if (this.isRGB() && this.getSizeC() != 3) {
            this.core[0].sizeC *= 3;
        }
        this.core[0].dimensionOrder = "XY";
        int maxNdx = 0;
        int max = 0;
        int[] dims = new int[]{this.getSizeZ(), this.getSizeC(), this.getSizeT()};
        String[] axes = new String[]{"Z", "C", "T"};
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] <= max) continue;
            max = dims[i];
            maxNdx = i;
        }
        this.core[0].dimensionOrder = this.core[0].dimensionOrder + axes[maxNdx];
        if (maxNdx != 1) {
            if (this.getSizeC() > 1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]);
            } else {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]) + "C";
            }
        } else {
            this.core[0].dimensionOrder = this.getSizeZ() > this.getSizeT() ? this.core[0].dimensionOrder + "ZT" : this.core[0].dimensionOrder + "TZ";
        }
    }
}

