/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MDBParser;
import loci.formats.meta.FilterMetadata;

public class ZeissLSMReader
extends BaseTiffReader {
    public static final String[] MDB_SUFFIX = new String[]{"mdb"};
    private static final int ZEISS_ID = 34412;
    private static final int TYPE_SUBBLOCK = 0;
    private static final int TYPE_ASCII = 2;
    private static final int TYPE_LONG = 4;
    private static final int TYPE_RATIONAL = 5;
    private static final int SUBBLOCK_RECORDING = 0x10000000;
    private static final int SUBBLOCK_LASERS = 0x30000000;
    private static final int SUBBLOCK_LASER = 0x50000000;
    private static final int SUBBLOCK_TRACKS = 0x20000000;
    private static final int SUBBLOCK_TRACK = 0x40000000;
    private static final int SUBBLOCK_DETECTION_CHANNELS = 0x60000000;
    private static final int SUBBLOCK_DETECTION_CHANNEL = 0x70000000;
    private static final int SUBBLOCK_ILLUMINATION_CHANNELS = Integer.MIN_VALUE;
    private static final int SUBBLOCK_ILLUMINATION_CHANNEL = -1879048192;
    private static final int SUBBLOCK_BEAM_SPLITTERS = -1610612736;
    private static final int SUBBLOCK_BEAM_SPLITTER = -1342177280;
    private static final int SUBBLOCK_DATA_CHANNELS = -1073741824;
    private static final int SUBBLOCK_DATA_CHANNEL = -805306368;
    private static final int SUBBLOCK_TIMERS = 0x11000000;
    private static final int SUBBLOCK_TIMER = 0x12000000;
    private static final int SUBBLOCK_MARKERS = 0x13000000;
    private static final int SUBBLOCK_MARKER = 0x14000000;
    private static final int SUBBLOCK_END = -1;
    private static final int SUBBLOCK_GAMMA = 1;
    private static final int SUBBLOCK_BRIGHTNESS = 2;
    private static final int SUBBLOCK_CONTRAST = 3;
    private static final int SUBBLOCK_RAMP = 4;
    private static final int SUBBLOCK_KNOTS = 5;
    private static final int SUBBLOCK_PALETTE = 6;
    private static final int RECORDING_ENTRY_DESCRIPTION = 0x10000002;
    private static final int RECORDING_ENTRY_OBJECTIVE = 0x10000004;
    private static final int TRACK_ENTRY_TIME_BETWEEN_STACKS = 0x4000000B;
    private static final int LASER_ENTRY_NAME = 0x50000001;
    private static final int CHANNEL_ENTRY_DETECTOR_GAIN = 0x70000003;
    private static final int CHANNEL_ENTRY_PINHOLE_DIAMETER = 0x70000009;
    private static final int CHANNEL_ENTRY_SPI_WAVELENGTH_START = 0x70000022;
    private static final int CHANNEL_ENTRY_SPI_WAVELENGTH_END = 1879048227;
    private static final int ILLUM_CHANNEL_WAVELENGTH = -1879048189;
    private static final int START_TIME = 268435510;
    private static final int DATA_CHANNEL_NAME = -805306367;
    private static Hashtable metadataKeys = ZeissLSMReader.createKeys();
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private boolean thumbnailsRemoved = false;
    private byte[] lut = null;
    private Vector timestamps;
    private int validChannels;
    private String mdbFilename;

    public ZeissLSMReader() {
        super("Zeiss Laser-Scanning Microscopy", "lsm");
    }

    public void close() throws IOException {
        super.close();
        this.pixelSizeZ = 0.0;
        this.pixelSizeY = 0.0;
        this.pixelSizeX = 0.0;
        this.lut = null;
        this.thumbnailsRemoved = false;
        this.timestamps = null;
        this.validChannels = 0;
        this.mdbFilename = null;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.mdbFilename == null) {
            return super.getUsedFiles();
        }
        return new String[]{this.currentId, this.mdbFilename};
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || this.getPixelType() != 1) {
            return null;
        }
        byte[][] b = new byte[3][256];
        for (int i = 2; i >= 3 - this.validChannels; --i) {
            for (int j = 0; j < 256; ++j) {
                b[i][j] = (byte)j;
            }
        }
        return b;
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || this.getPixelType() != 3) {
            return null;
        }
        short[][] s = new short[3][65536];
        for (int i = 2; i >= 3 - this.validChannels; --i) {
            for (int j = 0; j < s[i].length; ++j) {
                s[i][j] = (short)j;
            }
        }
        return s;
    }

    protected void initMetadata() throws FormatException, IOException {
        int i;
        if (!this.thumbnailsRemoved) {
            return;
        }
        Hashtable ifd = this.ifds[0];
        this.status("Reading LSM metadata");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        super.initStandardMetadata();
        short[] s = TiffTools.getIFDShortArray(ifd, 34412, true);
        byte[] cz = new byte[s.length];
        for (int i2 = 0; i2 < s.length; ++i2) {
            cz[i2] = (byte)s[i2];
        }
        RandomAccessStream ras = new RandomAccessStream(cz);
        ras.order(this.isLittleEndian());
        this.put("MagicNumber", ras.readInt());
        this.put("StructureSize", ras.readInt());
        this.put("DimensionX", ras.readInt());
        this.put("DimensionY", ras.readInt());
        this.core[0].sizeZ = ras.readInt();
        ras.skipBytes(4);
        this.core[0].sizeT = ras.readInt();
        int dataType = ras.readInt();
        switch (dataType) {
            case 2: {
                this.put("DataType", "12 bit unsigned integer");
                break;
            }
            case 5: {
                this.put("DataType", "32 bit float");
                break;
            }
            case 0: {
                this.put("DataType", "varying data types");
                break;
            }
            default: {
                this.put("DataType", "8 bit unsigned integer");
            }
        }
        this.put("ThumbnailX", ras.readInt());
        this.put("ThumbnailY", ras.readInt());
        this.pixelSizeX = ras.readDouble() * 1000000.0;
        this.pixelSizeY = ras.readDouble() * 1000000.0;
        this.pixelSizeZ = ras.readDouble() * 1000000.0;
        this.put("VoxelSizeX", new Double(this.pixelSizeX));
        this.put("VoxelSizeY", new Double(this.pixelSizeY));
        this.put("VoxelSizeZ", new Double(this.pixelSizeZ));
        this.put("OriginX", ras.readDouble());
        this.put("OriginY", ras.readDouble());
        this.put("OriginZ", ras.readDouble());
        short scanType = ras.readShort();
        switch (scanType) {
            case 0: {
                this.put("ScanType", "x-y-z scan");
                this.core[0].dimensionOrder = "XYZCT";
                break;
            }
            case 1: {
                this.put("ScanType", "z scan (x-z plane)");
                this.core[0].dimensionOrder = "XYZCT";
                break;
            }
            case 2: {
                this.put("ScanType", "line scan");
                this.core[0].dimensionOrder = "XYZCT";
                break;
            }
            case 3: {
                this.put("ScanType", "time series x-y");
                this.core[0].dimensionOrder = "XYTCZ";
                break;
            }
            case 4: {
                this.put("ScanType", "time series x-z");
                this.core[0].dimensionOrder = "XYZTC";
                break;
            }
            case 5: {
                this.put("ScanType", "time series 'Mean of ROIs'");
                this.core[0].dimensionOrder = "XYTCZ";
                break;
            }
            case 6: {
                this.put("ScanType", "time series x-y-z");
                this.core[0].dimensionOrder = "XYZTC";
                break;
            }
            case 7: {
                this.put("ScanType", "spline scan");
                this.core[0].dimensionOrder = "XYCTZ";
                break;
            }
            case 8: {
                this.put("ScanType", "spline scan x-z");
                this.core[0].dimensionOrder = "XYCZT";
                break;
            }
            case 9: {
                this.put("ScanType", "time series spline plane x-z");
                this.core[0].dimensionOrder = "XYTCZ";
                break;
            }
            case 10: {
                this.put("ScanType", "point mode");
                this.core[0].dimensionOrder = "XYZCT";
                break;
            }
            default: {
                this.put("ScanType", "x-y-z scan");
                this.core[0].dimensionOrder = "XYZCT";
            }
        }
        boolean bl = this.core[0].indexed = this.lut != null && this.getSizeC() == 1;
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.isRGB()) {
            this.core[0].dimensionOrder = this.getDimensionOrder().replaceAll("C", "");
            this.core[0].dimensionOrder = this.getDimensionOrder().replaceAll("XY", "XYC");
        }
        if (this.isIndexed()) {
            this.core[0].rgb = false;
        }
        this.core[0].imageCount = this.getEffectiveSizeC() == 0 ? this.getSizeZ() * this.getSizeT() : this.getSizeZ() * this.getSizeT() * this.getEffectiveSizeC();
        if (this.getImageCount() != this.ifds.length) {
            int diff = this.getImageCount() - this.ifds.length;
            this.core[0].imageCount = this.ifds.length;
            if (diff % this.getSizeZ() == 0) {
                this.core[0].sizeT -= diff / this.getSizeZ();
            } else if (diff % this.getSizeT() == 0) {
                this.core[0].sizeZ -= diff / this.getSizeT();
            } else if (this.getSizeZ() > 1) {
                this.core[0].sizeZ = this.ifds.length;
                this.core[0].sizeT = 1;
            } else if (this.getSizeT() > 1) {
                this.core[0].sizeT = this.ifds.length;
                this.core[0].sizeZ = 1;
            }
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = this.getImageCount();
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = this.getImageCount() / this.getSizeZ();
        }
        MetadataTools.populatePixels(store, this, true);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), 0);
        short spectralScan = ras.readShort();
        if (spectralScan != 1) {
            this.put("SpectralScan", "no spectral scan");
        } else {
            this.put("SpectralScan", "acquired with spectral scan");
        }
        int type = ras.readInt();
        switch (type) {
            case 1: {
                this.put("DataType2", "calculated data");
                break;
            }
            case 2: {
                this.put("DataType2", "animation");
                break;
            }
            default: {
                this.put("DataType2", "original scan data");
            }
        }
        long[] overlayOffsets = new long[9];
        String[] overlayKeys = new String[]{"VectorOverlay", "InputLut", "OutputLut", "ROI", "BleachROI", "MeanOfRoisOverlay", "TopoIsolineOverlay", "TopoProfileOverlay", "LinescanOverlay"};
        overlayOffsets[0] = ras.readInt();
        overlayOffsets[1] = ras.readInt();
        overlayOffsets[2] = ras.readInt();
        long channelColorsOffset = ras.readInt();
        this.put("TimeInterval", ras.readDouble());
        ras.skipBytes(4);
        long scanInformationOffset = ras.readInt();
        ras.skipBytes(4);
        long timeStampOffset = ras.readInt();
        long eventListOffset = ras.readInt();
        overlayOffsets[3] = ras.readInt();
        overlayOffsets[4] = ras.readInt();
        ras.skipBytes(4);
        this.put("DisplayAspectX", ras.readDouble());
        this.put("DisplayAspectY", ras.readDouble());
        this.put("DisplayAspectZ", ras.readDouble());
        this.put("DisplayAspectTime", ras.readDouble());
        overlayOffsets[5] = ras.readInt();
        overlayOffsets[6] = ras.readInt();
        overlayOffsets[7] = ras.readInt();
        overlayOffsets[8] = ras.readInt();
        for (i = 0; i < overlayOffsets.length; ++i) {
            this.parseOverlays(overlayOffsets[i], overlayKeys[i]);
        }
        this.put("ToolbarFlags", ras.readInt());
        ras.close();
        this.put("DimensionZ", this.getSizeZ());
        this.put("DimensionChannels", this.getSizeC());
        if (channelColorsOffset != 0L) {
            this.in.seek(channelColorsOffset + 16L);
            int namesOffset = this.in.readInt();
            if (namesOffset > 0) {
                this.in.skipBytes(namesOffset - 16);
                for (int i3 = 0; i3 < this.getSizeC() && this.in.getFilePointer() < this.in.length() - 1L; ++i3) {
                    String name = this.in.readCString();
                    if (name.length() > 128) continue;
                    this.put("ChannelName" + i3, name);
                }
            }
        }
        if (timeStampOffset != 0L) {
            this.in.seek(timeStampOffset + 8L);
            for (i = 0; i < this.getSizeT(); ++i) {
                double stamp = this.in.readDouble();
                this.put("TimeStamp" + i, stamp);
                this.timestamps.add(new Double(stamp));
            }
        }
        if (eventListOffset != 0L) {
            this.in.seek(eventListOffset + 4L);
            int numEvents = this.in.readInt();
            this.in.seek(this.in.getFilePointer() - 4L);
            this.in.order(!this.in.isLittleEndian());
            int tmpEvents = this.in.readInt();
            numEvents = numEvents < 0 ? tmpEvents : Math.min(numEvents, tmpEvents);
            this.in.order(!this.in.isLittleEndian());
            if (numEvents > 65535) {
                numEvents = 0;
            }
            for (int i4 = 0; i4 < numEvents; ++i4) {
                if (this.in.getFilePointer() + 16L > this.in.length()) continue;
                int size = this.in.readInt();
                double eventTime = this.in.readDouble();
                int eventType = this.in.readInt();
                this.put("Event" + i4 + " Time", eventTime);
                this.put("Event" + i4 + " Type", eventType);
                long fp = this.in.getFilePointer();
                int len = size - 16;
                if (len > 65536) {
                    len = 65536;
                }
                if (len < 0) {
                    len = 0;
                }
                this.put("Event" + i4 + " Description", this.in.readString(len));
                this.in.seek(fp + (long)size - 16L);
                if (this.in.getFilePointer() < 0L) break;
            }
        }
        Hashtable<Integer, Integer> acquireChannels = new Hashtable<Integer, Integer>();
        Hashtable<String, Object> channelData = new Hashtable<String, Object>();
        Hashtable<Integer, Integer> acquireLasers = new Hashtable<Integer, Integer>();
        Hashtable<String, String> laserData = new Hashtable<String, String>();
        if (scanInformationOffset != 0L) {
            this.in.seek(scanInformationOffset);
            Stack<String> prefix = new Stack<String>();
            int count = 1;
            Object value = null;
            boolean done = false;
            int nextLaserMedium = 0;
            int nextLaserType = 0;
            boolean nextGain = false;
            boolean nextPinhole = false;
            boolean nextEmWave = false;
            boolean nextExWave = false;
            boolean nextChannelName = false;
            while (!done) {
                int entry = this.in.readInt();
                int blockType = this.in.readInt();
                int dataSize = this.in.readInt();
                switch (blockType) {
                    case 0: {
                        switch (entry) {
                            case 0x10000000: {
                                prefix.push("Recording");
                                break;
                            }
                            case 0x30000000: {
                                prefix.push("Lasers");
                                break;
                            }
                            case 0x50000000: {
                                prefix.push("Laser " + count);
                                ++count;
                                break;
                            }
                            case 0x20000000: {
                                prefix.push("Tracks");
                                break;
                            }
                            case 0x40000000: {
                                prefix.push("Track " + count);
                                ++count;
                                break;
                            }
                            case 0x60000000: {
                                prefix.push("Detection Channels");
                                break;
                            }
                            case 0x70000000: {
                                prefix.push("Detection Channel " + count);
                                this.validChannels = ++count;
                                break;
                            }
                            case -2147483648: {
                                prefix.push("Illumination Channels");
                                break;
                            }
                            case -1879048192: {
                                prefix.push("Illumination Channel " + count);
                                ++count;
                                break;
                            }
                            case -1610612736: {
                                prefix.push("Beam Splitters");
                                break;
                            }
                            case -1342177280: {
                                prefix.push("Beam Splitter " + count);
                                ++count;
                                break;
                            }
                            case -1073741824: {
                                prefix.push("Data Channels");
                                break;
                            }
                            case -805306368: {
                                prefix.push("Data Channel " + count);
                                ++count;
                                break;
                            }
                            case 0x11000000: {
                                prefix.push("Timers");
                                break;
                            }
                            case 0x12000000: {
                                prefix.push("Timer " + count);
                                ++count;
                                break;
                            }
                            case 0x13000000: {
                                prefix.push("Markers");
                                break;
                            }
                            case 0x14000000: {
                                prefix.push("Marker " + count);
                                ++count;
                                break;
                            }
                            case -1: {
                                String p;
                                if (prefix.size() > 0 && (p = (String)prefix.pop()).endsWith("s")) {
                                    count = 1;
                                }
                                if (prefix.size() != 0) break;
                                done = true;
                            }
                        }
                        break;
                    }
                    case 4: {
                        value = new Long(this.in.readInt());
                        break;
                    }
                    case 5: {
                        value = new Double(this.in.readDouble());
                        break;
                    }
                    case 2: {
                        value = this.in.readString(dataSize);
                    }
                }
                String key = this.getKey(prefix, entry).trim();
                if (value instanceof String) {
                    value = ((String)value).trim();
                }
                if (key != null) {
                    this.addMeta(key, value);
                }
                if (key.endsWith("Acquire")) {
                    Integer index = new Integer(count - 2);
                    Integer acquire = new Integer(value.toString());
                    if (key.indexOf("Detection Channel") != -1) {
                        acquireChannels.put(index, acquire);
                    } else if (key.indexOf("Laser") != -1) {
                        acquireLasers.put(index, acquire);
                    }
                }
                switch (entry) {
                    case 0x10000002: {
                        store.setImageDescription(value.toString(), 0);
                        break;
                    }
                    case 0x10000004: {
                        int next;
                        String[] tokens = value.toString().split(" ");
                        StringBuffer model = new StringBuffer();
                        for (next = 0; next < tokens.length && tokens[next].indexOf("/") == -1; ++next) {
                            model.append(tokens[next]);
                        }
                        store.setObjectiveModel(model.toString(), 0, 0);
                        if (next < tokens.length) {
                            String p = tokens[next++];
                            String mag = p.substring(0, p.indexOf("/") - 1);
                            String na = p.substring(p.indexOf("/") + 1);
                            store.setObjectiveNominalMagnification(new Integer(mag), 0, 0);
                            store.setObjectiveLensNA(new Float(na), 0, 0);
                        }
                        if (next < tokens.length) {
                            store.setObjectiveImmersion(tokens[next++], 0, 0);
                        }
                        boolean iris = false;
                        if (next < tokens.length) {
                            iris = tokens[next++].trim().equalsIgnoreCase("iris");
                        }
                        store.setObjectiveIris(new Boolean(iris), 0, 0);
                        store.setObjectiveID("Objective:0", 0, 0);
                        store.setObjectiveSettingsObjective("Objective:0", 0);
                        break;
                    }
                    case 0x4000000B: {
                        store.setDimensionsTimeIncrement(new Float(value.toString()), 0, 0);
                        break;
                    }
                    case 0x50000001: {
                        String medium = value.toString();
                        String laserType = null;
                        if (medium.startsWith("HeNe")) {
                            medium = "HeNe";
                            laserType = "Gas";
                        } else if (medium.startsWith("Argon")) {
                            medium = "Ar";
                            laserType = "Gas";
                        } else if (medium.equals("Titanium:Sapphire") || medium.equals("Mai Tai")) {
                            medium = "TiSapphire";
                            laserType = "SolidState";
                        } else if (medium.equals("YAG")) {
                            medium = null;
                            laserType = "SolidState";
                        } else if (medium.equals("Ar/Kr")) {
                            medium = null;
                            laserType = "Gas";
                        } else if (medium.equals("Enterprise")) {
                            medium = null;
                        }
                        laserData.put("medium " + nextLaserMedium, medium == null ? "" : medium);
                        laserData.put("type " + nextLaserType, laserType == null ? "" : laserType);
                        ++nextLaserMedium;
                        ++nextLaserType;
                        break;
                    }
                    case 0x70000003: {
                        break;
                    }
                    case 0x70000009: {
                        float n = Float.parseFloat(value.toString());
                        channelData.put("pinhole " + count, new Float(n));
                        break;
                    }
                    case -1879048189: {
                        float n = Float.parseFloat(value.toString());
                        channelData.put("em " + count, new Integer((int)n));
                        channelData.put("ex " + count, new Integer((int)n));
                        break;
                    }
                    case 268435510: {
                        double time = Double.parseDouble(value.toString());
                        store.setImageCreationDate(DataTools.convertDate((long)(time * 8.64E7), 2), 0);
                        break;
                    }
                    case -805306367: {
                        channelData.put("name " + count, value.toString());
                    }
                }
                if (done) continue;
                done = this.in.getFilePointer() >= this.in.length() - 12L;
            }
        }
        int nextLaser = 0;
        for (int i5 = 0; i5 < acquireLasers.size(); ++i5) {
            boolean acquire;
            boolean bl2 = acquire = (Integer)acquireLasers.get(new Integer(i5)) != 0;
            if (!acquire) continue;
            String medium = (String)laserData.get("medium " + i5);
            String laserType = (String)laserData.get("type " + i5);
            if (medium.equals("") || laserType.equals("")) continue;
            store.setLaserLaserMedium(medium, 0, nextLaser);
            store.setLaserType(laserType, 0, nextLaser);
            store.setLightSourceID("LightSource:" + nextLaser, 0, nextLaser);
            store.setLightSourceSettingsLightSource("LightSource:" + nextLaser, 0, nextLaser);
            ++nextLaser;
        }
        int nextChannel = 0;
        for (int i6 = 0; i6 < acquireChannels.size(); ++i6) {
            boolean acquire;
            boolean bl3 = acquire = (Integer)acquireChannels.get(new Integer(i6 + 1)) != 0;
            if (!acquire) continue;
            String name = (String)channelData.get("name " + (i6 + 3));
            Integer ex = (Integer)channelData.get("ex " + (i6 + 3));
            Integer em = (Integer)channelData.get("em " + (i6 + 3));
            Float pinhole = (Float)channelData.get("pinhole " + (i6 + 3));
            store.setLogicalChannelName(name, 0, nextChannel);
            store.setLogicalChannelEmWave(em, 0, nextChannel);
            store.setLogicalChannelExWave(ex, 0, nextChannel);
            store.setLogicalChannelPinholeSize(pinhole, 0, nextChannel);
            ++nextChannel;
        }
        Float pixX = new Float((float)this.pixelSizeX);
        Float pixY = new Float((float)this.pixelSizeY);
        Float pixZ = new Float((float)this.pixelSizeZ);
        store.setDimensionsPhysicalSizeX(pixX, 0, 0);
        store.setDimensionsPhysicalSizeY(pixY, 0, 0);
        store.setDimensionsPhysicalSizeZ(pixZ, 0, 0);
        float firstStamp = this.timestamps.size() == 0 ? 0.0f : ((Double)this.timestamps.get(0)).floatValue();
        for (int i7 = 0; i7 < this.getImageCount(); ++i7) {
            float nextStamp;
            int[] zct = FormatTools.getZCTCoords(this, i7);
            if (zct[2] >= this.timestamps.size()) continue;
            float thisStamp = ((Double)this.timestamps.get(zct[2])).floatValue();
            store.setPlaneTimingDeltaT(new Float(thisStamp - firstStamp), 0, 0, i7);
            float f = nextStamp = zct[2] < this.getSizeT() - 1 ? ((Double)this.timestamps.get(zct[2] + 1)).floatValue() : thisStamp;
            if (i7 == this.getSizeT() - 1 && zct[2] > 0) {
                thisStamp = ((Double)this.timestamps.get(zct[2] - 1)).floatValue();
            }
            store.setPlaneTimingExposureTime(new Float(nextStamp - thisStamp), 0, 0, i7);
        }
        Location dir = new Location(this.currentId).getAbsoluteFile().getParentFile();
        String[] dirList = dir.list();
        for (int i8 = 0; i8 < dirList.length; ++i8) {
            block123: {
                if (!ZeissLSMReader.checkSuffix(dirList[i8], MDB_SUFFIX)) continue;
                try {
                    Location file2 = new Location(dir.getPath(), dirList[i8]);
                    if (!file2.isDirectory()) {
                        this.mdbFilename = file2.getAbsolutePath();
                        Vector[] tables = MDBParser.parseDatabase(this.mdbFilename);
                        for (int table = 0; table < tables.length; ++table) {
                            String[] columnNames = (String[])tables[table].get(0);
                            for (int row = 1; row < tables[table].size(); ++row) {
                                String[] tableRow = (String[])tables[table].get(row);
                                String baseKey = columnNames[0] + " ";
                                for (int col = 0; col < tableRow.length; ++col) {
                                    this.addMeta(baseKey + columnNames[col + 1] + " " + row, tableRow[col]);
                                }
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    if (!debug) break block123;
                    this.trace(exc);
                }
            }
            i8 = dirList.length;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (debug) {
            this.debug("ZeissLSMReader.initFile(" + id + ")");
        }
        this.thumbnailsRemoved = false;
        super.initFile(id);
        this.timestamps = new Vector();
        this.status("Removing thumbnails");
        Vector<Hashtable> newIFDs = new Vector<Hashtable>();
        for (i = 0; i < this.ifds.length; ++i) {
            long subFileType = TiffTools.getIFDLongValue(this.ifds[i], 254, true, 0L);
            if (subFileType != 0L) continue;
            if (TiffTools.getCompression(this.ifds[i]) != 5) {
                this.ifds[i].put(new Integer(317), new Integer(1));
            }
            newIFDs.add(this.ifds[i]);
        }
        this.ifds = newIFDs.toArray(new Hashtable[0]);
        this.thumbnailsRemoved = true;
        for (i = 1; i < this.ifds.length; ++i) {
            long thisOffset = TiffTools.getStripOffsets(this.ifds[i])[0] & 0xFFFFFFFFL;
            long prevOffset = TiffTools.getStripOffsets(this.ifds[i - 1])[0];
            if (prevOffset < 0L) {
                prevOffset &= 0xFFFFFFFFL;
            }
            if (prevOffset <= thisOffset) continue;
            this.ifds[i].put(new Integer(273), new Long(thisOffset += 0xFFFFFFFFL));
        }
        this.initMetadata();
        this.core[0].littleEndian = !this.isLittleEndian();
    }

    protected void parseOverlays(long data, String suffix) throws IOException {
        if (data == 0L) {
            return;
        }
        this.in.seek(data);
        int nde = this.in.readInt();
        this.put("NumberDrawingElements-" + suffix, nde);
        int size = this.in.readInt();
        int idata = this.in.readInt();
        this.put("LineWidth-" + suffix, idata);
        idata = this.in.readInt();
        this.put("Measure-" + suffix, idata);
        this.in.skipBytes(8);
        this.put("ColorRed-" + suffix, this.in.read());
        this.put("ColorGreen-" + suffix, this.in.read());
        this.put("ColorBlue-" + suffix, this.in.read());
        this.in.skipBytes(1);
        this.put("Valid-" + suffix, this.in.readInt());
        this.put("KnotWidth-" + suffix, this.in.readInt());
        this.put("CatchArea-" + suffix, this.in.readInt());
        this.put("FontHeight-" + suffix, this.in.readInt());
        this.put("FontWidth-" + suffix, this.in.readInt());
        this.put("FontEscapement-" + suffix, this.in.readInt());
        this.put("FontOrientation-" + suffix, this.in.readInt());
        this.put("FontWeight-" + suffix, this.in.readInt());
        this.put("FontItalic-" + suffix, this.in.readInt());
        this.put("FontUnderline-" + suffix, this.in.readInt());
        this.put("FontStrikeOut-" + suffix, this.in.readInt());
        this.put("FontCharSet-" + suffix, this.in.readInt());
        this.put("FontOutPrecision-" + suffix, this.in.readInt());
        this.put("FontClipPrecision-" + suffix, this.in.readInt());
        this.put("FontQuality-" + suffix, this.in.readInt());
        this.put("FontPitchAndFamily-" + suffix, this.in.readInt());
        this.put("FontFaceName-" + suffix, this.in.readString(64));
        this.put("ClosedPolyline-" + suffix, this.in.read());
        this.put("OpenPolyline-" + suffix, this.in.read());
        this.put("ClosedBezierCurve-" + suffix, this.in.read());
        this.put("OpenBezierCurve-" + suffix, this.in.read());
        this.put("ArrowWithClosedTip-" + suffix, this.in.read());
        this.put("ArrowWithOpenTip-" + suffix, this.in.read());
        this.put("Ellipse-" + suffix, this.in.read());
        this.put("Circle-" + suffix, this.in.read());
        this.put("Rectangle-" + suffix, this.in.read());
        this.put("Line-" + suffix, this.in.read());
    }

    private String getKey(Stack stack, int entry) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            sb.append((String)stack.get(i));
            sb.append("/");
        }
        sb.append(" - ");
        sb.append(metadataKeys.get(new Integer(entry)));
        return sb.toString();
    }

    private static Hashtable createKeys() {
        Hashtable<Integer, String> h = new Hashtable<Integer, String>();
        h.put(new Integer(0x10000001), "Name");
        h.put(new Integer(0x4000000C), "Name");
        h.put(new Integer(0x50000001), "Name");
        h.put(new Integer(-1879048191), "Name");
        h.put(new Integer(-1879048187), "Name");
        h.put(new Integer(-1342177277), "Name");
        h.put(new Integer(-805306367), "Name");
        h.put(new Integer(0x12000001), "Name");
        h.put(new Integer(0x14000001), "Name");
        h.put(new Integer(0x10000002), "Description");
        h.put(new Integer(335544322), "Description");
        h.put(new Integer(0x10000003), "Notes");
        h.put(new Integer(0x10000004), "Objective");
        h.put(new Integer(0x10000005), "Processing Summary");
        h.put(new Integer(0x10000006), "Special Scan Mode");
        h.put(new Integer(0x10000007), "Scan Type");
        h.put(new Integer(0x10000008), "Scan Mode");
        h.put(new Integer(0x10000009), "Number of Stacks");
        h.put(new Integer(0x1000000A), "Lines Per Plane");
        h.put(new Integer(0x1000000B), "Samples Per Line");
        h.put(new Integer(0x1000000C), "Planes Per Volume");
        h.put(new Integer(0x1000000D), "Images Width");
        h.put(new Integer(0x1000000E), "Images Height");
        h.put(new Integer(0x1000000F), "Number of Planes");
        h.put(new Integer(0x10000010), "Number of Stacks");
        h.put(new Integer(0x10000011), "Number of Channels");
        h.put(new Integer(0x10000012), "Linescan XY Size");
        h.put(new Integer(0x10000013), "Scan Direction");
        h.put(new Integer(0x10000014), "Time Series");
        h.put(new Integer(0x10000015), "Original Scan Data");
        h.put(new Integer(0x10000016), "Zoom X");
        h.put(new Integer(0x10000017), "Zoom Y");
        h.put(new Integer(0x10000018), "Zoom Z");
        h.put(new Integer(0x10000019), "Sample 0X");
        h.put(new Integer(0x1000001A), "Sample 0Y");
        h.put(new Integer(0x1000001B), "Sample 0Z");
        h.put(new Integer(0x1000001C), "Sample Spacing");
        h.put(new Integer(0x1000001D), "Line Spacing");
        h.put(new Integer(0x1000001E), "Plane Spacing");
        h.put(new Integer(0x1000001F), "Plane Width");
        h.put(new Integer(0x10000020), "Plane Height");
        h.put(new Integer(0x10000021), "Volume Depth");
        h.put(new Integer(268435508), "Rotation");
        h.put(new Integer(268435509), "Precession");
        h.put(new Integer(268435510), "Sample 0Time");
        h.put(new Integer(268435511), "Start Scan Trigger In");
        h.put(new Integer(268435512), "Start Scan Trigger Out");
        h.put(new Integer(268435513), "Start Scan Event");
        h.put(new Integer(0x10000040), "Start Scan Time");
        h.put(new Integer(0x10000041), "Stop Scan Trigger In");
        h.put(new Integer(268435522), "Stop Scan Trigger Out");
        h.put(new Integer(268435523), "Stop Scan Event");
        h.put(new Integer(0x10000044), "Stop Scan Time");
        h.put(new Integer(268435525), "Use ROIs");
        h.put(new Integer(268435526), "Use Reduced Memory ROIs");
        h.put(new Integer(268435527), "User");
        h.put(new Integer(268435528), "Use B/C Correction");
        h.put(new Integer(268435529), "Position B/C Contrast 1");
        h.put(new Integer(0x10000050), "Position B/C Contrast 2");
        h.put(new Integer(0x10000051), "Interpolation Y");
        h.put(new Integer(268435538), "Camera Binning");
        h.put(new Integer(268435539), "Camera Supersampling");
        h.put(new Integer(268435540), "Camera Frame Width");
        h.put(new Integer(0x10000055), "Camera Frame Height");
        h.put(new Integer(268435542), "Camera Offset X");
        h.put(new Integer(268435543), "Camera Offset Y");
        h.put(new Integer(0x40000001), "Multiplex Type");
        h.put(new Integer(0x40000002), "Multiplex Order");
        h.put(new Integer(0x40000003), "Sampling Mode");
        h.put(new Integer(0x40000004), "Sampling Method");
        h.put(new Integer(0x40000005), "Sampling Number");
        h.put(new Integer(0x40000006), "Acquire");
        h.put(new Integer(0x50000002), "Acquire");
        h.put(new Integer(0x7000000B), "Acquire");
        h.put(new Integer(-1879048188), "Acquire");
        h.put(new Integer(-805306345), "Acquire");
        h.put(new Integer(0x40000007), "Sample Observation Time");
        h.put(new Integer(0x40000008), "Time Between Stacks");
        h.put(new Integer(0x4000000D), "Collimator 1 Name");
        h.put(new Integer(0x4000000E), "Collimator 1 Position");
        h.put(new Integer(0x4000000F), "Collimator 2 Name");
        h.put(new Integer(0x40000010), "Collimator 2 Position");
        h.put(new Integer(0x40000011), "Is Bleach Track");
        h.put(new Integer(1073741842), "Bleach After Scan Number");
        h.put(new Integer(1073741843), "Bleach Scan Number");
        h.put(new Integer(0x40000014), "Trigger In");
        h.put(new Integer(301989892), "Trigger In");
        h.put(new Integer(335544323), "Trigger In");
        h.put(new Integer(1073741845), "Trigger Out");
        h.put(new Integer(301989893), "Trigger Out");
        h.put(new Integer(0x14000004), "Trigger Out");
        h.put(new Integer(1073741846), "Is Ratio Track");
        h.put(new Integer(1073741847), "Bleach Count");
        h.put(new Integer(1073741848), "SPI Center Wavelength");
        h.put(new Integer(1073741849), "Pixel Time");
        h.put(new Integer(0x40000020), "ID Condensor Frontlens");
        h.put(new Integer(1073741857), "Condensor Frontlens");
        h.put(new Integer(0x40000022), "ID Field Stop");
        h.put(new Integer(1073741859), "Field Stop Value");
        h.put(new Integer(0x40000024), "ID Condensor Aperture");
        h.put(new Integer(1073741861), "Condensor Aperture");
        h.put(new Integer(1073741862), "ID Condensor Revolver");
        h.put(new Integer(1073741863), "Condensor Revolver");
        h.put(new Integer(1073741864), "ID Transmission Filter 1");
        h.put(new Integer(1073741865), "ID Transmission 1");
        h.put(new Integer(0x40000030), "ID Transmission Filter 2");
        h.put(new Integer(1073741873), "ID Transmission 2");
        h.put(new Integer(1073741874), "Repeat Bleach");
        h.put(new Integer(0x40000033), "Enable Spot Bleach Pos");
        h.put(new Integer(0x40000034), "Spot Bleach Position X");
        h.put(new Integer(1073741877), "Spot Bleach Position Y");
        h.put(new Integer(1073741878), "Bleach Position Z");
        h.put(new Integer(0x50000003), "Power");
        h.put(new Integer(-1879048190), "Power");
        h.put(new Integer(0x70000003), "Detector Gain");
        h.put(new Integer(0x70000005), "Amplifier Gain");
        h.put(new Integer(0x70000007), "Amplifier Offset");
        h.put(new Integer(0x70000009), "Pinhole Diameter");
        h.put(new Integer(0x7000000C), "Detector Name");
        h.put(new Integer(0x7000000D), "Amplifier Name");
        h.put(new Integer(0x7000000E), "Pinhole Name");
        h.put(new Integer(0x7000000F), "Filter Set Name");
        h.put(new Integer(0x70000010), "Filter Name");
        h.put(new Integer(1879048211), "Integrator Name");
        h.put(new Integer(1879048212), "Detection Channel Name");
        h.put(new Integer(1879048213), "Detector Gain B/C 1");
        h.put(new Integer(1879048214), "Detector Gain B/C 2");
        h.put(new Integer(0x70000017), "Amplifier Gain B/C 1");
        h.put(new Integer(1879048216), "Amplifier Gain B/C 2");
        h.put(new Integer(1879048217), "Amplifier Offset B/C 1");
        h.put(new Integer(0x70000020), "Amplifier Offset B/C 2");
        h.put(new Integer(1879048225), "Spectral Scan Channels");
        h.put(new Integer(0x70000022), "SPI Wavelength Start");
        h.put(new Integer(1879048227), "SPI Wavelength End");
        h.put(new Integer(1879048230), "Dye Name");
        h.put(new Integer(-805306348), "Dye Name");
        h.put(new Integer(0x70000027), "Dye Folder");
        h.put(new Integer(-805306347), "Dye Folder");
        h.put(new Integer(-1879048189), "Wavelength");
        h.put(new Integer(-1879048186), "Power B/C 1");
        h.put(new Integer(-1879048185), "Power B/C 2");
        h.put(new Integer(-1342177279), "Filter Set");
        h.put(new Integer(-1342177278), "Filter");
        h.put(new Integer(-805306364), "Color");
        h.put(new Integer(-805306363), "Sample Type");
        h.put(new Integer(-805306362), "Bits Per Sample");
        h.put(new Integer(-805306361), "Ratio Type");
        h.put(new Integer(-805306360), "Ratio Track 1");
        h.put(new Integer(-805306359), "Ratio Track 2");
        h.put(new Integer(-805306358), "Ratio Channel 1");
        h.put(new Integer(-805306357), "Ratio Channel 2");
        h.put(new Integer(-805306356), "Ratio Const. 1");
        h.put(new Integer(-805306355), "Ratio Const. 2");
        h.put(new Integer(-805306354), "Ratio Const. 3");
        h.put(new Integer(-805306353), "Ratio Const. 4");
        h.put(new Integer(-805306352), "Ratio Const. 5");
        h.put(new Integer(-805306351), "Ratio Const. 6");
        h.put(new Integer(-805306350), "Ratio First Images 1");
        h.put(new Integer(-805306349), "Ratio First Images 2");
        h.put(new Integer(-805306346), "Spectrum");
        h.put(new Integer(301989891), "Interval");
        return h;
    }
}

