/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;

public class ZeissZVIReader
extends FormatReader {
    private int bpp;
    private String[] imageFiles;
    private int[] offsets;
    private int[][] coordinates;
    private Hashtable timestamps;
    private Hashtable exposureTime;
    private int cIndex = -1;
    private boolean isTiled;
    private int tileRows;
    private int tileColumns;
    private boolean isJPEG;
    private String firstImageTile;
    private String secondImageTile;
    private int tileWidth;
    private int tileHeight;
    private int realWidth;
    private int realHeight;
    private POITools poi;
    private Hashtable tagsToParse;

    public ZeissZVIReader() {
        super("Zeiss Vision Image (ZVI)", "zvi");
        this.blockCheckLen = 4;
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bytes * this.getRGBChannelCount();
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        if (this.tileRows * this.tileColumns == 0 || this.tileWidth * this.tileHeight == 0) {
            RandomAccessStream s = this.poi.getDocumentStream(this.imageFiles[no]);
            s.seek(this.offsets[no]);
            int len = w * pixel;
            if (this.isJPEG) {
                byte[] t = new JPEGCodec().decompress(s, options);
                int row = this.getSizeX() * pixel;
                for (int yy = 0; yy < h; ++yy) {
                    System.arraycopy(t, (yy + y) * row + x * pixel, buf, yy * len, len);
                }
            } else {
                this.readPlane(s, x, y, w, h, buf);
            }
            s.close();
        } else {
            int firstTile = no * this.tileRows * this.tileColumns;
            int rowOffset = 0;
            int colOffset = 0;
            byte[] tile = new byte[this.tileWidth * this.tileHeight * bytes];
            for (int row = 0; row < this.tileRows; ++row) {
                for (int col = 0; col < this.tileColumns; ++col) {
                    int rowIndex = row * this.tileHeight;
                    int colIndex = col * this.tileWidth;
                    if ((rowIndex > y || rowIndex + this.tileHeight < y) && (rowIndex <= y || rowIndex > y + h) || (colIndex > x || colIndex + this.tileWidth < x) && (colIndex <= x || colIndex > x + w)) continue;
                    int tileX = colIndex < x ? x - colIndex : 0;
                    int tileY = rowIndex < y ? y - rowIndex : 0;
                    int tileW = colIndex + this.tileWidth <= x + w ? this.tileWidth - tileX : x + w - colIndex - tileX;
                    int tileH = rowIndex + this.tileHeight <= y + h ? this.tileHeight - tileY : y + h - rowIndex - tileY;
                    int count = this.getSizeZ() * this.getSizeT() * this.getSizeC();
                    int ii = no + (row * this.tileColumns + col) * count;
                    if (row % 2 == 1) {
                        ii = no + (row * this.tileColumns + (this.tileColumns - col - 1)) * count;
                    }
                    RandomAccessStream s = this.poi.getDocumentStream(this.imageFiles[ii]);
                    s.seek(this.offsets[ii]);
                    s.read(tile);
                    if (this.isJPEG) {
                        tile = new JPEGCodec().decompress(tile, options);
                    }
                    s.close();
                    for (int r = tileY; r < tileY + tileH; ++r) {
                        int src = pixel * (r * this.tileWidth + tileX);
                        int dest = pixel * (w * (rowOffset + r - tileY) + colOffset);
                        int len = pixel * tileW;
                        System.arraycopy(tile, src, buf, dest, len);
                    }
                    if ((colOffset += tileW) < w) continue;
                    colOffset = 0;
                    rowOffset += tileH;
                }
            }
        }
        if (this.isRGB()) {
            byte[] bb = new byte[bytes];
            for (int i = 0; i < buf.length; i += this.bpp) {
                System.arraycopy(buf, i + 2 * bytes, bb, 0, bytes);
                System.arraycopy(buf, i, buf, i + 2 * bytes, bytes);
                System.arraycopy(bb, 0, buf, i, bytes);
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.exposureTime = null;
        this.timestamps = null;
        this.offsets = null;
        this.coordinates = null;
        this.imageFiles = null;
        this.cIndex = -1;
        this.tileColumns = 0;
        this.tileRows = 0;
        this.bpp = 0;
        this.isJPEG = false;
        this.isTiled = false;
        if (this.poi != null) {
            this.poi.close();
        }
        this.poi = null;
        this.tagsToParse = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (debug) {
            this.debug("ZeissZVIReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.timestamps = new Hashtable();
        this.exposureTime = new Hashtable();
        this.poi = new POITools(Location.getMappedId(id));
        this.tagsToParse = new Hashtable();
        String[] files = this.poi.getDocumentList().toArray(new String[0]);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                int n1 = ZeissZVIReader.this.getImageNumber((String)o1, -1);
                int n2 = ZeissZVIReader.this.getImageNumber((String)o2, -1);
                return new Integer(n1).compareTo(new Integer(n2));
            }
        });
        this.core[0].imageCount = 0;
        for (int i2 = 0; i2 < files.length; ++i2) {
            String uname = files[i2].toUpperCase();
            if (!(uname = uname.substring(uname.indexOf(File.separator) + 1)).endsWith("CONTENTS") || !uname.startsWith("IMAGE") && uname.indexOf("ITEM") == -1 || this.poi.getFileSize(files[i2]) <= 1024 || this.getImageNumber(files[i2], 0) < this.getImageCount()) continue;
            ++this.core[0].imageCount;
        }
        this.offsets = new int[this.getImageCount()];
        this.coordinates = new int[this.getImageCount()][3];
        this.imageFiles = new String[this.getImageCount()];
        Vector<Integer> cIndices = new Vector<Integer>();
        Vector<Integer> zIndices = new Vector<Integer>();
        Vector<Integer> tIndices = new Vector<Integer>();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        for (int i3 = 0; i3 < files.length; ++i3) {
            int imageNum;
            String name = files[i3];
            String relPath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (!relPath.toUpperCase().equals("CONTENTS")) continue;
            String dirName = name.substring(0, name.lastIndexOf(File.separator));
            if (dirName.indexOf(File.separator) != -1) {
                dirName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
            }
            if (name.indexOf("Scaling") == -1 && dirName.equals("Tags")) {
                RandomAccessStream s = this.poi.getDocumentStream(name);
                s.order(true);
                int imageNum2 = this.getImageNumber(name, -1);
                this.tagsToParse.put(new Integer(imageNum2), s);
                if (imageNum2 != -1) continue;
                this.parseTags(imageNum2, s, new DummyMetadata());
                continue;
            }
            if (!dirName.equals("Image") && dirName.toUpperCase().indexOf("ITEM") == -1 || (imageNum = this.getImageNumber(dirName, this.getImageCount() == 1 ? 0 : -1)) == -1) continue;
            RandomAccessStream s = this.poi.getDocumentStream(name);
            s.order(true);
            if (s.length() <= 1024L) {
                s.close();
                continue;
            }
            for (int q = 0; q < 11; ++q) {
                this.getNextTag(s);
            }
            s.skipBytes(2);
            int len = s.readInt() - 20;
            s.skipBytes(8);
            int zidx = s.readInt();
            int cidx = s.readInt();
            int tidx = s.readInt();
            Integer z = new Integer(zidx);
            Integer t = new Integer(tidx);
            Integer c = new Integer(cidx);
            if (!zIndices.contains(z)) {
                zIndices.add(z);
            }
            if (!tIndices.contains(t)) {
                tIndices.add(t);
            }
            if (!cIndices.contains(c)) {
                cIndices.add(c);
            }
            s.skipBytes(len);
            for (int q = 0; q < 5; ++q) {
                this.getNextTag(s);
            }
            s.skipBytes(4);
            this.core[0].sizeX = s.readInt();
            this.core[0].sizeY = s.readInt();
            s.skipBytes(4);
            this.bpp = s.readInt();
            s.skipBytes(4);
            int valid = s.readInt();
            this.isJPEG = valid == 0 || valid == 1;
            this.offsets[imageNum] = (int)s.getFilePointer();
            this.coordinates[imageNum][0] = zidx;
            this.coordinates[imageNum][1] = cidx;
            this.coordinates[imageNum][2] = tidx;
            this.imageFiles[imageNum] = name;
            s.close();
        }
        this.status("Populating metadata");
        this.core[0].sizeZ = zIndices.size();
        this.core[0].sizeT = tIndices.size();
        this.core[0].sizeC = cIndices.size();
        this.core[0].littleEndian = true;
        this.core[0].interleaved = !this.isJPEG;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        boolean bl = this.core[0].rgb = this.bpp % 3 == 0;
        if (this.isRGB()) {
            this.core[0].sizeC *= 3;
        }
        int totalTiles = this.offsets.length / this.getImageCount();
        this.tileRows = this.realHeight / this.getSizeY() + 1;
        this.tileColumns = this.realWidth / this.getSizeX() + 1;
        if (totalTiles <= 1) {
            this.tileRows = 1;
            this.tileColumns = 1;
            totalTiles = 1;
            this.isTiled = false;
        }
        if (this.tileRows == 0) {
            this.tileRows = 1;
        }
        if (this.tileColumns == 0) {
            this.tileColumns = 1;
        }
        if (this.tileColumns == 1 && this.tileRows == 1) {
            this.isTiled = false;
        } else {
            this.tileWidth = this.getSizeX();
            this.tileHeight = this.getSizeY();
            this.core[0].sizeX = this.tileWidth * this.tileColumns;
            this.core[0].sizeY = this.tileHeight * this.tileRows;
        }
        this.core[0].dimensionOrder = "XY";
        for (int i4 = 0; i4 < this.coordinates.length - 1; ++i4) {
            int[] zct1 = this.coordinates[i4];
            int[] zct2 = this.coordinates[i4 + 1];
            int deltaZ = zct2[0] - zct1[0];
            int deltaC = zct2[1] - zct1[1];
            int deltaT = zct2[2] - zct1[2];
            if (deltaZ > 0 && this.getDimensionOrder().indexOf("Z") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
            }
            if (deltaC > 0 && this.getDimensionOrder().indexOf("C") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
            }
            if (deltaT <= 0 || this.getDimensionOrder().indexOf("T") != -1) continue;
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        MetadataTools.populatePixels(store, this, true);
        store.setImageName("", 0);
        if (this.bpp == 1 || this.bpp == 3) {
            this.core[0].pixelType = 1;
        } else if (this.bpp == 2 || this.bpp == 6) {
            this.core[0].pixelType = 3;
        }
        long firstStamp = 0L;
        if (this.timestamps.size() > 0) {
            String timestamp = (String)this.timestamps.get(new Integer(0));
            firstStamp = this.parseTimestamp(timestamp);
            store.setImageCreationDate(DataTools.convertDate(firstStamp / 1600L, 3), 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), 0);
        }
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        for (int plane = 0; plane < this.getImageCount(); ++plane) {
            int[] zct = this.getZCTCoords(plane);
            String exposure = (String)this.exposureTime.get(new Integer(zct[1]));
            Float exp = new Float(0.0);
            try {
                exp = new Float(exposure);
            }
            catch (NumberFormatException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            store.setPlaneTimingExposureTime(exp, 0, 0, plane);
            if (plane >= this.timestamps.size()) continue;
            String timestamp = (String)this.timestamps.get(new Integer(plane));
            long stamp = this.parseTimestamp(timestamp);
            store.setPlaneTimingDeltaT(new Float((stamp -= firstStamp) / 1600000L), 0, 0, plane);
        }
        Integer[] keys = this.tagsToParse.keySet().toArray(new Integer[0]);
        for (i = 0; i < keys.length; ++i) {
            RandomAccessStream s = (RandomAccessStream)this.tagsToParse.get(keys[i]);
            this.parseTags(keys[i], s, store);
            s.close();
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            store.setDetectorID("Detector:" + i, 0, i);
            store.setDetectorSettingsDetector("Detector:" + i, 0, i);
        }
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
    }

    private int getImageNumber(String dirName, int defaultNumber) {
        if (dirName.toUpperCase().indexOf("ITEM") != -1) {
            int open = dirName.indexOf("(");
            int close = dirName.indexOf(")");
            if (open < 0 || close < 0 || close < open) {
                return defaultNumber;
            }
            return Integer.parseInt(dirName.substring(open + 1, close));
        }
        return defaultNumber;
    }

    private String getNextTag(RandomAccessStream s) throws IOException {
        short type = s.readShort();
        switch (type) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: {
                return String.valueOf(s.readShort());
            }
            case 3: 
            case 22: 
            case 23: {
                return String.valueOf(s.readInt());
            }
            case 4: {
                return String.valueOf(s.readFloat());
            }
            case 5: {
                return String.valueOf(s.readDouble());
            }
            case 7: 
            case 20: 
            case 21: {
                return String.valueOf(s.readLong());
            }
            case 8: 
            case 69: {
                int len = s.readInt();
                return s.readString(len);
            }
            case 9: 
            case 13: {
                s.skipBytes(16);
                return "";
            }
            case 63: 
            case 65: {
                int len = s.readInt();
                s.skipBytes(len);
                return "";
            }
            case 66: {
                short len = s.readShort();
                return s.readString(len);
            }
        }
        long old = s.getFilePointer();
        while (s.readShort() != 3 && s.getFilePointer() + 2L < s.length()) {
        }
        long fp = s.getFilePointer() - 2L;
        s.seek(old - 2L);
        return s.readString((int)(fp - old + 2L));
    }

    private void parseTags(int image, RandomAccessStream s, MetadataStore store) throws IOException {
        s.seek(8L);
        int count = s.readInt();
        float pixelSizeX = 0.0f;
        float pixelSizeY = 0.0f;
        float pixelSizeZ = 0.0f;
        for (int i = 0; i < count && s.getFilePointer() + 2L < s.length(); ++i) {
            String value = DataTools.stripString(this.getNextTag(s));
            s.skipBytes(2);
            int tagID = s.readInt();
            s.skipBytes(6);
            try {
                int q;
                String key = this.getKey(tagID);
                if (key.equals("Image Channel Index")) {
                    this.cIndex = Integer.parseInt(value);
                } else if (key.equals("ImageWidth")) {
                    int v = Integer.parseInt(value);
                    if (this.getSizeX() == 0) {
                        this.core[0].sizeX = v;
                    }
                    if (this.realWidth == 0 && v > this.realWidth) {
                        this.realWidth = v;
                    }
                } else if (key.equals("ImageHeight")) {
                    int v = Integer.parseInt(value);
                    if (this.getSizeY() == 0) {
                        this.core[0].sizeY = v;
                    }
                    if (this.realHeight == 0 || v > this.realHeight) {
                        this.realHeight = v;
                    }
                }
                if (this.cIndex != -1) {
                    key = key + " " + this.cIndex;
                }
                this.addMeta(key, value);
                if (key.equals("ImageTile Index") || key.equals("ImageTile Index 0")) {
                    this.firstImageTile = value;
                    continue;
                }
                if (key.equals("ImageTile Index 1")) {
                    this.secondImageTile = value;
                    continue;
                }
                if (key.equals("Scale Factor for X")) {
                    pixelSizeX = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("Scale Factor for Y")) {
                    pixelSizeY = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("Scale Factor for Z")) {
                    pixelSizeZ = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("Scale Unit for X")) {
                    store.setDimensionsPhysicalSizeX(new Float(pixelSizeX), 0, 0);
                    continue;
                }
                if (key.equals("Scale Unit for Y")) {
                    store.setDimensionsPhysicalSizeY(new Float(pixelSizeY), 0, 0);
                    continue;
                }
                if (key.equals("Scale Unit for Z")) {
                    store.setDimensionsPhysicalSizeZ(new Float(pixelSizeZ), 0, 0);
                    continue;
                }
                if (key.startsWith("Emission Wavelength")) {
                    if (this.cIndex == -1) continue;
                    store.setLogicalChannelEmWave(new Integer(value), 0, this.cIndex);
                    continue;
                }
                if (key.startsWith("Excitation Wavelength")) {
                    if (this.cIndex == -1) continue;
                    store.setLogicalChannelExWave(new Integer(value), 0, this.cIndex);
                    continue;
                }
                if (key.startsWith("Channel Name")) {
                    if (this.cIndex == -1) continue;
                    store.setLogicalChannelName(value, 0, this.cIndex);
                    continue;
                }
                if (key.startsWith("BlackValue")) {
                    if (this.cIndex == -1) continue;
                    continue;
                }
                if (key.startsWith("WhiteValue")) {
                    if (this.cIndex == -1) continue;
                    continue;
                }
                if (key.startsWith("GammaValue")) {
                    if (this.cIndex == -1) continue;
                    continue;
                }
                if (key.startsWith("Exposure Time [ms]")) {
                    if (this.cIndex == -1) continue;
                    this.exposureTime.put(new Integer(this.cIndex), value);
                    continue;
                }
                if (key.startsWith("User Name")) {
                    String[] username = value.split(" ");
                    if (username.length < 2) continue;
                    store.setExperimenterFirstName(username[0], 0);
                    store.setExperimenterLastName(username[username.length - 1], 0);
                    continue;
                }
                if (key.equals("User company")) {
                    store.setExperimenterInstitution(value, 0);
                    continue;
                }
                if (key.startsWith("Objective Magnification")) {
                    store.setObjectiveNominalMagnification(new Integer(value), 0, 0);
                    continue;
                }
                if (key.startsWith("Objective ID")) {
                    store.setObjectiveID(value, 0, 0);
                    continue;
                }
                if (key.startsWith("Objective N.A.")) {
                    store.setObjectiveLensNA(new Float(value), 0, 0);
                    continue;
                }
                if (key.startsWith("Objective Name")) {
                    store.setObjectiveModel(value, 0, 0);
                    continue;
                }
                if (key.startsWith("Objective Working Distance")) {
                    store.setObjectiveWorkingDistance(new Float(value), 0, 0);
                    continue;
                }
                if (key.startsWith("Objective Immersion Type")) {
                    String immersion = null;
                    switch (Integer.parseInt(value)) {
                        case 2: {
                            immersion = "oil";
                            break;
                        }
                        case 3: {
                            immersion = "water";
                        }
                    }
                    if (immersion == null) continue;
                    store.setObjectiveImmersion(immersion, 0, 0);
                    continue;
                }
                if (key.startsWith("Parfocal Correction")) {
                    store.setObjectiveCorrection(value, 0, 0);
                    continue;
                }
                if (key.indexOf("Stage Position X") != -1) {
                    for (q = 0; q < this.getImageCount(); ++q) {
                        store.setStagePositionPositionX(new Float(value), 0, 0, q);
                    }
                    continue;
                }
                if (key.indexOf("Stage Position Y") != -1) {
                    for (q = 0; q < this.getImageCount(); ++q) {
                        store.setStagePositionPositionY(new Float(value), 0, 0, q);
                    }
                    continue;
                }
                if (key.startsWith("Orca Analog Gain")) {
                    store.setDetectorSettingsGain(new Float(value), 0, this.cIndex);
                    continue;
                }
                if (key.startsWith("Orca Analog Offset")) {
                    store.setDetectorSettingsOffset(new Float(value), 0, this.cIndex);
                    continue;
                }
                if (key.startsWith("Comments")) {
                    store.setImageDescription(value, 0);
                    continue;
                }
                if (!key.startsWith("Acquisition Date") || image < 0) continue;
                this.timestamps.put(new Integer(image), value);
                this.addMeta("Timestamp " + image, value);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private float getScaleUnit(String value) {
        int v = Integer.parseInt(value);
        switch (v) {
            case 72: {
                return 1000000.0f;
            }
            case 77: {
                return 0.001f;
            }
            case 81: {
                return 25400.0f;
            }
        }
        return 1.0f;
    }

    private String getKey(int tagID) {
        switch (tagID) {
            case 222: {
                return "Compression";
            }
            case 258: {
                return "BlackValue";
            }
            case 259: {
                return "WhiteValue";
            }
            case 260: {
                return "ImageDataMappingAutoRange";
            }
            case 261: {
                return "Thumbnail";
            }
            case 262: {
                return "GammaValue";
            }
            case 264: {
                return "ImageOverExposure";
            }
            case 265: {
                return "ImageRelativeTime1";
            }
            case 266: {
                return "ImageRelativeTime2";
            }
            case 267: {
                return "ImageRelativeTime3";
            }
            case 268: {
                return "ImageRelativeTime4";
            }
            case 333: {
                return "RelFocusPosition1";
            }
            case 334: {
                return "RelFocusPosition2";
            }
            case 513: {
                return "ObjectType";
            }
            case 515: {
                return "ImageWidth";
            }
            case 516: {
                return "ImageHeight";
            }
            case 517: {
                return "Number Raw Count";
            }
            case 518: {
                return "PixelType";
            }
            case 519: {
                return "NumberOfRawImages";
            }
            case 520: {
                return "ImageSize";
            }
            case 523: {
                return "Acquisition pause annotation";
            }
            case 530: {
                return "Document Subtype";
            }
            case 531: {
                return "Acquisition Bit Depth";
            }
            case 532: {
                return "Image Memory Usage (RAM)";
            }
            case 534: {
                return "Z-Stack single representative";
            }
            case 769: {
                return "Scale Factor for X";
            }
            case 770: {
                return "Scale Unit for X";
            }
            case 771: {
                return "Scale Width";
            }
            case 772: {
                return "Scale Factor for Y";
            }
            case 773: {
                return "Scale Unit for Y";
            }
            case 774: {
                return "Scale Height";
            }
            case 775: {
                return "Scale Factor for Z";
            }
            case 776: {
                return "Scale Unit for Z";
            }
            case 777: {
                return "Scale Depth";
            }
            case 778: {
                return "Scaling Parent";
            }
            case 1001: {
                return "Date";
            }
            case 1002: {
                return "code";
            }
            case 1003: {
                return "Source";
            }
            case 1004: {
                return "Message";
            }
            case 1025: {
                return "Acquisition Date";
            }
            case 1026: {
                return "8-bit acquisition";
            }
            case 1027: {
                return "Camera Bit Depth";
            }
            case 1029: {
                return "MonoReferenceLow";
            }
            case 1030: {
                return "MonoReferenceHigh";
            }
            case 1031: {
                return "RedReferenceLow";
            }
            case 1032: {
                return "RedReferenceHigh";
            }
            case 1033: {
                return "GreenReferenceLow";
            }
            case 1034: {
                return "GreenReferenceHigh";
            }
            case 1035: {
                return "BlueReferenceLow";
            }
            case 1036: {
                return "BlueReferenceHigh";
            }
            case 1041: {
                return "FrameGrabber Name";
            }
            case 1042: {
                return "Camera";
            }
            case 1044: {
                return "CameraTriggerSignalType";
            }
            case 1045: {
                return "CameraTriggerEnable";
            }
            case 1046: {
                return "GrabberTimeout";
            }
            case 1281: {
                return "MultiChannelEnabled";
            }
            case 1282: {
                return "MultiChannel Color";
            }
            case 1283: {
                return "MultiChannel Weight";
            }
            case 1284: {
                return "Channel Name";
            }
            case 1536: {
                return "DocumentInformationGroup";
            }
            case 1537: {
                return "Title";
            }
            case 1538: {
                return "Author";
            }
            case 1539: {
                return "Keywords";
            }
            case 1540: {
                return "Comments";
            }
            case 1541: {
                return "SampleID";
            }
            case 1542: {
                return "Subject";
            }
            case 1543: {
                return "RevisionNumber";
            }
            case 1544: {
                return "Save Folder";
            }
            case 1545: {
                return "FileLink";
            }
            case 1546: {
                return "Document Type";
            }
            case 1547: {
                return "Storage Media";
            }
            case 1548: {
                return "File ID";
            }
            case 1549: {
                return "Reference";
            }
            case 1550: {
                return "File Date";
            }
            case 1551: {
                return "File Size";
            }
            case 1553: {
                return "Filename";
            }
            case 1792: {
                return "ProjectGroup";
            }
            case 1793: {
                return "Acquisition Date";
            }
            case 1794: {
                return "Last modified by";
            }
            case 1795: {
                return "User company";
            }
            case 1796: {
                return "User company logo";
            }
            case 1797: {
                return "Image";
            }
            case 1800: {
                return "User ID";
            }
            case 1801: {
                return "User Name";
            }
            case 1802: {
                return "User City";
            }
            case 1803: {
                return "User Address";
            }
            case 1804: {
                return "User Country";
            }
            case 1805: {
                return "User Phone";
            }
            case 1806: {
                return "User Fax";
            }
            case 2049: {
                return "Objective Name";
            }
            case 2050: {
                return "Optovar";
            }
            case 2051: {
                return "Reflector";
            }
            case 2052: {
                return "Condenser Contrast";
            }
            case 2053: {
                return "Transmitted Light Filter 1";
            }
            case 2054: {
                return "Transmitted Light Filter 2";
            }
            case 2055: {
                return "Reflected Light Shutter";
            }
            case 2056: {
                return "Condenser Front Lens";
            }
            case 2057: {
                return "Excitation Filter Name";
            }
            case 2060: {
                return "Transmitted Light Fieldstop Aperture";
            }
            case 2061: {
                return "Reflected Light Aperture";
            }
            case 2062: {
                return "Condenser N.A.";
            }
            case 2063: {
                return "Light Path";
            }
            case 2064: {
                return "HalogenLampOn";
            }
            case 2065: {
                return "Halogen Lamp Mode";
            }
            case 2066: {
                return "Halogen Lamp Voltage";
            }
            case 2068: {
                return "Fluorescence Lamp Level";
            }
            case 2069: {
                return "Fluorescence Lamp Intensity";
            }
            case 2070: {
                return "LightManagerEnabled";
            }
            case 2071: {
                return "tag_ID_2071";
            }
            case 2072: {
                return "Focus Position";
            }
            case 2073: {
                return "Stage Position X";
            }
            case 2074: {
                return "Stage Position Y";
            }
            case 2075: {
                return "Microscope Name";
            }
            case 2076: {
                return "Objective Magnification";
            }
            case 2077: {
                return "Objective N.A.";
            }
            case 2078: {
                return "MicroscopeIllumination";
            }
            case 2079: {
                return "External Shutter 1";
            }
            case 2080: {
                return "External Shutter 2";
            }
            case 2081: {
                return "External Shutter 3";
            }
            case 2082: {
                return "External Filter Wheel 1 Name";
            }
            case 2083: {
                return "External Filter Wheel 2 Name";
            }
            case 2084: {
                return "Parfocal Correction";
            }
            case 2086: {
                return "External Shutter 4";
            }
            case 2087: {
                return "External Shutter 5";
            }
            case 2088: {
                return "External Shutter 6";
            }
            case 2089: {
                return "External Filter Wheel 3 Name";
            }
            case 2090: {
                return "External Filter Wheel 4 Name";
            }
            case 2103: {
                return "Objective Turret Position";
            }
            case 2104: {
                return "Objective Contrast Method";
            }
            case 2105: {
                return "Objective Immersion Type";
            }
            case 2107: {
                return "Reflector Position";
            }
            case 2109: {
                return "Transmitted Light Filter 1 Position";
            }
            case 2110: {
                return "Transmitted Light Filter 2 Position";
            }
            case 2112: {
                return "Excitation Filter Position";
            }
            case 2113: {
                return "Lamp Mirror Position";
            }
            case 2114: {
                return "External Filter Wheel 1 Position";
            }
            case 2115: {
                return "External Filter Wheel 2 Position";
            }
            case 2116: {
                return "External Filter Wheel 3 Position";
            }
            case 2117: {
                return "External Filter Wheel 4 Position";
            }
            case 2118: {
                return "Lightmanager Mode";
            }
            case 2119: {
                return "Halogen Lamp Calibration";
            }
            case 2120: {
                return "CondenserNAGoSpeed";
            }
            case 2121: {
                return "TransmittedLightFieldstopGoSpeed";
            }
            case 2122: {
                return "OptovarGoSpeed";
            }
            case 2123: {
                return "Focus calibrated";
            }
            case 2124: {
                return "FocusBasicPosition";
            }
            case 2125: {
                return "FocusPower";
            }
            case 2126: {
                return "FocusBacklash";
            }
            case 2127: {
                return "FocusMeasurementOrigin";
            }
            case 2128: {
                return "FocusMeasurementDistance";
            }
            case 2129: {
                return "FocusSpeed";
            }
            case 2130: {
                return "FocusGoSpeed";
            }
            case 2131: {
                return "FocusDistance";
            }
            case 2132: {
                return "FocusInitPosition";
            }
            case 2133: {
                return "Stage calibrated";
            }
            case 2134: {
                return "StagePower";
            }
            case 2135: {
                return "StageXBacklash";
            }
            case 2136: {
                return "StageYBacklash";
            }
            case 2137: {
                return "StageSpeedX";
            }
            case 2138: {
                return "StageSpeedY";
            }
            case 2139: {
                return "StageSpeed";
            }
            case 2140: {
                return "StageGoSpeedX";
            }
            case 2141: {
                return "StageGoSpeedY";
            }
            case 2142: {
                return "StageStepDistanceX";
            }
            case 2143: {
                return "StageStepDistanceY";
            }
            case 2144: {
                return "StageInitialisationPositionX";
            }
            case 2145: {
                return "StageInitialisationPositionY";
            }
            case 2146: {
                return "MicroscopeMagnification";
            }
            case 2147: {
                return "ReflectorMagnification";
            }
            case 2148: {
                return "LampMirrorPosition";
            }
            case 2149: {
                return "FocusDepth";
            }
            case 2150: {
                return "MicroscopeType";
            }
            case 2151: {
                return "Objective Working Distance";
            }
            case 2152: {
                return "ReflectedLightApertureGoSpeed";
            }
            case 2153: {
                return "External Shutter";
            }
            case 2154: {
                return "ObjectiveImmersionStop";
            }
            case 2155: {
                return "Focus Start Speed";
            }
            case 2156: {
                return "Focus Acceleration";
            }
            case 2157: {
                return "ReflectedLightFieldstop";
            }
            case 2158: {
                return "ReflectedLightFieldstopGoSpeed";
            }
            case 2159: {
                return "ReflectedLightFilter 1";
            }
            case 2160: {
                return "ReflectedLightFilter 2";
            }
            case 2161: {
                return "ReflectedLightFilter1Position";
            }
            case 2162: {
                return "ReflectedLightFilter2Position";
            }
            case 2163: {
                return "TransmittedLightAttenuator";
            }
            case 2164: {
                return "ReflectedLightAttenuator";
            }
            case 2165: {
                return "Transmitted Light Shutter";
            }
            case 2166: {
                return "TransmittedLightAttenuatorGoSpeed";
            }
            case 2167: {
                return "ReflectedLightAttenuatorGoSpeed";
            }
            case 2176: {
                return "TransmittedLightVirtualFilterPosition";
            }
            case 2177: {
                return "TransmittedLightVirtualFilter";
            }
            case 2178: {
                return "ReflectedLightVirtualFilterPosition";
            }
            case 2179: {
                return "ReflectedLightVirtualFilter";
            }
            case 2180: {
                return "ReflectedLightHalogenLampMode";
            }
            case 2181: {
                return "ReflectedLightHalogenLampVoltage";
            }
            case 2182: {
                return "ReflectedLightHalogenLampColorTemperature";
            }
            case 2183: {
                return "ContrastManagerMode";
            }
            case 2184: {
                return "Dazzle Protection Active";
            }
            case 2195: {
                return "Zoom";
            }
            case 2196: {
                return "ZoomGoSpeed";
            }
            case 2197: {
                return "LightZoom";
            }
            case 2198: {
                return "LightZoomGoSpeed";
            }
            case 2199: {
                return "LightZoomCoupled";
            }
            case 2200: {
                return "TransmittedLightHalogenLampMode";
            }
            case 2201: {
                return "TransmittedLightHalogenLampVoltage";
            }
            case 2202: {
                return "TransmittedLightHalogenLampColorTemperature";
            }
            case 2203: {
                return "Reflected Coldlight Mode";
            }
            case 2204: {
                return "Reflected Coldlight Intensity";
            }
            case 2205: {
                return "Reflected Coldlight Color Temperature";
            }
            case 2206: {
                return "Transmitted Coldlight Mode";
            }
            case 2207: {
                return "Transmitted Coldlight Intensity";
            }
            case 2208: {
                return "Transmitted Coldlight Color Temperature";
            }
            case 2209: {
                return "Infinityspace Portchanger Position";
            }
            case 2210: {
                return "Beamsplitter Infinity Space";
            }
            case 2211: {
                return "TwoTv VisCamChanger Position";
            }
            case 2212: {
                return "Beamsplitter Ocular";
            }
            case 2213: {
                return "TwoTv CamerasChanger Position";
            }
            case 2214: {
                return "Beamsplitter Cameras";
            }
            case 2215: {
                return "Ocular Shutter";
            }
            case 2216: {
                return "TwoTv CamerasChangerCube";
            }
            case 2218: {
                return "Ocular Magnification";
            }
            case 2219: {
                return "Camera Adapter Magnification";
            }
            case 2220: {
                return "Microscope Port";
            }
            case 2221: {
                return "Ocular Total Magnification";
            }
            case 2222: {
                return "Field of View";
            }
            case 2223: {
                return "Ocular";
            }
            case 2224: {
                return "CameraAdapter";
            }
            case 2225: {
                return "StageJoystickEnabled";
            }
            case 2226: {
                return "ContrastManager Contrast Method";
            }
            case 2229: {
                return "CamerasChanger Beamsplitter Type";
            }
            case 2235: {
                return "Rearport Slider Position";
            }
            case 2236: {
                return "Rearport Source";
            }
            case 2237: {
                return "Beamsplitter Type Infinity Space";
            }
            case 2238: {
                return "Fluorescence Attenuator";
            }
            case 2239: {
                return "Fluorescence Attenuator Position";
            }
            case 2261: {
                return "Objective ID";
            }
            case 2262: {
                return "Reflector ID";
            }
            case 2307: {
                return "Camera Framestart Left";
            }
            case 2308: {
                return "Camera Framestart Top";
            }
            case 2309: {
                return "Camera Frame Width";
            }
            case 2310: {
                return "Camera Frame Height";
            }
            case 2311: {
                return "Camera Binning";
            }
            case 2312: {
                return "CameraFrameFull";
            }
            case 2313: {
                return "CameraFramePixelDistance";
            }
            case 2318: {
                return "DataFormatUseScaling";
            }
            case 2319: {
                return "CameraFrameImageOrientation";
            }
            case 2320: {
                return "VideoMonochromeSignalType";
            }
            case 2321: {
                return "VideoColorSignalType";
            }
            case 2322: {
                return "MeteorChannelInput";
            }
            case 2323: {
                return "MeteorChannelSync";
            }
            case 2324: {
                return "WhiteBalanceEnabled";
            }
            case 2325: {
                return "CameraWhiteBalanceRed";
            }
            case 2326: {
                return "CameraWhiteBalanceGreen";
            }
            case 2327: {
                return "CameraWhiteBalanceBlue";
            }
            case 2331: {
                return "CameraFrameScalingFactor";
            }
            case 2562: {
                return "Meteor Camera Type";
            }
            case 2564: {
                return "Exposure Time [ms]";
            }
            case 2568: {
                return "CameraExposureTimeAutoCalculate";
            }
            case 2569: {
                return "Meteor Gain Value";
            }
            case 2571: {
                return "Meteor Gain Automatic";
            }
            case 2572: {
                return "MeteorAdjustHue";
            }
            case 2573: {
                return "MeteorAdjustSaturation";
            }
            case 2574: {
                return "MeteorAdjustRedLow";
            }
            case 2575: {
                return "MeteorAdjustGreenLow";
            }
            case 2576: {
                return "Meteor Blue Low";
            }
            case 2577: {
                return "MeteorAdjustRedHigh";
            }
            case 2578: {
                return "MeteorAdjustGreenHigh";
            }
            case 2579: {
                return "MeteorBlue High";
            }
            case 2582: {
                return "CameraExposureTimeCalculationControl";
            }
            case 2585: {
                return "AxioCamFadingCorrectionEnable";
            }
            case 2587: {
                return "CameraLiveImage";
            }
            case 2588: {
                return "CameraLiveEnabled";
            }
            case 2589: {
                return "LiveImageSyncObjectName";
            }
            case 2590: {
                return "CameraLiveSpeed";
            }
            case 2591: {
                return "CameraImage";
            }
            case 2592: {
                return "CameraImageWidth";
            }
            case 2593: {
                return "CameraImageHeight";
            }
            case 2594: {
                return "CameraImagePixelType";
            }
            case 2595: {
                return "CameraImageShMemoryName";
            }
            case 2596: {
                return "CameraLiveImageWidth";
            }
            case 2597: {
                return "CameraLiveImageHeight";
            }
            case 2598: {
                return "CameraLiveImagePixelType";
            }
            case 2599: {
                return "CameraLiveImageShMemoryName";
            }
            case 2600: {
                return "CameraLiveMaximumSpeed";
            }
            case 2601: {
                return "CameraLiveBinning";
            }
            case 2602: {
                return "CameraLiveGainValue";
            }
            case 2603: {
                return "CameraLiveExposureTimeValue";
            }
            case 2604: {
                return "CameraLiveScalingFactor";
            }
            case 2819: {
                return "Image Index Z";
            }
            case 2820: {
                return "Image Channel Index";
            }
            case 2821: {
                return "Image Index T";
            }
            case 2822: {
                return "ImageTile Index";
            }
            case 2823: {
                return "Image acquisition Index";
            }
            case 2827: {
                return "Image IndexS";
            }
            case 2841: {
                return "Original Stage Position X";
            }
            case 2842: {
                return "Original Stage Position Y";
            }
            case 3088: {
                return "LayerDrawFlags";
            }
            case 3334: {
                return "RemainingTime";
            }
            case 3585: {
                return "User Field 1";
            }
            case 3586: {
                return "User Field 2";
            }
            case 3587: {
                return "User Field 3";
            }
            case 3588: {
                return "User Field 4";
            }
            case 3589: {
                return "User Field 5";
            }
            case 3590: {
                return "User Field 6";
            }
            case 3591: {
                return "User Field 7";
            }
            case 3592: {
                return "User Field 8";
            }
            case 3593: {
                return "User Field 9";
            }
            case 3594: {
                return "User Field 10";
            }
            case 3840: {
                return "ID";
            }
            case 3841: {
                return "Name";
            }
            case 3842: {
                return "Value";
            }
            case 5501: {
                return "PvCamClockingMode";
            }
            case 8193: {
                return "Autofocus Status Report";
            }
            case 8194: {
                return "Autofocus Position";
            }
            case 8195: {
                return "Autofocus Position Offset";
            }
            case 8196: {
                return "Autofocus Empty Field Threshold";
            }
            case 8197: {
                return "Autofocus Calibration Name";
            }
            case 8198: {
                return "Autofocus Current Calibration Item";
            }
            case 20478: {
                return "tag_ID_20478";
            }
            case 65537: {
                return "CameraFrameFullWidth";
            }
            case 65538: {
                return "CameraFrameFullHeight";
            }
            case 65541: {
                return "AxioCam Shutter Signal";
            }
            case 65542: {
                return "AxioCam Delay Time";
            }
            case 65543: {
                return "AxioCam Shutter Control";
            }
            case 65544: {
                return "AxioCam BlackRefIsCalculated";
            }
            case 65545: {
                return "AxioCam Black Reference";
            }
            case 65547: {
                return "Camera Shading Correction";
            }
            case 65550: {
                return "AxioCam Enhance Color";
            }
            case 65551: {
                return "AxioCam NIR Mode";
            }
            case 65552: {
                return "CameraShutterCloseDelay";
            }
            case 65553: {
                return "CameraWhiteBalanceAutoCalculate";
            }
            case 65556: {
                return "AxioCam NIR Mode Available";
            }
            case 65557: {
                return "AxioCam Fading Correction Available";
            }
            case 65559: {
                return "AxioCam Enhance Color Available";
            }
            case 65565: {
                return "MeteorVideoNorm";
            }
            case 65566: {
                return "MeteorAdjustWhiteReference";
            }
            case 65567: {
                return "MeteorBlackReference";
            }
            case 65568: {
                return "MeteorChannelInputCountMono";
            }
            case 65570: {
                return "MeteorChannelInputCountRGB";
            }
            case 65571: {
                return "MeteorEnableVCR";
            }
            case 65572: {
                return "Meteor Brightness";
            }
            case 65573: {
                return "Meteor Contrast";
            }
            case 65575: {
                return "AxioCam Selector";
            }
            case 65576: {
                return "AxioCam Type";
            }
            case 65577: {
                return "AxioCam Info";
            }
            case 65580: {
                return "AxioCam Resolution";
            }
            case 65581: {
                return "AxioCam Color Model";
            }
            case 65582: {
                return "AxioCam MicroScanning";
            }
            case 65585: {
                return "Amplification Index";
            }
            case 65586: {
                return "Device Command";
            }
            case 65587: {
                return "BeamLocation";
            }
            case 65588: {
                return "ComponentType";
            }
            case 65589: {
                return "ControllerType";
            }
            case 65590: {
                return "CameraWhiteBalanceCalculationRedPaint";
            }
            case 65591: {
                return "CameraWhiteBalanceCalculationBluePaint";
            }
            case 65592: {
                return "CameraWhiteBalanceSetRed";
            }
            case 65593: {
                return "CameraWhiteBalanceSetGreen";
            }
            case 65594: {
                return "CameraWhiteBalanceSetBlue";
            }
            case 65595: {
                return "CameraWhiteBalanceSetTargetRed";
            }
            case 65596: {
                return "CameraWhiteBalanceSetTargetGreen";
            }
            case 65597: {
                return "CameraWhiteBalanceSetTargetBlue";
            }
            case 65598: {
                return "ApotomeCamCalibrationMode";
            }
            case 65599: {
                return "ApoTome Grid Position";
            }
            case 65600: {
                return "ApotomeCamScannerPosition";
            }
            case 65601: {
                return "ApoTome Full Phase Shift";
            }
            case 65602: {
                return "ApoTome Grid Name";
            }
            case 65603: {
                return "ApoTome Staining";
            }
            case 65604: {
                return "ApoTome Processing Mode";
            }
            case 65605: {
                return "ApotomeCamLiveCombineMode";
            }
            case 65606: {
                return "ApoTome Filter Name";
            }
            case 65607: {
                return "Apotome Filter Strength";
            }
            case 65608: {
                return "ApotomeCamFilterHarmonics";
            }
            case 65609: {
                return "ApoTome Grating Period";
            }
            case 65610: {
                return "ApoTome Auto Shutter Used";
            }
            case 65611: {
                return "Apotome Cam Status";
            }
            case 65612: {
                return "ApotomeCamNormalize";
            }
            case 65613: {
                return "ApotomeCamSettingsManager";
            }
            case 65614: {
                return "DeepviewCamSupervisorMode";
            }
            case 65615: {
                return "DeepView Processing";
            }
            case 65616: {
                return "DeepviewCamFilterName";
            }
            case 65617: {
                return "DeepviewCamStatus";
            }
            case 65618: {
                return "DeepviewCamSettingsManager";
            }
            case 65619: {
                return "DeviceScalingName";
            }
            case 65620: {
                return "CameraShadingIsCalculated";
            }
            case 65621: {
                return "CameraShadingCalculationName";
            }
            case 65622: {
                return "CameraShadingAutoCalculate";
            }
            case 65623: {
                return "CameraTriggerAvailable";
            }
            case 65626: {
                return "CameraShutterAvailable";
            }
            case 65627: {
                return "AxioCam ShutterMicroScanningEnable";
            }
            case 65628: {
                return "ApotomeCamLiveFocus";
            }
            case 65629: {
                return "DeviceInitStatus";
            }
            case 65630: {
                return "DeviceErrorStatus";
            }
            case 65631: {
                return "ApotomeCamSliderInGridPosition";
            }
            case 65632: {
                return "Orca NIR Mode Used";
            }
            case 65633: {
                return "Orca Analog Gain";
            }
            case 65634: {
                return "Orca Analog Offset";
            }
            case 65635: {
                return "Orca Binning";
            }
            case 65636: {
                return "Orca Bit Depth";
            }
            case 65637: {
                return "ApoTome Averaging Count";
            }
            case 65638: {
                return "DeepView DoF";
            }
            case 65639: {
                return "DeepView EDoF";
            }
            case 65643: {
                return "DeepView Slider Name";
            }
            case 65655: {
                return "DeepView Slider Name";
            }
            case 0x530003: {
                return "Acquisition Sofware";
            }
            case 0x1000110: {
                return "Excitation Wavelength";
            }
            case 0x1000111: {
                return "Emission Wavelength";
            }
            case 101515267: {
                return "File Name";
            }
            case 101253123: 
            case 101777411: {
                return "Image Name";
            }
        }
        return "" + tagID;
    }

    private long parseTimestamp(String s) {
        long stamp = 0L;
        try {
            stamp = Long.parseLong(s);
        }
        catch (NumberFormatException exc) {
            SimpleDateFormat sdf = new SimpleDateFormat("M/d/y h:mm:ss aa");
            stamp = sdf.parse(s, new ParsePosition(0)).getTime();
        }
        return stamp;
    }
}

