/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import loci.common.DataTools;
import loci.formats.meta.MetadataStore;

public class FilterMetadata
implements MetadataStore {
    private MetadataStore store;
    private boolean filter;

    public FilterMetadata(MetadataStore store, boolean filter) {
        this.store = store;
        this.filter = filter;
    }

    public void createRoot() {
        this.store.createRoot();
    }

    public Object getRoot() {
        return this.store.getRoot();
    }

    public void setRoot(Object root) {
        this.store.setRoot(root);
    }

    public void setUUID(String uuid) {
        this.store.setUUID(uuid);
    }

    public void setArcType(String type, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(type) : type;
        this.store.setArcType(value, instrumentIndex, lightSourceIndex);
    }

    public void setChannelComponentColorDomain(String colorDomain, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        String value = this.filter ? DataTools.sanitize(colorDomain) : colorDomain;
        this.store.setChannelComponentColorDomain(value, imageIndex, logicalChannelIndex, channelComponentIndex);
    }

    public void setChannelComponentIndex(Integer index, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        this.store.setChannelComponentIndex(index, imageIndex, logicalChannelIndex, channelComponentIndex);
    }

    public void setDetectorGain(Float gain, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorGain(gain, instrumentIndex, detectorIndex);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDetectorID(value, instrumentIndex, detectorIndex);
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        String value = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setDetectorManufacturer(value, instrumentIndex, detectorIndex);
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        String value = this.filter ? DataTools.sanitize(model) : model;
        this.store.setDetectorModel(value, instrumentIndex, detectorIndex);
    }

    public void setDetectorOffset(Float offset, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorOffset(offset, instrumentIndex, detectorIndex);
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        String value = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setDetectorSerialNumber(value, instrumentIndex, detectorIndex);
    }

    public void setDetectorType(String type, int instrumentIndex, int detectorIndex) {
        String value = this.filter ? DataTools.sanitize(type) : type;
        this.store.setDetectorType(value, instrumentIndex, detectorIndex);
    }

    public void setDetectorVoltage(Float voltage, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorVoltage(voltage, instrumentIndex, detectorIndex);
    }

    public void setDetectorSettingsBinning(String binning, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(binning) : binning;
        this.store.setDetectorSettingsBinning(value, imageIndex, logicalChannelIndex);
    }

    public void setDetectorSettingsDetector(String detector, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(detector) : detector;
        this.store.setDetectorSettingsDetector(value, imageIndex, logicalChannelIndex);
    }

    public void setDetectorSettingsGain(Float gain, int imageIndex, int logicalChannelIndex) {
        this.store.setDetectorSettingsGain(gain, imageIndex, logicalChannelIndex);
    }

    public void setDetectorSettingsOffset(Float offset, int imageIndex, int logicalChannelIndex) {
        this.store.setDetectorSettingsOffset(offset, imageIndex, logicalChannelIndex);
    }

    public void setDetectorSettingsReadOutRate(Float readOutRate, int imageIndex, int logicalChannelIndex) {
        this.store.setDetectorSettingsReadOutRate(readOutRate, imageIndex, logicalChannelIndex);
    }

    public void setDetectorSettingsVoltage(Float voltage, int imageIndex, int logicalChannelIndex) {
        this.store.setDetectorSettingsVoltage(voltage, imageIndex, logicalChannelIndex);
    }

    public void setDimensionsPhysicalSizeX(Float physicalSizeX, int imageIndex, int pixelsIndex) {
        this.store.setDimensionsPhysicalSizeX(physicalSizeX, imageIndex, pixelsIndex);
    }

    public void setDimensionsPhysicalSizeY(Float physicalSizeY, int imageIndex, int pixelsIndex) {
        this.store.setDimensionsPhysicalSizeY(physicalSizeY, imageIndex, pixelsIndex);
    }

    public void setDimensionsPhysicalSizeZ(Float physicalSizeZ, int imageIndex, int pixelsIndex) {
        this.store.setDimensionsPhysicalSizeZ(physicalSizeZ, imageIndex, pixelsIndex);
    }

    public void setDimensionsTimeIncrement(Float timeIncrement, int imageIndex, int pixelsIndex) {
        this.store.setDimensionsTimeIncrement(timeIncrement, imageIndex, pixelsIndex);
    }

    public void setDimensionsWaveIncrement(Integer waveIncrement, int imageIndex, int pixelsIndex) {
        this.store.setDimensionsWaveIncrement(waveIncrement, imageIndex, pixelsIndex);
    }

    public void setDimensionsWaveStart(Integer waveStart, int imageIndex, int pixelsIndex) {
        this.store.setDimensionsWaveStart(waveStart, imageIndex, pixelsIndex);
    }

    public void setDisplayOptionsID(String id, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDisplayOptionsID(value, imageIndex);
    }

    public void setDisplayOptionsZoom(Float zoom, int imageIndex) {
        this.store.setDisplayOptionsZoom(zoom, imageIndex);
    }

    public void setDisplayOptionsProjectionZStart(Integer zStart, int imageIndex) {
        this.store.setDisplayOptionsProjectionZStart(zStart, imageIndex);
    }

    public void setDisplayOptionsProjectionZStop(Integer zStop, int imageIndex) {
        this.store.setDisplayOptionsProjectionZStop(zStop, imageIndex);
    }

    public void setDisplayOptionsTimeTStart(Integer tStart, int imageIndex) {
        this.store.setDisplayOptionsTimeTStart(tStart, imageIndex);
    }

    public void setDisplayOptionsTimeTStop(Integer tStop, int imageIndex) {
        this.store.setDisplayOptionsTimeTStop(tStop, imageIndex);
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        String value = this.filter ? DataTools.sanitize(description) : description;
        this.store.setExperimentDescription(value, experimentIndex);
    }

    public void setExperimentID(String id, int experimentIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setExperimentID(value, experimentIndex);
    }

    public void setExperimentType(String type, int experimentIndex) {
        String value = this.filter ? DataTools.sanitize(type) : type;
        this.store.setExperimentType(value, experimentIndex);
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        String value = this.filter ? DataTools.sanitize(email) : email;
        this.store.setExperimenterEmail(value, experimenterIndex);
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        String value = this.filter ? DataTools.sanitize(firstName) : firstName;
        this.store.setExperimenterFirstName(value, experimenterIndex);
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setExperimenterID(value, experimenterIndex);
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        String value = this.filter ? DataTools.sanitize(institution) : institution;
        this.store.setExperimenterInstitution(value, experimenterIndex);
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        String value = this.filter ? DataTools.sanitize(lastName) : lastName;
        this.store.setExperimenterLastName(value, experimenterIndex);
    }

    public void setExperimenterMembershipGroup(String group, int experimenterIndex, int groupRefIndex) {
        String value = this.filter ? DataTools.sanitize(group) : group;
        this.store.setExperimenterMembershipGroup(value, experimenterIndex, groupRefIndex);
    }

    public void setFilamentType(String type, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(type) : type;
        this.store.setFilamentType(value, instrumentIndex, lightSourceIndex);
    }

    public void setImageCreationDate(String creationDate, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(creationDate) : creationDate;
        this.store.setImageCreationDate(value, imageIndex);
    }

    public void setImageDefaultPixels(String defaultPixels, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(defaultPixels) : defaultPixels;
        this.store.setImageDefaultPixels(value, imageIndex);
    }

    public void setImageDescription(String description, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(description) : description;
        this.store.setImageDescription(value, imageIndex);
    }

    public void setImageID(String id, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setImageID(value, imageIndex);
    }

    public void setImageInstrumentRef(String instrumentRef, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(instrumentRef) : instrumentRef;
        this.store.setImageInstrumentRef(value, imageIndex);
    }

    public void setImageName(String name, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(name) : name;
        this.store.setImageName(value, imageIndex);
    }

    public void setImagingEnvironmentAirPressure(Float airPressure, int imageIndex) {
        this.store.setImagingEnvironmentAirPressure(airPressure, imageIndex);
    }

    public void setImagingEnvironmentCO2Percent(Float cO2Percent, int imageIndex) {
        this.store.setImagingEnvironmentCO2Percent(cO2Percent, imageIndex);
    }

    public void setImagingEnvironmentHumidity(Float humidity, int imageIndex) {
        this.store.setImagingEnvironmentHumidity(humidity, imageIndex);
    }

    public void setImagingEnvironmentTemperature(Float temperature, int imageIndex) {
        this.store.setImagingEnvironmentTemperature(temperature, imageIndex);
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setInstrumentID(value, instrumentIndex);
    }

    public void setLaserFrequencyMultiplication(Integer frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserFrequencyMultiplication(frequencyMultiplication, instrumentIndex, lightSourceIndex);
    }

    public void setLaserLaserMedium(String laserMedium, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(laserMedium) : laserMedium;
        this.store.setLaserLaserMedium(value, instrumentIndex, lightSourceIndex);
    }

    public void setLaserPulse(String pulse, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(pulse) : pulse;
        this.store.setLaserPulse(value, instrumentIndex, lightSourceIndex);
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserTuneable(tuneable, instrumentIndex, lightSourceIndex);
    }

    public void setLaserType(String type, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(type) : type;
        this.store.setLaserType(value, instrumentIndex, lightSourceIndex);
    }

    public void setLaserWavelength(Integer wavelength, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserWavelength(wavelength, instrumentIndex, lightSourceIndex);
    }

    public void setLightSourceID(String id, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLightSourceID(value, instrumentIndex, lightSourceIndex);
    }

    public void setLightSourceManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setLightSourceManufacturer(value, instrumentIndex, lightSourceIndex);
    }

    public void setLightSourceModel(String model, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(model) : model;
        this.store.setLightSourceModel(value, instrumentIndex, lightSourceIndex);
    }

    public void setLightSourcePower(Float power, int instrumentIndex, int lightSourceIndex) {
        this.store.setLightSourcePower(power, instrumentIndex, lightSourceIndex);
    }

    public void setLightSourceSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        String value = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setLightSourceSerialNumber(value, instrumentIndex, lightSourceIndex);
    }

    public void setLightSourceSettingsAttenuation(Float attenuation, int imageIndex, int logicalChannelIndex) {
        this.store.setLightSourceSettingsAttenuation(attenuation, imageIndex, logicalChannelIndex);
    }

    public void setLightSourceSettingsLightSource(String lightSource, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(lightSource) : lightSource;
        this.store.setLightSourceSettingsLightSource(value, imageIndex, logicalChannelIndex);
    }

    public void setLightSourceSettingsWavelength(Integer wavelength, int imageIndex, int logicalChannelIndex) {
        this.store.setLightSourceSettingsWavelength(wavelength, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelContrastMethod(String contrastMethod, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(contrastMethod) : contrastMethod;
        this.store.setLogicalChannelContrastMethod(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelEmWave(Integer emWave, int imageIndex, int logicalChannelIndex) {
        this.store.setLogicalChannelEmWave(emWave, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelExWave(Integer exWave, int imageIndex, int logicalChannelIndex) {
        this.store.setLogicalChannelExWave(exWave, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelFluor(String fluor, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(fluor) : fluor;
        this.store.setLogicalChannelFluor(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelID(String id, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLogicalChannelID(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelIlluminationType(String illuminationType, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(illuminationType) : illuminationType;
        this.store.setLogicalChannelIlluminationType(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelMode(String mode, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(mode) : mode;
        this.store.setLogicalChannelMode(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelName(String name, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(name) : name;
        this.store.setLogicalChannelName(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelNdFilter(Float ndFilter, int imageIndex, int logicalChannelIndex) {
        this.store.setLogicalChannelNdFilter(ndFilter, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelOTF(String otf, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(otf) : otf;
        this.store.setLogicalChannelOTF(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelPhotometricInterpretation(String photometricInterpretation, int imageIndex, int logicalChannelIndex) {
        String value = this.filter ? DataTools.sanitize(photometricInterpretation) : photometricInterpretation;
        this.store.setLogicalChannelPhotometricInterpretation(value, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelPinholeSize(Float pinholeSize, int imageIndex, int logicalChannelIndex) {
        this.store.setLogicalChannelPinholeSize(pinholeSize, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int logicalChannelIndex) {
        this.store.setLogicalChannelPockelCellSetting(pockelCellSetting, imageIndex, logicalChannelIndex);
    }

    public void setLogicalChannelSamplesPerPixel(Integer samplesPerPixel, int imageIndex, int logicalChannelIndex) {
        this.store.setLogicalChannelSamplesPerPixel(samplesPerPixel, imageIndex, logicalChannelIndex);
    }

    public void setOTFID(String id, int instrumentIndex, int otfIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setOTFID(value, instrumentIndex, otfIndex);
    }

    public void setOTFObjective(String objective, int instrumentIndex, int otfIndex) {
        String value = this.filter ? DataTools.sanitize(objective) : objective;
        this.store.setOTFObjective(value, instrumentIndex, otfIndex);
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int otfIndex) {
        this.store.setOTFOpticalAxisAveraged(opticalAxisAveraged, instrumentIndex, otfIndex);
    }

    public void setOTFPixelType(String pixelType, int instrumentIndex, int otfIndex) {
        String value = this.filter ? DataTools.sanitize(pixelType) : pixelType;
        this.store.setOTFPixelType(value, instrumentIndex, otfIndex);
    }

    public void setOTFSizeX(Integer sizeX, int instrumentIndex, int otfIndex) {
        this.store.setOTFSizeX(sizeX, instrumentIndex, otfIndex);
    }

    public void setOTFSizeY(Integer sizeY, int instrumentIndex, int otfIndex) {
        this.store.setOTFSizeY(sizeY, instrumentIndex, otfIndex);
    }

    public void setObjectiveCalibratedMagnification(Float calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveCalibratedMagnification(calibratedMagnification, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveCorrection(String correction, int instrumentIndex, int objectiveIndex) {
        String value = this.filter ? DataTools.sanitize(correction) : correction;
        this.store.setObjectiveCorrection(value, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setObjectiveID(value, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveImmersion(String immersion, int instrumentIndex, int objectiveIndex) {
        String value = this.filter ? DataTools.sanitize(immersion) : immersion;
        this.store.setObjectiveImmersion(value, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveIris(iris, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveLensNA(Float lensNA, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveLensNA(lensNA, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        String value = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setObjectiveManufacturer(value, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        String value = this.filter ? DataTools.sanitize(model) : model;
        this.store.setObjectiveModel(value, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveNominalMagnification(Integer nominalMagnification, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveNominalMagnification(nominalMagnification, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        String value = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setObjectiveSerialNumber(value, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveWorkingDistance(Float workingDistance, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveWorkingDistance(workingDistance, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveSettingsCorrectionCollar(Float correctionCollar, int imageIndex) {
        this.store.setObjectiveSettingsCorrectionCollar(correctionCollar, imageIndex);
    }

    public void setObjectiveSettingsMedium(String medium, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(medium) : medium;
        this.store.setObjectiveSettingsMedium(value, imageIndex);
    }

    public void setObjectiveSettingsObjective(String objective, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(objective) : objective;
        this.store.setObjectiveSettingsObjective(value, imageIndex);
    }

    public void setObjectiveSettingsRefractiveIndex(Float refractiveIndex, int imageIndex) {
        this.store.setObjectiveSettingsRefractiveIndex(refractiveIndex, imageIndex);
    }

    public void setPixelsBigEndian(Boolean bigEndian, int imageIndex, int pixelsIndex) {
        this.store.setPixelsBigEndian(bigEndian, imageIndex, pixelsIndex);
    }

    public void setPixelsDimensionOrder(String dimensionOrder, int imageIndex, int pixelsIndex) {
        String value = this.filter ? DataTools.sanitize(dimensionOrder) : dimensionOrder;
        this.store.setPixelsDimensionOrder(value, imageIndex, pixelsIndex);
    }

    public void setPixelsID(String id, int imageIndex, int pixelsIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPixelsID(value, imageIndex, pixelsIndex);
    }

    public void setPixelsPixelType(String pixelType, int imageIndex, int pixelsIndex) {
        String value = this.filter ? DataTools.sanitize(pixelType) : pixelType;
        this.store.setPixelsPixelType(value, imageIndex, pixelsIndex);
    }

    public void setPixelsSizeC(Integer sizeC, int imageIndex, int pixelsIndex) {
        this.store.setPixelsSizeC(sizeC, imageIndex, pixelsIndex);
    }

    public void setPixelsSizeT(Integer sizeT, int imageIndex, int pixelsIndex) {
        this.store.setPixelsSizeT(sizeT, imageIndex, pixelsIndex);
    }

    public void setPixelsSizeX(Integer sizeX, int imageIndex, int pixelsIndex) {
        this.store.setPixelsSizeX(sizeX, imageIndex, pixelsIndex);
    }

    public void setPixelsSizeY(Integer sizeY, int imageIndex, int pixelsIndex) {
        this.store.setPixelsSizeY(sizeY, imageIndex, pixelsIndex);
    }

    public void setPixelsSizeZ(Integer sizeZ, int imageIndex, int pixelsIndex) {
        this.store.setPixelsSizeZ(sizeZ, imageIndex, pixelsIndex);
    }

    public void setPlaneTheC(Integer theC, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setPlaneTheC(theC, imageIndex, pixelsIndex, planeIndex);
    }

    public void setPlaneTheT(Integer theT, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setPlaneTheT(theT, imageIndex, pixelsIndex, planeIndex);
    }

    public void setPlaneTheZ(Integer theZ, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setPlaneTheZ(theZ, imageIndex, pixelsIndex, planeIndex);
    }

    public void setPlaneTimingDeltaT(Float deltaT, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setPlaneTimingDeltaT(deltaT, imageIndex, pixelsIndex, planeIndex);
    }

    public void setPlaneTimingExposureTime(Float exposureTime, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setPlaneTimingExposureTime(exposureTime, imageIndex, pixelsIndex, planeIndex);
    }

    public void setPlateDescription(String description, int plateIndex) {
        String value = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPlateDescription(value, plateIndex);
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        String value = this.filter ? DataTools.sanitize(externalIdentifier) : externalIdentifier;
        this.store.setPlateExternalIdentifier(value, plateIndex);
    }

    public void setPlateID(String id, int plateIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPlateID(value, plateIndex);
    }

    public void setPlateName(String name, int plateIndex) {
        String value = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPlateName(value, plateIndex);
    }

    public void setPlateStatus(String status, int plateIndex) {
        String value = this.filter ? DataTools.sanitize(status) : status;
        this.store.setPlateStatus(value, plateIndex);
    }

    public void setPlateRefID(String id, int screenIndex, int plateRefIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPlateRefID(value, screenIndex, plateRefIndex);
    }

    public void setROIID(String id, int imageIndex, int roiIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setROIID(value, imageIndex, roiIndex);
    }

    public void setROIT0(Integer t0, int imageIndex, int roiIndex) {
        this.store.setROIT0(t0, imageIndex, roiIndex);
    }

    public void setROIT1(Integer t1, int imageIndex, int roiIndex) {
        this.store.setROIT1(t1, imageIndex, roiIndex);
    }

    public void setROIX0(Integer x0, int imageIndex, int roiIndex) {
        this.store.setROIX0(x0, imageIndex, roiIndex);
    }

    public void setROIX1(Integer x1, int imageIndex, int roiIndex) {
        this.store.setROIX1(x1, imageIndex, roiIndex);
    }

    public void setROIY0(Integer y0, int imageIndex, int roiIndex) {
        this.store.setROIY0(y0, imageIndex, roiIndex);
    }

    public void setROIY1(Integer y1, int imageIndex, int roiIndex) {
        this.store.setROIY1(y1, imageIndex, roiIndex);
    }

    public void setROIZ0(Integer z0, int imageIndex, int roiIndex) {
        this.store.setROIZ0(z0, imageIndex, roiIndex);
    }

    public void setROIZ1(Integer z1, int imageIndex, int roiIndex) {
        this.store.setROIZ1(z1, imageIndex, roiIndex);
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        String value = this.filter ? DataTools.sanitize(description) : description;
        this.store.setReagentDescription(value, screenIndex, reagentIndex);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setReagentID(value, screenIndex, reagentIndex);
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        String value = this.filter ? DataTools.sanitize(name) : name;
        this.store.setReagentName(value, screenIndex, reagentIndex);
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        String value = this.filter ? DataTools.sanitize(reagentIdentifier) : reagentIdentifier;
        this.store.setReagentReagentIdentifier(value, screenIndex, reagentIndex);
    }

    public void setScreenID(String id, int screenIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setScreenID(value, screenIndex);
    }

    public void setScreenName(String name, int screenIndex) {
        String value = this.filter ? DataTools.sanitize(name) : name;
        this.store.setScreenName(value, screenIndex);
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        String value = this.filter ? DataTools.sanitize(protocolDescription) : protocolDescription;
        this.store.setScreenProtocolDescription(value, screenIndex);
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        String value = this.filter ? DataTools.sanitize(protocolIdentifier) : protocolIdentifier;
        this.store.setScreenProtocolIdentifier(value, screenIndex);
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        String value = this.filter ? DataTools.sanitize(reagentSetDescription) : reagentSetDescription;
        this.store.setScreenReagentSetDescription(value, screenIndex);
    }

    public void setScreenType(String type, int screenIndex) {
        String value = this.filter ? DataTools.sanitize(type) : type;
        this.store.setScreenType(value, screenIndex);
    }

    public void setScreenAcquisitionEndTime(String endTime, int screenIndex, int screenAcquisitionIndex) {
        String value = this.filter ? DataTools.sanitize(endTime) : endTime;
        this.store.setScreenAcquisitionEndTime(value, screenIndex, screenAcquisitionIndex);
    }

    public void setScreenAcquisitionID(String id, int screenIndex, int screenAcquisitionIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setScreenAcquisitionID(value, screenIndex, screenAcquisitionIndex);
    }

    public void setScreenAcquisitionStartTime(String startTime, int screenIndex, int screenAcquisitionIndex) {
        String value = this.filter ? DataTools.sanitize(startTime) : startTime;
        this.store.setScreenAcquisitionStartTime(value, screenIndex, screenAcquisitionIndex);
    }

    public void setStageLabelName(String name, int imageIndex) {
        String value = this.filter ? DataTools.sanitize(name) : name;
        this.store.setStageLabelName(value, imageIndex);
    }

    public void setStageLabelX(Float x, int imageIndex) {
        this.store.setStageLabelX(x, imageIndex);
    }

    public void setStageLabelY(Float y, int imageIndex) {
        this.store.setStageLabelY(y, imageIndex);
    }

    public void setStageLabelZ(Float z, int imageIndex) {
        this.store.setStageLabelZ(z, imageIndex);
    }

    public void setStagePositionPositionX(Float positionX, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setStagePositionPositionX(positionX, imageIndex, pixelsIndex, planeIndex);
    }

    public void setStagePositionPositionY(Float positionY, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setStagePositionPositionY(positionY, imageIndex, pixelsIndex, planeIndex);
    }

    public void setStagePositionPositionZ(Float positionZ, int imageIndex, int pixelsIndex, int planeIndex) {
        this.store.setStagePositionPositionZ(positionZ, imageIndex, pixelsIndex, planeIndex);
    }

    public void setTiffDataFileName(String fileName, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        String value = this.filter ? DataTools.sanitize(fileName) : fileName;
        this.store.setTiffDataFileName(value, imageIndex, pixelsIndex, tiffDataIndex);
    }

    public void setTiffDataFirstC(Integer firstC, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstC(firstC, imageIndex, pixelsIndex, tiffDataIndex);
    }

    public void setTiffDataFirstT(Integer firstT, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstT(firstT, imageIndex, pixelsIndex, tiffDataIndex);
    }

    public void setTiffDataFirstZ(Integer firstZ, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstZ(firstZ, imageIndex, pixelsIndex, tiffDataIndex);
    }

    public void setTiffDataIFD(Integer ifd, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        this.store.setTiffDataIFD(ifd, imageIndex, pixelsIndex, tiffDataIndex);
    }

    public void setTiffDataNumPlanes(Integer numPlanes, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        this.store.setTiffDataNumPlanes(numPlanes, imageIndex, pixelsIndex, tiffDataIndex);
    }

    public void setTiffDataUUID(String uuid, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        String value = this.filter ? DataTools.sanitize(uuid) : uuid;
        this.store.setTiffDataUUID(value, imageIndex, pixelsIndex, tiffDataIndex);
    }

    public void setWellColumn(Integer column, int plateIndex, int wellIndex) {
        this.store.setWellColumn(column, plateIndex, wellIndex);
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        String value = this.filter ? DataTools.sanitize(externalDescription) : externalDescription;
        this.store.setWellExternalDescription(value, plateIndex, wellIndex);
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        String value = this.filter ? DataTools.sanitize(externalIdentifier) : externalIdentifier;
        this.store.setWellExternalIdentifier(value, plateIndex, wellIndex);
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setWellID(value, plateIndex, wellIndex);
    }

    public void setWellRow(Integer row, int plateIndex, int wellIndex) {
        this.store.setWellRow(row, plateIndex, wellIndex);
    }

    public void setWellType(String type, int plateIndex, int wellIndex) {
        String value = this.filter ? DataTools.sanitize(type) : type;
        this.store.setWellType(value, plateIndex, wellIndex);
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        String value = this.filter ? DataTools.sanitize(id) : id;
        this.store.setWellSampleID(value, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSampleIndex(Integer index, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSampleIndex(index, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSamplePosX(Float posX, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSamplePosX(posX, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSamplePosY(Float posY, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSamplePosY(posY, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSampleTimepoint(Integer timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSampleTimepoint(timepoint, plateIndex, wellIndex, wellSampleIndex);
    }
}

