/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;

public final class MetadataConverter {
    private MetadataConverter() {
    }

    public static void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        int experimentCount = src.getExperimentCount();
        for (int experimentIndex = 0; experimentIndex < experimentCount; ++experimentIndex) {
            String experimentTypeValue;
            String experimentIDValue;
            String experimentDescriptionValue = src.getExperimentDescription(experimentIndex);
            if (experimentDescriptionValue != null) {
                dest.setExperimentDescription(experimentDescriptionValue, experimentIndex);
            }
            if ((experimentIDValue = src.getExperimentID(experimentIndex)) != null) {
                dest.setExperimentID(experimentIDValue, experimentIndex);
            }
            if ((experimentTypeValue = src.getExperimentType(experimentIndex)) == null) continue;
            dest.setExperimentType(experimentTypeValue, experimentIndex);
        }
        int experimenterCount = src.getExperimenterCount();
        for (int experimenterIndex = 0; experimenterIndex < experimenterCount; ++experimenterIndex) {
            String experimenterLastNameValue;
            String experimenterInstitutionValue;
            String experimenterIDValue;
            String experimenterFirstNameValue;
            String experimenterEmailValue = src.getExperimenterEmail(experimenterIndex);
            if (experimenterEmailValue != null) {
                dest.setExperimenterEmail(experimenterEmailValue, experimenterIndex);
            }
            if ((experimenterFirstNameValue = src.getExperimenterFirstName(experimenterIndex)) != null) {
                dest.setExperimenterFirstName(experimenterFirstNameValue, experimenterIndex);
            }
            if ((experimenterIDValue = src.getExperimenterID(experimenterIndex)) != null) {
                dest.setExperimenterID(experimenterIDValue, experimenterIndex);
            }
            if ((experimenterInstitutionValue = src.getExperimenterInstitution(experimenterIndex)) != null) {
                dest.setExperimenterInstitution(experimenterInstitutionValue, experimenterIndex);
            }
            if ((experimenterLastNameValue = src.getExperimenterLastName(experimenterIndex)) != null) {
                dest.setExperimenterLastName(experimenterLastNameValue, experimenterIndex);
            }
            int groupRefCount = src.getGroupRefCount(experimenterIndex);
            for (int groupRefIndex = 0; groupRefIndex < groupRefCount; ++groupRefIndex) {
                String experimenterMembershipGroupValue = src.getExperimenterMembershipGroup(experimenterIndex, groupRefIndex);
                if (experimenterMembershipGroupValue == null) continue;
                dest.setExperimenterMembershipGroup(experimenterMembershipGroupValue, experimenterIndex, groupRefIndex);
            }
        }
        int imageCount = src.getImageCount();
        for (int imageIndex = 0; imageIndex < imageCount; ++imageIndex) {
            Float stageLabelZValue;
            Float stageLabelYValue;
            Float stageLabelXValue;
            Float objectiveSettingsRefractiveIndexValue;
            String objectiveSettingsObjectiveValue;
            String objectiveSettingsMediumValue;
            Float imagingEnvironmentTemperatureValue;
            Float imagingEnvironmentHumidityValue;
            Float imagingEnvironmentCO2PercentValue;
            Float imagingEnvironmentAirPressureValue;
            Integer displayOptionsTimeTStopValue;
            Integer displayOptionsProjectionZStopValue;
            Integer displayOptionsProjectionZStartValue;
            Float displayOptionsZoomValue;
            String displayOptionsIDValue;
            String imageNameValue;
            String imageInstrumentRefValue;
            String imageIDValue;
            String imageDescriptionValue;
            String imageDefaultPixelsValue;
            String imageCreationDateValue = src.getImageCreationDate(imageIndex);
            if (imageCreationDateValue != null) {
                dest.setImageCreationDate(imageCreationDateValue, imageIndex);
            }
            if ((imageDefaultPixelsValue = src.getImageDefaultPixels(imageIndex)) != null) {
                dest.setImageDefaultPixels(imageDefaultPixelsValue, imageIndex);
            }
            if ((imageDescriptionValue = src.getImageDescription(imageIndex)) != null) {
                dest.setImageDescription(imageDescriptionValue, imageIndex);
            }
            if ((imageIDValue = src.getImageID(imageIndex)) != null) {
                dest.setImageID(imageIDValue, imageIndex);
            }
            if ((imageInstrumentRefValue = src.getImageInstrumentRef(imageIndex)) != null) {
                dest.setImageInstrumentRef(imageInstrumentRefValue, imageIndex);
            }
            if ((imageNameValue = src.getImageName(imageIndex)) != null) {
                dest.setImageName(imageNameValue, imageIndex);
            }
            if ((displayOptionsIDValue = src.getDisplayOptionsID(imageIndex)) != null) {
                dest.setDisplayOptionsID(displayOptionsIDValue, imageIndex);
            }
            if ((displayOptionsZoomValue = src.getDisplayOptionsZoom(imageIndex)) != null) {
                dest.setDisplayOptionsZoom(displayOptionsZoomValue, imageIndex);
            }
            if ((displayOptionsProjectionZStartValue = src.getDisplayOptionsProjectionZStart(imageIndex)) != null) {
                dest.setDisplayOptionsProjectionZStart(displayOptionsProjectionZStartValue, imageIndex);
            }
            if ((displayOptionsProjectionZStopValue = src.getDisplayOptionsProjectionZStop(imageIndex)) != null) {
                dest.setDisplayOptionsProjectionZStop(displayOptionsProjectionZStopValue, imageIndex);
            }
            int roiCount = src.getROICount(imageIndex);
            for (int roiIndex = 0; roiIndex < roiCount; ++roiIndex) {
                Integer roiZ1Value;
                Integer roiZ0Value;
                Integer roiY1Value;
                Integer roiY0Value;
                Integer roiX1Value;
                Integer roiX0Value;
                Integer roiT1Value;
                Integer roiT0Value;
                String roiidValue = src.getROIID(imageIndex, roiIndex);
                if (roiidValue != null) {
                    dest.setROIID(roiidValue, imageIndex, roiIndex);
                }
                if ((roiT0Value = src.getROIT0(imageIndex, roiIndex)) != null) {
                    dest.setROIT0(roiT0Value, imageIndex, roiIndex);
                }
                if ((roiT1Value = src.getROIT1(imageIndex, roiIndex)) != null) {
                    dest.setROIT1(roiT1Value, imageIndex, roiIndex);
                }
                if ((roiX0Value = src.getROIX0(imageIndex, roiIndex)) != null) {
                    dest.setROIX0(roiX0Value, imageIndex, roiIndex);
                }
                if ((roiX1Value = src.getROIX1(imageIndex, roiIndex)) != null) {
                    dest.setROIX1(roiX1Value, imageIndex, roiIndex);
                }
                if ((roiY0Value = src.getROIY0(imageIndex, roiIndex)) != null) {
                    dest.setROIY0(roiY0Value, imageIndex, roiIndex);
                }
                if ((roiY1Value = src.getROIY1(imageIndex, roiIndex)) != null) {
                    dest.setROIY1(roiY1Value, imageIndex, roiIndex);
                }
                if ((roiZ0Value = src.getROIZ0(imageIndex, roiIndex)) != null) {
                    dest.setROIZ0(roiZ0Value, imageIndex, roiIndex);
                }
                if ((roiZ1Value = src.getROIZ1(imageIndex, roiIndex)) == null) continue;
                dest.setROIZ1(roiZ1Value, imageIndex, roiIndex);
            }
            Integer displayOptionsTimeTStartValue = src.getDisplayOptionsTimeTStart(imageIndex);
            if (displayOptionsTimeTStartValue != null) {
                dest.setDisplayOptionsTimeTStart(displayOptionsTimeTStartValue, imageIndex);
            }
            if ((displayOptionsTimeTStopValue = src.getDisplayOptionsTimeTStop(imageIndex)) != null) {
                dest.setDisplayOptionsTimeTStop(displayOptionsTimeTStopValue, imageIndex);
            }
            if ((imagingEnvironmentAirPressureValue = src.getImagingEnvironmentAirPressure(imageIndex)) != null) {
                dest.setImagingEnvironmentAirPressure(imagingEnvironmentAirPressureValue, imageIndex);
            }
            if ((imagingEnvironmentCO2PercentValue = src.getImagingEnvironmentCO2Percent(imageIndex)) != null) {
                dest.setImagingEnvironmentCO2Percent(imagingEnvironmentCO2PercentValue, imageIndex);
            }
            if ((imagingEnvironmentHumidityValue = src.getImagingEnvironmentHumidity(imageIndex)) != null) {
                dest.setImagingEnvironmentHumidity(imagingEnvironmentHumidityValue, imageIndex);
            }
            if ((imagingEnvironmentTemperatureValue = src.getImagingEnvironmentTemperature(imageIndex)) != null) {
                dest.setImagingEnvironmentTemperature(imagingEnvironmentTemperatureValue, imageIndex);
            }
            int logicalChannelCount = src.getLogicalChannelCount(imageIndex);
            for (int logicalChannelIndex = 0; logicalChannelIndex < logicalChannelCount; ++logicalChannelIndex) {
                Integer lightSourceSettingsWavelengthValue;
                String lightSourceSettingsLightSourceValue;
                Float lightSourceSettingsAttenuationValue;
                Float detectorSettingsVoltageValue;
                Float detectorSettingsReadOutRateValue;
                Float detectorSettingsOffsetValue;
                Float detectorSettingsGainValue;
                String detectorSettingsDetectorValue;
                Integer logicalChannelSamplesPerPixelValue;
                Integer logicalChannelPockelCellSettingValue;
                Float logicalChannelPinholeSizeValue;
                String logicalChannelPhotometricInterpretationValue;
                String logicalChannelOTFValue;
                Float logicalChannelNdFilterValue;
                String logicalChannelNameValue;
                String logicalChannelModeValue;
                String logicalChannelIlluminationTypeValue;
                String logicalChannelIDValue;
                String logicalChannelFluorValue;
                Integer logicalChannelExWaveValue;
                Integer logicalChannelEmWaveValue;
                String logicalChannelContrastMethodValue = src.getLogicalChannelContrastMethod(imageIndex, logicalChannelIndex);
                if (logicalChannelContrastMethodValue != null) {
                    dest.setLogicalChannelContrastMethod(logicalChannelContrastMethodValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelEmWaveValue = src.getLogicalChannelEmWave(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelEmWave(logicalChannelEmWaveValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelExWaveValue = src.getLogicalChannelExWave(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelExWave(logicalChannelExWaveValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelFluorValue = src.getLogicalChannelFluor(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelFluor(logicalChannelFluorValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelIDValue = src.getLogicalChannelID(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelID(logicalChannelIDValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelIlluminationTypeValue = src.getLogicalChannelIlluminationType(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelIlluminationType(logicalChannelIlluminationTypeValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelModeValue = src.getLogicalChannelMode(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelMode(logicalChannelModeValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelNameValue = src.getLogicalChannelName(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelName(logicalChannelNameValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelNdFilterValue = src.getLogicalChannelNdFilter(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelNdFilter(logicalChannelNdFilterValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelOTFValue = src.getLogicalChannelOTF(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelOTF(logicalChannelOTFValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelPhotometricInterpretationValue = src.getLogicalChannelPhotometricInterpretation(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelPhotometricInterpretation(logicalChannelPhotometricInterpretationValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelPinholeSizeValue = src.getLogicalChannelPinholeSize(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelPinholeSize(logicalChannelPinholeSizeValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelPockelCellSettingValue = src.getLogicalChannelPockelCellSetting(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelPockelCellSetting(logicalChannelPockelCellSettingValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelSamplesPerPixelValue = src.getLogicalChannelSamplesPerPixel(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelSamplesPerPixel(logicalChannelSamplesPerPixelValue, imageIndex, logicalChannelIndex);
                }
                int channelComponentCount = src.getChannelComponentCount(imageIndex, logicalChannelIndex);
                for (int channelComponentIndex = 0; channelComponentIndex < channelComponentCount; ++channelComponentIndex) {
                    Integer channelComponentIndexValue;
                    String channelComponentColorDomainValue = src.getChannelComponentColorDomain(imageIndex, logicalChannelIndex, channelComponentIndex);
                    if (channelComponentColorDomainValue != null) {
                        dest.setChannelComponentColorDomain(channelComponentColorDomainValue, imageIndex, logicalChannelIndex, channelComponentIndex);
                    }
                    if ((channelComponentIndexValue = src.getChannelComponentIndex(imageIndex, logicalChannelIndex, channelComponentIndex)) == null) continue;
                    dest.setChannelComponentIndex(channelComponentIndexValue, imageIndex, logicalChannelIndex, channelComponentIndex);
                }
                String detectorSettingsBinningValue = src.getDetectorSettingsBinning(imageIndex, logicalChannelIndex);
                if (detectorSettingsBinningValue != null) {
                    dest.setDetectorSettingsBinning(detectorSettingsBinningValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsDetectorValue = src.getDetectorSettingsDetector(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsDetector(detectorSettingsDetectorValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsGainValue = src.getDetectorSettingsGain(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsGain(detectorSettingsGainValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsOffsetValue = src.getDetectorSettingsOffset(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsOffset(detectorSettingsOffsetValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsReadOutRateValue = src.getDetectorSettingsReadOutRate(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsReadOutRate(detectorSettingsReadOutRateValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsVoltageValue = src.getDetectorSettingsVoltage(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsVoltage(detectorSettingsVoltageValue, imageIndex, logicalChannelIndex);
                }
                if ((lightSourceSettingsAttenuationValue = src.getLightSourceSettingsAttenuation(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLightSourceSettingsAttenuation(lightSourceSettingsAttenuationValue, imageIndex, logicalChannelIndex);
                }
                if ((lightSourceSettingsLightSourceValue = src.getLightSourceSettingsLightSource(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLightSourceSettingsLightSource(lightSourceSettingsLightSourceValue, imageIndex, logicalChannelIndex);
                }
                if ((lightSourceSettingsWavelengthValue = src.getLightSourceSettingsWavelength(imageIndex, logicalChannelIndex)) == null) continue;
                dest.setLightSourceSettingsWavelength(lightSourceSettingsWavelengthValue, imageIndex, logicalChannelIndex);
            }
            Float objectiveSettingsCorrectionCollarValue = src.getObjectiveSettingsCorrectionCollar(imageIndex);
            if (objectiveSettingsCorrectionCollarValue != null) {
                dest.setObjectiveSettingsCorrectionCollar(objectiveSettingsCorrectionCollarValue, imageIndex);
            }
            if ((objectiveSettingsMediumValue = src.getObjectiveSettingsMedium(imageIndex)) != null) {
                dest.setObjectiveSettingsMedium(objectiveSettingsMediumValue, imageIndex);
            }
            if ((objectiveSettingsObjectiveValue = src.getObjectiveSettingsObjective(imageIndex)) != null) {
                dest.setObjectiveSettingsObjective(objectiveSettingsObjectiveValue, imageIndex);
            }
            if ((objectiveSettingsRefractiveIndexValue = src.getObjectiveSettingsRefractiveIndex(imageIndex)) != null) {
                dest.setObjectiveSettingsRefractiveIndex(objectiveSettingsRefractiveIndexValue, imageIndex);
            }
            int pixelsCount = src.getPixelsCount(imageIndex);
            for (int pixelsIndex = 0; pixelsIndex < pixelsCount; ++pixelsIndex) {
                Integer pixelsSizeZValue;
                Integer pixelsSizeYValue;
                Integer pixelsSizeXValue;
                Integer pixelsSizeTValue;
                Integer pixelsSizeCValue;
                String pixelsPixelTypeValue;
                String pixelsIDValue;
                String pixelsDimensionOrderValue;
                Boolean pixelsBigEndianValue;
                Integer dimensionsWaveStartValue;
                Integer dimensionsWaveIncrementValue;
                Float dimensionsTimeIncrementValue;
                Float dimensionsPhysicalSizeZValue;
                Float dimensionsPhysicalSizeYValue;
                Float dimensionsPhysicalSizeXValue = src.getDimensionsPhysicalSizeX(imageIndex, pixelsIndex);
                if (dimensionsPhysicalSizeXValue != null) {
                    dest.setDimensionsPhysicalSizeX(dimensionsPhysicalSizeXValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsPhysicalSizeYValue = src.getDimensionsPhysicalSizeY(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsPhysicalSizeY(dimensionsPhysicalSizeYValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsPhysicalSizeZValue = src.getDimensionsPhysicalSizeZ(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsPhysicalSizeZ(dimensionsPhysicalSizeZValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsTimeIncrementValue = src.getDimensionsTimeIncrement(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsTimeIncrement(dimensionsTimeIncrementValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsWaveIncrementValue = src.getDimensionsWaveIncrement(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsWaveIncrement(dimensionsWaveIncrementValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsWaveStartValue = src.getDimensionsWaveStart(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsWaveStart(dimensionsWaveStartValue, imageIndex, pixelsIndex);
                }
                if ((pixelsBigEndianValue = src.getPixelsBigEndian(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsBigEndian(pixelsBigEndianValue, imageIndex, pixelsIndex);
                }
                if ((pixelsDimensionOrderValue = src.getPixelsDimensionOrder(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsDimensionOrder(pixelsDimensionOrderValue, imageIndex, pixelsIndex);
                }
                if ((pixelsIDValue = src.getPixelsID(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsID(pixelsIDValue, imageIndex, pixelsIndex);
                }
                if ((pixelsPixelTypeValue = src.getPixelsPixelType(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsPixelType(pixelsPixelTypeValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeCValue = src.getPixelsSizeC(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeC(pixelsSizeCValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeTValue = src.getPixelsSizeT(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeT(pixelsSizeTValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeXValue = src.getPixelsSizeX(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeX(pixelsSizeXValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeYValue = src.getPixelsSizeY(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeY(pixelsSizeYValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeZValue = src.getPixelsSizeZ(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeZ(pixelsSizeZValue, imageIndex, pixelsIndex);
                }
                int planeCount = src.getPlaneCount(imageIndex, pixelsIndex);
                for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                    Float stagePositionPositionZValue;
                    Float stagePositionPositionYValue;
                    Float stagePositionPositionXValue;
                    Float planeTimingExposureTimeValue;
                    Float planeTimingDeltaTValue;
                    Integer planeTheZValue;
                    Integer planeTheTValue;
                    Integer planeTheCValue = src.getPlaneTheC(imageIndex, pixelsIndex, planeIndex);
                    if (planeTheCValue != null) {
                        dest.setPlaneTheC(planeTheCValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTheTValue = src.getPlaneTheT(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTheT(planeTheTValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTheZValue = src.getPlaneTheZ(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTheZ(planeTheZValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTimingDeltaTValue = src.getPlaneTimingDeltaT(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTimingDeltaT(planeTimingDeltaTValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTimingExposureTimeValue = src.getPlaneTimingExposureTime(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTimingExposureTime(planeTimingExposureTimeValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((stagePositionPositionXValue = src.getStagePositionPositionX(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setStagePositionPositionX(stagePositionPositionXValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((stagePositionPositionYValue = src.getStagePositionPositionY(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setStagePositionPositionY(stagePositionPositionYValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((stagePositionPositionZValue = src.getStagePositionPositionZ(imageIndex, pixelsIndex, planeIndex)) == null) continue;
                    dest.setStagePositionPositionZ(stagePositionPositionZValue, imageIndex, pixelsIndex, planeIndex);
                }
                int tiffDataCount = src.getTiffDataCount(imageIndex, pixelsIndex);
                for (int tiffDataIndex = 0; tiffDataIndex < tiffDataCount; ++tiffDataIndex) {
                    String tiffDataUUIDValue;
                    Integer tiffDataNumPlanesValue;
                    Integer tiffDataIFDValue;
                    Integer tiffDataFirstZValue;
                    Integer tiffDataFirstTValue;
                    Integer tiffDataFirstCValue;
                    String tiffDataFileNameValue = src.getTiffDataFileName(imageIndex, pixelsIndex, tiffDataIndex);
                    if (tiffDataFileNameValue != null) {
                        dest.setTiffDataFileName(tiffDataFileNameValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataFirstCValue = src.getTiffDataFirstC(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataFirstC(tiffDataFirstCValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataFirstTValue = src.getTiffDataFirstT(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataFirstT(tiffDataFirstTValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataFirstZValue = src.getTiffDataFirstZ(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataFirstZ(tiffDataFirstZValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataIFDValue = src.getTiffDataIFD(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataIFD(tiffDataIFDValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataNumPlanesValue = src.getTiffDataNumPlanes(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataNumPlanes(tiffDataNumPlanesValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataUUIDValue = src.getTiffDataUUID(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
                    dest.setTiffDataUUID(tiffDataUUIDValue, imageIndex, pixelsIndex, tiffDataIndex);
                }
            }
            String stageLabelNameValue = src.getStageLabelName(imageIndex);
            if (stageLabelNameValue != null) {
                dest.setStageLabelName(stageLabelNameValue, imageIndex);
            }
            if ((stageLabelXValue = src.getStageLabelX(imageIndex)) != null) {
                dest.setStageLabelX(stageLabelXValue, imageIndex);
            }
            if ((stageLabelYValue = src.getStageLabelY(imageIndex)) != null) {
                dest.setStageLabelY(stageLabelYValue, imageIndex);
            }
            if ((stageLabelZValue = src.getStageLabelZ(imageIndex)) == null) continue;
            dest.setStageLabelZ(stageLabelZValue, imageIndex);
        }
        int instrumentCount = src.getInstrumentCount();
        for (int instrumentIndex = 0; instrumentIndex < instrumentCount; ++instrumentIndex) {
            String instrumentIDValue = src.getInstrumentID(instrumentIndex);
            if (instrumentIDValue != null) {
                dest.setInstrumentID(instrumentIDValue, instrumentIndex);
            }
            int detectorCount = src.getDetectorCount(instrumentIndex);
            for (int detectorIndex = 0; detectorIndex < detectorCount; ++detectorIndex) {
                Float detectorVoltageValue;
                String detectorTypeValue;
                String detectorSerialNumberValue;
                Float detectorOffsetValue;
                String detectorModelValue;
                String detectorManufacturerValue;
                String detectorIDValue;
                Float detectorGainValue = src.getDetectorGain(instrumentIndex, detectorIndex);
                if (detectorGainValue != null) {
                    dest.setDetectorGain(detectorGainValue, instrumentIndex, detectorIndex);
                }
                if ((detectorIDValue = src.getDetectorID(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorID(detectorIDValue, instrumentIndex, detectorIndex);
                }
                if ((detectorManufacturerValue = src.getDetectorManufacturer(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorManufacturer(detectorManufacturerValue, instrumentIndex, detectorIndex);
                }
                if ((detectorModelValue = src.getDetectorModel(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorModel(detectorModelValue, instrumentIndex, detectorIndex);
                }
                if ((detectorOffsetValue = src.getDetectorOffset(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorOffset(detectorOffsetValue, instrumentIndex, detectorIndex);
                }
                if ((detectorSerialNumberValue = src.getDetectorSerialNumber(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorSerialNumber(detectorSerialNumberValue, instrumentIndex, detectorIndex);
                }
                if ((detectorTypeValue = src.getDetectorType(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorType(detectorTypeValue, instrumentIndex, detectorIndex);
                }
                if ((detectorVoltageValue = src.getDetectorVoltage(instrumentIndex, detectorIndex)) == null) continue;
                dest.setDetectorVoltage(detectorVoltageValue, instrumentIndex, detectorIndex);
            }
            int lightSourceCount = src.getLightSourceCount(instrumentIndex);
            for (int lightSourceIndex = 0; lightSourceIndex < lightSourceCount; ++lightSourceIndex) {
                Integer laserWavelengthValue;
                String laserTypeValue;
                Boolean laserTuneableValue;
                String laserPulseValue;
                String laserLaserMediumValue;
                Integer laserFrequencyMultiplicationValue;
                String filamentTypeValue;
                String arcTypeValue;
                String lightSourceSerialNumberValue;
                Float lightSourcePowerValue;
                String lightSourceModelValue;
                String lightSourceManufacturerValue;
                String lightSourceIDValue = src.getLightSourceID(instrumentIndex, lightSourceIndex);
                if (lightSourceIDValue != null) {
                    dest.setLightSourceID(lightSourceIDValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourceManufacturerValue = src.getLightSourceManufacturer(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourceManufacturer(lightSourceManufacturerValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourceModelValue = src.getLightSourceModel(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourceModel(lightSourceModelValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourcePowerValue = src.getLightSourcePower(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourcePower(lightSourcePowerValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourceSerialNumberValue = src.getLightSourceSerialNumber(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourceSerialNumber(lightSourceSerialNumberValue, instrumentIndex, lightSourceIndex);
                }
                if ((arcTypeValue = src.getArcType(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setArcType(arcTypeValue, instrumentIndex, lightSourceIndex);
                }
                if ((filamentTypeValue = src.getFilamentType(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setFilamentType(filamentTypeValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserFrequencyMultiplicationValue = src.getLaserFrequencyMultiplication(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserFrequencyMultiplication(laserFrequencyMultiplicationValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserLaserMediumValue = src.getLaserLaserMedium(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserLaserMedium(laserLaserMediumValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserPulseValue = src.getLaserPulse(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserPulse(laserPulseValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserTuneableValue = src.getLaserTuneable(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserTuneable(laserTuneableValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserTypeValue = src.getLaserType(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserType(laserTypeValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserWavelengthValue = src.getLaserWavelength(instrumentIndex, lightSourceIndex)) == null) continue;
                dest.setLaserWavelength(laserWavelengthValue, instrumentIndex, lightSourceIndex);
            }
            int otfCount = src.getOTFCount(instrumentIndex);
            for (int otfIndex = 0; otfIndex < otfCount; ++otfIndex) {
                Integer otfSizeYValue;
                Integer otfSizeXValue;
                String otfPixelTypeValue;
                Boolean otfOpticalAxisAveragedValue;
                String otfObjectiveValue;
                String otfidValue = src.getOTFID(instrumentIndex, otfIndex);
                if (otfidValue != null) {
                    dest.setOTFID(otfidValue, instrumentIndex, otfIndex);
                }
                if ((otfObjectiveValue = src.getOTFObjective(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFObjective(otfObjectiveValue, instrumentIndex, otfIndex);
                }
                if ((otfOpticalAxisAveragedValue = src.getOTFOpticalAxisAveraged(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFOpticalAxisAveraged(otfOpticalAxisAveragedValue, instrumentIndex, otfIndex);
                }
                if ((otfPixelTypeValue = src.getOTFPixelType(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFPixelType(otfPixelTypeValue, instrumentIndex, otfIndex);
                }
                if ((otfSizeXValue = src.getOTFSizeX(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFSizeX(otfSizeXValue, instrumentIndex, otfIndex);
                }
                if ((otfSizeYValue = src.getOTFSizeY(instrumentIndex, otfIndex)) == null) continue;
                dest.setOTFSizeY(otfSizeYValue, instrumentIndex, otfIndex);
            }
            int objectiveCount = src.getObjectiveCount(instrumentIndex);
            for (int objectiveIndex = 0; objectiveIndex < objectiveCount; ++objectiveIndex) {
                Float objectiveWorkingDistanceValue;
                String objectiveSerialNumberValue;
                Integer objectiveNominalMagnificationValue;
                String objectiveModelValue;
                String objectiveManufacturerValue;
                Float objectiveLensNAValue;
                Boolean objectiveIrisValue;
                String objectiveImmersionValue;
                String objectiveIDValue;
                String objectiveCorrectionValue;
                Float objectiveCalibratedMagnificationValue = src.getObjectiveCalibratedMagnification(instrumentIndex, objectiveIndex);
                if (objectiveCalibratedMagnificationValue != null) {
                    dest.setObjectiveCalibratedMagnification(objectiveCalibratedMagnificationValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveCorrectionValue = src.getObjectiveCorrection(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveCorrection(objectiveCorrectionValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveIDValue = src.getObjectiveID(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveID(objectiveIDValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveImmersionValue = src.getObjectiveImmersion(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveImmersion(objectiveImmersionValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveIrisValue = src.getObjectiveIris(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveIris(objectiveIrisValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveLensNAValue = src.getObjectiveLensNA(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveLensNA(objectiveLensNAValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveManufacturerValue = src.getObjectiveManufacturer(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveManufacturer(objectiveManufacturerValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveModelValue = src.getObjectiveModel(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveModel(objectiveModelValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveNominalMagnificationValue = src.getObjectiveNominalMagnification(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveNominalMagnification(objectiveNominalMagnificationValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveSerialNumberValue = src.getObjectiveSerialNumber(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveSerialNumber(objectiveSerialNumberValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveWorkingDistanceValue = src.getObjectiveWorkingDistance(instrumentIndex, objectiveIndex)) == null) continue;
                dest.setObjectiveWorkingDistance(objectiveWorkingDistanceValue, instrumentIndex, objectiveIndex);
            }
        }
        int plateCount = src.getPlateCount();
        for (int plateIndex = 0; plateIndex < plateCount; ++plateIndex) {
            String plateStatusValue;
            String plateNameValue;
            String plateIDValue;
            String plateExternalIdentifierValue;
            String plateDescriptionValue = src.getPlateDescription(plateIndex);
            if (plateDescriptionValue != null) {
                dest.setPlateDescription(plateDescriptionValue, plateIndex);
            }
            if ((plateExternalIdentifierValue = src.getPlateExternalIdentifier(plateIndex)) != null) {
                dest.setPlateExternalIdentifier(plateExternalIdentifierValue, plateIndex);
            }
            if ((plateIDValue = src.getPlateID(plateIndex)) != null) {
                dest.setPlateID(plateIDValue, plateIndex);
            }
            if ((plateNameValue = src.getPlateName(plateIndex)) != null) {
                dest.setPlateName(plateNameValue, plateIndex);
            }
            if ((plateStatusValue = src.getPlateStatus(plateIndex)) != null) {
                dest.setPlateStatus(plateStatusValue, plateIndex);
            }
            int wellCount = src.getWellCount(plateIndex);
            for (int wellIndex = 0; wellIndex < wellCount; ++wellIndex) {
                String wellTypeValue;
                Integer wellRowValue;
                String wellIDValue;
                String wellExternalIdentifierValue;
                String wellExternalDescriptionValue;
                Integer wellColumnValue = src.getWellColumn(plateIndex, wellIndex);
                if (wellColumnValue != null) {
                    dest.setWellColumn(wellColumnValue, plateIndex, wellIndex);
                }
                if ((wellExternalDescriptionValue = src.getWellExternalDescription(plateIndex, wellIndex)) != null) {
                    dest.setWellExternalDescription(wellExternalDescriptionValue, plateIndex, wellIndex);
                }
                if ((wellExternalIdentifierValue = src.getWellExternalIdentifier(plateIndex, wellIndex)) != null) {
                    dest.setWellExternalIdentifier(wellExternalIdentifierValue, plateIndex, wellIndex);
                }
                if ((wellIDValue = src.getWellID(plateIndex, wellIndex)) != null) {
                    dest.setWellID(wellIDValue, plateIndex, wellIndex);
                }
                if ((wellRowValue = src.getWellRow(plateIndex, wellIndex)) != null) {
                    dest.setWellRow(wellRowValue, plateIndex, wellIndex);
                }
                if ((wellTypeValue = src.getWellType(plateIndex, wellIndex)) != null) {
                    dest.setWellType(wellTypeValue, plateIndex, wellIndex);
                }
                int wellSampleCount = src.getWellSampleCount(plateIndex, wellIndex);
                for (int wellSampleIndex = 0; wellSampleIndex < wellSampleCount; ++wellSampleIndex) {
                    Integer wellSampleTimepointValue;
                    Float wellSamplePosYValue;
                    Float wellSamplePosXValue;
                    Integer wellSampleIndexValue;
                    String wellSampleIDValue = src.getWellSampleID(plateIndex, wellIndex, wellSampleIndex);
                    if (wellSampleIDValue != null) {
                        dest.setWellSampleID(wellSampleIDValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSampleIndexValue = src.getWellSampleIndex(plateIndex, wellIndex, wellSampleIndex)) != null) {
                        dest.setWellSampleIndex(wellSampleIndexValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSamplePosXValue = src.getWellSamplePosX(plateIndex, wellIndex, wellSampleIndex)) != null) {
                        dest.setWellSamplePosX(wellSamplePosXValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSamplePosYValue = src.getWellSamplePosY(plateIndex, wellIndex, wellSampleIndex)) != null) {
                        dest.setWellSamplePosY(wellSamplePosYValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSampleTimepointValue = src.getWellSampleTimepoint(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
                    dest.setWellSampleTimepoint(wellSampleTimepointValue, plateIndex, wellIndex, wellSampleIndex);
                }
            }
        }
        int screenCount = src.getScreenCount();
        for (int screenIndex = 0; screenIndex < screenCount; ++screenIndex) {
            String screenTypeValue;
            String screenReagentSetDescriptionValue;
            String screenProtocolIdentifierValue;
            String screenProtocolDescriptionValue;
            String screenNameValue;
            String screenIDValue = src.getScreenID(screenIndex);
            if (screenIDValue != null) {
                dest.setScreenID(screenIDValue, screenIndex);
            }
            if ((screenNameValue = src.getScreenName(screenIndex)) != null) {
                dest.setScreenName(screenNameValue, screenIndex);
            }
            if ((screenProtocolDescriptionValue = src.getScreenProtocolDescription(screenIndex)) != null) {
                dest.setScreenProtocolDescription(screenProtocolDescriptionValue, screenIndex);
            }
            if ((screenProtocolIdentifierValue = src.getScreenProtocolIdentifier(screenIndex)) != null) {
                dest.setScreenProtocolIdentifier(screenProtocolIdentifierValue, screenIndex);
            }
            if ((screenReagentSetDescriptionValue = src.getScreenReagentSetDescription(screenIndex)) != null) {
                dest.setScreenReagentSetDescription(screenReagentSetDescriptionValue, screenIndex);
            }
            if ((screenTypeValue = src.getScreenType(screenIndex)) != null) {
                dest.setScreenType(screenTypeValue, screenIndex);
            }
            int plateRefCount = src.getPlateRefCount(screenIndex);
            for (int plateRefIndex = 0; plateRefIndex < plateRefCount; ++plateRefIndex) {
                String plateRefIDValue = src.getPlateRefID(screenIndex, plateRefIndex);
                if (plateRefIDValue == null) continue;
                dest.setPlateRefID(plateRefIDValue, screenIndex, plateRefIndex);
            }
            int reagentCount = src.getReagentCount(screenIndex);
            for (int reagentIndex = 0; reagentIndex < reagentCount; ++reagentIndex) {
                String reagentReagentIdentifierValue;
                String reagentNameValue;
                String reagentIDValue;
                String reagentDescriptionValue = src.getReagentDescription(screenIndex, reagentIndex);
                if (reagentDescriptionValue != null) {
                    dest.setReagentDescription(reagentDescriptionValue, screenIndex, reagentIndex);
                }
                if ((reagentIDValue = src.getReagentID(screenIndex, reagentIndex)) != null) {
                    dest.setReagentID(reagentIDValue, screenIndex, reagentIndex);
                }
                if ((reagentNameValue = src.getReagentName(screenIndex, reagentIndex)) != null) {
                    dest.setReagentName(reagentNameValue, screenIndex, reagentIndex);
                }
                if ((reagentReagentIdentifierValue = src.getReagentReagentIdentifier(screenIndex, reagentIndex)) == null) continue;
                dest.setReagentReagentIdentifier(reagentReagentIdentifierValue, screenIndex, reagentIndex);
            }
            int screenAcquisitionCount = src.getScreenAcquisitionCount(screenIndex);
            for (int screenAcquisitionIndex = 0; screenAcquisitionIndex < screenAcquisitionCount; ++screenAcquisitionIndex) {
                String screenAcquisitionStartTimeValue;
                String screenAcquisitionIDValue;
                String screenAcquisitionEndTimeValue = src.getScreenAcquisitionEndTime(screenIndex, screenAcquisitionIndex);
                if (screenAcquisitionEndTimeValue != null) {
                    dest.setScreenAcquisitionEndTime(screenAcquisitionEndTimeValue, screenIndex, screenAcquisitionIndex);
                }
                if ((screenAcquisitionIDValue = src.getScreenAcquisitionID(screenIndex, screenAcquisitionIndex)) != null) {
                    dest.setScreenAcquisitionID(screenAcquisitionIDValue, screenIndex, screenAcquisitionIndex);
                }
                if ((screenAcquisitionStartTimeValue = src.getScreenAcquisitionStartTime(screenIndex, screenAcquisitionIndex)) == null) continue;
                dest.setScreenAcquisitionStartTime(screenAcquisitionStartTimeValue, screenIndex, screenAcquisitionIndex);
            }
        }
    }
}

