/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.LogTools;
import loci.formats.ome.OMEXMLMetadata;
import ome.xml.OMEXMLFactory;
import ome.xml.OMEXMLNode;
import ome.xml.r200802.ome.ArcNode;
import ome.xml.r200802.ome.ChannelComponentNode;
import ome.xml.r200802.ome.DetectorNode;
import ome.xml.r200802.ome.DetectorRefNode;
import ome.xml.r200802.ome.DisplayOptionsNode;
import ome.xml.r200802.ome.ExperimentNode;
import ome.xml.r200802.ome.ExperimenterNode;
import ome.xml.r200802.ome.FilamentNode;
import ome.xml.r200802.ome.GroupRefNode;
import ome.xml.r200802.ome.ImageNode;
import ome.xml.r200802.ome.ImagingEnvironmentNode;
import ome.xml.r200802.ome.InstrumentNode;
import ome.xml.r200802.ome.InstrumentRefNode;
import ome.xml.r200802.ome.LaserNode;
import ome.xml.r200802.ome.LightSourceNode;
import ome.xml.r200802.ome.LightSourceRefNode;
import ome.xml.r200802.ome.LogicalChannelNode;
import ome.xml.r200802.ome.OMENode;
import ome.xml.r200802.ome.OTFNode;
import ome.xml.r200802.ome.OTFRefNode;
import ome.xml.r200802.ome.ObjectiveNode;
import ome.xml.r200802.ome.ObjectiveRefNode;
import ome.xml.r200802.ome.PixelsNode;
import ome.xml.r200802.ome.PlaneNode;
import ome.xml.r200802.ome.PlaneTimingNode;
import ome.xml.r200802.ome.ProjectionNode;
import ome.xml.r200802.ome.ROINode;
import ome.xml.r200802.ome.StageLabelNode;
import ome.xml.r200802.ome.StagePositionNode;
import ome.xml.r200802.ome.TiffDataNode;
import ome.xml.r200802.ome.TimeNode;
import ome.xml.r200802.ome.UUIDNode;
import ome.xml.r200802.spw.PlateNode;
import ome.xml.r200802.spw.PlateRefNode;
import ome.xml.r200802.spw.ReagentNode;
import ome.xml.r200802.spw.ScreenAcquisitionNode;
import ome.xml.r200802.spw.ScreenNode;
import ome.xml.r200802.spw.WellNode;
import ome.xml.r200802.spw.WellSampleNode;
import org.xml.sax.SAXException;

public class OMEXML200802Metadata
extends OMEXMLMetadata {
    private ExperimentNode experimentNode = null;
    private int experimentNodeExperimentIndex = -1;
    private ExperimenterNode experimenterNode = null;
    private int experimenterNodeExperimenterIndex = -1;
    private GroupRefNode experimenterGroupRefNode = null;
    private int experimenterGroupRefNodeExperimenterIndex = -1;
    private int experimenterGroupRefNodeGroupRefIndex = -1;
    private ImageNode imageNode = null;
    private int imageNodeImageIndex = -1;
    private DisplayOptionsNode imageDisplayOptionsNode = null;
    private int imageDisplayOptionsNodeImageIndex = -1;
    private ProjectionNode imageDisplayOptionsProjectionNode = null;
    private int imageDisplayOptionsProjectionNodeImageIndex = -1;
    private ROINode imageDisplayOptionsROINode = null;
    private int imageDisplayOptionsROINodeImageIndex = -1;
    private int imageDisplayOptionsROINodeROIIndex = -1;
    private TimeNode imageDisplayOptionsTimeNode = null;
    private int imageDisplayOptionsTimeNodeImageIndex = -1;
    private ImagingEnvironmentNode imageImagingEnvironmentNode = null;
    private int imageImagingEnvironmentNodeImageIndex = -1;
    private LogicalChannelNode imageLogicalChannelNode = null;
    private int imageLogicalChannelNodeImageIndex = -1;
    private int imageLogicalChannelNodeLogicalChannelIndex = -1;
    private ChannelComponentNode imageLogicalChannelChannelComponentNode = null;
    private int imageLogicalChannelChannelComponentNodeImageIndex = -1;
    private int imageLogicalChannelChannelComponentNodeLogicalChannelIndex = -1;
    private int imageLogicalChannelChannelComponentNodeChannelComponentIndex = -1;
    private DetectorRefNode imageLogicalChannelDetectorRefNode = null;
    private int imageLogicalChannelDetectorRefNodeImageIndex = -1;
    private int imageLogicalChannelDetectorRefNodeLogicalChannelIndex = -1;
    private LightSourceRefNode imageLogicalChannelLightSourceRefNode = null;
    private int imageLogicalChannelLightSourceRefNodeImageIndex = -1;
    private int imageLogicalChannelLightSourceRefNodeLogicalChannelIndex = -1;
    private OTFRefNode imageLogicalChannelOTFRefNode = null;
    private int imageLogicalChannelOTFRefNodeImageIndex = -1;
    private int imageLogicalChannelOTFRefNodeLogicalChannelIndex = -1;
    private ObjectiveRefNode imageObjectiveRefNode = null;
    private int imageObjectiveRefNodeImageIndex = -1;
    private PixelsNode imagePixelsNode = null;
    private int imagePixelsNodeImageIndex = -1;
    private int imagePixelsNodePixelsIndex = -1;
    private PlaneNode imagePixelsPlaneNode = null;
    private int imagePixelsPlaneNodeImageIndex = -1;
    private int imagePixelsPlaneNodePixelsIndex = -1;
    private int imagePixelsPlaneNodePlaneIndex = -1;
    private PlaneTimingNode imagePixelsPlanePlaneTimingNode = null;
    private int imagePixelsPlanePlaneTimingNodeImageIndex = -1;
    private int imagePixelsPlanePlaneTimingNodePixelsIndex = -1;
    private int imagePixelsPlanePlaneTimingNodePlaneIndex = -1;
    private StagePositionNode imagePixelsPlaneStagePositionNode = null;
    private int imagePixelsPlaneStagePositionNodeImageIndex = -1;
    private int imagePixelsPlaneStagePositionNodePixelsIndex = -1;
    private int imagePixelsPlaneStagePositionNodePlaneIndex = -1;
    private TiffDataNode imagePixelsTiffDataNode = null;
    private int imagePixelsTiffDataNodeImageIndex = -1;
    private int imagePixelsTiffDataNodePixelsIndex = -1;
    private int imagePixelsTiffDataNodeTiffDataIndex = -1;
    private UUIDNode imagePixelsTiffDataUUIDNode = null;
    private int imagePixelsTiffDataUUIDNodeImageIndex = -1;
    private int imagePixelsTiffDataUUIDNodePixelsIndex = -1;
    private int imagePixelsTiffDataUUIDNodeTiffDataIndex = -1;
    private StageLabelNode imageStageLabelNode = null;
    private int imageStageLabelNodeImageIndex = -1;
    private InstrumentNode instrumentNode = null;
    private int instrumentNodeInstrumentIndex = -1;
    private DetectorNode instrumentDetectorNode = null;
    private int instrumentDetectorNodeInstrumentIndex = -1;
    private int instrumentDetectorNodeDetectorIndex = -1;
    private LightSourceNode instrumentLightSourceNode = null;
    private int instrumentLightSourceNodeInstrumentIndex = -1;
    private int instrumentLightSourceNodeLightSourceIndex = -1;
    private ArcNode instrumentLightSourceArcNode = null;
    private int instrumentLightSourceArcNodeInstrumentIndex = -1;
    private int instrumentLightSourceArcNodeLightSourceIndex = -1;
    private FilamentNode instrumentLightSourceFilamentNode = null;
    private int instrumentLightSourceFilamentNodeInstrumentIndex = -1;
    private int instrumentLightSourceFilamentNodeLightSourceIndex = -1;
    private LaserNode instrumentLightSourceLaserNode = null;
    private int instrumentLightSourceLaserNodeInstrumentIndex = -1;
    private int instrumentLightSourceLaserNodeLightSourceIndex = -1;
    private OTFNode instrumentOTFNode = null;
    private int instrumentOTFNodeInstrumentIndex = -1;
    private int instrumentOTFNodeOTFIndex = -1;
    private ObjectiveRefNode instrumentOTFObjectiveRefNode = null;
    private int instrumentOTFObjectiveRefNodeInstrumentIndex = -1;
    private int instrumentOTFObjectiveRefNodeOTFIndex = -1;
    private ObjectiveNode instrumentObjectiveNode = null;
    private int instrumentObjectiveNodeInstrumentIndex = -1;
    private int instrumentObjectiveNodeObjectiveIndex = -1;
    private PlateNode plateNode = null;
    private int plateNodePlateIndex = -1;
    private WellNode plateWellNode = null;
    private int plateWellNodePlateIndex = -1;
    private int plateWellNodeWellIndex = -1;
    private WellSampleNode plateWellWellSampleNode = null;
    private int plateWellWellSampleNodePlateIndex = -1;
    private int plateWellWellSampleNodeWellIndex = -1;
    private int plateWellWellSampleNodeWellSampleIndex = -1;
    private ScreenNode screenNode = null;
    private int screenNodeScreenIndex = -1;
    private PlateRefNode screenPlateRefNode = null;
    private int screenPlateRefNodeScreenIndex = -1;
    private int screenPlateRefNodePlateRefIndex = -1;
    private ReagentNode screenReagentNode = null;
    private int screenReagentNodeScreenIndex = -1;
    private int screenReagentNodeReagentIndex = -1;
    private ScreenAcquisitionNode screenScreenAcquisitionNode = null;
    private int screenScreenAcquisitionNodeScreenIndex = -1;
    private int screenScreenAcquisitionNodeScreenAcquisitionIndex = -1;

    public int getChannelComponentCount(int imageIndex, int logicalChannelIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getChannelComponentNode(imageIndex, logicalChannelIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getDetectorCount(int instrumentIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getDetectorNode(instrumentIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getExperimentCount() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getExperimentNode(i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getExperimenterCount() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getExperimenterNode(i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getExperimenterMembershipCount(int experimenterIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getGroupRefNode(experimenterIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getGroupRefCount(int experimenterIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getGroupRefNode(experimenterIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getImageCount() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getImageNode(i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getInstrumentCount() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getInstrumentNode(i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getLightSourceCount(int instrumentIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getLightSourceNode(instrumentIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getLogicalChannelCount(int imageIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getLogicalChannelNode(imageIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getOTFCount(int instrumentIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getOTFNode(instrumentIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getObjectiveCount(int instrumentIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getObjectiveNode(instrumentIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getPixelsCount(int imageIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getPixelsNode(imageIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getPlaneCount(int imageIndex, int pixelsIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getPlaneNode(imageIndex, pixelsIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getPlateCount() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getPlateNode(i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getPlateRefCount(int screenIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getPlateRefNode(screenIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getROICount(int imageIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getROINode(imageIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getReagentCount(int screenIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getReagentNode(screenIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getScreenCount() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getScreenNode(i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getScreenAcquisitionCount(int screenIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getScreenAcquisitionNode(screenIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getTiffDataCount(int imageIndex, int pixelsIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getTiffDataNode(imageIndex, pixelsIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getWellCount(int plateIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getWellNode(plateIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public int getWellSampleCount(int plateIndex, int wellIndex) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.getWellSampleNode(plateIndex, wellIndex, i, false) != null) continue;
            return i;
        }
        return -1;
    }

    public String getArcType(int instrumentIndex, int lightSourceIndex) {
        ArcNode arc = this.getArcNode(instrumentIndex, lightSourceIndex, false);
        return arc == null ? null : arc.getType();
    }

    public String getChannelComponentColorDomain(int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        ChannelComponentNode channelComponent = this.getChannelComponentNode(imageIndex, logicalChannelIndex, channelComponentIndex, false);
        return channelComponent == null ? null : channelComponent.getColorDomain();
    }

    public Integer getChannelComponentIndex(int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        ChannelComponentNode channelComponent = this.getChannelComponentNode(imageIndex, logicalChannelIndex, channelComponentIndex, false);
        return channelComponent == null ? null : channelComponent.getIndex();
    }

    public Float getDetectorGain(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getGain();
    }

    public String getDetectorID(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getNodeID();
    }

    public String getDetectorManufacturer(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getManufacturer();
    }

    public String getDetectorModel(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getModel();
    }

    public Float getDetectorOffset(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getOffset();
    }

    public String getDetectorSerialNumber(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getSerialNumber();
    }

    public String getDetectorType(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getType();
    }

    public Float getDetectorVoltage(int instrumentIndex, int detectorIndex) {
        DetectorNode detector = this.getDetectorNode(instrumentIndex, detectorIndex, false);
        return detector == null ? null : detector.getVoltage();
    }

    public String getDetectorSettingsBinning(int imageIndex, int logicalChannelIndex) {
        DetectorRefNode detectorRef = this.getDetectorRefNode(imageIndex, logicalChannelIndex, false);
        return detectorRef == null ? null : detectorRef.getBinning();
    }

    public String getDetectorSettingsDetector(int imageIndex, int logicalChannelIndex) {
        DetectorRefNode detectorRef = this.getDetectorRefNode(imageIndex, logicalChannelIndex, false);
        return detectorRef == null ? null : detectorRef.getNodeID();
    }

    public Float getDetectorSettingsGain(int imageIndex, int logicalChannelIndex) {
        DetectorRefNode detectorRef = this.getDetectorRefNode(imageIndex, logicalChannelIndex, false);
        return detectorRef == null ? null : detectorRef.getGain();
    }

    public Float getDetectorSettingsOffset(int imageIndex, int logicalChannelIndex) {
        DetectorRefNode detectorRef = this.getDetectorRefNode(imageIndex, logicalChannelIndex, false);
        return detectorRef == null ? null : detectorRef.getOffset();
    }

    public Float getDetectorSettingsReadOutRate(int imageIndex, int logicalChannelIndex) {
        DetectorRefNode detectorRef = this.getDetectorRefNode(imageIndex, logicalChannelIndex, false);
        return detectorRef == null ? null : detectorRef.getReadOutRate();
    }

    public Float getDetectorSettingsVoltage(int imageIndex, int logicalChannelIndex) {
        DetectorRefNode detectorRef = this.getDetectorRefNode(imageIndex, logicalChannelIndex, false);
        return detectorRef == null ? null : detectorRef.getVoltage();
    }

    public Float getDimensionsPhysicalSizeX(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getPhysicalSizeX();
    }

    public Float getDimensionsPhysicalSizeY(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getPhysicalSizeY();
    }

    public Float getDimensionsPhysicalSizeZ(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getPhysicalSizeZ();
    }

    public Float getDimensionsTimeIncrement(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getTimeIncrement();
    }

    public Integer getDimensionsWaveIncrement(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getWaveIncrement();
    }

    public Integer getDimensionsWaveStart(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getWaveStart();
    }

    public String getDisplayOptionsID(int imageIndex) {
        DisplayOptionsNode displayOptions = this.getDisplayOptionsNode(imageIndex, false);
        return displayOptions == null ? null : displayOptions.getNodeID();
    }

    public Float getDisplayOptionsZoom(int imageIndex) {
        DisplayOptionsNode displayOptions = this.getDisplayOptionsNode(imageIndex, false);
        return displayOptions == null ? null : displayOptions.getZoom();
    }

    public Integer getDisplayOptionsProjectionZStart(int imageIndex) {
        ProjectionNode projection = this.getProjectionNode(imageIndex, false);
        return projection == null ? null : projection.getZStart();
    }

    public Integer getDisplayOptionsProjectionZStop(int imageIndex) {
        ProjectionNode projection = this.getProjectionNode(imageIndex, false);
        return projection == null ? null : projection.getZStop();
    }

    public Integer getDisplayOptionsTimeTStart(int imageIndex) {
        TimeNode time = this.getTimeNode(imageIndex, false);
        return time == null ? null : time.getTStart();
    }

    public Integer getDisplayOptionsTimeTStop(int imageIndex) {
        TimeNode time = this.getTimeNode(imageIndex, false);
        return time == null ? null : time.getTStop();
    }

    public String getExperimentDescription(int experimentIndex) {
        ExperimentNode experiment = this.getExperimentNode(experimentIndex, false);
        return experiment == null ? null : experiment.getDescription();
    }

    public String getExperimentID(int experimentIndex) {
        ExperimentNode experiment = this.getExperimentNode(experimentIndex, false);
        return experiment == null ? null : experiment.getNodeID();
    }

    public String getExperimentType(int experimentIndex) {
        ExperimentNode experiment = this.getExperimentNode(experimentIndex, false);
        return experiment == null ? null : experiment.getType();
    }

    public String getExperimenterEmail(int experimenterIndex) {
        ExperimenterNode experimenter = this.getExperimenterNode(experimenterIndex, false);
        return experimenter == null ? null : experimenter.getEmail();
    }

    public String getExperimenterFirstName(int experimenterIndex) {
        ExperimenterNode experimenter = this.getExperimenterNode(experimenterIndex, false);
        return experimenter == null ? null : experimenter.getFirstName();
    }

    public String getExperimenterID(int experimenterIndex) {
        ExperimenterNode experimenter = this.getExperimenterNode(experimenterIndex, false);
        return experimenter == null ? null : experimenter.getNodeID();
    }

    public String getExperimenterInstitution(int experimenterIndex) {
        ExperimenterNode experimenter = this.getExperimenterNode(experimenterIndex, false);
        return experimenter == null ? null : experimenter.getInstitution();
    }

    public String getExperimenterLastName(int experimenterIndex) {
        ExperimenterNode experimenter = this.getExperimenterNode(experimenterIndex, false);
        return experimenter == null ? null : experimenter.getLastName();
    }

    public String getExperimenterMembershipGroup(int experimenterIndex, int groupRefIndex) {
        GroupRefNode groupRef = this.getGroupRefNode(experimenterIndex, groupRefIndex, false);
        return groupRef == null ? null : groupRef.getNodeID();
    }

    public String getFilamentType(int instrumentIndex, int lightSourceIndex) {
        FilamentNode filament = this.getFilamentNode(instrumentIndex, lightSourceIndex, false);
        return filament == null ? null : filament.getType();
    }

    public String getImageCreationDate(int imageIndex) {
        ImageNode image = this.getImageNode(imageIndex, false);
        return image == null ? null : image.getCreationDate();
    }

    public String getImageDefaultPixels(int imageIndex) {
        ImageNode image = this.getImageNode(imageIndex, false);
        return image == null ? null : image.getDefaultPixels();
    }

    public String getImageDescription(int imageIndex) {
        ImageNode image = this.getImageNode(imageIndex, false);
        return image == null ? null : image.getDescription();
    }

    public String getImageID(int imageIndex) {
        ImageNode image = this.getImageNode(imageIndex, false);
        return image == null ? null : image.getNodeID();
    }

    public String getImageInstrumentRef(int imageIndex) {
        ImageNode image = this.getImageNode(imageIndex, false);
        InstrumentNode node2 = image.getInstrument();
        if (node2 == null) {
            return null;
        }
        return node2.getNodeID();
    }

    public String getImageName(int imageIndex) {
        ImageNode image = this.getImageNode(imageIndex, false);
        return image == null ? null : image.getName();
    }

    public Float getImagingEnvironmentAirPressure(int imageIndex) {
        ImagingEnvironmentNode imagingEnvironment = this.getImagingEnvironmentNode(imageIndex, false);
        return imagingEnvironment == null ? null : imagingEnvironment.getAirPressure();
    }

    public Float getImagingEnvironmentCO2Percent(int imageIndex) {
        ImagingEnvironmentNode imagingEnvironment = this.getImagingEnvironmentNode(imageIndex, false);
        return imagingEnvironment == null ? null : imagingEnvironment.getCO2Percent();
    }

    public Float getImagingEnvironmentHumidity(int imageIndex) {
        ImagingEnvironmentNode imagingEnvironment = this.getImagingEnvironmentNode(imageIndex, false);
        return imagingEnvironment == null ? null : imagingEnvironment.getHumidity();
    }

    public Float getImagingEnvironmentTemperature(int imageIndex) {
        ImagingEnvironmentNode imagingEnvironment = this.getImagingEnvironmentNode(imageIndex, false);
        return imagingEnvironment == null ? null : imagingEnvironment.getTemperature();
    }

    public String getInstrumentID(int instrumentIndex) {
        InstrumentNode instrument = this.getInstrumentNode(instrumentIndex, false);
        return instrument == null ? null : instrument.getNodeID();
    }

    public Integer getLaserFrequencyMultiplication(int instrumentIndex, int lightSourceIndex) {
        LaserNode laser = this.getLaserNode(instrumentIndex, lightSourceIndex, false);
        return laser == null ? null : laser.getFrequencyMultiplication();
    }

    public String getLaserLaserMedium(int instrumentIndex, int lightSourceIndex) {
        LaserNode laser = this.getLaserNode(instrumentIndex, lightSourceIndex, false);
        return laser == null ? null : laser.getLaserMedium();
    }

    public String getLaserPulse(int instrumentIndex, int lightSourceIndex) {
        LaserNode laser = this.getLaserNode(instrumentIndex, lightSourceIndex, false);
        return laser == null ? null : laser.getPulse();
    }

    public Boolean getLaserTuneable(int instrumentIndex, int lightSourceIndex) {
        LaserNode laser = this.getLaserNode(instrumentIndex, lightSourceIndex, false);
        return laser == null ? null : laser.getTuneable();
    }

    public String getLaserType(int instrumentIndex, int lightSourceIndex) {
        LaserNode laser = this.getLaserNode(instrumentIndex, lightSourceIndex, false);
        return laser == null ? null : laser.getType();
    }

    public Integer getLaserWavelength(int instrumentIndex, int lightSourceIndex) {
        LaserNode laser = this.getLaserNode(instrumentIndex, lightSourceIndex, false);
        return laser == null ? null : laser.getWavelength();
    }

    public String getLightSourceID(int instrumentIndex, int lightSourceIndex) {
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, false);
        return lightSource == null ? null : lightSource.getNodeID();
    }

    public String getLightSourceManufacturer(int instrumentIndex, int lightSourceIndex) {
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, false);
        return lightSource == null ? null : lightSource.getManufacturer();
    }

    public String getLightSourceModel(int instrumentIndex, int lightSourceIndex) {
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, false);
        return lightSource == null ? null : lightSource.getModel();
    }

    public Float getLightSourcePower(int instrumentIndex, int lightSourceIndex) {
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, false);
        return lightSource == null ? null : lightSource.getPower();
    }

    public String getLightSourceSerialNumber(int instrumentIndex, int lightSourceIndex) {
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, false);
        return lightSource == null ? null : lightSource.getSerialNumber();
    }

    public Float getLightSourceSettingsAttenuation(int imageIndex, int logicalChannelIndex) {
        LightSourceRefNode lightSourceRef = this.getLightSourceRefNode(imageIndex, logicalChannelIndex, false);
        return lightSourceRef == null ? null : lightSourceRef.getAttenuation();
    }

    public String getLightSourceSettingsLightSource(int imageIndex, int logicalChannelIndex) {
        LightSourceRefNode lightSourceRef = this.getLightSourceRefNode(imageIndex, logicalChannelIndex, false);
        return lightSourceRef == null ? null : lightSourceRef.getNodeID();
    }

    public Integer getLightSourceSettingsWavelength(int imageIndex, int logicalChannelIndex) {
        LightSourceRefNode lightSourceRef = this.getLightSourceRefNode(imageIndex, logicalChannelIndex, false);
        return lightSourceRef == null ? null : lightSourceRef.getWavelength();
    }

    public String getLogicalChannelContrastMethod(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getContrastMethod();
    }

    public Integer getLogicalChannelEmWave(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getEmWave();
    }

    public Integer getLogicalChannelExWave(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getExWave();
    }

    public String getLogicalChannelFluor(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getFluor();
    }

    public String getLogicalChannelID(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getNodeID();
    }

    public String getLogicalChannelIlluminationType(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getIlluminationType();
    }

    public String getLogicalChannelMode(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getMode();
    }

    public String getLogicalChannelName(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getName();
    }

    public Float getLogicalChannelNdFilter(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getNdFilter();
    }

    public String getLogicalChannelOTF(int imageIndex, int logicalChannelIndex) {
        OTFRefNode otfRef = this.getOTFRefNode(imageIndex, logicalChannelIndex, false);
        return otfRef == null ? null : otfRef.getNodeID();
    }

    public String getLogicalChannelPhotometricInterpretation(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getPhotometricInterpretation();
    }

    public Float getLogicalChannelPinholeSize(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : this.integerToFloat(logicalChannel.getPinholeSize());
    }

    public Integer getLogicalChannelPockelCellSetting(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getPockelCellSetting();
    }

    public Integer getLogicalChannelSamplesPerPixel(int imageIndex, int logicalChannelIndex) {
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, false);
        return logicalChannel == null ? null : logicalChannel.getSamplesPerPixel();
    }

    public String getOTFID(int instrumentIndex, int otfIndex) {
        OTFNode otf = this.getOTFNode(instrumentIndex, otfIndex, false);
        return otf == null ? null : otf.getNodeID();
    }

    public String getOTFObjective(int instrumentIndex, int otfIndex) {
        ObjectiveRefNode objectiveRef = this.getObjectiveRefNode(instrumentIndex, otfIndex, false);
        return objectiveRef == null ? null : objectiveRef.getNodeID();
    }

    public Boolean getOTFOpticalAxisAveraged(int instrumentIndex, int otfIndex) {
        OTFNode otf = this.getOTFNode(instrumentIndex, otfIndex, false);
        return otf == null ? null : otf.getOpticalAxisAveraged();
    }

    public String getOTFPixelType(int instrumentIndex, int otfIndex) {
        OTFNode otf = this.getOTFNode(instrumentIndex, otfIndex, false);
        return otf == null ? null : otf.getPixelType();
    }

    public Integer getOTFSizeX(int instrumentIndex, int otfIndex) {
        OTFNode otf = this.getOTFNode(instrumentIndex, otfIndex, false);
        return otf == null ? null : otf.getSizeX();
    }

    public Integer getOTFSizeY(int instrumentIndex, int otfIndex) {
        OTFNode otf = this.getOTFNode(instrumentIndex, otfIndex, false);
        return otf == null ? null : otf.getSizeY();
    }

    public Float getObjectiveCalibratedMagnification(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getCalibratedMagnification();
    }

    public String getObjectiveCorrection(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getCorrection();
    }

    public String getObjectiveID(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getNodeID();
    }

    public String getObjectiveImmersion(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getImmersion();
    }

    public Boolean getObjectiveIris(int instrumentIndex, int objectiveIndex) {
        return null;
    }

    public Float getObjectiveLensNA(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getLensNA();
    }

    public String getObjectiveManufacturer(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getManufacturer();
    }

    public String getObjectiveModel(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getModel();
    }

    public Integer getObjectiveNominalMagnification(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getNominalMagnification();
    }

    public String getObjectiveSerialNumber(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getSerialNumber();
    }

    public Float getObjectiveWorkingDistance(int instrumentIndex, int objectiveIndex) {
        ObjectiveNode objective = this.getObjectiveNode(instrumentIndex, objectiveIndex, false);
        return objective == null ? null : objective.getWorkingDistance();
    }

    public Float getObjectiveSettingsCorrectionCollar(int imageIndex) {
        ObjectiveRefNode objectiveRef = this.getObjectiveRefNode(imageIndex, false);
        return objectiveRef == null ? null : objectiveRef.getCorrectionCollar();
    }

    public String getObjectiveSettingsMedium(int imageIndex) {
        ObjectiveRefNode objectiveRef = this.getObjectiveRefNode(imageIndex, false);
        return objectiveRef == null ? null : objectiveRef.getMedium();
    }

    public String getObjectiveSettingsObjective(int imageIndex) {
        ObjectiveRefNode objectiveRef = this.getObjectiveRefNode(imageIndex, false);
        return objectiveRef == null ? null : objectiveRef.getNodeID();
    }

    public Float getObjectiveSettingsRefractiveIndex(int imageIndex) {
        ObjectiveRefNode objectiveRef = this.getObjectiveRefNode(imageIndex, false);
        return objectiveRef == null ? null : objectiveRef.getRefractiveIndex();
    }

    public Boolean getPixelsBigEndian(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getBigEndian();
    }

    public String getPixelsDimensionOrder(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getDimensionOrder();
    }

    public String getPixelsID(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getNodeID();
    }

    public String getPixelsPixelType(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getPixelType();
    }

    public Integer getPixelsSizeC(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getSizeC();
    }

    public Integer getPixelsSizeT(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getSizeT();
    }

    public Integer getPixelsSizeX(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getSizeX();
    }

    public Integer getPixelsSizeY(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getSizeY();
    }

    public Integer getPixelsSizeZ(int imageIndex, int pixelsIndex) {
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, false);
        return pixels == null ? null : pixels.getSizeZ();
    }

    public Integer getPlaneTheC(int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneNode plane = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, false);
        return plane == null ? null : plane.getTheC();
    }

    public Integer getPlaneTheT(int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneNode plane = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, false);
        return plane == null ? null : plane.getTheT();
    }

    public Integer getPlaneTheZ(int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneNode plane = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, false);
        return plane == null ? null : plane.getTheZ();
    }

    public Float getPlaneTimingDeltaT(int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneTimingNode planeTiming = this.getPlaneTimingNode(imageIndex, pixelsIndex, planeIndex, false);
        return planeTiming == null ? null : planeTiming.getDeltaT();
    }

    public Float getPlaneTimingExposureTime(int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneTimingNode planeTiming = this.getPlaneTimingNode(imageIndex, pixelsIndex, planeIndex, false);
        return planeTiming == null ? null : planeTiming.getExposureTime();
    }

    public String getPlateDescription(int plateIndex) {
        PlateNode plate = this.getPlateNode(plateIndex, false);
        return plate == null ? null : plate.getDescription();
    }

    public String getPlateExternalIdentifier(int plateIndex) {
        PlateNode plate = this.getPlateNode(plateIndex, false);
        return plate == null ? null : plate.getExternalIdentifier();
    }

    public String getPlateID(int plateIndex) {
        PlateNode plate = this.getPlateNode(plateIndex, false);
        return plate == null ? null : plate.getNodeID();
    }

    public String getPlateName(int plateIndex) {
        PlateNode plate = this.getPlateNode(plateIndex, false);
        return plate == null ? null : plate.getName();
    }

    public String getPlateStatus(int plateIndex) {
        PlateNode plate = this.getPlateNode(plateIndex, false);
        return plate == null ? null : plate.getStatus();
    }

    public String getPlateRefID(int screenIndex, int plateRefIndex) {
        PlateRefNode plateRef = this.getPlateRefNode(screenIndex, plateRefIndex, false);
        return plateRef == null ? null : plateRef.getNodeID();
    }

    public String getROIID(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getNodeID();
    }

    public Integer getROIT0(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getT0();
    }

    public Integer getROIT1(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getT1();
    }

    public Integer getROIX0(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getX0();
    }

    public Integer getROIX1(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getX1();
    }

    public Integer getROIY0(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getY0();
    }

    public Integer getROIY1(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getY1();
    }

    public Integer getROIZ0(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getZ0();
    }

    public Integer getROIZ1(int imageIndex, int roiIndex) {
        ROINode roi = this.getROINode(imageIndex, roiIndex, false);
        return roi == null ? null : roi.getZ1();
    }

    public String getReagentDescription(int screenIndex, int reagentIndex) {
        ReagentNode reagent = this.getReagentNode(screenIndex, reagentIndex, false);
        return reagent == null ? null : reagent.getDescription();
    }

    public String getReagentID(int screenIndex, int reagentIndex) {
        ReagentNode reagent = this.getReagentNode(screenIndex, reagentIndex, false);
        return reagent == null ? null : reagent.getNodeID();
    }

    public String getReagentName(int screenIndex, int reagentIndex) {
        ReagentNode reagent = this.getReagentNode(screenIndex, reagentIndex, false);
        return reagent == null ? null : reagent.getName();
    }

    public String getReagentReagentIdentifier(int screenIndex, int reagentIndex) {
        ReagentNode reagent = this.getReagentNode(screenIndex, reagentIndex, false);
        return reagent == null ? null : reagent.getReagentIdentifier();
    }

    public String getScreenID(int screenIndex) {
        ScreenNode screen = this.getScreenNode(screenIndex, false);
        return screen == null ? null : screen.getNodeID();
    }

    public String getScreenName(int screenIndex) {
        ScreenNode screen = this.getScreenNode(screenIndex, false);
        return screen == null ? null : screen.getName();
    }

    public String getScreenProtocolDescription(int screenIndex) {
        ScreenNode screen = this.getScreenNode(screenIndex, false);
        return screen == null ? null : screen.getProtocolDescription();
    }

    public String getScreenProtocolIdentifier(int screenIndex) {
        ScreenNode screen = this.getScreenNode(screenIndex, false);
        return screen == null ? null : screen.getProtocolIdentifier();
    }

    public String getScreenReagentSetDescription(int screenIndex) {
        ScreenNode screen = this.getScreenNode(screenIndex, false);
        return screen == null ? null : screen.getReagentSetDescription();
    }

    public String getScreenType(int screenIndex) {
        ScreenNode screen = this.getScreenNode(screenIndex, false);
        return screen == null ? null : screen.getType();
    }

    public String getScreenAcquisitionEndTime(int screenIndex, int screenAcquisitionIndex) {
        ScreenAcquisitionNode screenAcquisition = this.getScreenAcquisitionNode(screenIndex, screenAcquisitionIndex, false);
        return screenAcquisition == null ? null : screenAcquisition.getEndTime();
    }

    public String getScreenAcquisitionID(int screenIndex, int screenAcquisitionIndex) {
        ScreenAcquisitionNode screenAcquisition = this.getScreenAcquisitionNode(screenIndex, screenAcquisitionIndex, false);
        return screenAcquisition == null ? null : screenAcquisition.getNodeID();
    }

    public String getScreenAcquisitionStartTime(int screenIndex, int screenAcquisitionIndex) {
        ScreenAcquisitionNode screenAcquisition = this.getScreenAcquisitionNode(screenIndex, screenAcquisitionIndex, false);
        return screenAcquisition == null ? null : screenAcquisition.getStartTime();
    }

    public String getStageLabelName(int imageIndex) {
        StageLabelNode stageLabel = this.getStageLabelNode(imageIndex, false);
        return stageLabel == null ? null : stageLabel.getName();
    }

    public Float getStageLabelX(int imageIndex) {
        StageLabelNode stageLabel = this.getStageLabelNode(imageIndex, false);
        return stageLabel == null ? null : stageLabel.getX();
    }

    public Float getStageLabelY(int imageIndex) {
        StageLabelNode stageLabel = this.getStageLabelNode(imageIndex, false);
        return stageLabel == null ? null : stageLabel.getY();
    }

    public Float getStageLabelZ(int imageIndex) {
        StageLabelNode stageLabel = this.getStageLabelNode(imageIndex, false);
        return stageLabel == null ? null : stageLabel.getZ();
    }

    public Float getStagePositionPositionX(int imageIndex, int pixelsIndex, int planeIndex) {
        StagePositionNode stagePosition = this.getStagePositionNode(imageIndex, pixelsIndex, planeIndex, false);
        return stagePosition == null ? null : stagePosition.getPositionX();
    }

    public Float getStagePositionPositionY(int imageIndex, int pixelsIndex, int planeIndex) {
        StagePositionNode stagePosition = this.getStagePositionNode(imageIndex, pixelsIndex, planeIndex, false);
        return stagePosition == null ? null : stagePosition.getPositionY();
    }

    public Float getStagePositionPositionZ(int imageIndex, int pixelsIndex, int planeIndex) {
        StagePositionNode stagePosition = this.getStagePositionNode(imageIndex, pixelsIndex, planeIndex, false);
        return stagePosition == null ? null : stagePosition.getPositionZ();
    }

    public String getTiffDataFileName(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        UUIDNode uuid = this.getUUIDNode(imageIndex, pixelsIndex, tiffDataIndex, false);
        return uuid == null ? null : uuid.getFileName();
    }

    public Integer getTiffDataFirstC(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        TiffDataNode tiffData = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, false);
        return tiffData == null ? null : tiffData.getFirstC();
    }

    public Integer getTiffDataFirstT(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        TiffDataNode tiffData = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, false);
        return tiffData == null ? null : tiffData.getFirstT();
    }

    public Integer getTiffDataFirstZ(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        TiffDataNode tiffData = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, false);
        return tiffData == null ? null : tiffData.getFirstZ();
    }

    public Integer getTiffDataIFD(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        TiffDataNode tiffData = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, false);
        return tiffData == null ? null : tiffData.getIFD();
    }

    public Integer getTiffDataNumPlanes(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        TiffDataNode tiffData = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, false);
        return tiffData == null ? null : tiffData.getNumPlanes();
    }

    public String getTiffDataUUID(int imageIndex, int pixelsIndex, int tiffDataIndex) {
        UUIDNode uuid = this.getUUIDNode(imageIndex, pixelsIndex, tiffDataIndex, false);
        return uuid == null ? null : uuid.getCData();
    }

    public Integer getWellColumn(int plateIndex, int wellIndex) {
        WellNode well = this.getWellNode(plateIndex, wellIndex, false);
        return well == null ? null : well.getColumn();
    }

    public String getWellExternalDescription(int plateIndex, int wellIndex) {
        WellNode well = this.getWellNode(plateIndex, wellIndex, false);
        return well == null ? null : well.getExternalDescription();
    }

    public String getWellExternalIdentifier(int plateIndex, int wellIndex) {
        WellNode well = this.getWellNode(plateIndex, wellIndex, false);
        return well == null ? null : well.getExternalIdentifier();
    }

    public String getWellID(int plateIndex, int wellIndex) {
        WellNode well = this.getWellNode(plateIndex, wellIndex, false);
        return well == null ? null : well.getNodeID();
    }

    public Integer getWellRow(int plateIndex, int wellIndex) {
        WellNode well = this.getWellNode(plateIndex, wellIndex, false);
        return well == null ? null : well.getRow();
    }

    public String getWellType(int plateIndex, int wellIndex) {
        WellNode well = this.getWellNode(plateIndex, wellIndex, false);
        return well == null ? null : well.getType();
    }

    public String getWellSampleID(int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSampleNode wellSample = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, false);
        return wellSample == null ? null : wellSample.getNodeID();
    }

    public Integer getWellSampleIndex(int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSampleNode wellSample = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, false);
        return wellSample == null ? null : wellSample.getIndex();
    }

    public Float getWellSamplePosX(int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSampleNode wellSample = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, false);
        return wellSample == null ? null : wellSample.getPosX();
    }

    public Float getWellSamplePosY(int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSampleNode wellSample = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, false);
        return wellSample == null ? null : wellSample.getPosY();
    }

    public Integer getWellSampleTimepoint(int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSampleNode wellSample = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, false);
        return wellSample == null ? null : wellSample.getTimepoint();
    }

    public void createRoot() {
        try {
            this.setRoot(OMEXMLFactory.newOMENode("2008-02"));
        }
        catch (IOException exc) {
            LogTools.trace(exc);
        }
        catch (SAXException exc) {
            LogTools.trace(exc);
        }
        catch (ParserConfigurationException exc) {
            LogTools.trace(exc);
        }
    }

    public void setRoot(Object root) {
        if (!(root instanceof OMENode)) {
            throw new IllegalArgumentException("Invalid root type: " + root.getClass().getName() + ". " + "This metadata store accepts root objects of type " + OMENode.class.getName());
        }
        this.root = (OMENode)root;
        this.clearCachedNodes();
    }

    public void setArcType(String type, int instrumentIndex, int lightSourceIndex) {
        if (type == null) {
            return;
        }
        ArcNode arcNode = this.getArcNode(instrumentIndex, lightSourceIndex, true);
        arcNode.setType(type);
    }

    public void setChannelComponentColorDomain(String colorDomain, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        if (colorDomain == null) {
            return;
        }
        ChannelComponentNode channelComponentNode = this.getChannelComponentNode(imageIndex, logicalChannelIndex, channelComponentIndex, true);
        channelComponentNode.setColorDomain(colorDomain);
    }

    public void setChannelComponentIndex(Integer index, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
        if (index == null) {
            return;
        }
        ChannelComponentNode channelComponentNode = this.getChannelComponentNode(imageIndex, logicalChannelIndex, channelComponentIndex, true);
        channelComponentNode.setIndex(index);
    }

    public void setDetectorGain(Float gain, int instrumentIndex, int detectorIndex) {
        if (gain == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setGain(gain);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        if (id == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setNodeID(id);
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        if (manufacturer == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setManufacturer(manufacturer);
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        if (model == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setModel(model);
    }

    public void setDetectorOffset(Float offset, int instrumentIndex, int detectorIndex) {
        if (offset == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setOffset(offset);
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        if (serialNumber == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setSerialNumber(serialNumber);
    }

    public void setDetectorType(String type, int instrumentIndex, int detectorIndex) {
        if (type == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setType(type);
    }

    public void setDetectorVoltage(Float voltage, int instrumentIndex, int detectorIndex) {
        if (voltage == null) {
            return;
        }
        DetectorNode detectorNode = this.getDetectorNode(instrumentIndex, detectorIndex, true);
        detectorNode.setVoltage(voltage);
    }

    public void setDetectorSettingsBinning(String binning, int imageIndex, int logicalChannelIndex) {
        if (binning == null) {
            return;
        }
        DetectorRefNode detectorRefNode = this.getDetectorRefNode(imageIndex, logicalChannelIndex, true);
        detectorRefNode.setBinning(binning);
    }

    public void setDetectorSettingsDetector(String detector, int imageIndex, int logicalChannelIndex) {
        if (detector == null) {
            return;
        }
        DetectorRefNode detectorRefNode = this.getDetectorRefNode(imageIndex, logicalChannelIndex, true);
        detectorRefNode.setNodeID(detector);
    }

    public void setDetectorSettingsGain(Float gain, int imageIndex, int logicalChannelIndex) {
        if (gain == null) {
            return;
        }
        DetectorRefNode detectorRefNode = this.getDetectorRefNode(imageIndex, logicalChannelIndex, true);
        detectorRefNode.setGain(gain);
    }

    public void setDetectorSettingsOffset(Float offset, int imageIndex, int logicalChannelIndex) {
        if (offset == null) {
            return;
        }
        DetectorRefNode detectorRefNode = this.getDetectorRefNode(imageIndex, logicalChannelIndex, true);
        detectorRefNode.setOffset(offset);
    }

    public void setDetectorSettingsReadOutRate(Float readOutRate, int imageIndex, int logicalChannelIndex) {
        if (readOutRate == null) {
            return;
        }
        DetectorRefNode detectorRefNode = this.getDetectorRefNode(imageIndex, logicalChannelIndex, true);
        detectorRefNode.setReadOutRate(readOutRate);
    }

    public void setDetectorSettingsVoltage(Float voltage, int imageIndex, int logicalChannelIndex) {
        if (voltage == null) {
            return;
        }
        DetectorRefNode detectorRefNode = this.getDetectorRefNode(imageIndex, logicalChannelIndex, true);
        detectorRefNode.setVoltage(voltage);
    }

    public void setDimensionsPhysicalSizeX(Float physicalSizeX, int imageIndex, int pixelsIndex) {
        if (physicalSizeX == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setPhysicalSizeX(physicalSizeX);
    }

    public void setDimensionsPhysicalSizeY(Float physicalSizeY, int imageIndex, int pixelsIndex) {
        if (physicalSizeY == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setPhysicalSizeY(physicalSizeY);
    }

    public void setDimensionsPhysicalSizeZ(Float physicalSizeZ, int imageIndex, int pixelsIndex) {
        if (physicalSizeZ == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setPhysicalSizeZ(physicalSizeZ);
    }

    public void setDimensionsTimeIncrement(Float timeIncrement, int imageIndex, int pixelsIndex) {
        if (timeIncrement == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setTimeIncrement(timeIncrement);
    }

    public void setDimensionsWaveIncrement(Integer waveIncrement, int imageIndex, int pixelsIndex) {
        if (waveIncrement == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setWaveIncrement(waveIncrement);
    }

    public void setDimensionsWaveStart(Integer waveStart, int imageIndex, int pixelsIndex) {
        if (waveStart == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setWaveStart(waveStart);
    }

    public void setDisplayOptionsID(String id, int imageIndex) {
        if (id == null) {
            return;
        }
        DisplayOptionsNode displayOptionsNode = this.getDisplayOptionsNode(imageIndex, true);
        displayOptionsNode.setNodeID(id);
    }

    public void setDisplayOptionsZoom(Float zoom, int imageIndex) {
        if (zoom == null) {
            return;
        }
        DisplayOptionsNode displayOptionsNode = this.getDisplayOptionsNode(imageIndex, true);
        displayOptionsNode.setZoom(zoom);
    }

    public void setDisplayOptionsProjectionZStart(Integer zStart, int imageIndex) {
        if (zStart == null) {
            return;
        }
        ProjectionNode projectionNode = this.getProjectionNode(imageIndex, true);
        projectionNode.setZStart(zStart);
    }

    public void setDisplayOptionsProjectionZStop(Integer zStop, int imageIndex) {
        if (zStop == null) {
            return;
        }
        ProjectionNode projectionNode = this.getProjectionNode(imageIndex, true);
        projectionNode.setZStop(zStop);
    }

    public void setDisplayOptionsTimeTStart(Integer tStart, int imageIndex) {
        if (tStart == null) {
            return;
        }
        TimeNode timeNode = this.getTimeNode(imageIndex, true);
        timeNode.setTStart(tStart);
    }

    public void setDisplayOptionsTimeTStop(Integer tStop, int imageIndex) {
        if (tStop == null) {
            return;
        }
        TimeNode timeNode = this.getTimeNode(imageIndex, true);
        timeNode.setTStop(tStop);
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        if (description == null) {
            return;
        }
        ExperimentNode experimentNode = this.getExperimentNode(experimentIndex, true);
        experimentNode.setDescription(description);
    }

    public void setExperimentID(String id, int experimentIndex) {
        if (id == null) {
            return;
        }
        ExperimentNode experimentNode = this.getExperimentNode(experimentIndex, true);
        experimentNode.setNodeID(id);
    }

    public void setExperimentType(String type, int experimentIndex) {
        if (type == null) {
            return;
        }
        ExperimentNode experimentNode = this.getExperimentNode(experimentIndex, true);
        experimentNode.setType(type);
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        if (email == null) {
            return;
        }
        ExperimenterNode experimenterNode = this.getExperimenterNode(experimenterIndex, true);
        experimenterNode.setEmail(email);
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        if (firstName == null) {
            return;
        }
        ExperimenterNode experimenterNode = this.getExperimenterNode(experimenterIndex, true);
        experimenterNode.setFirstName(firstName);
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        if (id == null) {
            return;
        }
        ExperimenterNode experimenterNode = this.getExperimenterNode(experimenterIndex, true);
        experimenterNode.setNodeID(id);
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        if (institution == null) {
            return;
        }
        ExperimenterNode experimenterNode = this.getExperimenterNode(experimenterIndex, true);
        experimenterNode.setInstitution(institution);
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        if (lastName == null) {
            return;
        }
        ExperimenterNode experimenterNode = this.getExperimenterNode(experimenterIndex, true);
        experimenterNode.setLastName(lastName);
    }

    public void setExperimenterMembershipGroup(String group, int experimenterIndex, int groupRefIndex) {
        if (group == null) {
            return;
        }
        GroupRefNode groupRefNode = this.getGroupRefNode(experimenterIndex, groupRefIndex, true);
        groupRefNode.setNodeID(group);
    }

    public void setFilamentType(String type, int instrumentIndex, int lightSourceIndex) {
        if (type == null) {
            return;
        }
        FilamentNode filamentNode = this.getFilamentNode(instrumentIndex, lightSourceIndex, true);
        filamentNode.setType(type);
    }

    public void setImageCreationDate(String creationDate, int imageIndex) {
        if (creationDate == null) {
            return;
        }
        ImageNode imageNode = this.getImageNode(imageIndex, true);
        imageNode.setCreationDate(creationDate);
    }

    public void setImageDefaultPixels(String defaultPixels, int imageIndex) {
        if (defaultPixels == null) {
            return;
        }
        ImageNode imageNode = this.getImageNode(imageIndex, true);
        imageNode.setDefaultPixels(defaultPixels);
    }

    public void setImageDescription(String description, int imageIndex) {
        if (description == null) {
            return;
        }
        ImageNode imageNode = this.getImageNode(imageIndex, true);
        imageNode.setDescription(description);
    }

    public void setImageID(String id, int imageIndex) {
        if (id == null) {
            return;
        }
        ImageNode imageNode = this.getImageNode(imageIndex, true);
        imageNode.setNodeID(id);
    }

    public void setImageInstrumentRef(String instrumentRef, int imageIndex) {
        if (instrumentRef == null) {
            return;
        }
        ImageNode imageNode = this.getImageNode(imageIndex, true);
        OMENode ome = (OMENode)this.root;
        Vector list = ome.getInstrumentList();
        InstrumentNode node2 = null;
        for (int i = 0; i < list.size(); ++i) {
            OMEXMLNode o = (OMEXMLNode)list.get(i);
            if (!o.getNodeID().equals(instrumentRef)) continue;
            node2 = (InstrumentNode)o;
        }
        if (node2 == null) {
            node2 = new InstrumentNode(ome);
            node2.setNodeID(instrumentRef);
        }
        InstrumentRefNode ref = new InstrumentRefNode(imageNode);
        ref.setInstrumentNode(node2);
    }

    public void setImageName(String name, int imageIndex) {
        if (name == null) {
            return;
        }
        ImageNode imageNode = this.getImageNode(imageIndex, true);
        imageNode.setName(name);
    }

    public void setImagingEnvironmentAirPressure(Float airPressure, int imageIndex) {
        if (airPressure == null) {
            return;
        }
        ImagingEnvironmentNode imagingEnvironmentNode = this.getImagingEnvironmentNode(imageIndex, true);
        imagingEnvironmentNode.setAirPressure(airPressure);
    }

    public void setImagingEnvironmentCO2Percent(Float cO2Percent, int imageIndex) {
        if (cO2Percent == null) {
            return;
        }
        ImagingEnvironmentNode imagingEnvironmentNode = this.getImagingEnvironmentNode(imageIndex, true);
        imagingEnvironmentNode.setCO2Percent(cO2Percent);
    }

    public void setImagingEnvironmentHumidity(Float humidity, int imageIndex) {
        if (humidity == null) {
            return;
        }
        ImagingEnvironmentNode imagingEnvironmentNode = this.getImagingEnvironmentNode(imageIndex, true);
        imagingEnvironmentNode.setHumidity(humidity);
    }

    public void setImagingEnvironmentTemperature(Float temperature, int imageIndex) {
        if (temperature == null) {
            return;
        }
        ImagingEnvironmentNode imagingEnvironmentNode = this.getImagingEnvironmentNode(imageIndex, true);
        imagingEnvironmentNode.setTemperature(temperature);
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        if (id == null) {
            return;
        }
        InstrumentNode instrumentNode = this.getInstrumentNode(instrumentIndex, true);
        instrumentNode.setNodeID(id);
    }

    public void setLaserFrequencyMultiplication(Integer frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        if (frequencyMultiplication == null) {
            return;
        }
        LaserNode laserNode = this.getLaserNode(instrumentIndex, lightSourceIndex, true);
        laserNode.setFrequencyMultiplication(frequencyMultiplication);
    }

    public void setLaserLaserMedium(String laserMedium, int instrumentIndex, int lightSourceIndex) {
        if (laserMedium == null) {
            return;
        }
        LaserNode laserNode = this.getLaserNode(instrumentIndex, lightSourceIndex, true);
        laserNode.setLaserMedium(laserMedium);
    }

    public void setLaserPulse(String pulse, int instrumentIndex, int lightSourceIndex) {
        if (pulse == null) {
            return;
        }
        LaserNode laserNode = this.getLaserNode(instrumentIndex, lightSourceIndex, true);
        laserNode.setPulse(pulse);
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        if (tuneable == null) {
            return;
        }
        LaserNode laserNode = this.getLaserNode(instrumentIndex, lightSourceIndex, true);
        laserNode.setTuneable(tuneable);
    }

    public void setLaserType(String type, int instrumentIndex, int lightSourceIndex) {
        if (type == null) {
            return;
        }
        LaserNode laserNode = this.getLaserNode(instrumentIndex, lightSourceIndex, true);
        laserNode.setType(type);
    }

    public void setLaserWavelength(Integer wavelength, int instrumentIndex, int lightSourceIndex) {
        if (wavelength == null) {
            return;
        }
        LaserNode laserNode = this.getLaserNode(instrumentIndex, lightSourceIndex, true);
        laserNode.setWavelength(wavelength);
    }

    public void setLightSourceID(String id, int instrumentIndex, int lightSourceIndex) {
        if (id == null) {
            return;
        }
        LightSourceNode lightSourceNode = this.getLightSourceNode(instrumentIndex, lightSourceIndex, true);
        lightSourceNode.setNodeID(id);
    }

    public void setLightSourceManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        if (manufacturer == null) {
            return;
        }
        LightSourceNode lightSourceNode = this.getLightSourceNode(instrumentIndex, lightSourceIndex, true);
        lightSourceNode.setManufacturer(manufacturer);
    }

    public void setLightSourceModel(String model, int instrumentIndex, int lightSourceIndex) {
        if (model == null) {
            return;
        }
        LightSourceNode lightSourceNode = this.getLightSourceNode(instrumentIndex, lightSourceIndex, true);
        lightSourceNode.setModel(model);
    }

    public void setLightSourcePower(Float power, int instrumentIndex, int lightSourceIndex) {
        if (power == null) {
            return;
        }
        LightSourceNode lightSourceNode = this.getLightSourceNode(instrumentIndex, lightSourceIndex, true);
        lightSourceNode.setPower(power);
    }

    public void setLightSourceSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        if (serialNumber == null) {
            return;
        }
        LightSourceNode lightSourceNode = this.getLightSourceNode(instrumentIndex, lightSourceIndex, true);
        lightSourceNode.setSerialNumber(serialNumber);
    }

    public void setLightSourceSettingsAttenuation(Float attenuation, int imageIndex, int logicalChannelIndex) {
        if (attenuation == null) {
            return;
        }
        LightSourceRefNode lightSourceRefNode = this.getLightSourceRefNode(imageIndex, logicalChannelIndex, true);
        lightSourceRefNode.setAttenuation(attenuation);
    }

    public void setLightSourceSettingsLightSource(String lightSource, int imageIndex, int logicalChannelIndex) {
        if (lightSource == null) {
            return;
        }
        LightSourceRefNode lightSourceRefNode = this.getLightSourceRefNode(imageIndex, logicalChannelIndex, true);
        lightSourceRefNode.setNodeID(lightSource);
    }

    public void setLightSourceSettingsWavelength(Integer wavelength, int imageIndex, int logicalChannelIndex) {
        if (wavelength == null) {
            return;
        }
        LightSourceRefNode lightSourceRefNode = this.getLightSourceRefNode(imageIndex, logicalChannelIndex, true);
        lightSourceRefNode.setWavelength(wavelength);
    }

    public void setLogicalChannelContrastMethod(String contrastMethod, int imageIndex, int logicalChannelIndex) {
        if (contrastMethod == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setContrastMethod(contrastMethod);
    }

    public void setLogicalChannelEmWave(Integer emWave, int imageIndex, int logicalChannelIndex) {
        if (emWave == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setEmWave(emWave);
    }

    public void setLogicalChannelExWave(Integer exWave, int imageIndex, int logicalChannelIndex) {
        if (exWave == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setExWave(exWave);
    }

    public void setLogicalChannelFluor(String fluor, int imageIndex, int logicalChannelIndex) {
        if (fluor == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setFluor(fluor);
    }

    public void setLogicalChannelID(String id, int imageIndex, int logicalChannelIndex) {
        if (id == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setNodeID(id);
    }

    public void setLogicalChannelIlluminationType(String illuminationType, int imageIndex, int logicalChannelIndex) {
        if (illuminationType == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setIlluminationType(illuminationType);
    }

    public void setLogicalChannelMode(String mode, int imageIndex, int logicalChannelIndex) {
        if (mode == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setMode(mode);
    }

    public void setLogicalChannelName(String name, int imageIndex, int logicalChannelIndex) {
        if (name == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setName(name);
    }

    public void setLogicalChannelNdFilter(Float ndFilter, int imageIndex, int logicalChannelIndex) {
        if (ndFilter == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setNdFilter(ndFilter);
    }

    public void setLogicalChannelOTF(String otf, int imageIndex, int logicalChannelIndex) {
        if (otf == null) {
            return;
        }
        OTFRefNode otfRefNode = this.getOTFRefNode(imageIndex, logicalChannelIndex, true);
        otfRefNode.setNodeID(otf);
    }

    public void setLogicalChannelPhotometricInterpretation(String photometricInterpretation, int imageIndex, int logicalChannelIndex) {
        if (photometricInterpretation == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setPhotometricInterpretation(photometricInterpretation);
    }

    public void setLogicalChannelPinholeSize(Float pinholeSize, int imageIndex, int logicalChannelIndex) {
        if (pinholeSize == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setPinholeSize(this.floatToInteger(pinholeSize));
    }

    public void setLogicalChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int logicalChannelIndex) {
        if (pockelCellSetting == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setPockelCellSetting(pockelCellSetting);
    }

    public void setLogicalChannelSamplesPerPixel(Integer samplesPerPixel, int imageIndex, int logicalChannelIndex) {
        if (samplesPerPixel == null) {
            return;
        }
        LogicalChannelNode logicalChannelNode = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, true);
        logicalChannelNode.setSamplesPerPixel(samplesPerPixel);
    }

    public void setOTFID(String id, int instrumentIndex, int otfIndex) {
        if (id == null) {
            return;
        }
        OTFNode otfNode = this.getOTFNode(instrumentIndex, otfIndex, true);
        otfNode.setNodeID(id);
    }

    public void setOTFObjective(String objective, int instrumentIndex, int otfIndex) {
        if (objective == null) {
            return;
        }
        ObjectiveRefNode objectiveRefNode = this.getObjectiveRefNode(instrumentIndex, otfIndex, true);
        objectiveRefNode.setNodeID(objective);
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int otfIndex) {
        if (opticalAxisAveraged == null) {
            return;
        }
        OTFNode otfNode = this.getOTFNode(instrumentIndex, otfIndex, true);
        otfNode.setOpticalAxisAveraged(opticalAxisAveraged);
    }

    public void setOTFPixelType(String pixelType, int instrumentIndex, int otfIndex) {
        if (pixelType == null) {
            return;
        }
        OTFNode otfNode = this.getOTFNode(instrumentIndex, otfIndex, true);
        otfNode.setPixelType(pixelType);
    }

    public void setOTFSizeX(Integer sizeX, int instrumentIndex, int otfIndex) {
        if (sizeX == null) {
            return;
        }
        OTFNode otfNode = this.getOTFNode(instrumentIndex, otfIndex, true);
        otfNode.setSizeX(sizeX);
    }

    public void setOTFSizeY(Integer sizeY, int instrumentIndex, int otfIndex) {
        if (sizeY == null) {
            return;
        }
        OTFNode otfNode = this.getOTFNode(instrumentIndex, otfIndex, true);
        otfNode.setSizeY(sizeY);
    }

    public void setObjectiveCalibratedMagnification(Float calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        if (calibratedMagnification == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setCalibratedMagnification(calibratedMagnification);
    }

    public void setObjectiveCorrection(String correction, int instrumentIndex, int objectiveIndex) {
        if (correction == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setCorrection(correction);
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        if (id == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setNodeID(id);
    }

    public void setObjectiveImmersion(String immersion, int instrumentIndex, int objectiveIndex) {
        if (immersion == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setImmersion(immersion);
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
    }

    public void setObjectiveLensNA(Float lensNA, int instrumentIndex, int objectiveIndex) {
        if (lensNA == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setLensNA(lensNA);
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        if (manufacturer == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setManufacturer(manufacturer);
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        if (model == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setModel(model);
    }

    public void setObjectiveNominalMagnification(Integer nominalMagnification, int instrumentIndex, int objectiveIndex) {
        if (nominalMagnification == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setNominalMagnification(nominalMagnification);
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        if (serialNumber == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setSerialNumber(serialNumber);
    }

    public void setObjectiveWorkingDistance(Float workingDistance, int instrumentIndex, int objectiveIndex) {
        if (workingDistance == null) {
            return;
        }
        ObjectiveNode objectiveNode = this.getObjectiveNode(instrumentIndex, objectiveIndex, true);
        objectiveNode.setWorkingDistance(workingDistance);
    }

    public void setObjectiveSettingsCorrectionCollar(Float correctionCollar, int imageIndex) {
        if (correctionCollar == null) {
            return;
        }
        ObjectiveRefNode objectiveRefNode = this.getObjectiveRefNode(imageIndex, true);
        objectiveRefNode.setCorrectionCollar(correctionCollar);
    }

    public void setObjectiveSettingsMedium(String medium, int imageIndex) {
        if (medium == null) {
            return;
        }
        ObjectiveRefNode objectiveRefNode = this.getObjectiveRefNode(imageIndex, true);
        objectiveRefNode.setMedium(medium);
    }

    public void setObjectiveSettingsObjective(String objective, int imageIndex) {
        if (objective == null) {
            return;
        }
        ObjectiveRefNode objectiveRefNode = this.getObjectiveRefNode(imageIndex, true);
        objectiveRefNode.setNodeID(objective);
    }

    public void setObjectiveSettingsRefractiveIndex(Float refractiveIndex, int imageIndex) {
        if (refractiveIndex == null) {
            return;
        }
        ObjectiveRefNode objectiveRefNode = this.getObjectiveRefNode(imageIndex, true);
        objectiveRefNode.setRefractiveIndex(refractiveIndex);
    }

    public void setPixelsBigEndian(Boolean bigEndian, int imageIndex, int pixelsIndex) {
        if (bigEndian == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setBigEndian(bigEndian);
    }

    public void setPixelsDimensionOrder(String dimensionOrder, int imageIndex, int pixelsIndex) {
        if (dimensionOrder == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setDimensionOrder(dimensionOrder);
    }

    public void setPixelsID(String id, int imageIndex, int pixelsIndex) {
        if (id == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setNodeID(id);
    }

    public void setPixelsPixelType(String pixelType, int imageIndex, int pixelsIndex) {
        if (pixelType == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setPixelType(pixelType);
    }

    public void setPixelsSizeC(Integer sizeC, int imageIndex, int pixelsIndex) {
        if (sizeC == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setSizeC(sizeC);
    }

    public void setPixelsSizeT(Integer sizeT, int imageIndex, int pixelsIndex) {
        if (sizeT == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setSizeT(sizeT);
    }

    public void setPixelsSizeX(Integer sizeX, int imageIndex, int pixelsIndex) {
        if (sizeX == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setSizeX(sizeX);
    }

    public void setPixelsSizeY(Integer sizeY, int imageIndex, int pixelsIndex) {
        if (sizeY == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setSizeY(sizeY);
    }

    public void setPixelsSizeZ(Integer sizeZ, int imageIndex, int pixelsIndex) {
        if (sizeZ == null) {
            return;
        }
        PixelsNode pixelsNode = this.getPixelsNode(imageIndex, pixelsIndex, true);
        pixelsNode.setSizeZ(sizeZ);
    }

    public void setPlaneTheC(Integer theC, int imageIndex, int pixelsIndex, int planeIndex) {
        if (theC == null) {
            return;
        }
        PlaneNode planeNode = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, true);
        planeNode.setTheC(theC);
    }

    public void setPlaneTheT(Integer theT, int imageIndex, int pixelsIndex, int planeIndex) {
        if (theT == null) {
            return;
        }
        PlaneNode planeNode = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, true);
        planeNode.setTheT(theT);
    }

    public void setPlaneTheZ(Integer theZ, int imageIndex, int pixelsIndex, int planeIndex) {
        if (theZ == null) {
            return;
        }
        PlaneNode planeNode = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, true);
        planeNode.setTheZ(theZ);
    }

    public void setPlaneTimingDeltaT(Float deltaT, int imageIndex, int pixelsIndex, int planeIndex) {
        if (deltaT == null) {
            return;
        }
        PlaneTimingNode planeTimingNode = this.getPlaneTimingNode(imageIndex, pixelsIndex, planeIndex, true);
        planeTimingNode.setDeltaT(deltaT);
    }

    public void setPlaneTimingExposureTime(Float exposureTime, int imageIndex, int pixelsIndex, int planeIndex) {
        if (exposureTime == null) {
            return;
        }
        PlaneTimingNode planeTimingNode = this.getPlaneTimingNode(imageIndex, pixelsIndex, planeIndex, true);
        planeTimingNode.setExposureTime(exposureTime);
    }

    public void setPlateDescription(String description, int plateIndex) {
        if (description == null) {
            return;
        }
        PlateNode plateNode = this.getPlateNode(plateIndex, true);
        plateNode.setDescription(description);
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        if (externalIdentifier == null) {
            return;
        }
        PlateNode plateNode = this.getPlateNode(plateIndex, true);
        plateNode.setExternalIdentifier(externalIdentifier);
    }

    public void setPlateID(String id, int plateIndex) {
        if (id == null) {
            return;
        }
        PlateNode plateNode = this.getPlateNode(plateIndex, true);
        plateNode.setNodeID(id);
    }

    public void setPlateName(String name, int plateIndex) {
        if (name == null) {
            return;
        }
        PlateNode plateNode = this.getPlateNode(plateIndex, true);
        plateNode.setName(name);
    }

    public void setPlateStatus(String status, int plateIndex) {
        if (status == null) {
            return;
        }
        PlateNode plateNode = this.getPlateNode(plateIndex, true);
        plateNode.setStatus(status);
    }

    public void setPlateRefID(String id, int screenIndex, int plateRefIndex) {
        if (id == null) {
            return;
        }
        PlateRefNode plateRefNode = this.getPlateRefNode(screenIndex, plateRefIndex, true);
        plateRefNode.setNodeID(id);
    }

    public void setROIID(String id, int imageIndex, int roiIndex) {
        if (id == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setNodeID(id);
    }

    public void setROIT0(Integer t0, int imageIndex, int roiIndex) {
        if (t0 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setT0(t0);
    }

    public void setROIT1(Integer t1, int imageIndex, int roiIndex) {
        if (t1 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setT1(t1);
    }

    public void setROIX0(Integer x0, int imageIndex, int roiIndex) {
        if (x0 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setX0(x0);
    }

    public void setROIX1(Integer x1, int imageIndex, int roiIndex) {
        if (x1 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setX1(x1);
    }

    public void setROIY0(Integer y0, int imageIndex, int roiIndex) {
        if (y0 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setY0(y0);
    }

    public void setROIY1(Integer y1, int imageIndex, int roiIndex) {
        if (y1 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setY1(y1);
    }

    public void setROIZ0(Integer z0, int imageIndex, int roiIndex) {
        if (z0 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setZ0(z0);
    }

    public void setROIZ1(Integer z1, int imageIndex, int roiIndex) {
        if (z1 == null) {
            return;
        }
        ROINode roiNode = this.getROINode(imageIndex, roiIndex, true);
        roiNode.setZ1(z1);
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        if (description == null) {
            return;
        }
        ReagentNode reagentNode = this.getReagentNode(screenIndex, reagentIndex, true);
        reagentNode.setDescription(description);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        if (id == null) {
            return;
        }
        ReagentNode reagentNode = this.getReagentNode(screenIndex, reagentIndex, true);
        reagentNode.setNodeID(id);
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        if (name == null) {
            return;
        }
        ReagentNode reagentNode = this.getReagentNode(screenIndex, reagentIndex, true);
        reagentNode.setName(name);
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        if (reagentIdentifier == null) {
            return;
        }
        ReagentNode reagentNode = this.getReagentNode(screenIndex, reagentIndex, true);
        reagentNode.setReagentIdentifier(reagentIdentifier);
    }

    public void setScreenID(String id, int screenIndex) {
        if (id == null) {
            return;
        }
        ScreenNode screenNode = this.getScreenNode(screenIndex, true);
        screenNode.setNodeID(id);
    }

    public void setScreenName(String name, int screenIndex) {
        if (name == null) {
            return;
        }
        ScreenNode screenNode = this.getScreenNode(screenIndex, true);
        screenNode.setName(name);
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        if (protocolDescription == null) {
            return;
        }
        ScreenNode screenNode = this.getScreenNode(screenIndex, true);
        screenNode.setProtocolDescription(protocolDescription);
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        if (protocolIdentifier == null) {
            return;
        }
        ScreenNode screenNode = this.getScreenNode(screenIndex, true);
        screenNode.setProtocolIdentifier(protocolIdentifier);
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        if (reagentSetDescription == null) {
            return;
        }
        ScreenNode screenNode = this.getScreenNode(screenIndex, true);
        screenNode.setReagentSetDescription(reagentSetDescription);
    }

    public void setScreenType(String type, int screenIndex) {
        if (type == null) {
            return;
        }
        ScreenNode screenNode = this.getScreenNode(screenIndex, true);
        screenNode.setType(type);
    }

    public void setScreenAcquisitionEndTime(String endTime, int screenIndex, int screenAcquisitionIndex) {
        if (endTime == null) {
            return;
        }
        ScreenAcquisitionNode screenAcquisitionNode = this.getScreenAcquisitionNode(screenIndex, screenAcquisitionIndex, true);
        screenAcquisitionNode.setEndTime(endTime);
    }

    public void setScreenAcquisitionID(String id, int screenIndex, int screenAcquisitionIndex) {
        if (id == null) {
            return;
        }
        ScreenAcquisitionNode screenAcquisitionNode = this.getScreenAcquisitionNode(screenIndex, screenAcquisitionIndex, true);
        screenAcquisitionNode.setNodeID(id);
    }

    public void setScreenAcquisitionStartTime(String startTime, int screenIndex, int screenAcquisitionIndex) {
        if (startTime == null) {
            return;
        }
        ScreenAcquisitionNode screenAcquisitionNode = this.getScreenAcquisitionNode(screenIndex, screenAcquisitionIndex, true);
        screenAcquisitionNode.setStartTime(startTime);
    }

    public void setStageLabelName(String name, int imageIndex) {
        if (name == null) {
            return;
        }
        StageLabelNode stageLabelNode = this.getStageLabelNode(imageIndex, true);
        stageLabelNode.setName(name);
    }

    public void setStageLabelX(Float x, int imageIndex) {
        if (x == null) {
            return;
        }
        StageLabelNode stageLabelNode = this.getStageLabelNode(imageIndex, true);
        stageLabelNode.setX(x);
    }

    public void setStageLabelY(Float y, int imageIndex) {
        if (y == null) {
            return;
        }
        StageLabelNode stageLabelNode = this.getStageLabelNode(imageIndex, true);
        stageLabelNode.setY(y);
    }

    public void setStageLabelZ(Float z, int imageIndex) {
        if (z == null) {
            return;
        }
        StageLabelNode stageLabelNode = this.getStageLabelNode(imageIndex, true);
        stageLabelNode.setZ(z);
    }

    public void setStagePositionPositionX(Float positionX, int imageIndex, int pixelsIndex, int planeIndex) {
        if (positionX == null) {
            return;
        }
        StagePositionNode stagePositionNode = this.getStagePositionNode(imageIndex, pixelsIndex, planeIndex, true);
        stagePositionNode.setPositionX(positionX);
    }

    public void setStagePositionPositionY(Float positionY, int imageIndex, int pixelsIndex, int planeIndex) {
        if (positionY == null) {
            return;
        }
        StagePositionNode stagePositionNode = this.getStagePositionNode(imageIndex, pixelsIndex, planeIndex, true);
        stagePositionNode.setPositionY(positionY);
    }

    public void setStagePositionPositionZ(Float positionZ, int imageIndex, int pixelsIndex, int planeIndex) {
        if (positionZ == null) {
            return;
        }
        StagePositionNode stagePositionNode = this.getStagePositionNode(imageIndex, pixelsIndex, planeIndex, true);
        stagePositionNode.setPositionZ(positionZ);
    }

    public void setTiffDataFileName(String fileName, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        if (fileName == null) {
            return;
        }
        UUIDNode uuidNode = this.getUUIDNode(imageIndex, pixelsIndex, tiffDataIndex, true);
        uuidNode.setFileName(fileName);
    }

    public void setTiffDataFirstC(Integer firstC, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        if (firstC == null) {
            return;
        }
        TiffDataNode tiffDataNode = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, true);
        tiffDataNode.setFirstC(firstC);
    }

    public void setTiffDataFirstT(Integer firstT, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        if (firstT == null) {
            return;
        }
        TiffDataNode tiffDataNode = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, true);
        tiffDataNode.setFirstT(firstT);
    }

    public void setTiffDataFirstZ(Integer firstZ, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        if (firstZ == null) {
            return;
        }
        TiffDataNode tiffDataNode = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, true);
        tiffDataNode.setFirstZ(firstZ);
    }

    public void setTiffDataIFD(Integer ifd, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        if (ifd == null) {
            return;
        }
        TiffDataNode tiffDataNode = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, true);
        tiffDataNode.setIFD(ifd);
    }

    public void setTiffDataNumPlanes(Integer numPlanes, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        if (numPlanes == null) {
            return;
        }
        TiffDataNode tiffDataNode = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, true);
        tiffDataNode.setNumPlanes(numPlanes);
    }

    public void setTiffDataUUID(String uuid, int imageIndex, int pixelsIndex, int tiffDataIndex) {
        if (uuid == null) {
            return;
        }
        UUIDNode uuidNode = this.getUUIDNode(imageIndex, pixelsIndex, tiffDataIndex, true);
        uuidNode.setCData(uuid);
    }

    public void setWellColumn(Integer column, int plateIndex, int wellIndex) {
        if (column == null) {
            return;
        }
        WellNode wellNode = this.getWellNode(plateIndex, wellIndex, true);
        wellNode.setColumn(column);
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        if (externalDescription == null) {
            return;
        }
        WellNode wellNode = this.getWellNode(plateIndex, wellIndex, true);
        wellNode.setExternalDescription(externalDescription);
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        if (externalIdentifier == null) {
            return;
        }
        WellNode wellNode = this.getWellNode(plateIndex, wellIndex, true);
        wellNode.setExternalIdentifier(externalIdentifier);
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        if (id == null) {
            return;
        }
        WellNode wellNode = this.getWellNode(plateIndex, wellIndex, true);
        wellNode.setNodeID(id);
    }

    public void setWellRow(Integer row, int plateIndex, int wellIndex) {
        if (row == null) {
            return;
        }
        WellNode wellNode = this.getWellNode(plateIndex, wellIndex, true);
        wellNode.setRow(row);
    }

    public void setWellType(String type, int plateIndex, int wellIndex) {
        if (type == null) {
            return;
        }
        WellNode wellNode = this.getWellNode(plateIndex, wellIndex, true);
        wellNode.setType(type);
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        if (id == null) {
            return;
        }
        WellSampleNode wellSampleNode = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, true);
        wellSampleNode.setNodeID(id);
    }

    public void setWellSampleIndex(Integer index, int plateIndex, int wellIndex, int wellSampleIndex) {
        if (index == null) {
            return;
        }
        WellSampleNode wellSampleNode = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, true);
        wellSampleNode.setIndex(index);
    }

    public void setWellSamplePosX(Float posX, int plateIndex, int wellIndex, int wellSampleIndex) {
        if (posX == null) {
            return;
        }
        WellSampleNode wellSampleNode = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, true);
        wellSampleNode.setPosX(posX);
    }

    public void setWellSamplePosY(Float posY, int plateIndex, int wellIndex, int wellSampleIndex) {
        if (posY == null) {
            return;
        }
        WellSampleNode wellSampleNode = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, true);
        wellSampleNode.setPosY(posY);
    }

    public void setWellSampleTimepoint(Integer timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        if (timepoint == null) {
            return;
        }
        WellSampleNode wellSampleNode = this.getWellSampleNode(plateIndex, wellIndex, wellSampleIndex, true);
        wellSampleNode.setTimepoint(timepoint);
    }

    private ExperimentNode getExperimentNode(int experimentIndex, boolean create) {
        boolean match = true;
        if (this.experimentNodeExperimentIndex != experimentIndex) {
            match = false;
        }
        if (match) {
            return this.experimentNode;
        }
        this.experimentNode = null;
        this.experimentNodeExperimentIndex = experimentIndex;
        OMENode ome = (OMENode)this.root;
        int count = ome.getExperimentCount();
        if (!create && count <= experimentIndex) {
            return null;
        }
        for (int i = count; i <= experimentIndex; ++i) {
            new ExperimentNode(ome);
        }
        Vector list = ome.getExperimentList();
        this.experimentNode = (ExperimentNode)list.get(experimentIndex);
        return this.experimentNode;
    }

    private ExperimenterNode getExperimenterNode(int experimenterIndex, boolean create) {
        boolean match = true;
        if (this.experimenterNodeExperimenterIndex != experimenterIndex) {
            match = false;
        }
        if (match) {
            return this.experimenterNode;
        }
        this.experimenterNode = null;
        this.experimenterNodeExperimenterIndex = experimenterIndex;
        OMENode ome = (OMENode)this.root;
        int count = ome.getExperimenterCount();
        if (!create && count <= experimenterIndex) {
            return null;
        }
        for (int i = count; i <= experimenterIndex; ++i) {
            new ExperimenterNode(ome);
        }
        Vector list = ome.getExperimenterList();
        this.experimenterNode = (ExperimenterNode)list.get(experimenterIndex);
        return this.experimenterNode;
    }

    private GroupRefNode getGroupRefNode(int experimenterIndex, int groupRefIndex, boolean create) {
        boolean match = true;
        if (this.experimenterGroupRefNodeExperimenterIndex != experimenterIndex) {
            match = false;
        }
        if (this.experimenterGroupRefNodeGroupRefIndex != groupRefIndex) {
            match = false;
        }
        if (match) {
            return this.experimenterGroupRefNode;
        }
        this.experimenterGroupRefNode = null;
        this.experimenterGroupRefNodeExperimenterIndex = experimenterIndex;
        this.experimenterGroupRefNodeGroupRefIndex = groupRefIndex;
        ExperimenterNode experimenter = this.getExperimenterNode(experimenterIndex, create);
        if (experimenter == null) {
            return null;
        }
        int count = experimenter.getGroupRefCount();
        if (!create && count <= groupRefIndex) {
            return null;
        }
        for (int i = count; i <= groupRefIndex; ++i) {
            new GroupRefNode(experimenter);
        }
        Vector list = experimenter.getGroupRefList();
        this.experimenterGroupRefNode = (GroupRefNode)list.get(groupRefIndex);
        return this.experimenterGroupRefNode;
    }

    private ImageNode getImageNode(int imageIndex, boolean create) {
        boolean match = true;
        if (this.imageNodeImageIndex != imageIndex) {
            match = false;
        }
        if (match) {
            return this.imageNode;
        }
        this.imageNode = null;
        this.imageNodeImageIndex = imageIndex;
        OMENode ome = (OMENode)this.root;
        int count = ome.getImageCount();
        if (!create && count <= imageIndex) {
            return null;
        }
        for (int i = count; i <= imageIndex; ++i) {
            new ImageNode(ome);
        }
        Vector list = ome.getImageList();
        this.imageNode = (ImageNode)list.get(imageIndex);
        return this.imageNode;
    }

    private DisplayOptionsNode getDisplayOptionsNode(int imageIndex, boolean create) {
        boolean match = true;
        if (this.imageDisplayOptionsNodeImageIndex != imageIndex) {
            match = false;
        }
        if (match) {
            return this.imageDisplayOptionsNode;
        }
        this.imageDisplayOptionsNode = null;
        this.imageDisplayOptionsNodeImageIndex = imageIndex;
        ImageNode image = this.getImageNode(imageIndex, create);
        if (image == null) {
            return null;
        }
        DisplayOptionsNode displayOptions = image.getDisplayOptions();
        if (displayOptions == null) {
            if (create) {
                displayOptions = new DisplayOptionsNode(image);
            } else {
                return null;
            }
        }
        this.imageDisplayOptionsNode = displayOptions;
        return this.imageDisplayOptionsNode;
    }

    private ProjectionNode getProjectionNode(int imageIndex, boolean create) {
        boolean match = true;
        if (this.imageDisplayOptionsProjectionNodeImageIndex != imageIndex) {
            match = false;
        }
        if (match) {
            return this.imageDisplayOptionsProjectionNode;
        }
        this.imageDisplayOptionsProjectionNode = null;
        this.imageDisplayOptionsProjectionNodeImageIndex = imageIndex;
        DisplayOptionsNode displayOptions = this.getDisplayOptionsNode(imageIndex, create);
        if (displayOptions == null) {
            return null;
        }
        ProjectionNode projection = displayOptions.getProjection();
        if (projection == null) {
            if (create) {
                projection = new ProjectionNode(displayOptions);
            } else {
                return null;
            }
        }
        this.imageDisplayOptionsProjectionNode = projection;
        return this.imageDisplayOptionsProjectionNode;
    }

    private ROINode getROINode(int imageIndex, int roiIndex, boolean create) {
        boolean match = true;
        if (this.imageDisplayOptionsROINodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imageDisplayOptionsROINodeROIIndex != roiIndex) {
            match = false;
        }
        if (match) {
            return this.imageDisplayOptionsROINode;
        }
        this.imageDisplayOptionsROINode = null;
        this.imageDisplayOptionsROINodeImageIndex = imageIndex;
        this.imageDisplayOptionsROINodeROIIndex = roiIndex;
        DisplayOptionsNode displayOptions = this.getDisplayOptionsNode(imageIndex, create);
        if (displayOptions == null) {
            return null;
        }
        int count = displayOptions.getROICount();
        if (!create && count <= roiIndex) {
            return null;
        }
        for (int i = count; i <= roiIndex; ++i) {
            new ROINode(displayOptions);
        }
        Vector list = displayOptions.getROIList();
        this.imageDisplayOptionsROINode = (ROINode)list.get(roiIndex);
        return this.imageDisplayOptionsROINode;
    }

    private TimeNode getTimeNode(int imageIndex, boolean create) {
        boolean match = true;
        if (this.imageDisplayOptionsTimeNodeImageIndex != imageIndex) {
            match = false;
        }
        if (match) {
            return this.imageDisplayOptionsTimeNode;
        }
        this.imageDisplayOptionsTimeNode = null;
        this.imageDisplayOptionsTimeNodeImageIndex = imageIndex;
        DisplayOptionsNode displayOptions = this.getDisplayOptionsNode(imageIndex, create);
        if (displayOptions == null) {
            return null;
        }
        TimeNode time = displayOptions.getTime();
        if (time == null) {
            if (create) {
                time = new TimeNode(displayOptions);
            } else {
                return null;
            }
        }
        this.imageDisplayOptionsTimeNode = time;
        return this.imageDisplayOptionsTimeNode;
    }

    private ImagingEnvironmentNode getImagingEnvironmentNode(int imageIndex, boolean create) {
        boolean match = true;
        if (this.imageImagingEnvironmentNodeImageIndex != imageIndex) {
            match = false;
        }
        if (match) {
            return this.imageImagingEnvironmentNode;
        }
        this.imageImagingEnvironmentNode = null;
        this.imageImagingEnvironmentNodeImageIndex = imageIndex;
        ImageNode image = this.getImageNode(imageIndex, create);
        if (image == null) {
            return null;
        }
        ImagingEnvironmentNode imagingEnvironment = image.getImagingEnvironment();
        if (imagingEnvironment == null) {
            if (create) {
                imagingEnvironment = new ImagingEnvironmentNode(image);
            } else {
                return null;
            }
        }
        this.imageImagingEnvironmentNode = imagingEnvironment;
        return this.imageImagingEnvironmentNode;
    }

    private LogicalChannelNode getLogicalChannelNode(int imageIndex, int logicalChannelIndex, boolean create) {
        boolean match = true;
        if (this.imageLogicalChannelNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imageLogicalChannelNodeLogicalChannelIndex != logicalChannelIndex) {
            match = false;
        }
        if (match) {
            return this.imageLogicalChannelNode;
        }
        this.imageLogicalChannelNode = null;
        this.imageLogicalChannelNodeImageIndex = imageIndex;
        this.imageLogicalChannelNodeLogicalChannelIndex = logicalChannelIndex;
        ImageNode image = this.getImageNode(imageIndex, create);
        if (image == null) {
            return null;
        }
        int count = image.getLogicalChannelCount();
        if (!create && count <= logicalChannelIndex) {
            return null;
        }
        for (int i = count; i <= logicalChannelIndex; ++i) {
            new LogicalChannelNode(image);
        }
        Vector list = image.getLogicalChannelList();
        this.imageLogicalChannelNode = (LogicalChannelNode)list.get(logicalChannelIndex);
        return this.imageLogicalChannelNode;
    }

    private ChannelComponentNode getChannelComponentNode(int imageIndex, int logicalChannelIndex, int channelComponentIndex, boolean create) {
        boolean match = true;
        if (this.imageLogicalChannelChannelComponentNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imageLogicalChannelChannelComponentNodeLogicalChannelIndex != logicalChannelIndex) {
            match = false;
        }
        if (this.imageLogicalChannelChannelComponentNodeChannelComponentIndex != channelComponentIndex) {
            match = false;
        }
        if (match) {
            return this.imageLogicalChannelChannelComponentNode;
        }
        this.imageLogicalChannelChannelComponentNode = null;
        this.imageLogicalChannelChannelComponentNodeImageIndex = imageIndex;
        this.imageLogicalChannelChannelComponentNodeLogicalChannelIndex = logicalChannelIndex;
        this.imageLogicalChannelChannelComponentNodeChannelComponentIndex = channelComponentIndex;
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, create);
        if (logicalChannel == null) {
            return null;
        }
        int count = logicalChannel.getChannelComponentCount();
        if (!create && count <= channelComponentIndex) {
            return null;
        }
        for (int i = count; i <= channelComponentIndex; ++i) {
            new ChannelComponentNode(logicalChannel);
        }
        Vector list = logicalChannel.getChannelComponentList();
        this.imageLogicalChannelChannelComponentNode = (ChannelComponentNode)list.get(channelComponentIndex);
        return this.imageLogicalChannelChannelComponentNode;
    }

    private DetectorRefNode getDetectorRefNode(int imageIndex, int logicalChannelIndex, boolean create) {
        boolean match = true;
        if (this.imageLogicalChannelDetectorRefNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imageLogicalChannelDetectorRefNodeLogicalChannelIndex != logicalChannelIndex) {
            match = false;
        }
        if (match) {
            return this.imageLogicalChannelDetectorRefNode;
        }
        this.imageLogicalChannelDetectorRefNode = null;
        this.imageLogicalChannelDetectorRefNodeImageIndex = imageIndex;
        this.imageLogicalChannelDetectorRefNodeLogicalChannelIndex = logicalChannelIndex;
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, create);
        if (logicalChannel == null) {
            return null;
        }
        DetectorRefNode detectorRef = logicalChannel.getDetectorRef();
        if (detectorRef == null) {
            if (create) {
                detectorRef = new DetectorRefNode(logicalChannel);
            } else {
                return null;
            }
        }
        this.imageLogicalChannelDetectorRefNode = detectorRef;
        return this.imageLogicalChannelDetectorRefNode;
    }

    private LightSourceRefNode getLightSourceRefNode(int imageIndex, int logicalChannelIndex, boolean create) {
        boolean match = true;
        if (this.imageLogicalChannelLightSourceRefNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imageLogicalChannelLightSourceRefNodeLogicalChannelIndex != logicalChannelIndex) {
            match = false;
        }
        if (match) {
            return this.imageLogicalChannelLightSourceRefNode;
        }
        this.imageLogicalChannelLightSourceRefNode = null;
        this.imageLogicalChannelLightSourceRefNodeImageIndex = imageIndex;
        this.imageLogicalChannelLightSourceRefNodeLogicalChannelIndex = logicalChannelIndex;
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, create);
        if (logicalChannel == null) {
            return null;
        }
        LightSourceRefNode lightSourceRef = logicalChannel.getLightSourceRef();
        if (lightSourceRef == null) {
            if (create) {
                lightSourceRef = new LightSourceRefNode(logicalChannel);
            } else {
                return null;
            }
        }
        this.imageLogicalChannelLightSourceRefNode = lightSourceRef;
        return this.imageLogicalChannelLightSourceRefNode;
    }

    private OTFRefNode getOTFRefNode(int imageIndex, int logicalChannelIndex, boolean create) {
        boolean match = true;
        if (this.imageLogicalChannelOTFRefNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imageLogicalChannelOTFRefNodeLogicalChannelIndex != logicalChannelIndex) {
            match = false;
        }
        if (match) {
            return this.imageLogicalChannelOTFRefNode;
        }
        this.imageLogicalChannelOTFRefNode = null;
        this.imageLogicalChannelOTFRefNodeImageIndex = imageIndex;
        this.imageLogicalChannelOTFRefNodeLogicalChannelIndex = logicalChannelIndex;
        LogicalChannelNode logicalChannel = this.getLogicalChannelNode(imageIndex, logicalChannelIndex, create);
        if (logicalChannel == null) {
            return null;
        }
        OTFRefNode otfRef = logicalChannel.getOTFRef();
        if (otfRef == null) {
            if (create) {
                otfRef = new OTFRefNode(logicalChannel);
            } else {
                return null;
            }
        }
        this.imageLogicalChannelOTFRefNode = otfRef;
        return this.imageLogicalChannelOTFRefNode;
    }

    private ObjectiveRefNode getObjectiveRefNode(int imageIndex, boolean create) {
        boolean match = true;
        if (this.imageObjectiveRefNodeImageIndex != imageIndex) {
            match = false;
        }
        if (match) {
            return this.imageObjectiveRefNode;
        }
        this.imageObjectiveRefNode = null;
        this.imageObjectiveRefNodeImageIndex = imageIndex;
        ImageNode image = this.getImageNode(imageIndex, create);
        if (image == null) {
            return null;
        }
        ObjectiveRefNode objectiveRef = image.getObjectiveRef();
        if (objectiveRef == null) {
            if (create) {
                objectiveRef = new ObjectiveRefNode(image);
            } else {
                return null;
            }
        }
        this.imageObjectiveRefNode = objectiveRef;
        return this.imageObjectiveRefNode;
    }

    private PixelsNode getPixelsNode(int imageIndex, int pixelsIndex, boolean create) {
        boolean match = true;
        if (this.imagePixelsNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imagePixelsNodePixelsIndex != pixelsIndex) {
            match = false;
        }
        if (match) {
            return this.imagePixelsNode;
        }
        this.imagePixelsNode = null;
        this.imagePixelsNodeImageIndex = imageIndex;
        this.imagePixelsNodePixelsIndex = pixelsIndex;
        ImageNode image = this.getImageNode(imageIndex, create);
        if (image == null) {
            return null;
        }
        int count = image.getPixelsCount();
        if (!create && count <= pixelsIndex) {
            return null;
        }
        for (int i = count; i <= pixelsIndex; ++i) {
            new PixelsNode(image);
        }
        Vector list = image.getPixelsList();
        this.imagePixelsNode = (PixelsNode)list.get(pixelsIndex);
        return this.imagePixelsNode;
    }

    private PlaneNode getPlaneNode(int imageIndex, int pixelsIndex, int planeIndex, boolean create) {
        boolean match = true;
        if (this.imagePixelsPlaneNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imagePixelsPlaneNodePixelsIndex != pixelsIndex) {
            match = false;
        }
        if (this.imagePixelsPlaneNodePlaneIndex != planeIndex) {
            match = false;
        }
        if (match) {
            return this.imagePixelsPlaneNode;
        }
        this.imagePixelsPlaneNode = null;
        this.imagePixelsPlaneNodeImageIndex = imageIndex;
        this.imagePixelsPlaneNodePixelsIndex = pixelsIndex;
        this.imagePixelsPlaneNodePlaneIndex = planeIndex;
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, create);
        if (pixels == null) {
            return null;
        }
        int count = pixels.getPlaneCount();
        if (!create && count <= planeIndex) {
            return null;
        }
        for (int i = count; i <= planeIndex; ++i) {
            new PlaneNode(pixels);
        }
        Vector list = pixels.getPlaneList();
        this.imagePixelsPlaneNode = (PlaneNode)list.get(planeIndex);
        return this.imagePixelsPlaneNode;
    }

    private PlaneTimingNode getPlaneTimingNode(int imageIndex, int pixelsIndex, int planeIndex, boolean create) {
        boolean match = true;
        if (this.imagePixelsPlanePlaneTimingNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imagePixelsPlanePlaneTimingNodePixelsIndex != pixelsIndex) {
            match = false;
        }
        if (this.imagePixelsPlanePlaneTimingNodePlaneIndex != planeIndex) {
            match = false;
        }
        if (match) {
            return this.imagePixelsPlanePlaneTimingNode;
        }
        this.imagePixelsPlanePlaneTimingNode = null;
        this.imagePixelsPlanePlaneTimingNodeImageIndex = imageIndex;
        this.imagePixelsPlanePlaneTimingNodePixelsIndex = pixelsIndex;
        this.imagePixelsPlanePlaneTimingNodePlaneIndex = planeIndex;
        PlaneNode plane = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, create);
        if (plane == null) {
            return null;
        }
        PlaneTimingNode planeTiming = plane.getPlaneTiming();
        if (planeTiming == null) {
            if (create) {
                planeTiming = new PlaneTimingNode(plane);
            } else {
                return null;
            }
        }
        this.imagePixelsPlanePlaneTimingNode = planeTiming;
        return this.imagePixelsPlanePlaneTimingNode;
    }

    private StagePositionNode getStagePositionNode(int imageIndex, int pixelsIndex, int planeIndex, boolean create) {
        boolean match = true;
        if (this.imagePixelsPlaneStagePositionNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imagePixelsPlaneStagePositionNodePixelsIndex != pixelsIndex) {
            match = false;
        }
        if (this.imagePixelsPlaneStagePositionNodePlaneIndex != planeIndex) {
            match = false;
        }
        if (match) {
            return this.imagePixelsPlaneStagePositionNode;
        }
        this.imagePixelsPlaneStagePositionNode = null;
        this.imagePixelsPlaneStagePositionNodeImageIndex = imageIndex;
        this.imagePixelsPlaneStagePositionNodePixelsIndex = pixelsIndex;
        this.imagePixelsPlaneStagePositionNodePlaneIndex = planeIndex;
        PlaneNode plane = this.getPlaneNode(imageIndex, pixelsIndex, planeIndex, create);
        if (plane == null) {
            return null;
        }
        StagePositionNode stagePosition = plane.getStagePosition();
        if (stagePosition == null) {
            if (create) {
                stagePosition = new StagePositionNode(plane);
            } else {
                return null;
            }
        }
        this.imagePixelsPlaneStagePositionNode = stagePosition;
        return this.imagePixelsPlaneStagePositionNode;
    }

    private TiffDataNode getTiffDataNode(int imageIndex, int pixelsIndex, int tiffDataIndex, boolean create) {
        boolean match = true;
        if (this.imagePixelsTiffDataNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imagePixelsTiffDataNodePixelsIndex != pixelsIndex) {
            match = false;
        }
        if (this.imagePixelsTiffDataNodeTiffDataIndex != tiffDataIndex) {
            match = false;
        }
        if (match) {
            return this.imagePixelsTiffDataNode;
        }
        this.imagePixelsTiffDataNode = null;
        this.imagePixelsTiffDataNodeImageIndex = imageIndex;
        this.imagePixelsTiffDataNodePixelsIndex = pixelsIndex;
        this.imagePixelsTiffDataNodeTiffDataIndex = tiffDataIndex;
        PixelsNode pixels = this.getPixelsNode(imageIndex, pixelsIndex, create);
        if (pixels == null) {
            return null;
        }
        int count = pixels.getTiffDataCount();
        if (!create && count <= tiffDataIndex) {
            return null;
        }
        for (int i = count; i <= tiffDataIndex; ++i) {
            new TiffDataNode(pixels);
        }
        Vector list = pixels.getTiffDataList();
        this.imagePixelsTiffDataNode = (TiffDataNode)list.get(tiffDataIndex);
        return this.imagePixelsTiffDataNode;
    }

    private UUIDNode getUUIDNode(int imageIndex, int pixelsIndex, int tiffDataIndex, boolean create) {
        boolean match = true;
        if (this.imagePixelsTiffDataUUIDNodeImageIndex != imageIndex) {
            match = false;
        }
        if (this.imagePixelsTiffDataUUIDNodePixelsIndex != pixelsIndex) {
            match = false;
        }
        if (this.imagePixelsTiffDataUUIDNodeTiffDataIndex != tiffDataIndex) {
            match = false;
        }
        if (match) {
            return this.imagePixelsTiffDataUUIDNode;
        }
        this.imagePixelsTiffDataUUIDNode = null;
        this.imagePixelsTiffDataUUIDNodeImageIndex = imageIndex;
        this.imagePixelsTiffDataUUIDNodePixelsIndex = pixelsIndex;
        this.imagePixelsTiffDataUUIDNodeTiffDataIndex = tiffDataIndex;
        TiffDataNode tiffData = this.getTiffDataNode(imageIndex, pixelsIndex, tiffDataIndex, create);
        if (tiffData == null) {
            return null;
        }
        UUIDNode uuid = tiffData.getUUID();
        if (uuid == null) {
            if (create) {
                uuid = new UUIDNode(tiffData);
            } else {
                return null;
            }
        }
        this.imagePixelsTiffDataUUIDNode = uuid;
        return this.imagePixelsTiffDataUUIDNode;
    }

    private StageLabelNode getStageLabelNode(int imageIndex, boolean create) {
        boolean match = true;
        if (this.imageStageLabelNodeImageIndex != imageIndex) {
            match = false;
        }
        if (match) {
            return this.imageStageLabelNode;
        }
        this.imageStageLabelNode = null;
        this.imageStageLabelNodeImageIndex = imageIndex;
        ImageNode image = this.getImageNode(imageIndex, create);
        if (image == null) {
            return null;
        }
        StageLabelNode stageLabel = image.getStageLabel();
        if (stageLabel == null) {
            if (create) {
                stageLabel = new StageLabelNode(image);
            } else {
                return null;
            }
        }
        this.imageStageLabelNode = stageLabel;
        return this.imageStageLabelNode;
    }

    private InstrumentNode getInstrumentNode(int instrumentIndex, boolean create) {
        boolean match = true;
        if (this.instrumentNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentNode;
        }
        this.instrumentNode = null;
        this.instrumentNodeInstrumentIndex = instrumentIndex;
        OMENode ome = (OMENode)this.root;
        int count = ome.getInstrumentCount();
        if (!create && count <= instrumentIndex) {
            return null;
        }
        for (int i = count; i <= instrumentIndex; ++i) {
            new InstrumentNode(ome);
        }
        Vector list = ome.getInstrumentList();
        this.instrumentNode = (InstrumentNode)list.get(instrumentIndex);
        return this.instrumentNode;
    }

    private DetectorNode getDetectorNode(int instrumentIndex, int detectorIndex, boolean create) {
        boolean match = true;
        if (this.instrumentDetectorNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentDetectorNodeDetectorIndex != detectorIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentDetectorNode;
        }
        this.instrumentDetectorNode = null;
        this.instrumentDetectorNodeInstrumentIndex = instrumentIndex;
        this.instrumentDetectorNodeDetectorIndex = detectorIndex;
        InstrumentNode instrument = this.getInstrumentNode(instrumentIndex, create);
        if (instrument == null) {
            return null;
        }
        int count = instrument.getDetectorCount();
        if (!create && count <= detectorIndex) {
            return null;
        }
        for (int i = count; i <= detectorIndex; ++i) {
            new DetectorNode(instrument);
        }
        Vector list = instrument.getDetectorList();
        this.instrumentDetectorNode = (DetectorNode)list.get(detectorIndex);
        return this.instrumentDetectorNode;
    }

    private LightSourceNode getLightSourceNode(int instrumentIndex, int lightSourceIndex, boolean create) {
        boolean match = true;
        if (this.instrumentLightSourceNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentLightSourceNodeLightSourceIndex != lightSourceIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentLightSourceNode;
        }
        this.instrumentLightSourceNode = null;
        this.instrumentLightSourceNodeInstrumentIndex = instrumentIndex;
        this.instrumentLightSourceNodeLightSourceIndex = lightSourceIndex;
        InstrumentNode instrument = this.getInstrumentNode(instrumentIndex, create);
        if (instrument == null) {
            return null;
        }
        int count = instrument.getLightSourceCount();
        if (!create && count <= lightSourceIndex) {
            return null;
        }
        for (int i = count; i <= lightSourceIndex; ++i) {
            new LightSourceNode(instrument);
        }
        Vector list = instrument.getLightSourceList();
        this.instrumentLightSourceNode = (LightSourceNode)list.get(lightSourceIndex);
        return this.instrumentLightSourceNode;
    }

    private ArcNode getArcNode(int instrumentIndex, int lightSourceIndex, boolean create) {
        boolean match = true;
        if (this.instrumentLightSourceArcNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentLightSourceArcNodeLightSourceIndex != lightSourceIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentLightSourceArcNode;
        }
        this.instrumentLightSourceArcNode = null;
        this.instrumentLightSourceArcNodeInstrumentIndex = instrumentIndex;
        this.instrumentLightSourceArcNodeLightSourceIndex = lightSourceIndex;
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, create);
        if (lightSource == null) {
            return null;
        }
        ArcNode arc = lightSource.getArc();
        if (arc == null) {
            if (create) {
                arc = new ArcNode(lightSource);
            } else {
                return null;
            }
        }
        this.instrumentLightSourceArcNode = arc;
        return this.instrumentLightSourceArcNode;
    }

    private FilamentNode getFilamentNode(int instrumentIndex, int lightSourceIndex, boolean create) {
        boolean match = true;
        if (this.instrumentLightSourceFilamentNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentLightSourceFilamentNodeLightSourceIndex != lightSourceIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentLightSourceFilamentNode;
        }
        this.instrumentLightSourceFilamentNode = null;
        this.instrumentLightSourceFilamentNodeInstrumentIndex = instrumentIndex;
        this.instrumentLightSourceFilamentNodeLightSourceIndex = lightSourceIndex;
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, create);
        if (lightSource == null) {
            return null;
        }
        FilamentNode filament = lightSource.getFilament();
        if (filament == null) {
            if (create) {
                filament = new FilamentNode(lightSource);
            } else {
                return null;
            }
        }
        this.instrumentLightSourceFilamentNode = filament;
        return this.instrumentLightSourceFilamentNode;
    }

    private LaserNode getLaserNode(int instrumentIndex, int lightSourceIndex, boolean create) {
        boolean match = true;
        if (this.instrumentLightSourceLaserNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentLightSourceLaserNodeLightSourceIndex != lightSourceIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentLightSourceLaserNode;
        }
        this.instrumentLightSourceLaserNode = null;
        this.instrumentLightSourceLaserNodeInstrumentIndex = instrumentIndex;
        this.instrumentLightSourceLaserNodeLightSourceIndex = lightSourceIndex;
        LightSourceNode lightSource = this.getLightSourceNode(instrumentIndex, lightSourceIndex, create);
        if (lightSource == null) {
            return null;
        }
        LaserNode laser = lightSource.getLaser();
        if (laser == null) {
            if (create) {
                laser = new LaserNode(lightSource);
            } else {
                return null;
            }
        }
        this.instrumentLightSourceLaserNode = laser;
        return this.instrumentLightSourceLaserNode;
    }

    private OTFNode getOTFNode(int instrumentIndex, int otfIndex, boolean create) {
        boolean match = true;
        if (this.instrumentOTFNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentOTFNodeOTFIndex != otfIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentOTFNode;
        }
        this.instrumentOTFNode = null;
        this.instrumentOTFNodeInstrumentIndex = instrumentIndex;
        this.instrumentOTFNodeOTFIndex = otfIndex;
        InstrumentNode instrument = this.getInstrumentNode(instrumentIndex, create);
        if (instrument == null) {
            return null;
        }
        int count = instrument.getOTFCount();
        if (!create && count <= otfIndex) {
            return null;
        }
        for (int i = count; i <= otfIndex; ++i) {
            new OTFNode(instrument);
        }
        Vector list = instrument.getOTFList();
        this.instrumentOTFNode = (OTFNode)list.get(otfIndex);
        return this.instrumentOTFNode;
    }

    private ObjectiveRefNode getObjectiveRefNode(int instrumentIndex, int otfIndex, boolean create) {
        boolean match = true;
        if (this.instrumentOTFObjectiveRefNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentOTFObjectiveRefNodeOTFIndex != otfIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentOTFObjectiveRefNode;
        }
        this.instrumentOTFObjectiveRefNode = null;
        this.instrumentOTFObjectiveRefNodeInstrumentIndex = instrumentIndex;
        this.instrumentOTFObjectiveRefNodeOTFIndex = otfIndex;
        OTFNode otf = this.getOTFNode(instrumentIndex, otfIndex, create);
        if (otf == null) {
            return null;
        }
        ObjectiveRefNode objectiveRef = otf.getObjectiveRef();
        if (objectiveRef == null) {
            if (create) {
                objectiveRef = new ObjectiveRefNode(otf);
            } else {
                return null;
            }
        }
        this.instrumentOTFObjectiveRefNode = objectiveRef;
        return this.instrumentOTFObjectiveRefNode;
    }

    private ObjectiveNode getObjectiveNode(int instrumentIndex, int objectiveIndex, boolean create) {
        boolean match = true;
        if (this.instrumentObjectiveNodeInstrumentIndex != instrumentIndex) {
            match = false;
        }
        if (this.instrumentObjectiveNodeObjectiveIndex != objectiveIndex) {
            match = false;
        }
        if (match) {
            return this.instrumentObjectiveNode;
        }
        this.instrumentObjectiveNode = null;
        this.instrumentObjectiveNodeInstrumentIndex = instrumentIndex;
        this.instrumentObjectiveNodeObjectiveIndex = objectiveIndex;
        InstrumentNode instrument = this.getInstrumentNode(instrumentIndex, create);
        if (instrument == null) {
            return null;
        }
        int count = instrument.getObjectiveCount();
        if (!create && count <= objectiveIndex) {
            return null;
        }
        for (int i = count; i <= objectiveIndex; ++i) {
            new ObjectiveNode(instrument);
        }
        Vector list = instrument.getObjectiveList();
        this.instrumentObjectiveNode = (ObjectiveNode)list.get(objectiveIndex);
        return this.instrumentObjectiveNode;
    }

    private PlateNode getPlateNode(int plateIndex, boolean create) {
        boolean match = true;
        if (this.plateNodePlateIndex != plateIndex) {
            match = false;
        }
        if (match) {
            return this.plateNode;
        }
        this.plateNode = null;
        this.plateNodePlateIndex = plateIndex;
        OMENode ome = (OMENode)this.root;
        int count = ome.getPlateCount();
        if (!create && count <= plateIndex) {
            return null;
        }
        for (int i = count; i <= plateIndex; ++i) {
            new PlateNode(ome);
        }
        Vector list = ome.getPlateList();
        this.plateNode = (PlateNode)list.get(plateIndex);
        return this.plateNode;
    }

    private WellNode getWellNode(int plateIndex, int wellIndex, boolean create) {
        boolean match = true;
        if (this.plateWellNodePlateIndex != plateIndex) {
            match = false;
        }
        if (this.plateWellNodeWellIndex != wellIndex) {
            match = false;
        }
        if (match) {
            return this.plateWellNode;
        }
        this.plateWellNode = null;
        this.plateWellNodePlateIndex = plateIndex;
        this.plateWellNodeWellIndex = wellIndex;
        PlateNode plate = this.getPlateNode(plateIndex, create);
        if (plate == null) {
            return null;
        }
        int count = plate.getWellCount();
        if (!create && count <= wellIndex) {
            return null;
        }
        for (int i = count; i <= wellIndex; ++i) {
            new WellNode(plate);
        }
        Vector list = plate.getWellList();
        this.plateWellNode = (WellNode)list.get(wellIndex);
        return this.plateWellNode;
    }

    private WellSampleNode getWellSampleNode(int plateIndex, int wellIndex, int wellSampleIndex, boolean create) {
        boolean match = true;
        if (this.plateWellWellSampleNodePlateIndex != plateIndex) {
            match = false;
        }
        if (this.plateWellWellSampleNodeWellIndex != wellIndex) {
            match = false;
        }
        if (this.plateWellWellSampleNodeWellSampleIndex != wellSampleIndex) {
            match = false;
        }
        if (match) {
            return this.plateWellWellSampleNode;
        }
        this.plateWellWellSampleNode = null;
        this.plateWellWellSampleNodePlateIndex = plateIndex;
        this.plateWellWellSampleNodeWellIndex = wellIndex;
        this.plateWellWellSampleNodeWellSampleIndex = wellSampleIndex;
        WellNode well = this.getWellNode(plateIndex, wellIndex, create);
        if (well == null) {
            return null;
        }
        int count = well.getWellSampleCount();
        if (!create && count <= wellSampleIndex) {
            return null;
        }
        for (int i = count; i <= wellSampleIndex; ++i) {
            new WellSampleNode(well);
        }
        Vector list = well.getWellSampleList();
        this.plateWellWellSampleNode = (WellSampleNode)list.get(wellSampleIndex);
        return this.plateWellWellSampleNode;
    }

    private ScreenNode getScreenNode(int screenIndex, boolean create) {
        boolean match = true;
        if (this.screenNodeScreenIndex != screenIndex) {
            match = false;
        }
        if (match) {
            return this.screenNode;
        }
        this.screenNode = null;
        this.screenNodeScreenIndex = screenIndex;
        OMENode ome = (OMENode)this.root;
        int count = ome.getScreenCount();
        if (!create && count <= screenIndex) {
            return null;
        }
        for (int i = count; i <= screenIndex; ++i) {
            new ScreenNode(ome);
        }
        Vector list = ome.getScreenList();
        this.screenNode = (ScreenNode)list.get(screenIndex);
        return this.screenNode;
    }

    private PlateRefNode getPlateRefNode(int screenIndex, int plateRefIndex, boolean create) {
        boolean match = true;
        if (this.screenPlateRefNodeScreenIndex != screenIndex) {
            match = false;
        }
        if (this.screenPlateRefNodePlateRefIndex != plateRefIndex) {
            match = false;
        }
        if (match) {
            return this.screenPlateRefNode;
        }
        this.screenPlateRefNode = null;
        this.screenPlateRefNodeScreenIndex = screenIndex;
        this.screenPlateRefNodePlateRefIndex = plateRefIndex;
        ScreenNode screen = this.getScreenNode(screenIndex, create);
        if (screen == null) {
            return null;
        }
        int count = screen.getPlateRefCount();
        if (!create && count <= plateRefIndex) {
            return null;
        }
        for (int i = count; i <= plateRefIndex; ++i) {
            new PlateRefNode(screen);
        }
        Vector list = screen.getPlateRefList();
        this.screenPlateRefNode = (PlateRefNode)list.get(plateRefIndex);
        return this.screenPlateRefNode;
    }

    private ReagentNode getReagentNode(int screenIndex, int reagentIndex, boolean create) {
        boolean match = true;
        if (this.screenReagentNodeScreenIndex != screenIndex) {
            match = false;
        }
        if (this.screenReagentNodeReagentIndex != reagentIndex) {
            match = false;
        }
        if (match) {
            return this.screenReagentNode;
        }
        this.screenReagentNode = null;
        this.screenReagentNodeScreenIndex = screenIndex;
        this.screenReagentNodeReagentIndex = reagentIndex;
        ScreenNode screen = this.getScreenNode(screenIndex, create);
        if (screen == null) {
            return null;
        }
        int count = screen.getReagentCount();
        if (!create && count <= reagentIndex) {
            return null;
        }
        for (int i = count; i <= reagentIndex; ++i) {
            new ReagentNode(screen);
        }
        Vector list = screen.getReagentList();
        this.screenReagentNode = (ReagentNode)list.get(reagentIndex);
        return this.screenReagentNode;
    }

    private ScreenAcquisitionNode getScreenAcquisitionNode(int screenIndex, int screenAcquisitionIndex, boolean create) {
        boolean match = true;
        if (this.screenScreenAcquisitionNodeScreenIndex != screenIndex) {
            match = false;
        }
        if (this.screenScreenAcquisitionNodeScreenAcquisitionIndex != screenAcquisitionIndex) {
            match = false;
        }
        if (match) {
            return this.screenScreenAcquisitionNode;
        }
        this.screenScreenAcquisitionNode = null;
        this.screenScreenAcquisitionNodeScreenIndex = screenIndex;
        this.screenScreenAcquisitionNodeScreenAcquisitionIndex = screenAcquisitionIndex;
        ScreenNode screen = this.getScreenNode(screenIndex, create);
        if (screen == null) {
            return null;
        }
        int count = screen.getScreenAcquisitionCount();
        if (!create && count <= screenAcquisitionIndex) {
            return null;
        }
        for (int i = count; i <= screenAcquisitionIndex; ++i) {
            new ScreenAcquisitionNode(screen);
        }
        Vector list = screen.getScreenAcquisitionList();
        this.screenScreenAcquisitionNode = (ScreenAcquisitionNode)list.get(screenAcquisitionIndex);
        return this.screenScreenAcquisitionNode;
    }

    private void clearCachedNodes() {
        this.experimentNode = null;
        this.experimentNodeExperimentIndex = -1;
        this.experimenterNode = null;
        this.experimenterNodeExperimenterIndex = -1;
        this.experimenterGroupRefNode = null;
        this.experimenterGroupRefNodeExperimenterIndex = -1;
        this.experimenterGroupRefNodeGroupRefIndex = -1;
        this.imageNode = null;
        this.imageNodeImageIndex = -1;
        this.imageDisplayOptionsNode = null;
        this.imageDisplayOptionsNodeImageIndex = -1;
        this.imageDisplayOptionsProjectionNode = null;
        this.imageDisplayOptionsProjectionNodeImageIndex = -1;
        this.imageDisplayOptionsROINode = null;
        this.imageDisplayOptionsROINodeImageIndex = -1;
        this.imageDisplayOptionsROINodeROIIndex = -1;
        this.imageDisplayOptionsTimeNode = null;
        this.imageDisplayOptionsTimeNodeImageIndex = -1;
        this.imageImagingEnvironmentNode = null;
        this.imageImagingEnvironmentNodeImageIndex = -1;
        this.imageLogicalChannelNode = null;
        this.imageLogicalChannelNodeImageIndex = -1;
        this.imageLogicalChannelNodeLogicalChannelIndex = -1;
        this.imageLogicalChannelChannelComponentNode = null;
        this.imageLogicalChannelChannelComponentNodeImageIndex = -1;
        this.imageLogicalChannelChannelComponentNodeLogicalChannelIndex = -1;
        this.imageLogicalChannelChannelComponentNodeChannelComponentIndex = -1;
        this.imageLogicalChannelDetectorRefNode = null;
        this.imageLogicalChannelDetectorRefNodeImageIndex = -1;
        this.imageLogicalChannelDetectorRefNodeLogicalChannelIndex = -1;
        this.imageLogicalChannelLightSourceRefNode = null;
        this.imageLogicalChannelLightSourceRefNodeImageIndex = -1;
        this.imageLogicalChannelLightSourceRefNodeLogicalChannelIndex = -1;
        this.imageLogicalChannelOTFRefNode = null;
        this.imageLogicalChannelOTFRefNodeImageIndex = -1;
        this.imageLogicalChannelOTFRefNodeLogicalChannelIndex = -1;
        this.imageObjectiveRefNode = null;
        this.imageObjectiveRefNodeImageIndex = -1;
        this.imagePixelsNode = null;
        this.imagePixelsNodeImageIndex = -1;
        this.imagePixelsNodePixelsIndex = -1;
        this.imagePixelsPlaneNode = null;
        this.imagePixelsPlaneNodeImageIndex = -1;
        this.imagePixelsPlaneNodePixelsIndex = -1;
        this.imagePixelsPlaneNodePlaneIndex = -1;
        this.imagePixelsPlanePlaneTimingNode = null;
        this.imagePixelsPlanePlaneTimingNodeImageIndex = -1;
        this.imagePixelsPlanePlaneTimingNodePixelsIndex = -1;
        this.imagePixelsPlanePlaneTimingNodePlaneIndex = -1;
        this.imagePixelsPlaneStagePositionNode = null;
        this.imagePixelsPlaneStagePositionNodeImageIndex = -1;
        this.imagePixelsPlaneStagePositionNodePixelsIndex = -1;
        this.imagePixelsPlaneStagePositionNodePlaneIndex = -1;
        this.imagePixelsTiffDataNode = null;
        this.imagePixelsTiffDataNodeImageIndex = -1;
        this.imagePixelsTiffDataNodePixelsIndex = -1;
        this.imagePixelsTiffDataNodeTiffDataIndex = -1;
        this.imagePixelsTiffDataUUIDNode = null;
        this.imagePixelsTiffDataUUIDNodeImageIndex = -1;
        this.imagePixelsTiffDataUUIDNodePixelsIndex = -1;
        this.imagePixelsTiffDataUUIDNodeTiffDataIndex = -1;
        this.imageStageLabelNode = null;
        this.imageStageLabelNodeImageIndex = -1;
        this.instrumentNode = null;
        this.instrumentNodeInstrumentIndex = -1;
        this.instrumentDetectorNode = null;
        this.instrumentDetectorNodeInstrumentIndex = -1;
        this.instrumentDetectorNodeDetectorIndex = -1;
        this.instrumentLightSourceNode = null;
        this.instrumentLightSourceNodeInstrumentIndex = -1;
        this.instrumentLightSourceNodeLightSourceIndex = -1;
        this.instrumentLightSourceArcNode = null;
        this.instrumentLightSourceArcNodeInstrumentIndex = -1;
        this.instrumentLightSourceArcNodeLightSourceIndex = -1;
        this.instrumentLightSourceFilamentNode = null;
        this.instrumentLightSourceFilamentNodeInstrumentIndex = -1;
        this.instrumentLightSourceFilamentNodeLightSourceIndex = -1;
        this.instrumentLightSourceLaserNode = null;
        this.instrumentLightSourceLaserNodeInstrumentIndex = -1;
        this.instrumentLightSourceLaserNodeLightSourceIndex = -1;
        this.instrumentOTFNode = null;
        this.instrumentOTFNodeInstrumentIndex = -1;
        this.instrumentOTFNodeOTFIndex = -1;
        this.instrumentOTFObjectiveRefNode = null;
        this.instrumentOTFObjectiveRefNodeInstrumentIndex = -1;
        this.instrumentOTFObjectiveRefNodeOTFIndex = -1;
        this.instrumentObjectiveNode = null;
        this.instrumentObjectiveNodeInstrumentIndex = -1;
        this.instrumentObjectiveNodeObjectiveIndex = -1;
        this.plateNode = null;
        this.plateNodePlateIndex = -1;
        this.plateWellNode = null;
        this.plateWellNodePlateIndex = -1;
        this.plateWellNodeWellIndex = -1;
        this.plateWellWellSampleNode = null;
        this.plateWellWellSampleNodePlateIndex = -1;
        this.plateWellWellSampleNodeWellIndex = -1;
        this.plateWellWellSampleNodeWellSampleIndex = -1;
        this.screenNode = null;
        this.screenNodeScreenIndex = -1;
        this.screenPlateRefNode = null;
        this.screenPlateRefNodeScreenIndex = -1;
        this.screenPlateRefNodePlateRefIndex = -1;
        this.screenReagentNode = null;
        this.screenReagentNodeScreenIndex = -1;
        this.screenReagentNodeReagentIndex = -1;
        this.screenScreenAcquisitionNode = null;
        this.screenScreenAcquisitionNodeScreenIndex = -1;
        this.screenScreenAcquisitionNodeScreenAcquisitionIndex = -1;
    }
}

