/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import loci.common.Location;
import loci.formats.AWTImageTools;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.IFormatReader;
import loci.plugins.Checker;
import loci.plugins.ThumbLoader;
import loci.plugins.Util;

public class ImporterOptions
implements FocusListener,
ItemListener,
MouseListener {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCELED = 1;
    public static final int STATUS_FINISHED = 2;
    public static final String VIEW_NONE = "Metadata only";
    public static final String VIEW_STANDARD = "Standard ImageJ";
    public static final String VIEW_HYPERSTACK = "Hyperstack";
    public static final String VIEW_BROWSER = "Data Browser";
    public static final String VIEW_VISBIO = "VisBio";
    public static final String VIEW_IMAGE_5D = "Image5D";
    public static final String VIEW_VIEW_5D = "View5D";
    public static final String ORDER_DEFAULT = "Default";
    public static final String ORDER_XYZCT = "XYZCT";
    public static final String ORDER_XYZTC = "XYZTC";
    public static final String ORDER_XYCZT = "XYCZT";
    public static final String ORDER_XYTCZ = "XYTCZ";
    public static final String ORDER_XYCTZ = "XYCTZ";
    public static final String ORDER_XYTZC = "XYTZC";
    public static final String MERGE_DEFAULT = "Do not merge";
    public static final String MERGE_PROJECTION = "Spectral projection";
    private static final String CLASS_VISBIO = "loci.visbio.VisBio";
    private static final String CLASS_IMAGE_5D = "i5d.Image5D";
    private static final String CLASS_VIEW_5D = "View5D_";
    public static final String LOCATION_LOCAL = "Local machine";
    public static final String LOCATION_HTTP = "Internet";
    public static final String LOCATION_OME = "OME server";
    public static final String LOCATION_OMERO = "OMERO server";
    public static final String[] LOCATIONS = new String[]{"Local machine", "Internet", "OME server", "OMERO server"};
    public static final String PREF_STACK = "bioformats.stackFormat";
    public static final String PREF_ORDER = "bioformats.stackOrder";
    public static final String PREF_MERGE = "bioformats.mergeChannels";
    public static final String PREF_COLORIZE = "bioformats.colorize";
    public static final String PREF_SPLIT_C = "bioformats.splitWindows";
    public static final String PREF_SPLIT_Z = "bioformats.splitFocalPlanes";
    public static final String PREF_SPLIT_T = "bioformats.splitTimepoints";
    public static final String PREF_CROP = "bioformats.crop";
    public static final String PREF_METADATA = "bioformats.showMetadata";
    public static final String PREF_OME_XML = "bioformats.showOMEXML";
    public static final String PREF_GROUP = "bioformats.groupFiles";
    public static final String PREF_CONCATENATE = "bioformats.concatenate";
    public static final String PREF_RANGE = "bioformats.specifyRanges";
    public static final String PREF_AUTOSCALE = "bioformats.autoscale";
    public static final String PREF_VIRTUAL = "bioformats.virtual";
    public static final String PREF_RECORD = "bioformats.record";
    public static final String PREF_ALL_SERIES = "bioformats.openAllSeries";
    public static final String PREF_MERGE_OPTION = "bioformats.mergeOption";
    public static final String PREF_WINDOWLESS = "bioformats.windowless";
    public static final String PREF_SERIES = "bioformats.series";
    public static final String PREF_FIRST = "bioformats.firstTime";
    public static final String PREF_THUMBNAIL = "bioformats.forceThumbnails";
    public static final String PREF_SWAP = "bioformats.swapDimensions";
    public static final String LABEL_STACK = "View stack with: ";
    public static final String LABEL_ORDER = "Stack_order: ";
    public static final String LABEL_MERGE = "Merge_channels to RGB";
    public static final String LABEL_COLORIZE = "Colorize channels";
    public static final String LABEL_SPLIT_C = "Split_channels";
    public static final String LABEL_SPLIT_Z = "Split_focal planes";
    public static final String LABEL_SPLIT_T = "Split_timepoints";
    public static final String LABEL_CROP = "Crop on import";
    public static final String LABEL_METADATA = "Display_metadata in results window";
    public static final String LABEL_OME_XML = "Display_OME-XML metadata";
    public static final String LABEL_GROUP = "Group_files with similar names";
    public static final String LABEL_CONCATENATE = "Concatenate_series when compatible";
    public static final String LABEL_RANGE = "Specify_range for each series";
    public static final String LABEL_AUTOSCALE = "Autoscale";
    public static final String LABEL_VIRTUAL = "Use_virtual_stack";
    public static final String LABEL_RECORD = "Record_modifications_to_virtual_stack";
    public static final String LABEL_ALL_SERIES = "Open_all_series";
    public static final String LABEL_SWAP = "Swap_dimensions";
    public static final String LABEL_MERGE_OPTION = "Merging Options";
    public static final String LABEL_WINDOWLESS = "windowless";
    public static final String LABEL_SERIES = "series";
    public static final String LABEL_LOCATION = "Location: ";
    public static final String LABEL_ID = "Open";
    public static final String INFO_STACK = ImporterOptions.info("View stack with: ") + " - The type of image viewer to use when displaying the dataset." + "<br><br>Possible choices are:<ul>" + "<li><b>" + "Metadata only" + "</b> - Display no pixels, only metadata.</li>" + "<li><b>" + "Standard ImageJ" + "</b> - Display the pixels in a standard " + "ImageJ window without multidimensional support.</li>" + "<li><b>" + "Hyperstack" + "</b> - Display the pixels in ImageJ's " + "built-in 5D viewer. If you do not have this option, upgrade to a more " + "recent version of ImageJ.</li>" + "<li><b>" + "Data Browser" + "</b> - Display the pixels in LOCI's " + "multidimensional Data Browser viewer. The Data Browser has some " + "additional features on top of the normal ImageJ hyperstack. If you do " + "not have this option, upgrade to a more recent version of ImageJ.</li>" + "<li><b>" + "Image5D" + "</b> - Display the pixels in " + "Joachim Walter's Image5D viewer. Requires the Image5D plugin.</li>" + "<li><b>" + "View5D" + "</b> - Display the pixels in " + "Rainer Heintzmann's View5D viewer. Requires the View5D plugin.</li>" + "</ul>";
    public static final String INFO_ORDER = ImporterOptions.info("Stack_order: ") + " - Controls the rasterization order of the dataset's dimensional axes." + "<br><br>Unless you care about the order in which the image planes " + "appear, you probably don't need to worry too much about this option." + "<br><br>By default, Bio-Formats reads the image planes in whatever " + "order they are stored, which is format-dependent. However, several " + "stack view modes require a specific rasterization order:<ul>" + "<li>Hyperstacks must be in " + "XYCZT" + " order.</li>" + "<li>Image5D must be in " + "XYCZT" + " order.</li>" + "<li>View5D must be in " + "XYCZT" + " order.</li>" + "</ul><b>Example:</b> For a dataset in " + "XYCZT" + " order with " + "2 channels, 3 focal planes and 5 time points, the order would be:<ol>" + "<li>C1-Z1-T1</li>" + "<li>C2-Z1-T1</li>" + "<li>C1-Z2-T1</li>" + "<li>C2-Z2-T1</li>" + "<li>C1-Z3-T1</li>" + "<li>C2-Z3-T1</li>" + "<li>C1-Z1-T2</li>" + "<li>C2-Z1-T2</li>" + "<li>etc.</li>" + "</ol>";
    public static final String INFO_MERGE = ImporterOptions.info("Merge_channels to RGB") + " - A dataset with multiple channels will be opened and merged with " + "channels pseudocolored in the order of the RGB color scheme; i.e., " + "channel 1 is red, channel 2 is green, and channel 3 is blue." + "<br><br>The bit depth will be preserved. If the dataset has more than " + "3 channels, Bio-Formats will ask how to combine them." + "<br><br>For example, a 12-channel image could be combined into:<ul>" + "<li>6 planes with 2 channels each (1st channel is red, 2nd is green)" + "</li>" + "<li>4 planes with 3 channels each (3rd channel is blue)</li>" + "<li>3 planes with 4 channels each (4th channel is gray)</li>" + "<li>3 planes with 5 channels each (5th channel is cyan)</li>" + "<li>2 planes with 6 channels each (6th channel is magenta)</li>" + "<li>2 planes with 7 channels each (7th channel is yellow)</li>" + "</ul>";
    public static final String INFO_COLORIZE = ImporterOptions.info("Colorize channels") + " - Each channel is assigned an appropriate pseudocolor table rather " + "than the normal grayscale." + "<br><br>The first channel is colorized red, the second channel is " + "green, and the third channel is blue. This option is not available " + "when " + ImporterOptions.info("Merge_channels to RGB") + " is set.";
    public static final String INFO_SPLIT_C = ImporterOptions.info("Split_channels") + " - Each channel is opened as a separate stack." + "<br><br>This option is especially useful if you want to merge the " + "channels into a specific order, rather than automatically assign " + "channels to the order of RGB. The bit depth is preserved.";
    public static final String INFO_SPLIT_Z = ImporterOptions.info("Split_focal planes") + " - Each focal plane is opened as a separate stack.";
    public static final String INFO_SPLIT_T = ImporterOptions.info("Split_timepoints") + " - Timelapse data will be opened as a separate stack for each timepoint.";
    public static final String INFO_CROP = ImporterOptions.info("Crop on import") + " - Image planes may be cropped during import to conserve memory." + "<br><br>A window is opened with display of the pixel width and height " + "of the image plane. Enter the X and Y coordinates for the upper left " + "corner of the crop region and the width and height of the selection to " + "be displayed, in pixels.";
    public static final String INFO_METADATA = ImporterOptions.info("Display_metadata in results window") + " - Reads metadata that may be contained within the file format and " + "displays it. You can save it as a text file or copy it from the File " + "and Edit menus specific to the ImageJ Results window. Readability " + "depends upon the manner in which metadata is formatted in the data " + "source.";
    public static final String INFO_OME_XML = ImporterOptions.info("Display_OME-XML metadata") + " - Displays a tree of metadata standardized into the OME data model. " + "This structure is the same regardless of file format, though some " + "formats will populate more information than others." + "<br><br><b>Examples:</b><ul>" + "<li>The title of the dataset is listed under " + "OME &gt; Image &gt; Name.</li>" + "<li>The time and date when the dataset was acquired is listed under " + "OME &gt; Image &gt; CreationDate.</li>" + "<li>The physical pixel sizes of each plane in microns is listed under " + "OME &gt; Image &gt; Pixels &gt; " + "PhysicalSizeX, PhysicalSizeY, PhysicalSizeZ.</li>" + "</ul>";
    public static final String INFO_GROUP = ImporterOptions.info("Group_files with similar names") + " - Parses filenames in the selected folder to open files with similar " + "names as planes in the same dataset." + "<br><br>The base filename and path is presented before opening for " + "editing." + "<br><br><b>Example:</b> Suppose you have a collection of 12 TIFF files " + "numbered data1.tif, data2.tif, ..., data12.tif, with each file " + "representing one timepoint, and containing the 9 focal planes at that " + "timepoint. If you leave this option unchecked and attempt to import " + "data1.tif, Bio-Formats will create an image stack with 9 planes. " + "But if you enable this option, Bio-Formats will automatically detect " + "the other similarly named files and present a confirmation dialog with " + "the detected file pattern, which in this example would be " + "<code>data&lt;1-12&gt;.tif</code>. You can then edit the pattern in " + "case it is incorrect. Bio-Formats will then import all 12 x 9 = 108 " + "planes of the dataset.";
    public static final String INFO_CONCATENATE = ImporterOptions.info("Concatenate_series when compatible") + " - Allows multiple image series to be joined end to end." + "<br><br><b>Example:</b> You want to join two sequential timelapse " + "series.";
    public static final String INFO_RANGE = ImporterOptions.info("Specify_range for each series") + " - Opens only the specified range of image planes from a dataset." + "<br><br>After analyzing the dataset dimensional parameters, " + "Bio-Formats will present an additional dialog box prompting for the " + "desired range." + "<br><br><b>Example:</b> You only want to open the range of focal " + "planes in a z-series that actually contain structures of interest to " + "conserve memory.";
    public static final String INFO_AUTOSCALE = ImporterOptions.info("Autoscale") + " - Stretches the histogram of the image planes to fit the data range. " + "Does not alter underlying values in the image. If selected, histogram " + "is stretched for each stack based upon the global minimum and maximum " + "value throughout the stack. " + "<br><br>Note that you can use the Brightness &amp; Contrast or " + "Window/Level controls to adjust the contrast range regardless of " + "whether this option is used.";
    public static final String INFO_VIRTUAL = ImporterOptions.info("Use_virtual_stack") + " - Only reads one image plane into memory at a time, loading from the " + "data source on the fly as the active image plane changes." + "<br><br>This option is essential for datasets too large to fit into " + "memory.";
    public static final String INFO_RECORD = ImporterOptions.info("Record_modifications_to_virtual_stack") + " - <i>BETA FEATURE</i> - Record and reapply changes to virtual stack " + "planes." + "<br><br>When viewing as a virtual stack with this option enabled, " + "Bio-Formats will attempt to record the operations you perform. When " + "you switch to a new image plane, Bio-Formats will \"play back\" those " + "same operations, so that the image plane undergoes the same processing " + "you performed previously. In this way, the image stack should behave " + "more like a normal, fully memory-resident image stack.";
    public static final String INFO_ALL_SERIES = ImporterOptions.info("Open_all_series") + " - Opens every available image series without prompting." + "<br><br>Some datasets contain multiple distinct image series. Normally " + "when Bio-Formats detects such data it presents a dialog box with " + "thumbnails allowing individual selection of each available series. " + "Checking this box instructs Bio-Formats to bypass this dialog box and " + "instead open every available image series. Essentially, it is a " + "shortcut for checking all the boxes in the series selector dialog box. " + "It is also useful in a macro when the number of available image series " + "is unknown.";
    public static final String INFO_SWAP = ImporterOptions.info("Swap_dimensions") + " - " + " - Allows reassignment of dimensional axes (e.g., channel, Z and time)." + "<br><br>Bio-Formats is supposed to be smart about handling " + "multidimensional image data, but in some cases gets things wrong. " + "For example, when stitching together a dataset from multiple files " + "using the " + ImporterOptions.info("Group_files with similar names") + " option, Bio-Formats may not know " + "which dimensional axis the file numbering is supposed to represent. " + "It will take a guess, but in case it guesses wrong, you can use " + ImporterOptions.info("Swap_dimensions") + " to reassign which dimensions are which.";
    public static final String INFO_DEFAULT = "<i>Select an option for a detailed explanation. Documentation written by Glen MacDonald and Curtis Rueden.</i>";
    private static final boolean IS_GLITCHED = System.getProperty("os.name").indexOf("Mac OS X") >= 0;
    private Choice stackChoice;
    private Choice orderChoice;
    private Checkbox mergeBox;
    private Checkbox colorizeBox;
    private Checkbox splitCBox;
    private Checkbox splitZBox;
    private Checkbox splitTBox;
    private Checkbox metadataBox;
    private Checkbox omexmlBox;
    private Checkbox groupBox;
    private Checkbox concatenateBox;
    private Checkbox rangeBox;
    private Checkbox autoscaleBox;
    private Checkbox virtualBox;
    private Checkbox recordBox;
    private Checkbox allSeriesBox;
    private Checkbox cropBox;
    private Checkbox swapBox;
    private Hashtable infoTable;
    private JEditorPane infoPane;
    private Choice mergeChoice;
    private boolean firstTime;
    private String stackFormat;
    private String stackOrder;
    private boolean mergeChannels;
    private boolean colorize;
    private boolean splitChannels;
    private boolean splitFocalPlanes;
    private boolean splitTimepoints;
    private boolean crop;
    private boolean showMetadata;
    private boolean showOMEXML;
    private boolean groupFiles;
    private boolean concatenate;
    private boolean specifyRanges;
    private boolean autoscale;
    private boolean virtual;
    private boolean record;
    private boolean openAllSeries;
    private boolean swapDimensions;
    private String mergeOption;
    private boolean windowless;
    private String seriesString;
    private boolean forceThumbnails;
    private String location;
    private String id;
    private boolean quiet;
    private Location idLoc;
    private String idName;
    private String idType;

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public String getStackFormat() {
        return this.stackFormat;
    }

    public String getStackOrder() {
        return this.stackOrder;
    }

    public boolean isMergeChannels() {
        return this.mergeChannels;
    }

    public boolean isColorize() {
        return this.colorize;
    }

    public boolean isSplitChannels() {
        return this.splitChannels;
    }

    public boolean isSplitFocalPlanes() {
        return this.splitFocalPlanes;
    }

    public boolean isSplitTimepoints() {
        return this.splitTimepoints;
    }

    public boolean isShowMetadata() {
        return this.showMetadata;
    }

    public boolean isShowOMEXML() {
        return this.showOMEXML;
    }

    public boolean isGroupFiles() {
        return this.groupFiles;
    }

    public boolean isConcatenate() {
        return this.concatenate;
    }

    public boolean isSpecifyRanges() {
        return this.specifyRanges;
    }

    public boolean isForceThumbnails() {
        return this.forceThumbnails;
    }

    public boolean isAutoscale() {
        return this.autoscale;
    }

    public boolean isWindowless() {
        return this.windowless;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isRecord() {
        return this.record;
    }

    public boolean openAllSeries() {
        return this.openAllSeries;
    }

    public boolean doCrop() {
        return this.crop;
    }

    public boolean isSwapDimensions() {
        return this.swapDimensions;
    }

    public String getMergeOption() {
        return this.mergeOption;
    }

    public boolean isViewNone() {
        return VIEW_NONE.equals(this.stackFormat);
    }

    public boolean isViewStandard() {
        return VIEW_STANDARD.equals(this.stackFormat);
    }

    public boolean isViewHyperstack() {
        return VIEW_HYPERSTACK.equals(this.stackFormat);
    }

    public boolean isViewBrowser() {
        return VIEW_BROWSER.equals(this.stackFormat);
    }

    public boolean isViewVisBio() {
        return VIEW_VISBIO.equals(this.stackFormat);
    }

    public boolean isViewImage5D() {
        return VIEW_IMAGE_5D.equals(this.stackFormat);
    }

    public boolean isViewView5D() {
        return VIEW_VIEW_5D.equals(this.stackFormat);
    }

    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isLocal() {
        return LOCATION_LOCAL.equals(this.location);
    }

    public boolean isHTTP() {
        return LOCATION_HTTP.equals(this.location);
    }

    public boolean isOME() {
        return LOCATION_OME.equals(this.location);
    }

    public boolean isOMERO() {
        return LOCATION_OMERO.equals(this.location);
    }

    public Location getIdLocation() {
        return this.idLoc;
    }

    public String getIdName() {
        return this.idName;
    }

    public String getIdType() {
        return this.idType;
    }

    public void setStackFormat(String s) {
        this.stackFormat = s;
    }

    public void setStackOrder(String s) {
        this.stackOrder = s;
    }

    public void setMergeChannels(boolean b) {
        this.mergeChannels = b;
    }

    public void setColorize(boolean b) {
        this.colorize = b;
    }

    public void setSplitChannels(boolean b) {
        this.splitChannels = b;
    }

    public void setSplitFocalPlanes(boolean b) {
        this.splitFocalPlanes = b;
    }

    public void setSplitTimepoints(boolean b) {
        this.splitTimepoints = b;
    }

    public void setShowMetadata(boolean b) {
        this.showMetadata = b;
    }

    public void setShowOMEXML(boolean b) {
        this.showOMEXML = b;
    }

    public void setGroupFiles(boolean b) {
        this.groupFiles = b;
    }

    public void setConcatenate(boolean b) {
        this.concatenate = b;
    }

    public void setSpecifyRanges(boolean b) {
        this.specifyRanges = b;
    }

    public void setForceThumbnails(boolean b) {
        this.forceThumbnails = b;
    }

    public void setAutoscale(boolean b) {
        this.autoscale = b;
    }

    public void setWindowless(boolean b) {
        this.windowless = b;
    }

    public void setVirtual(boolean b) {
        this.virtual = b;
    }

    public void setRecord(boolean b) {
        this.record = b;
    }

    public void setOpenAllSeries(boolean b) {
        this.openAllSeries = b;
    }

    public void setCrop(boolean b) {
        this.crop = b;
    }

    public void setSwapDimensions(boolean b) {
        this.swapDimensions = b;
    }

    public void loadPreferences() {
        this.stackFormat = Prefs.get((String)PREF_STACK, (String)VIEW_STANDARD);
        this.stackOrder = Prefs.get((String)PREF_ORDER, (String)ORDER_DEFAULT);
        this.mergeChannels = Prefs.get((String)PREF_MERGE, (boolean)false);
        this.colorize = Prefs.get((String)PREF_COLORIZE, (boolean)true);
        this.splitChannels = Prefs.get((String)PREF_SPLIT_C, (boolean)true);
        this.splitFocalPlanes = Prefs.get((String)PREF_SPLIT_Z, (boolean)false);
        this.splitTimepoints = Prefs.get((String)PREF_SPLIT_T, (boolean)false);
        this.crop = Prefs.get((String)PREF_CROP, (boolean)false);
        this.showMetadata = Prefs.get((String)PREF_METADATA, (boolean)false);
        this.showOMEXML = Prefs.get((String)PREF_OME_XML, (boolean)false);
        this.groupFiles = Prefs.get((String)PREF_GROUP, (boolean)false);
        this.concatenate = Prefs.get((String)PREF_CONCATENATE, (boolean)false);
        this.specifyRanges = Prefs.get((String)PREF_RANGE, (boolean)false);
        this.autoscale = Prefs.get((String)PREF_AUTOSCALE, (boolean)true);
        this.virtual = Prefs.get((String)PREF_VIRTUAL, (boolean)false);
        this.record = Prefs.get((String)PREF_RECORD, (boolean)true);
        this.openAllSeries = Prefs.get((String)PREF_ALL_SERIES, (boolean)false);
        this.swapDimensions = Prefs.get((String)PREF_SWAP, (boolean)false);
        this.mergeOption = Prefs.get((String)PREF_MERGE_OPTION, (String)MERGE_DEFAULT);
        this.windowless = Prefs.get((String)PREF_WINDOWLESS, (boolean)false);
        this.seriesString = Prefs.get((String)PREF_SERIES, (String)"0");
        this.firstTime = Prefs.get((String)PREF_FIRST, (boolean)true);
        this.forceThumbnails = Prefs.get((String)PREF_THUMBNAIL, (boolean)false);
    }

    public void savePreferences() {
        Prefs.set((String)PREF_STACK, (String)this.stackFormat);
        Prefs.set((String)PREF_ORDER, (String)this.stackOrder);
        Prefs.set((String)PREF_MERGE, (boolean)this.mergeChannels);
        Prefs.set((String)PREF_COLORIZE, (boolean)this.colorize);
        Prefs.set((String)PREF_SPLIT_C, (boolean)this.splitChannels);
        Prefs.set((String)PREF_SPLIT_Z, (boolean)this.splitFocalPlanes);
        Prefs.set((String)PREF_SPLIT_T, (boolean)this.splitTimepoints);
        Prefs.set((String)PREF_CROP, (boolean)this.crop);
        Prefs.set((String)PREF_METADATA, (boolean)this.showMetadata);
        Prefs.set((String)PREF_OME_XML, (boolean)this.showOMEXML);
        Prefs.set((String)PREF_GROUP, (boolean)this.groupFiles);
        Prefs.set((String)PREF_CONCATENATE, (boolean)this.concatenate);
        Prefs.set((String)PREF_RANGE, (boolean)this.specifyRanges);
        Prefs.set((String)PREF_AUTOSCALE, (boolean)this.autoscale);
        Prefs.set((String)PREF_VIRTUAL, (boolean)this.virtual);
        Prefs.set((String)PREF_RECORD, (boolean)this.record);
        Prefs.set((String)PREF_ALL_SERIES, (boolean)this.openAllSeries);
        Prefs.set((String)PREF_SWAP, (boolean)this.swapDimensions);
        Prefs.set((String)PREF_MERGE_OPTION, (String)this.mergeOption);
        Prefs.set((String)PREF_WINDOWLESS, (boolean)this.windowless);
        Prefs.set((String)PREF_SERIES, (String)this.seriesString);
        Prefs.set((String)PREF_FIRST, (boolean)false);
    }

    public void parseArg(String arg) {
        if (arg == null || arg.length() == 0) {
            return;
        }
        if (new Location(arg).exists()) {
            this.location = LOCATION_LOCAL;
            this.id = arg;
            this.quiet = true;
        } else {
            this.stackFormat = Macro.getValue((String)arg, (String)LABEL_STACK, (String)this.stackFormat);
            this.stackOrder = Macro.getValue((String)arg, (String)LABEL_ORDER, (String)this.stackOrder);
            this.mergeChannels = ImporterOptions.getMacroValue(arg, LABEL_MERGE, this.mergeChannels);
            this.colorize = ImporterOptions.getMacroValue(arg, LABEL_COLORIZE, this.colorize);
            this.splitChannels = ImporterOptions.getMacroValue(arg, LABEL_SPLIT_C, this.splitChannels);
            this.splitFocalPlanes = ImporterOptions.getMacroValue(arg, LABEL_SPLIT_Z, this.splitFocalPlanes);
            this.splitTimepoints = ImporterOptions.getMacroValue(arg, LABEL_SPLIT_T, this.splitTimepoints);
            this.crop = ImporterOptions.getMacroValue(arg, LABEL_CROP, this.crop);
            this.showMetadata = ImporterOptions.getMacroValue(arg, LABEL_METADATA, this.showMetadata);
            this.showOMEXML = ImporterOptions.getMacroValue(arg, LABEL_OME_XML, this.showOMEXML);
            this.groupFiles = ImporterOptions.getMacroValue(arg, LABEL_GROUP, this.groupFiles);
            this.concatenate = ImporterOptions.getMacroValue(arg, LABEL_CONCATENATE, this.concatenate);
            this.specifyRanges = ImporterOptions.getMacroValue(arg, LABEL_RANGE, this.specifyRanges);
            this.autoscale = ImporterOptions.getMacroValue(arg, LABEL_AUTOSCALE, this.autoscale);
            this.virtual = ImporterOptions.getMacroValue(arg, LABEL_VIRTUAL, this.virtual);
            this.record = ImporterOptions.getMacroValue(arg, LABEL_RECORD, this.record);
            this.openAllSeries = ImporterOptions.getMacroValue(arg, LABEL_ALL_SERIES, this.openAllSeries);
            this.swapDimensions = ImporterOptions.getMacroValue(arg, LABEL_SWAP, this.swapDimensions);
            this.mergeOption = Macro.getValue((String)arg, (String)LABEL_MERGE_OPTION, (String)this.mergeOption);
            this.windowless = ImporterOptions.getMacroValue(arg, LABEL_WINDOWLESS, this.windowless);
            this.seriesString = Macro.getValue((String)arg, (String)LABEL_SERIES, (String)"0");
            this.location = Macro.getValue((String)arg, (String)LABEL_LOCATION, (String)this.location);
            this.id = Macro.getValue((String)arg, (String)LABEL_ID, (String)this.id);
        }
    }

    public int promptLocation() {
        if (this.location == null) {
            GenericDialog gd = new GenericDialog("Bio-Formats Dataset Location");
            gd.addChoice(LABEL_LOCATION, LOCATIONS, LOCATION_LOCAL);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return 1;
            }
            this.location = gd.getNextChoice();
        }
        boolean isLocal = LOCATION_LOCAL.equals(this.location);
        boolean isHTTP = LOCATION_HTTP.equals(this.location);
        boolean isOME = LOCATION_OME.equals(this.location);
        boolean isOMERO = LOCATION_OMERO.equals(this.location);
        if (!(isLocal || isHTTP || isOME || isOMERO)) {
            if (!this.quiet) {
                IJ.error((String)"Bio-Formats", (String)("Invalid location: " + this.location));
            }
            return 2;
        }
        return 0;
    }

    public int promptId() {
        if (this.isLocal()) {
            return this.promptIdLocal();
        }
        if (this.isHTTP()) {
            return this.promptIdHTTP();
        }
        return this.promptIdOME();
    }

    public int promptIdLocal() {
        String osVersion;
        if (this.firstTime && IJ.isMacOSX() && ((osVersion = System.getProperty("os.version")) == null || osVersion.startsWith("10.4.") || osVersion.startsWith("10.3.") || osVersion.startsWith("10.2."))) {
            IJ.showMessage((String)"Bio-Formats", (String)"One-time warning: There is a bug in Java on Mac OS X with the\nnative file chooser that crashes ImageJ if you click on a file\nin cxd, ipw, oib or zvi format while in column view mode.\nYou can work around the problem by switching to list view\n(press Command+2) or by checking the \"Use JFileChooser to\nOpen/Save\" option in the Edit>Options>Input/Output... dialog.");
        }
        String ijVersion = IJ.getVersion();
        if (this.firstTime && (ijVersion == null || ijVersion.compareTo("1.39u") < 0)) {
            if (ijVersion == null) {
                ijVersion = "unknown";
            }
            IJ.showMessage((String)"Bio-Formats", (String)("One-time warning: Some features of Bio-Formats, such as the\nData Browser and some color handling options, require ImageJ\nv1.39u or later. Your version is " + ijVersion + "; you will need to upgrade\n" + "if you wish to take advantage of these features."));
        }
        if (this.id == null) {
            OpenDialog od = new OpenDialog(LABEL_ID, this.id);
            String dir = od.getDirectory();
            String name = od.getFileName();
            if (dir == null || name == null) {
                return 1;
            }
            this.id = dir + name;
        }
        if (this.id != null) {
            this.idLoc = new Location(this.id);
        }
        if (this.idLoc == null || !this.idLoc.exists()) {
            if (!this.quiet) {
                IJ.error((String)"Bio-Formats", (String)(this.idLoc == null ? "No file was specified." : "The specified file (" + this.id + ") does not exist."));
            }
            return 2;
        }
        this.idName = this.idLoc.getName();
        this.idType = "Filename";
        return 0;
    }

    public int promptIdHTTP() {
        if (this.id == null) {
            GenericDialog gd = new GenericDialog("Bio-Formats URL");
            gd.addStringField("URL: ", "http://", 30);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return 1;
            }
            this.id = gd.getNextString();
        }
        if (this.id == null) {
            if (!this.quiet) {
                IJ.error((String)"Bio-Formats", (String)"No URL was specified.");
            }
            return 2;
        }
        this.idName = this.id;
        this.idType = "URL";
        return 0;
    }

    public int promptIdOME() {
        if (this.id == null) {
            IJ.runPlugIn((String)"loci.plugins.ome.OMEPlugin", (String)"");
            return 2;
        }
        this.idType = "OME address";
        return 0;
    }

    public int promptMergeOption(int[] nums, boolean spectral) {
        if (this.windowless) {
            return 0;
        }
        GenericDialog gd = new GenericDialog("Merging Options...");
        String[] options = new String[spectral ? 8 : 7];
        options[6] = MERGE_DEFAULT;
        if (spectral) {
            options[7] = MERGE_PROJECTION;
        }
        for (int i = 0; i < 6; ++i) {
            options[i] = nums[i] + " planes, " + (i + 2) + " channels per plane";
        }
        gd.addMessage("How would you like to merge this data?");
        gd.addChoice(LABEL_MERGE_OPTION, options, MERGE_DEFAULT);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        this.mergeOption = options[gd.getNextChoiceIndex()];
        return 0;
    }

    public int promptOptions() {
        Vector boxes;
        Vector choices;
        Vector<String> stackTypes = new Vector<String>();
        stackTypes.add(VIEW_NONE);
        stackTypes.add(VIEW_STANDARD);
        if (IJ.getVersion().compareTo("1.39l") >= 0) {
            stackTypes.add(VIEW_HYPERSTACK);
            stackTypes.add(VIEW_BROWSER);
        }
        if (Checker.checkClass(CLASS_VISBIO)) {
            stackTypes.add(VIEW_VISBIO);
        }
        if (Checker.checkClass(CLASS_IMAGE_5D)) {
            stackTypes.add(VIEW_IMAGE_5D);
        }
        if (Checker.checkClass(CLASS_VIEW_5D)) {
            stackTypes.add(VIEW_VIEW_5D);
        }
        Object[] stackFormats = new String[stackTypes.size()];
        stackTypes.copyInto(stackFormats);
        String[] stackOrders = new String[]{ORDER_DEFAULT, ORDER_XYZCT, ORDER_XYZTC, ORDER_XYCZT, ORDER_XYCTZ, ORDER_XYTZC, ORDER_XYTCZ};
        GenericDialog gd = new GenericDialog("Bio-Formats Import Options");
        gd.addChoice(LABEL_STACK, (String[])stackFormats, this.stackFormat);
        gd.addChoice(LABEL_ORDER, stackOrders, this.stackOrder);
        gd.addCheckbox(LABEL_MERGE, this.mergeChannels);
        gd.addCheckbox(LABEL_COLORIZE, this.colorize);
        gd.addCheckbox(LABEL_SPLIT_C, this.splitChannels);
        gd.addCheckbox(LABEL_SPLIT_Z, this.splitFocalPlanes);
        gd.addCheckbox(LABEL_SPLIT_T, this.splitTimepoints);
        gd.addCheckbox(LABEL_CROP, this.crop);
        gd.addCheckbox(LABEL_METADATA, this.showMetadata);
        gd.addCheckbox(LABEL_OME_XML, this.showOMEXML);
        gd.addCheckbox(LABEL_GROUP, this.groupFiles);
        gd.addCheckbox(LABEL_CONCATENATE, this.concatenate);
        gd.addCheckbox(LABEL_RANGE, this.specifyRanges);
        gd.addCheckbox(LABEL_AUTOSCALE, this.autoscale);
        gd.addCheckbox(LABEL_VIRTUAL, this.virtual);
        gd.addCheckbox(LABEL_RECORD, this.record);
        gd.addCheckbox(LABEL_ALL_SERIES, this.openAllSeries);
        gd.addCheckbox(LABEL_SWAP, this.swapDimensions);
        Vector<Label> labels = null;
        Label stackLabel = null;
        Label orderLabel = null;
        Component[] c = gd.getComponents();
        if (c != null) {
            labels = new Vector<Label>();
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof Label)) continue;
                Label item = (Label)c[i];
                labels.add(item);
            }
            stackLabel = (Label)labels.get(0);
            orderLabel = (Label)labels.get(1);
        }
        if ((choices = gd.getChoices()) != null) {
            this.stackChoice = (Choice)choices.get(0);
            this.orderChoice = (Choice)choices.get(1);
            for (int i = 0; i < choices.size(); ++i) {
                Choice item = (Choice)choices.get(i);
                item.addFocusListener(this);
                item.addItemListener(this);
                item.addMouseListener(this);
            }
        }
        if ((boxes = gd.getCheckboxes()) != null) {
            this.mergeBox = (Checkbox)boxes.get(0);
            this.colorizeBox = (Checkbox)boxes.get(1);
            this.splitCBox = (Checkbox)boxes.get(2);
            this.splitZBox = (Checkbox)boxes.get(3);
            this.splitTBox = (Checkbox)boxes.get(4);
            this.cropBox = (Checkbox)boxes.get(5);
            this.metadataBox = (Checkbox)boxes.get(6);
            this.omexmlBox = (Checkbox)boxes.get(7);
            this.groupBox = (Checkbox)boxes.get(8);
            this.concatenateBox = (Checkbox)boxes.get(9);
            this.rangeBox = (Checkbox)boxes.get(10);
            this.autoscaleBox = (Checkbox)boxes.get(11);
            this.virtualBox = (Checkbox)boxes.get(12);
            this.recordBox = (Checkbox)boxes.get(13);
            this.allSeriesBox = (Checkbox)boxes.get(14);
            this.swapBox = (Checkbox)boxes.get(15);
            for (int i = 0; i < boxes.size(); ++i) {
                Checkbox item = (Checkbox)boxes.get(i);
                item.addFocusListener(this);
                item.addItemListener(this);
                item.addMouseListener(this);
            }
        }
        this.verifyOptions(null);
        this.infoTable = new Hashtable();
        this.infoTable.put(stackLabel, INFO_STACK);
        this.infoTable.put(this.stackChoice, INFO_STACK);
        this.infoTable.put(orderLabel, INFO_ORDER);
        this.infoTable.put(this.orderChoice, INFO_ORDER);
        this.infoTable.put(this.mergeBox, INFO_MERGE);
        this.infoTable.put(this.colorizeBox, INFO_COLORIZE);
        this.infoTable.put(this.splitCBox, INFO_SPLIT_C);
        this.infoTable.put(this.splitZBox, INFO_SPLIT_Z);
        this.infoTable.put(this.splitTBox, INFO_SPLIT_T);
        this.infoTable.put(this.cropBox, INFO_CROP);
        this.infoTable.put(this.metadataBox, INFO_METADATA);
        this.infoTable.put(this.omexmlBox, INFO_OME_XML);
        this.infoTable.put(this.groupBox, INFO_GROUP);
        this.infoTable.put(this.concatenateBox, INFO_CONCATENATE);
        this.infoTable.put(this.rangeBox, INFO_RANGE);
        this.infoTable.put(this.autoscaleBox, INFO_AUTOSCALE);
        this.infoTable.put(this.virtualBox, INFO_VIRTUAL);
        this.infoTable.put(this.recordBox, INFO_RECORD);
        this.infoTable.put(this.allSeriesBox, INFO_ALL_SERIES);
        this.infoTable.put(this.swapBox, INFO_SWAP);
        String cols = "pref, 3dlu, pref:grow, 10dlu, pref";
        String rows = "pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, fill:100dlu";
        PanelBuilder builder = new PanelBuilder(new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 1;
        builder.addSeparator("Stack viewing", cc.xyw(1, row, 3));
        builder.add((Component)stackLabel, cc.xy(1, row += 2));
        builder.add((Component)this.stackChoice, cc.xy(3, row));
        builder.add((Component)orderLabel, cc.xy(1, row += 2));
        builder.add((Component)this.orderChoice, cc.xy(3, row));
        builder.addSeparator("Dataset organization", cc.xyw(1, row += 2, 3));
        builder.add((Component)this.groupBox, ImporterOptions.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.swapBox, ImporterOptions.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.allSeriesBox, ImporterOptions.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.concatenateBox, ImporterOptions.xyw(cc, 1, row += 2, 3));
        builder.addSeparator("Color options", cc.xyw(1, row += 2, 3));
        builder.add((Component)this.mergeBox, ImporterOptions.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.colorizeBox, ImporterOptions.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.autoscaleBox, ImporterOptions.xyw(cc, 1, row += 2, 3));
        row += 2;
        row = 1;
        builder.addSeparator("Metadata viewing", cc.xy(5, row));
        builder.add((Component)this.metadataBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.omexmlBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Memory management", cc.xy(5, row += 2));
        builder.add((Component)this.virtualBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.recordBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.rangeBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.cropBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Split into separate windows", cc.xy(5, row += 2));
        builder.add((Component)this.splitCBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.splitZBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.splitTBox, ImporterOptions.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Information", cc.xyw(1, row += 2, 5));
        this.infoPane = new JEditorPane();
        this.infoPane.setContentType("text/html");
        this.infoPane.setEditable(false);
        this.infoPane.setText("<html><i>Select an option for a detailed explanation. Documentation written by Glen MacDonald and Curtis Rueden.</i>");
        builder.add((Component)new JScrollPane(this.infoPane), cc.xyw(1, row += 2, 5));
        row += 2;
        gd.removeAll();
        gd.add((Component)builder.getPanel());
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        this.stackFormat = stackFormats[gd.getNextChoiceIndex()];
        this.stackOrder = stackOrders[gd.getNextChoiceIndex()];
        this.mergeChannels = gd.getNextBoolean();
        this.colorize = gd.getNextBoolean();
        this.splitChannels = gd.getNextBoolean();
        this.splitFocalPlanes = gd.getNextBoolean();
        this.splitTimepoints = gd.getNextBoolean();
        this.crop = gd.getNextBoolean();
        this.showMetadata = gd.getNextBoolean();
        this.showOMEXML = gd.getNextBoolean();
        this.groupFiles = gd.getNextBoolean();
        this.concatenate = gd.getNextBoolean();
        this.specifyRanges = gd.getNextBoolean();
        this.autoscale = gd.getNextBoolean();
        this.virtual = gd.getNextBoolean();
        this.record = gd.getNextBoolean();
        this.openAllSeries = gd.getNextBoolean();
        this.swapDimensions = gd.getNextBoolean();
        return 0;
    }

    public int promptFilePattern() {
        if (this.windowless) {
            return 0;
        }
        this.id = FilePattern.findPattern(this.idLoc);
        if (this.id == null) {
            IJ.showMessage((String)"Bio-Formats", (String)"Warning: Bio-Formats was unable to determine a grouping that\nincludes the file you chose. The most common reason for this\nsituation is that the folder contains extraneous files with similar\nnames and numbers that confuse the detection algorithm.\n \nFor example, if you have multiple datasets in the same folder\nnamed series1_z*_c*.tif, series2_z*_c*.tif, etc., Bio-Formats\nmay try to group all such files into a single series.\n \nFor best results, put each image series's files in their own folder,\nor type in a file pattern manually.\n");
            this.id = this.idLoc.getAbsolutePath();
        }
        GenericDialog gd = new GenericDialog("Bio-Formats File Stitching");
        int len = this.id.length() + 1;
        if (len > 80) {
            len = 80;
        }
        gd.addStringField("Pattern: ", this.id, len);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        this.id = gd.getNextString();
        return 0;
    }

    public int promptSeries(IFormatReader r, String[] seriesLabels, boolean[] series) {
        int i;
        if (this.windowless) {
            if (this.seriesString != null) {
                if (this.seriesString.startsWith("[")) {
                    this.seriesString = this.seriesString.substring(1, this.seriesString.length() - 2);
                }
                Arrays.fill(series, false);
                StringTokenizer tokens = new StringTokenizer(this.seriesString, " ");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken().trim();
                    int n = Integer.parseInt(token);
                    if (n >= series.length) continue;
                    series[n] = true;
                }
            }
            return 0;
        }
        int seriesCount = r.getSeriesCount();
        GenericDialog gd = new GenericDialog("Bio-Formats Series Options"){

            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if ("select".equals(cmd)) {
                    Checkbox[] boxes = this.getCheckboxes().toArray(new Checkbox[0]);
                    for (int i = 0; i < boxes.length; ++i) {
                        boxes[i].setState(true);
                    }
                } else if ("deselect".equals(cmd)) {
                    Checkbox[] boxes = this.getCheckboxes().toArray(new Checkbox[0]);
                    for (int i = 0; i < boxes.length; ++i) {
                        boxes[i].setState(false);
                    }
                } else {
                    super.actionPerformed(e);
                }
            }
        };
        GridBagLayout gdl = (GridBagLayout)gd.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 0;
        Panel[] p = new Panel[seriesCount];
        for (int i2 = 0; i2 < seriesCount; ++i2) {
            gd.addCheckbox(seriesLabels[i2], series[i2]);
            r.setSeries(i2);
            int sx = r.getThumbSizeX() + 10;
            int sy = r.getThumbSizeY();
            p[i2] = new Panel();
            p[i2].add(Box.createRigidArea(new Dimension(sx, sy)));
            gbc.gridy = i2;
            if (this.forceThumbnails) {
                IJ.showStatus((String)("Reading thumbnail for series #" + (i2 + 1)));
                int z = r.getSizeZ() / 2;
                int t = r.getSizeT() / 2;
                int ndx = r.getIndex(z, 0, t);
                try {
                    BufferedImage img = r.openThumbImage(ndx);
                    if (this.isAutoscale() && r.getPixelType() != 6) {
                        img = AWTImageTools.autoscale(img);
                    }
                    ImageIcon icon = new ImageIcon(img);
                    p[i2].removeAll();
                    p[i2].add(new JLabel(icon));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            gdl.setConstraints(p[i2], gbc);
            gd.add((Component)p[i2]);
        }
        Util.addScrollBars((Container)gd);
        Panel buttons = new Panel();
        Button select = new Button("Select All");
        select.setActionCommand("select");
        select.addActionListener((ActionListener)gd);
        Button deselect = new Button("Deselect All");
        deselect.setActionCommand("deselect");
        deselect.addActionListener((ActionListener)gd);
        buttons.add(select);
        buttons.add(deselect);
        gbc.gridx = 0;
        gbc.gridy = seriesCount;
        gdl.setConstraints(buttons, gbc);
        gd.add((Component)buttons);
        if (this.forceThumbnails) {
            gd.showDialog();
        } else {
            ThumbLoader loader = new ThumbLoader(r, p, (Dialog)gd, this.isAutoscale());
            gd.showDialog();
            loader.stop();
        }
        if (gd.wasCanceled()) {
            return 1;
        }
        this.seriesString = "[";
        for (i = 0; i < seriesCount; ++i) {
            series[i] = gd.getNextBoolean();
            if (!series[i]) continue;
            this.seriesString = this.seriesString + i + " ";
        }
        this.seriesString = this.seriesString + "]";
        if (this.concatenate) {
            block5: for (i = 0; i < seriesCount; ++i) {
                if (series[i]) continue;
                r.setSeries(i);
                int sizeX = r.getSizeX();
                int sizeY = r.getSizeY();
                int pixelType = r.getPixelType();
                int sizeC = r.getSizeC();
                for (int j = 0; j < seriesCount; ++j) {
                    if (j == i || !series[j]) continue;
                    r.setSeries(j);
                    if (sizeX != r.getSizeX() || sizeY != r.getSizeY() || pixelType != r.getPixelType() || sizeC != r.getSizeC()) continue;
                    series[i] = true;
                    continue block5;
                }
            }
        }
        return 0;
    }

    public int promptCropSize(IFormatReader r, String[] labels, boolean[] series, Rectangle[] box) {
        int i;
        GenericDialog gd = new GenericDialog("Bio-Formats Crop Options");
        for (i = 0; i < series.length; ++i) {
            if (!series[i]) continue;
            gd.addMessage(labels[i].replaceAll("_", " "));
            gd.addNumericField("X_Coordinate_" + i, 0.0, 0);
            gd.addNumericField("Y_Coordinate_" + i, 0.0, 0);
            gd.addNumericField("Width_" + i, 0.0, 0);
            gd.addNumericField("Height_" + i, 0.0, 0);
        }
        Util.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        for (i = 0; i < series.length; ++i) {
            if (!series[i]) continue;
            r.setSeries(i);
            box[i].x = (int)gd.getNextNumber();
            box[i].y = (int)gd.getNextNumber();
            box[i].width = (int)gd.getNextNumber();
            box[i].height = (int)gd.getNextNumber();
            if (box[i].x < 0) {
                box[i].x = 0;
            }
            if (box[i].y < 0) {
                box[i].y = 0;
            }
            if (box[i].x >= r.getSizeX()) {
                box[i].x = r.getSizeX() - box[i].width - 1;
            }
            if (box[i].y >= r.getSizeY()) {
                box[i].y = r.getSizeY() - box[i].height - 1;
            }
            if (box[i].width < 1) {
                box[i].width = 1;
            }
            if (box[i].height < 1) {
                box[i].height = 1;
            }
            if (box[i].width + box[i].x > r.getSizeX()) {
                box[i].width = r.getSizeX() - box[i].x;
            }
            if (box[i].height + box[i].y <= r.getSizeY()) continue;
            box[i].height = r.getSizeY() - box[i].y;
        }
        return 0;
    }

    public int promptRange(IFormatReader r, boolean[] series, String[] seriesLabels, int[] cBegin, int[] cEnd, int[] cStep, int[] zBegin, int[] zEnd, int[] zStep, int[] tBegin, int[] tEnd, int[] tStep) {
        int i;
        int seriesCount = r.getSeriesCount();
        GenericDialog gd = new GenericDialog("Bio-Formats Range Options");
        for (i = 0; i < seriesCount; ++i) {
            String s;
            if (!series[i]) continue;
            r.setSeries(i);
            gd.addMessage(seriesLabels[i].replaceAll("_", " "));
            String string = s = seriesCount > 1 ? "_" + (i + 1) : "";
            if (r.getEffectiveSizeC() > 1) {
                gd.addNumericField("C_Begin" + s, (double)(cBegin[i] + 1), 0);
                gd.addNumericField("C_End" + s, (double)(cEnd[i] + 1), 0);
                gd.addNumericField("C_Step" + s, (double)cStep[i], 0);
            }
            if (r.getSizeZ() > 1) {
                gd.addNumericField("Z_Begin" + s, (double)(zBegin[i] + 1), 0);
                gd.addNumericField("Z_End" + s, (double)(zEnd[i] + 1), 0);
                gd.addNumericField("Z_Step" + s, (double)zStep[i], 0);
            }
            if (r.getSizeT() <= 1) continue;
            gd.addNumericField("T_Begin" + s, (double)(tBegin[i] + 1), 0);
            gd.addNumericField("T_End" + s, (double)(tEnd[i] + 1), 0);
            gd.addNumericField("T_Step" + s, (double)tStep[i], 0);
        }
        Util.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        for (i = 0; i < seriesCount; ++i) {
            int maxC;
            if (!series[i]) continue;
            r.setSeries(i);
            int sizeC = r.getEffectiveSizeC();
            int sizeZ = r.getSizeZ();
            int sizeT = r.getSizeT();
            boolean certain = r.isOrderCertain();
            if (r.getEffectiveSizeC() > 1) {
                cBegin[i] = (int)gd.getNextNumber() - 1;
                cEnd[i] = (int)gd.getNextNumber() - 1;
                cStep[i] = (int)gd.getNextNumber();
            }
            if (r.getSizeZ() > 1) {
                zBegin[i] = (int)gd.getNextNumber() - 1;
                zEnd[i] = (int)gd.getNextNumber() - 1;
                zStep[i] = (int)gd.getNextNumber();
            }
            if (r.getSizeT() > 1) {
                tBegin[i] = (int)gd.getNextNumber() - 1;
                tEnd[i] = (int)gd.getNextNumber() - 1;
                tStep[i] = (int)gd.getNextNumber();
            }
            int n = maxC = certain ? sizeC : r.getImageCount();
            if (cBegin[i] < 0) {
                cBegin[i] = 0;
            }
            if (cBegin[i] >= maxC) {
                cBegin[i] = maxC - 1;
            }
            if (cEnd[i] < cBegin[i]) {
                cEnd[i] = cBegin[i];
            }
            if (cEnd[i] >= maxC) {
                cEnd[i] = maxC - 1;
            }
            if (cStep[i] < 1) {
                cStep[i] = 1;
            }
            if (zBegin[i] < 0) {
                zBegin[i] = 0;
            }
            if (zBegin[i] >= sizeZ) {
                zBegin[i] = sizeZ - 1;
            }
            if (zEnd[i] < zBegin[i]) {
                zEnd[i] = zBegin[i];
            }
            if (zEnd[i] >= sizeZ) {
                zEnd[i] = sizeZ - 1;
            }
            if (zStep[i] < 1) {
                zStep[i] = 1;
            }
            if (tBegin[i] < 0) {
                tBegin[i] = 0;
            }
            if (tBegin[i] >= sizeT) {
                tBegin[i] = sizeT - 1;
            }
            if (tEnd[i] < tBegin[i]) {
                tEnd[i] = tBegin[i];
            }
            if (tEnd[i] >= sizeT) {
                tEnd[i] = sizeT - 1;
            }
            if (tStep[i] >= 1) continue;
            tStep[i] = 1;
        }
        return 0;
    }

    public int promptSwap(DimensionSwapper r, boolean[] series) {
        int n;
        GenericDialog gd = new GenericDialog("Dimension swapping options");
        int oldSeries = r.getSeries();
        String[] labels = new String[]{"Z", "C", "T"};
        for (n = 0; n < r.getSeriesCount(); ++n) {
            if (!series[n]) continue;
            r.setSeries(n);
            gd.addMessage("Series " + n + ":\n");
            int[] axisSizes = new int[]{r.getSizeZ(), r.getSizeC(), r.getSizeT()};
            for (int i = 0; i < labels.length; ++i) {
                gd.addChoice(axisSizes[i] + "_planes", labels, labels[i]);
            }
        }
        Util.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        for (n = 0; n < r.getSeriesCount(); ++n) {
            r.setSeries(n);
            String z = gd.getNextChoice();
            String c = gd.getNextChoice();
            String t = gd.getNextChoice();
            if (z.equals(t) || z.equals(c) || c.equals(t)) {
                IJ.error((String)"Invalid swapping options - each axis can be used only once.");
                return this.promptSwap(r, series);
            }
            String originalOrder = r.getDimensionOrder();
            StringBuffer sb = new StringBuffer();
            sb.append("XY");
            for (int i = 2; i < originalOrder.length(); ++i) {
                if (originalOrder.charAt(i) == 'Z') {
                    sb.append(z);
                    continue;
                }
                if (originalOrder.charAt(i) == 'C') {
                    sb.append(c);
                    continue;
                }
                if (originalOrder.charAt(i) != 'T') continue;
                sb.append(t);
            }
            r.swapDimensions(sb.toString());
        }
        r.setSeries(oldSeries);
        return 0;
    }

    public void focusGained(FocusEvent e) {
        Object src = e.getSource();
        String text = (String)this.infoTable.get(src);
        this.infoPane.setText("<html>" + text);
        this.infoPane.setCaretPosition(0);
    }

    public void focusLost(FocusEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        this.verifyOptions(e.getSource());
    }

    public void mouseEntered(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof Component) {
            ((Component)src).requestFocusInWindow();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private static boolean getMacroValue(String options, String key, boolean defaultValue) {
        String s = Macro.getValue((String)options, (String)key, null);
        return s == null ? defaultValue : s.equalsIgnoreCase("true");
    }

    private static String info(String label) {
        return "<b>" + label.replaceAll("[_:]", " ").trim() + "</b>";
    }

    private static CellConstraints xyw(CellConstraints cc, int x, int y, int w) {
        return cc.xyw(x, y, w, CellConstraints.LEFT, CellConstraints.CENTER);
    }

    private void verifyOptions(Object src) {
        boolean orderEnabled = this.orderChoice.isEnabled();
        boolean mergeEnabled = this.mergeBox.isEnabled();
        boolean colorizeEnabled = this.colorizeBox.isEnabled();
        boolean splitCEnabled = this.splitCBox.isEnabled();
        boolean splitZEnabled = this.splitZBox.isEnabled();
        boolean splitTEnabled = this.splitTBox.isEnabled();
        boolean metadataEnabled = this.metadataBox.isEnabled();
        boolean omexmlEnabled = this.omexmlBox.isEnabled();
        boolean groupEnabled = this.groupBox.isEnabled();
        boolean concatenateEnabled = this.concatenateBox.isEnabled();
        boolean rangeEnabled = this.rangeBox.isEnabled();
        boolean autoscaleEnabled = this.autoscaleBox.isEnabled();
        boolean virtualEnabled = this.virtualBox.isEnabled();
        boolean recordEnabled = this.recordBox.isEnabled();
        boolean allSeriesEnabled = this.allSeriesBox.isEnabled();
        boolean cropEnabled = this.cropBox.isEnabled();
        boolean swapEnabled = this.swapBox.isEnabled();
        boolean isStackNone = false;
        boolean isStackStandard = false;
        boolean isStackHyperstack = false;
        boolean isStackBrowser = false;
        boolean isStackVisBio = false;
        boolean isStackImage5D = false;
        boolean isStackView5D = false;
        String stackValue = this.stackChoice.getSelectedItem();
        if (stackValue.equals(VIEW_NONE)) {
            isStackNone = true;
        } else if (stackValue.equals(VIEW_STANDARD)) {
            isStackStandard = true;
        } else if (stackValue.equals(VIEW_HYPERSTACK)) {
            isStackHyperstack = true;
        } else if (stackValue.equals(VIEW_BROWSER)) {
            isStackBrowser = true;
        } else if (stackValue.equals(VIEW_VISBIO)) {
            isStackVisBio = true;
        } else if (stackValue.equals(VIEW_IMAGE_5D)) {
            isStackImage5D = true;
        } else if (stackValue.equals(VIEW_VIEW_5D)) {
            isStackView5D = true;
        }
        String orderValue = this.orderChoice.getSelectedItem();
        boolean isMerge = this.mergeBox.getState();
        boolean isColorize = this.colorizeBox.getState();
        boolean isSplitC = this.splitCBox.getState();
        boolean isSplitZ = this.splitZBox.getState();
        boolean isSplitT = this.splitTBox.getState();
        boolean isMetadata = this.metadataBox.getState();
        boolean isOMEXML = this.omexmlBox.getState();
        boolean isGroup = this.groupBox.getState();
        boolean isConcatenate = this.concatenateBox.getState();
        boolean isRange = this.rangeBox.getState();
        boolean isAutoscale = this.autoscaleBox.getState();
        boolean isVirtual = this.virtualBox.getState();
        boolean isRecord = this.recordBox.getState();
        boolean isAllSeries = this.allSeriesBox.getState();
        boolean isCrop = this.cropBox.getState();
        boolean isSwap = this.swapBox.getState();
        boolean bl = orderEnabled = isStackStandard || isStackVisBio;
        if (src == this.stackChoice) {
            orderValue = isStackHyperstack || isStackBrowser || isStackImage5D ? ORDER_XYCZT : (isStackView5D ? ORDER_XYZCT : ORDER_DEFAULT);
        }
        boolean bl2 = metadataEnabled = !isStackNone;
        if (!metadataEnabled) {
            isMetadata = true;
        }
        boolean bl3 = groupEnabled = !this.isOME() && !this.isOMERO();
        if (!groupEnabled) {
            isGroup = false;
        } else if (src == this.stackChoice && isStackBrowser) {
            isGroup = true;
        }
        boolean bl4 = virtualEnabled = !isStackNone && !isStackImage5D && !isStackView5D;
        if (!virtualEnabled) {
            isVirtual = false;
        } else if (src == this.stackChoice && isStackBrowser) {
            isVirtual = true;
        }
        recordEnabled = isVirtual;
        if (!recordEnabled) {
            isRecord = false;
        }
        boolean bl5 = rangeEnabled = !isStackNone;
        if (!rangeEnabled) {
            isRange = false;
        }
        boolean bl6 = cropEnabled = !isStackNone;
        if (!cropEnabled) {
            isCrop = false;
        }
        boolean bl7 = mergeEnabled = !isStackImage5D;
        if (!mergeEnabled) {
            isMerge = false;
        }
        boolean bl8 = colorizeEnabled = !isMerge && !isStackBrowser && !isStackImage5D && !isStackView5D;
        if (!colorizeEnabled) {
            isColorize = false;
        }
        boolean bl9 = autoscaleEnabled = !isVirtual;
        if (!autoscaleEnabled) {
            isAutoscale = false;
        }
        boolean splitEnabled = !isStackNone && !isStackBrowser && !isStackVisBio && !isStackImage5D && !isStackView5D && !isVirtual;
        boolean bl10 = splitCEnabled = splitEnabled && !isMerge;
        if (!splitCEnabled) {
            isSplitC = false;
        }
        if (!(splitZEnabled = splitEnabled)) {
            isSplitZ = false;
        }
        if (!(splitTEnabled = splitEnabled)) {
            isSplitT = false;
        }
        this.orderChoice.setEnabled(orderEnabled);
        this.mergeBox.setEnabled(mergeEnabled);
        this.colorizeBox.setEnabled(colorizeEnabled);
        this.splitCBox.setEnabled(splitCEnabled);
        this.splitZBox.setEnabled(splitZEnabled);
        this.splitTBox.setEnabled(splitTEnabled);
        this.metadataBox.setEnabled(metadataEnabled);
        this.omexmlBox.setEnabled(omexmlEnabled);
        this.groupBox.setEnabled(groupEnabled);
        this.concatenateBox.setEnabled(concatenateEnabled);
        this.rangeBox.setEnabled(rangeEnabled);
        this.autoscaleBox.setEnabled(autoscaleEnabled);
        this.virtualBox.setEnabled(virtualEnabled);
        this.recordBox.setEnabled(recordEnabled);
        this.allSeriesBox.setEnabled(allSeriesEnabled);
        this.cropBox.setEnabled(cropEnabled);
        this.swapBox.setEnabled(swapEnabled);
        this.orderChoice.select(orderValue);
        this.mergeBox.setState(isMerge);
        this.colorizeBox.setState(isColorize);
        this.splitCBox.setState(isSplitC);
        this.splitZBox.setState(isSplitZ);
        this.splitTBox.setState(isSplitT);
        this.metadataBox.setState(isMetadata);
        this.omexmlBox.setState(isOMEXML);
        this.groupBox.setState(isGroup);
        this.concatenateBox.setState(isConcatenate);
        this.rangeBox.setState(isRange);
        this.autoscaleBox.setState(isAutoscale);
        this.virtualBox.setState(isVirtual);
        this.recordBox.setState(isRecord);
        this.allSeriesBox.setState(isAllSeries);
        this.cropBox.setState(isCrop);
        this.swapBox.setState(isSwap);
        if (IS_GLITCHED) {
            int i;
            Component[] c = new Component[]{this.stackChoice, this.orderChoice, this.mergeBox, this.colorizeBox, this.splitCBox, this.splitZBox, this.splitTBox, this.metadataBox, this.omexmlBox, this.groupBox, this.concatenateBox, this.rangeBox, this.autoscaleBox, this.virtualBox, this.recordBox, this.allSeriesBox, this.cropBox, this.swapBox};
            Component focused = null;
            for (i = 0; i < c.length; ++i) {
                if (!c[i].isFocusOwner()) continue;
                focused = c[i];
            }
            for (i = 0; i < c.length; ++i) {
                c[i].removeFocusListener(this);
            }
            for (i = 0; i < c.length; ++i) {
                c[i].requestFocusInWindow();
            }
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.clearGlobalFocusOwner();
            this.sleep(100L);
            if (focused != null) {
                focused.requestFocusInWindow();
            }
            for (int i2 = 0; i2 < c.length; ++i2) {
                c[i2].addFocusListener(this);
            }
        }
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

