/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.IOException;
import loci.formats.ChannelSeparator;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.plugins.MacroFunctions;
import loci.plugins.Util;

public class LociFunctions
extends MacroFunctions {
    private IFormatReader r = new ChannelSeparator(new FileStitcher(true));

    public LociFunctions() {
        this.r.setMetadataStore(MetadataTools.createOMEXMLMetadata());
    }

    public void getImageCount(Double[] imageCount) {
        imageCount[0] = new Double(this.r.getImageCount());
    }

    public void getSizeX(Double[] sizeX) {
        sizeX[0] = new Double(this.r.getSizeX());
    }

    public void getSizeY(Double[] sizeY) {
        sizeY[0] = new Double(this.r.getSizeY());
    }

    public void getSizeZ(Double[] sizeZ) {
        sizeZ[0] = new Double(this.r.getSizeZ());
    }

    public void getSizeC(Double[] sizeC) {
        sizeC[0] = new Double(this.r.getSizeC());
    }

    public void getSizeT(Double[] sizeT) {
        sizeT[0] = new Double(this.r.getSizeT());
    }

    public void getPixelType(String[] pixelType) {
        pixelType[0] = FormatTools.getPixelTypeString(this.r.getPixelType());
    }

    public void getEffectiveSizeC(Double[] effectiveSizeC) {
        effectiveSizeC[0] = new Double(this.r.getEffectiveSizeC());
    }

    public void getRGBChannelCount(Double[] rgbChannelCount) {
        rgbChannelCount[0] = new Double(this.r.getRGBChannelCount());
    }

    public void isIndexed(String[] indexed) {
        indexed[0] = this.r.isIndexed() ? "true" : "false";
    }

    public void getChannelDimCount(Double[] channelDimCount) {
        channelDimCount[0] = new Double(this.r.getChannelDimLengths().length);
    }

    public void getChannelDimLength(Double i, Double[] channelDimLength) {
        channelDimLength[0] = new Double(this.r.getChannelDimLengths()[i.intValue()]);
    }

    public void getChannelDimType(Double i, Double[] channelDimType) {
        channelDimType[0] = new Double(this.r.getChannelDimTypes()[i.intValue()]);
    }

    public void isLittleEndian(String[] littleEndian) {
        littleEndian[0] = this.r.isLittleEndian() ? "true" : "false";
    }

    public void getDimensionOrder(String[] dimOrder) {
        dimOrder[0] = this.r.getDimensionOrder();
    }

    public void isOrderCertain(String[] orderCertain) {
        orderCertain[0] = this.r.isOrderCertain() ? "true" : "false";
    }

    public void isInterleaved(String[] interleaved) {
        interleaved[0] = this.r.isInterleaved() ? "true" : "false";
    }

    public void isInterleavedSubC(Double subC, String[] interleaved) {
        interleaved[0] = this.r.isInterleaved(subC.intValue()) ? "true" : "false";
    }

    public void openImage(String title, Double no) throws FormatException, IOException {
        ImageProcessor[] ip = Util.openProcessors(this.r, no.intValue());
        Util.makeRGB(title, ip).show();
    }

    public void openSubImage(String title, Double no, Double x, Double y, Double width, Double height) throws FormatException, IOException {
        Rectangle crop = new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue());
        ImageProcessor[] ip = Util.openProcessors(this.r, no.intValue(), crop);
        Util.makeRGB(title, ip).show();
    }

    public void close() throws IOException {
        this.r.close();
    }

    public void closeFileOnly() throws IOException {
        this.r.close(true);
    }

    public void getSeriesCount(Double[] seriesCount) {
        seriesCount[0] = new Double(this.r.getSeriesCount());
    }

    public void setSeries(Double seriesNum) {
        this.r.setSeries(seriesNum.intValue());
    }

    public void getSeries(Double[] seriesNum) {
        seriesNum[0] = new Double(this.r.getSeries());
    }

    public void setNormalized(Boolean normalize) {
        this.r.setNormalized(normalize);
    }

    public void isNormalized(Boolean[] normalize) {
        normalize[0] = new Boolean(this.r.isNormalized());
    }

    public void setMetadataCollected(Boolean collect) {
        this.r.setMetadataCollected(collect);
    }

    public void isMetadataCollected(Boolean[] collect) {
        collect[0] = new Boolean(this.r.isMetadataCollected());
    }

    public void setOriginalMetadataPopulated(Boolean populate) {
        this.r.setOriginalMetadataPopulated(populate);
    }

    public void isOriginalMetadataPopulated(Boolean[] populate) {
        populate[0] = new Boolean(this.r.isOriginalMetadataPopulated());
    }

    public void setGroupFiles(String groupFiles) {
        this.r.setGroupFiles("true".equalsIgnoreCase(groupFiles));
    }

    public void isGroupFiles(String[] groupFiles) {
        groupFiles[0] = this.r.isGroupFiles() ? "true" : "false";
    }

    public void isMetadataComplete(String[] complete) {
        complete[0] = this.r.isMetadataComplete() ? "true" : "false";
    }

    public void fileGroupOption(String id, String[] fileGroupOption) throws FormatException, IOException {
        switch (this.r.fileGroupOption(id)) {
            case 0: {
                fileGroupOption[0] = "must";
                break;
            }
            case 1: {
                fileGroupOption[0] = "can";
                break;
            }
            case 2: {
                fileGroupOption[0] = "cannot";
                break;
            }
            default: {
                fileGroupOption[0] = "unknown";
            }
        }
    }

    public void getUsedFileCount(Double[] count) {
        count[0] = new Double(this.r.getUsedFiles().length);
    }

    public void getUsedFile(Double i, String[] used) {
        used[0] = this.r.getUsedFiles()[i.intValue()];
    }

    public void getCurrentFile(String[] file2) {
        file2[0] = this.r.getCurrentFile();
    }

    public void getIndex(Double z, Double c, Double t, Double[] index) {
        index[0] = new Double(this.r.getIndex(z.intValue(), c.intValue(), t.intValue()));
    }

    public void getZCTCoords(Double index, Double[] z, Double[] c, Double[] t) {
        int[] zct = this.r.getZCTCoords(index.intValue());
        z[0] = new Double(zct[0]);
        c[0] = new Double(zct[1]);
        t[0] = new Double(zct[2]);
    }

    public void getMetadataValue(String field, String[] value) {
        Object o = this.r.getMetadataValue(field);
        value[0] = o == null ? null : o.toString();
    }

    public void setMetadataFiltered(String metadataFiltered) {
        this.r.setMetadataFiltered("true".equalsIgnoreCase(metadataFiltered));
    }

    public void isMetadataFiltered(String[] metadataFiltered) {
        metadataFiltered[0] = this.r.isMetadataFiltered() ? "true" : "false";
    }

    public void setId(String id) throws FormatException, IOException {
        this.r.setId(id);
    }

    public void isThisType(String name, String[] thisType) {
        thisType[0] = this.r.isThisType(name) ? "true" : "false";
    }

    public void getSeriesName(String[] seriesName) {
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        seriesName[0] = retrieve.getImageName(this.r.getSeries());
    }

    public void getImageCreationDate(String[] creationDate) {
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        creationDate[0] = retrieve.getImageCreationDate(this.r.getSeries());
    }

    public void getPlaneTimingDeltaT(Double[] deltaT, Double no) {
        int imageIndex = this.r.getSeries();
        int planeIndex = LociFunctions.getPlaneIndex(this.r, no.intValue());
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Float val = null;
        if (planeIndex >= 0) {
            val = retrieve.getPlaneTimingDeltaT(imageIndex, 0, planeIndex);
        }
        deltaT[0] = new Double(val == null ? Double.NaN : val.doubleValue());
    }

    public void getPlaneTimingExposureTime(Double[] exposureTime, Double no) {
        int imageIndex = this.r.getSeries();
        int planeIndex = LociFunctions.getPlaneIndex(this.r, no.intValue());
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Float val = null;
        if (planeIndex >= 0) {
            val = retrieve.getPlaneTimingExposureTime(imageIndex, 0, planeIndex);
        }
        exposureTime[0] = new Double(val == null ? Double.NaN : val.doubleValue());
    }

    public void run(String arg) {
        if (IJ.macroRunning()) {
            super.run(arg);
        } else {
            IJ.showMessage((String)"LOCI Plugins for ImageJ", (String)"The macro extensions are designed to be used within a macro.\nInstructions on doing so will be printed to the Results window.");
            IJ.write((String)"To gain access to more advanced features of Bio-Formats");
            IJ.write((String)"from within a macro, put the following line at the");
            IJ.write((String)"beginning of your macro:");
            IJ.write((String)"");
            IJ.write((String)"run(\"Bio-Formats Macro Extensions\");");
            IJ.write((String)"");
            IJ.write((String)"This will enable the following macro functions:");
            IJ.write((String)"");
            IJ.write((String)"-= Usable any time =-");
            IJ.write((String)"");
            IJ.write((String)"Ext.setId(id)");
            IJ.write((String)"-- Initializes the given id (filename).");
            IJ.write((String)"Ext.isThisType(name, thisType)");
            IJ.write((String)"-- True if Bio-Formats recognizes the given filename as a");
            IJ.write((String)"-- supported image file format.");
            IJ.write((String)"Ext.isMetadataComplete(complete)");
            IJ.write((String)"-- True if Bio-Formats completely parses the current");
            IJ.write((String)"-- dataset's file format. If this function returns false,");
            IJ.write((String)"-- there are known limitations or missing features in how");
            IJ.write((String)"-- Bio-Formats handles this file format.");
            IJ.write((String)"Ext.fileGroupOption(id, fileGroupOption)");
            IJ.write((String)"-- Returns a code indicating the file grouping policy for");
            IJ.write((String)"-- for the current dataset. Possible values are:");
            IJ.write((String)"--   must, can, cannot, unknown");
            IJ.write((String)"");
            IJ.write((String)"-= Usable before initializing a file =-");
            IJ.write((String)"");
            IJ.write((String)"Ext.setNormalized(normalize)");
            IJ.write((String)"-- Sets whether to normalize floating point data to [0-1].");
            IJ.write((String)"Ext.isNormalized(normalize)");
            IJ.write((String)"-- Gets whether float data is being normalized to [0-1].");
            IJ.write((String)"Ext.setMetadataCollected(collect)");
            IJ.write((String)"-- Sets whether Bio-Formats should extract metadata at all.");
            IJ.write((String)"Ext.isMetadataCollected(collect)");
            IJ.write((String)"-- Gets whether Bio-Formats is supposed to extract metadata.");
            IJ.write((String)"Ext.setOriginalMetadataPopulated(populate)");
            IJ.write((String)"-- Sets whether Bio-Formats should save proprietary metadata");
            IJ.write((String)"-- to the OME metadata store as custom attributes.");
            IJ.write((String)"Ext.isOriginalMetadataPopulated(populate)");
            IJ.write((String)"-- Sets whether Bio-Formats is saving proprietary metadata");
            IJ.write((String)"-- to the OME metadata store as custom attributes.");
            IJ.write((String)"Ext.setGroupFiles(group)");
            IJ.write((String)"-- For multi-file formats, sets whether to force grouping.");
            IJ.write((String)"Ext.isGroupFiles(group)");
            IJ.write((String)"-- Gets whether grouping is forced for multi-file formats..");
            IJ.write((String)"Ext.setMetadataFiltered(filter)");
            IJ.write((String)"-- Sets whether to filter out ugly metadata from the table");
            IJ.write((String)"-- (i.e., entries with unprintable characters, and extremely");
            IJ.write((String)"-- long values).");
            IJ.write((String)"Ext.isMetadataFiltered(filter)");
            IJ.write((String)"-- Gets whether ugly metadata is being filtered out.");
            IJ.write((String)"");
            IJ.write((String)"-== Usable after initializing a file ==-");
            IJ.write((String)"");
            IJ.write((String)"Ext.getSeriesCount(seriesCount)");
            IJ.write((String)"-- Gets the number of image series in the active dataset.");
            IJ.write((String)"Ext.setSeries(seriesNum)");
            IJ.write((String)"-- Sets the current series within the active dataset.");
            IJ.write((String)"Ext.getSeries(seriesNum)");
            IJ.write((String)"-- Gets the current series within the active dataset.");
            IJ.write((String)"Ext.getUsedFileCount(count)");
            IJ.write((String)"-- Gets the number of files that are part of this dataset.");
            IJ.write((String)"Ext.getUsedFile(i, used)");
            IJ.write((String)"-- Gets the i'th filename part of this dataset.");
            IJ.write((String)"Ext.getCurrentFile(file)");
            IJ.write((String)"-- Gets the base filename used to initialize this dataset.");
            IJ.write((String)"Ext.openImage(title, no)");
            IJ.write((String)"-- Opens the no'th plane in a new window named 'title'.");
            IJ.write((String)"Ext.openImage(title, no, x, y, width, height)");
            IJ.write((String)"-- Opens a subset of the no'th plane in a new window");
            IJ.write((String)"-- named 'title'.");
            IJ.write((String)"Ext.close()");
            IJ.write((String)"-- Closes the active dataset.");
            IJ.write((String)"Ext.closeFileOnly()");
            IJ.write((String)"-- Closes open files, leaving the current dataset active.");
            IJ.write((String)"");
            IJ.write((String)"-== Applying to the current series ==-");
            IJ.write((String)"");
            IJ.write((String)"Ext.getImageCount(imageCount)");
            IJ.write((String)"-- Gets the total number of planes in the current dataset.");
            IJ.write((String)"Ext.getSizeX(sizeX)");
            IJ.write((String)"-- Gets the width of each image plane in pixels.");
            IJ.write((String)"Ext.getSizeY(sizeY)");
            IJ.write((String)"-- Gets the height of each image plane in pixels.");
            IJ.write((String)"Ext.getSizeZ(sizeZ)");
            IJ.write((String)"-- Gets the number of focal planes in the dataset.");
            IJ.write((String)"Ext.getSizeC(sizeC)");
            IJ.write((String)"-- Gets the number of channels in the dataset.");
            IJ.write((String)"Ext.getSizeT(sizeT)");
            IJ.write((String)"-- Gets the number of time points in the dataset.");
            IJ.write((String)"Ext.getPixelType(pixelType)");
            IJ.write((String)"-- Gets a code representing the pixel type of the image.");
            IJ.write((String)"-- Possible values include:");
            IJ.write((String)"--   int8, uint8, int16, uint16, int32, uint32, float, double");
            IJ.write((String)"Ext.getEffectiveSizeC(effectiveSizeC)");
            IJ.write((String)"-- Gets the 'effective' number of channels, such that:");
            IJ.write((String)"-- effectiveSizeC * sizeZ * sizeT == imageCount");
            IJ.write((String)"Ext.getRGBChannelCount(rgbChannelCount)");
            IJ.write((String)"-- Gets the number of channels per composite image plane:");
            IJ.write((String)"-- sizeC / rgbChannelCount == effectiveSizeC");
            IJ.write((String)"Ext.isIndexed(indexed)");
            IJ.write((String)"-- Gets whether the image planes are stored as indexed color");
            IJ.write((String)"-- (i.e., whether they have embedded LUTs).");
            IJ.write((String)"Ext.getChannelDimCount(channelDimCount)");
            IJ.write((String)"-- For highly multidimensional image data, the C dimension");
            IJ.write((String)"-- may consist of multiple embedded 'sub' dimensions.");
            IJ.write((String)"-- This function returns the number of such dimensions.");
            IJ.write((String)"Ext.getChannelDimLength(i, channelDimLength)");
            IJ.write((String)"-- Gets the length of the i'th embedded 'sub' dimension.");
            IJ.write((String)"Ext.getChannelDimType(i, channelDimType)");
            IJ.write((String)"-- Gets a string label for the i'th embedded 'sub' channel.");
            IJ.write((String)"Ext.isLittleEndian(littleEndian)");
            IJ.write((String)"-- For multi-byte pixel types, get the data's endianness.");
            IJ.write((String)"Ext.getDimensionOrder(dimOrder)");
            IJ.write((String)"-- Gets a five-character string representing the dimensional");
            IJ.write((String)"-- rasterization order within the dataset. Valid orders are:");
            IJ.write((String)"--   XYCTZ, XYCZT, XYTCZ, XYTZC, XYZCT, XYZTC");
            IJ.write((String)"-- In cases where the channels are interleaved (e.g., CXYTZ),");
            IJ.write((String)"-- C will be the first dimension after X and Y (e.g., XYCTZ)");
            IJ.write((String)"-- and the isInterleaved function will return true.");
            IJ.write((String)"Ext.isOrderCertain(orderCertain)");
            IJ.write((String)"-- Gets whether the dimension order and sizes are known,");
            IJ.write((String)"-- or merely guesses.");
            IJ.write((String)"Ext.isInterleaved(interleaved)");
            IJ.write((String)"-- Gets whether or not the channels are interleaved.");
            IJ.write((String)"-- This function exists because X and Y must appear first");
            IJ.write((String)"-- in the dimension order. For interleaved data, XYCTZ or");
            IJ.write((String)"-- XYCZT is used, and this method returns true.");
            IJ.write((String)"Ext.isInterleavedSubC(subC, interleaved)");
            IJ.write((String)"-- Gets whether the given 'sub' channel is interleaved.");
            IJ.write((String)"-- This method exists because some data with multiple");
            IJ.write((String)"-- rasterized sub-dimensions within C have one sub-dimension");
            IJ.write((String)"-- interleaved, and the other not -- e.g., the SDT reader");
            IJ.write((String)"-- handles spectral-lifetime data with interleaved lifetime");
            IJ.write((String)"-- bins and non-interleaved spectral channels.");
            IJ.write((String)"Ext.getIndex(z, c, t, index)");
            IJ.write((String)"-- Gets the rasterized index corresponding to the given");
            IJ.write((String)"-- Z, C and T coordinates, according to the dataset's");
            IJ.write((String)"-- dimension order.");
            IJ.write((String)"Ext.getZCTCoords(index, z, c, t)");
            IJ.write((String)"-- Gets the Z, C and T coordinates corresponding to the given");
            IJ.write((String)"-- rasterized index value, according to the dataset's");
            IJ.write((String)"-- dimension order.");
            IJ.write((String)"Ext.getMetadataValue(field, value)");
            IJ.write((String)"-- Obtains the specified metadata field's value.");
            IJ.write((String)"Ext.getSeriesName(seriesName)");
            IJ.write((String)"-- Obtains the name of the current series.");
            IJ.write((String)"Ext.getImageCreationDate(creationDate)");
            IJ.write((String)"-- Obtains the creation date of the dataset");
            IJ.write((String)"-- in ISO 8601 format.");
            IJ.write((String)"Ext.getPlaneTimingDeltaT(deltaT, no)");
            IJ.write((String)"-- Obtains the time offset (seconds since the beginning ");
            IJ.write((String)"-- of the experiment) for the no'th plane, or NaN if none.");
            IJ.write((String)"Ext.getPlaneTimingExposureTime(exposureTime, no)");
            IJ.write((String)"-- Obtains the exposure time (in seconds) for the no'th");
            IJ.write((String)"-- plane, or NaN if none.");
            IJ.write((String)"");
            IJ.write((String)"For more information, see the online Javadocs");
            IJ.write((String)"for the loci.formats.IFormatReader and ");
            IJ.write((String)"loci.formats.meta.MetadataRetrieve interfaces:");
            IJ.write((String)"http://www.loci.wisc.edu/software/docs/");
        }
    }

    private static int getPlaneIndex(IFormatReader r, int no) {
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)r.getMetadataStore());
        int imageIndex = r.getSeries();
        int planeCount = retrieve.getPlaneCount(imageIndex, 0);
        int[] zct = r.getZCTCoords(no);
        for (int i = 0; i < planeCount; ++i) {
            Integer theC = retrieve.getPlaneTheC(imageIndex, 0, i);
            Integer theT = retrieve.getPlaneTheT(imageIndex, 0, i);
            Integer theZ = retrieve.getPlaneTheZ(imageIndex, 0, i);
            if (zct[0] != theZ || zct[1] != theC || zct[2] != theT) continue;
            return i;
        }
        return -1;
    }
}

