/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import loci.common.DataTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.in.ND2Reader;
import loci.formats.in.PictReader;
import loci.formats.in.QTReader;
import loci.formats.in.SDTReader;
import loci.formats.meta.MetadataRetrieve;

public final class Util {
    public static final String COMPOSITE_MSG = "ImageJ 1.39l or later is required to merge >8 bit or >3 channel data";
    public static final String PREF_READER_ENABLED = "bioformats.enabled";
    public static final String PREF_READER_WINDOWLESS = "bioformats.windowless";
    public static final String PREF_ND2_NIKON = "bioformats.nd2.nikon";
    public static final String PREF_PICT_QTJAVA = "bioformats.pict.qtjava";
    public static final String PREF_QT_QTJAVA = "bioformats.qt.qtjava";
    public static final String PREF_SDT_INTENSITY = "bioformats.sdt.intensity";

    private Util() {
    }

    public static ImageProcessor[] openProcessors(IFormatReader r, int no) throws FormatException, IOException {
        return Util.openProcessors(r, no, null);
    }

    public static ImageProcessor[] openProcessors(IFormatReader r, int no, Rectangle crop) throws FormatException, IOException {
        byte[][] byteTable;
        byte[] b = null;
        boolean first = true;
        if (crop == null) {
            crop = new Rectangle(0, 0, r.getSizeX(), r.getSizeY());
        }
        while (true) {
            String code;
            if ((code = Prefs.get((String)"lurawave.license", null)) != null) {
                System.setProperty("lurawave.license", code);
            }
            try {
                b = r.openBytes(no, crop.x, crop.y, crop.width, crop.height);
            }
            catch (FormatException exc) {
                String msg = exc.getMessage();
                if (msg != null && (msg.equals("No LuraWave license code was specified.\r\nPlease set one in the lurawave.license system property (e.g., with -Dlurawave.license=XXXX from the command line).") || msg.startsWith("Invalid license code: "))) {
                    GenericDialog gd = new GenericDialog("LuraWave License Code");
                    if (first) {
                        first = false;
                    } else {
                        gd.addMessage("Invalid license code; try again.");
                    }
                    gd.addStringField("LuraWave_License Code: ", code, 16);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return null;
                    }
                    code = gd.getNextString();
                    if (code == null) continue;
                    Prefs.set((String)"lurawave.license", (String)code);
                    continue;
                }
                throw exc;
            }
            break;
        }
        int w = crop.width;
        int h = crop.height;
        int c = r.getRGBChannelCount();
        int type = r.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(type);
        boolean interleave = r.isInterleaved();
        if (b.length != w * h * c * bpp && b.length != w * h * bpp) {
            BufferedImage bi = r.openImage(no, crop.x, crop.y, crop.width, crop.height);
            b = ImageTools.padImage(b, r.isInterleaved(), c, bi.getWidth() * bpp, w, h);
        }
        boolean isFloat = type == 6 || type == 7;
        boolean isLittle = r.isLittleEndian();
        boolean isSigned = type == 0 || type == 2 || type == 4;
        IndexColorModel cm = null;
        ColorModel model = null;
        if (r.isIndexed() && (byteTable = r.get8BitLookupTable()) != null) {
            cm = new IndexColorModel(8, byteTable[0].length, byteTable[0], byteTable[1], byteTable[2]);
        }
        ImageProcessor[] ip = new ImageProcessor[c];
        for (int i = 0; i < c; ++i) {
            Object[] tmp;
            Object[] q;
            byte[] channel = ImageTools.splitChannels(b, i, c, bpp, false, interleave);
            Object pixels = DataTools.makeDataArray(channel, bpp, isFloat, isLittle);
            if (pixels instanceof byte[]) {
                q = (byte[])pixels;
                if (q.length > w * h) {
                    tmp = q;
                    q = new byte[w * h];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                if (isSigned) {
                    q = DataTools.makeSigned(q);
                }
                ip[i] = new ByteProcessor(w, h, q, null);
                if (cm == null) continue;
                ip[i].setColorModel((ColorModel)cm);
                continue;
            }
            if (pixels instanceof short[]) {
                q = (short[])pixels;
                if (q.length > w * h) {
                    tmp = q;
                    q = new short[w * h];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                if (isSigned) {
                    q = DataTools.makeSigned((short[])q);
                }
                ip[i] = new ShortProcessor(w, h, (short[])q, model);
                continue;
            }
            if (pixels instanceof int[]) {
                q = (int[])pixels;
                if (q.length > w * h) {
                    tmp = q;
                    q = new int[w * h];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                ip[i] = new FloatProcessor(w, h, (int[])q);
                continue;
            }
            if (pixels instanceof float[]) {
                q = (float[])pixels;
                if (q.length > w * h) {
                    tmp = q;
                    q = new float[w * h];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                ip[i] = new FloatProcessor(w, h, (float[])q, null);
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            q = (double[])pixels;
            if (q.length > w * h) {
                tmp = q;
                q = new double[w * h];
                System.arraycopy(tmp, 0, q, 0, q.length);
            }
            ip[i] = new FloatProcessor(w, h, (double[])q);
        }
        return ip;
    }

    public static ImagePlus makeRGB(ImageProcessor[] p) {
        return Util.makeRGB("", p);
    }

    public static ImagePlus makeRGB(String title, ImageProcessor[] p) {
        if (p.length == 1) {
            return new ImagePlus(title, p[0]);
        }
        boolean sameType = true;
        int width = p[0].getWidth();
        int height = p[0].getHeight();
        boolean byteProc = p[0] instanceof ByteProcessor;
        boolean shortProc = p[0] instanceof ShortProcessor;
        boolean floatProc = p[0] instanceof FloatProcessor;
        for (int i = 1; i < p.length; ++i) {
            int w = p[i].getWidth();
            int h = p[i].getHeight();
            boolean b = p[i] instanceof ByteProcessor;
            boolean s = p[i] instanceof ShortProcessor;
            boolean f = p[i] instanceof FloatProcessor;
            if (w == width && h == height && b == byteProc && s == shortProc && f == floatProc) continue;
            sameType = false;
            break;
        }
        if (!sameType || p.length > 4 || p[0] instanceof ColorProcessor) {
            return null;
        }
        ImagePlus imp = null;
        if (p.length < 4 && byteProc) {
            ColorProcessor cp = new ColorProcessor(width, height);
            byte[][] bytes = new byte[p.length][];
            for (int i = 0; i < p.length; ++i) {
                bytes[i] = (byte[])p[i].getPixels();
            }
            cp.setRGB(bytes[0], bytes[1], bytes.length == 3 ? bytes[2] : new byte[width * height]);
            imp = new ImagePlus(title, (ImageProcessor)cp);
        } else if (p.length <= 7 && Util.checkVersion("1.39l", COMPOSITE_MSG)) {
            ImageStack tmpStack = new ImageStack(width, height);
            for (int i = 0; i < p.length; ++i) {
                tmpStack.addSlice("", p[i]);
            }
            try {
                ReflectedUniverse r = new ReflectedUniverse();
                r.exec("import ij.CompositeImage");
                ImagePlus ii = new ImagePlus(title, tmpStack);
                r.setVar("ii", ii);
                r.exec("imp = new CompositeImage(ii, CompositeImage.COMPOSITE)");
                imp = (ImagePlus)r.getVar("imp");
            }
            catch (ReflectException e) {
                ByteArrayOutputStream s = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(s));
                IJ.error((String)s.toString());
            }
        }
        return imp;
    }

    public static void applyCalibration(MetadataRetrieve retrieve, ImagePlus imp, int series) {
        String type;
        int pixelType;
        boolean signed;
        Float tf;
        Float zf;
        Float yf;
        double xcal = Double.NaN;
        double ycal = Double.NaN;
        double zcal = Double.NaN;
        double tcal = Double.NaN;
        Float xf = retrieve.getDimensionsPhysicalSizeX(series, 0);
        if (xf != null) {
            xcal = xf.floatValue();
        }
        if ((yf = retrieve.getDimensionsPhysicalSizeY(series, 0)) != null) {
            ycal = yf.floatValue();
        }
        if ((zf = retrieve.getDimensionsPhysicalSizeZ(series, 0)) != null) {
            zcal = zf.floatValue();
        }
        if ((tf = retrieve.getDimensionsTimeIncrement(series, 0)) != null) {
            tcal = tf.floatValue();
        }
        if (xcal == xcal || ycal == ycal || zcal == zcal || tcal == tcal) {
            if (xcal != xcal) {
                xcal = ycal;
            }
            if (ycal != ycal) {
                ycal = xcal;
            }
            Calibration cal = new Calibration();
            cal.setUnit("micron");
            cal.pixelWidth = xcal;
            cal.pixelHeight = ycal;
            cal.pixelDepth = zcal;
            cal.frameInterval = tcal;
            imp.setCalibration(cal);
        }
        boolean bl = signed = (pixelType = FormatTools.pixelTypeFromString(type = retrieve.getPixelsPixelType(series, 0))) == 0 || pixelType == 2 || pixelType == 4;
        if (signed) {
            int bitsPerPixel = FormatTools.getBytesPerPixel(pixelType) * 8;
            double min = -1.0 * Math.pow(2.0, bitsPerPixel - 1);
            imp.getLocalCalibration().setFunction(0, new double[]{min, 1.0}, "gray value");
        }
    }

    public static void addScrollBars(Container pane) {
        GridBagLayout layout = (GridBagLayout)pane.getLayout();
        int count = pane.getComponentCount();
        Component[] c = new Component[count];
        GridBagConstraints[] gbc = new GridBagConstraints[count];
        for (int i = 0; i < count; ++i) {
            c[i] = pane.getComponent(i);
            gbc[i] = layout.getConstraints(c[i]);
        }
        pane.removeAll();
        layout.invalidateLayout(pane);
        Panel newPane = new Panel();
        GridBagLayout newLayout = new GridBagLayout();
        newPane.setLayout(newLayout);
        for (int i = 0; i < count; ++i) {
            newLayout.setConstraints(c[i], gbc[i]);
            newPane.add(c[i]);
        }
        Frame f = new Frame();
        f.setLayout(new BorderLayout());
        f.add((Component)newPane, "Center");
        f.pack();
        final Dimension size = newPane.getSize();
        f.remove(newPane);
        f.dispose();
        size.width += 15;
        size.height += 15;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int maxWidth = 3 * screen.width / 4;
        int maxHeight = 3 * screen.height / 4;
        if (size.width > maxWidth) {
            size.width = maxWidth;
        }
        if (size.height > maxHeight) {
            size.height = maxHeight;
        }
        ScrollPane scroll = new ScrollPane(){

            public Dimension getPreferredSize() {
                return size;
            }
        };
        scroll.add(newPane);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        layout.setConstraints(scroll, constraints);
        pane.add(scroll);
    }

    public static void adjustColorRange(ImagePlus imp) {
        ImageStack s = imp.getStack();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < s.getSize(); ++i) {
            ImageProcessor p = s.getProcessor(i + 1);
            p.resetMinAndMax();
            if (p.getMin() < min) {
                min = p.getMin();
            }
            if (!(p.getMax() > max)) continue;
            max = p.getMax();
        }
        ImageProcessor p = imp.getProcessor();
        if (p instanceof ColorProcessor) {
            ((ColorProcessor)p).setMinAndMax(min, max, 3);
        } else {
            p.setMinAndMax(min, max);
        }
        imp.setProcessor(imp.getTitle(), p);
    }

    public static boolean checkVersion(String target, String msg) {
        String current = IJ.getVersion();
        if (current.compareTo(target) < 0) {
            IJ.showMessage((String)msg);
            return false;
        }
        return true;
    }

    public static ImagePlus reorder(ImagePlus imp, String origOrder, String newOrder) {
        ImageStack s = imp.getStack();
        ImageStack newStack = new ImageStack(s.getWidth(), s.getHeight());
        int z = imp.getNSlices();
        int c = imp.getNChannels();
        int t = imp.getNFrames();
        int stackSize = s.getSize();
        for (int i = 0; i < stackSize; ++i) {
            int ndx = FormatTools.getReorderedIndex(origOrder, newOrder, z, c, t, stackSize, i);
            newStack.addSlice(s.getSliceLabel(ndx + 1), s.getProcessor(ndx + 1));
        }
        ImagePlus p = new ImagePlus(imp.getTitle(), newStack);
        p.setDimensions(c, z, t);
        p.setCalibration(imp.getCalibration());
        p.setFileInfo(imp.getOriginalFileInfo());
        return p;
    }

    public static ImageReader makeImageReader() {
        Class[] c = null;
        try {
            ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
            c = defaultClasses.getClasses();
        }
        catch (IOException exc) {
            return new ImageReader();
        }
        ClassList enabledClasses = new ClassList(IFormatReader.class);
        for (int i = 0; i < c.length; ++i) {
            boolean on = Util.getPref(PREF_READER_ENABLED, c[i], true);
            if (!on) continue;
            try {
                enabledClasses.addClass(c[i]);
                continue;
            }
            catch (FormatException exc) {
                exc.printStackTrace();
            }
        }
        ImageReader reader = new ImageReader(enabledClasses);
        boolean nd2Nikon = Prefs.get((String)PREF_ND2_NIKON, (boolean)false);
        boolean pictQTJava = Prefs.get((String)PREF_PICT_QTJAVA, (boolean)false);
        boolean qtQTJava = Prefs.get((String)PREF_QT_QTJAVA, (boolean)false);
        boolean sdtIntensity = Prefs.get((String)PREF_SDT_INTENSITY, (boolean)false);
        IFormatReader[] r = reader.getReaders();
        for (int i = 0; i < r.length; ++i) {
            if (r[i] instanceof ND2Reader) {
                ND2Reader nd2 = (ND2Reader)r[i];
                nd2.setLegacy(nd2Nikon);
                continue;
            }
            if (r[i] instanceof PictReader) {
                PictReader pict = (PictReader)r[i];
                pict.setLegacy(pictQTJava);
                continue;
            }
            if (r[i] instanceof QTReader) {
                QTReader qt = (QTReader)r[i];
                qt.setLegacy(qtQTJava);
                continue;
            }
            if (!(r[i] instanceof SDTReader)) continue;
            SDTReader sdt = (SDTReader)r[i];
            sdt.setIntensity(sdtIntensity);
        }
        return reader;
    }

    public static boolean isWindowless(IFormatReader reader) {
        return Util.getPref(PREF_READER_WINDOWLESS, reader.getClass(), false);
    }

    public static void placeWindow(Window w) {
        Dimension size = w.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ImageJ ij = IJ.getInstance();
        Point p = new Point();
        if (ij == null) {
            p.x = (screen.width - size.width) / 2;
            p.y = (screen.height - size.height) / 2;
        } else {
            Rectangle ijBounds = ij.getBounds();
            p.x = ijBounds.x + (ijBounds.width - size.width) / 2;
            p.y = ijBounds.y + ijBounds.height + 5;
        }
        int pad = 10;
        if (p.x < 10) {
            p.x = 10;
        } else if (p.x + size.width + 10 > screen.width) {
            p.x = screen.width - size.width - 10;
        }
        if (p.y < 10) {
            p.y = 10;
        } else if (p.y + size.height + 10 > screen.height) {
            p.y = screen.height - size.height - 10;
        }
        w.setLocation(p);
    }

    public static void reportException(Throwable t) {
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        t.printStackTrace(pw);
        String s = caw.toString();
        if (IJ.isMacintosh()) {
            if (s.indexOf("ThreadDeath") > 0) {
                return;
            }
            s = Tools.fixNewLines((String)s);
        }
        if (IJ.getInstance() != null) {
            new TextWindow("Exception", s, 350, 250);
        } else {
            IJ.log((String)s);
        }
    }

    private static boolean getPref(String pref, Class c, boolean defaultValue) {
        String n = c.getName();
        String readerName = n.substring(n.lastIndexOf(".") + 1, n.length() - 6);
        String key = pref + "." + readerName;
        return Prefs.get((String)key, (boolean)defaultValue);
    }
}

