/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import loci.common.RandomAccessStream;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class POIDocument {
    protected SummaryInformation sInf;
    protected DocumentSummaryInformation dsInf;
    protected POIFSFileSystem filesystem;
    protected POILogger logger = POILogFactory.getLogger(this.getClass());

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        return this.sInf;
    }

    protected void readProperties() {
        this.dsInf = (DocumentSummaryInformation)this.getPropertySet("\u0005DocumentSummaryInformation");
        this.sInf = (SummaryInformation)this.getPropertySet("\u0005SummaryInformation");
    }

    protected PropertySet getPropertySet(String setName) {
        DocumentInputStream dis;
        try {
            dis = this.filesystem.createDocumentInputStream(setName);
        }
        catch (IOException ie) {
            this.logger.log(5, "Error getting property set with name " + setName + "\n" + ie);
            return null;
        }
        try {
            PropertySet set = PropertySetFactory.create(dis);
            return set;
        }
        catch (IOException ie) {
            this.logger.log(5, "Error creating property set with name " + setName + "\n" + ie);
        }
        catch (HPSFException he) {
            this.logger.log(5, "Error creating property set with name " + setName + "\n" + he);
        }
        return null;
    }

    protected void writeProperties(POIFSFileSystem outFS) throws IOException {
        this.writeProperties(outFS, null);
    }

    protected void writeProperties(POIFSFileSystem outFS, List writtenEntries) throws IOException {
        if (this.sInf != null) {
            this.writePropertySet("\u0005SummaryInformation", this.sInf, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005SummaryInformation");
            }
        }
        if (this.dsInf != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", this.dsInf, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String name, PropertySet set, POIFSFileSystem outFS) throws IOException {
        try {
            MutablePropertySet mSet = new MutablePropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write(bOut);
            byte[] data = bOut.toByteArray();
            outFS.createDocument(new RandomAccessStream(data), name);
            this.logger.log(3, "Wrote property set " + name + " of size " + data.length);
        }
        catch (WritingNotSupportedException wnse) {
            System.err.println("Couldn't write property set with name " + name + " as not supported by HPSF yet");
        }
    }

    protected void copyNodes(POIFSFileSystem source, POIFSFileSystem target, List excepts) throws IOException {
        DirectoryEntry root = source.getRoot();
        DirectoryEntry newRoot = target.getRoot();
        Iterator entries = root.getEntries();
        while (entries.hasNext()) {
            Entry entry = (Entry)entries.next();
            if (this.isInList(entry.getName(), excepts)) continue;
            this.copyNodeRecursively(entry, newRoot);
        }
    }

    private boolean isInList(String entry, List list) {
        for (int k = 0; k < list.size(); ++k) {
            if (!list.get(k).equals(entry)) continue;
            return true;
        }
        return false;
    }

    private void copyNodeRecursively(Entry entry, DirectoryEntry target) throws IOException {
        DirectoryEntry newTarget = null;
        if (entry.isDirectoryEntry()) {
            newTarget = target.createDirectory(entry.getName());
            Iterator entries = ((DirectoryEntry)entry).getEntries();
            while (entries.hasNext()) {
                this.copyNodeRecursively((Entry)entries.next(), newTarget);
            }
        } else {
            DocumentEntry dentry = (DocumentEntry)entry;
        }
    }
}

