/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class EmbeddedObjectRefSubRecord
extends SubRecord {
    public static final short sid = 9;
    public short field_1_stream_id_offset;
    public short[] field_2_unknown;
    public short field_3_unicode_len;
    public boolean field_4_unicode_flag;
    public String field_5_ole_classname;
    public int field_6_stream_id;

    public EmbeddedObjectRefSubRecord() {
    }

    public EmbeddedObjectRefSubRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 9) {
            throw new RecordFormatException("Not a EmbeddedObjectRef record");
        }
    }

    public short getSid() {
        return 9;
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_stream_id_offset = in.readShort();
        this.field_2_unknown = in.readShortArray();
        this.field_3_unicode_len = in.readShort();
        this.field_4_unicode_flag = (in.readByte() & 1) != 0;
        this.field_5_ole_classname = this.field_4_unicode_flag ? in.readUnicodeLEString(this.field_3_unicode_len) : in.readCompressedUnicode(this.field_3_unicode_len);
        while (in.getRecordOffset() - 2 < this.field_1_stream_id_offset) {
            in.readByte();
        }
        this.field_6_stream_id = in.readInt();
    }

    public int serialize(int offset, byte[] data) {
        int pos = offset;
        LittleEndian.putShort(data, pos, this.field_1_stream_id_offset);
        LittleEndian.putShortArray(data, pos += 2, this.field_2_unknown);
        LittleEndian.putShort(data, pos += this.field_2_unknown.length * 2 + 2, this.field_3_unicode_len);
        data[pos += 2] = this.field_4_unicode_flag ? (byte)1 : 0;
        ++pos;
        if (this.field_4_unicode_flag) {
            StringUtil.putUnicodeLE(this.field_5_ole_classname, data, pos);
            pos += this.field_5_ole_classname.length() * 2;
        } else {
            StringUtil.putCompressedUnicode(this.field_5_ole_classname, data, pos);
            pos += this.field_5_ole_classname.length();
        }
        pos = this.field_1_stream_id_offset;
        LittleEndian.putInt(data, pos, this.field_6_stream_id);
        pos += 4;
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return this.field_1_stream_id_offset + 4;
    }

    public int getStreamId() {
        return this.field_6_stream_id;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ftPictFmla]\n");
        buffer.append("    .streamIdOffset       = ").append("0x").append(HexDump.toHex(this.field_1_stream_id_offset)).append(" (").append(this.field_1_stream_id_offset).append(" )").append(System.getProperty("line.separator"));
        buffer.append("    .unknown              = ").append("0x").append(HexDump.toHex(this.field_2_unknown)).append(" (").append(this.field_2_unknown).append(" )").append(System.getProperty("line.separator"));
        buffer.append("    .unicodeLen           = ").append("0x").append(HexDump.toHex(this.field_3_unicode_len)).append(" (").append(this.field_3_unicode_len).append(" )").append(System.getProperty("line.separator"));
        buffer.append("    .unicodeFlag          = ").append("0x").append(this.field_4_unicode_flag ? 1 : 0).append(" (").append(this.field_4_unicode_flag).append(" )").append(System.getProperty("line.separator"));
        buffer.append("    .oleClassname         = ").append(this.field_5_ole_classname).append(System.getProperty("line.separator"));
        buffer.append("    .streamId             = ").append("0x").append(HexDump.toHex(this.field_6_stream_id)).append(" (").append(this.field_6_stream_id).append(" )").append(System.getProperty("line.separator"));
        buffer.append("[/ftPictFmla]");
        return buffer.toString();
    }
}

