/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.ListManagedBlock;

class BlockListImpl
implements BlockList {
    protected ListManagedBlock[] _blocks = new ListManagedBlock[0];
    private BlockAllocationTableReader _bat = null;

    protected BlockListImpl() {
    }

    protected void setBlocks(ListManagedBlock[] blocks) {
        this._blocks = blocks;
    }

    public void zap(int index) {
        if (index >= 0 && index < this._blocks.length) {
            this._blocks[index] = null;
        }
    }

    public ListManagedBlock remove(int index) throws IOException {
        ListManagedBlock result = null;
        try {
            result = this._blocks[index];
            if (result == null) {
                throw new IOException("block[ " + index + " ] already removed");
            }
            this._blocks[index] = null;
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new IOException("Cannot remove block[ " + index + " ]; out of range");
        }
        return result;
    }

    public ListManagedBlock[] fetchBlocks(int startBlock) throws IOException {
        if (this._bat == null) {
            throw new IOException("Improperly initialized list: no block allocation table provided");
        }
        return this._bat.fetchBlocks(startBlock, this);
    }

    public void setBAT(BlockAllocationTableReader bat) throws IOException {
        if (this._bat != null) {
            throw new IOException("Attempt to replace existing BlockAllocationTable");
        }
        this._bat = bat;
    }
}

