/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import loci.common.RandomAccessStream;
import org.apache.poi.poifs.storage.ListManagedBlock;

public class RawDataBlock
implements ListManagedBlock {
    private boolean _eof;
    private int blockSize;
    private RandomAccessStream stream;
    private long offset;
    private int length;

    public RawDataBlock(RandomAccessStream stream, int size) throws IOException {
        this.stream = stream;
        this.length = this.blockSize = size;
        this._eof = stream.length() - stream.getFilePointer() <= 0L;
        this.offset = stream.getFilePointer();
    }

    public boolean eof() throws IOException {
        return this._eof;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() throws IOException {
        if (this.eof()) {
            throw new IOException("Cannot return empty data");
        }
        byte[] b = new byte[this.length];
        this.stream.seek(this.offset);
        this.stream.read(b);
        return b;
    }
}

