/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import sun.net.www.protocol.http.Handler;

public class NetworkUtils {
    public static void initProtocolHandler() {
        try {
            new URL(null, "http://motherlode.ucar.edu:8080/", new Handler());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static String resolve(String baseUrl, String relativeUrl) {
        if (baseUrl == null || relativeUrl == null) {
            return relativeUrl;
        }
        URI refURI = URI.create(relativeUrl = NetworkUtils.canonicalizeRead(relativeUrl));
        if (refURI.isAbsolute()) {
            return relativeUrl;
        }
        if (baseUrl.startsWith("file:")) {
            if (relativeUrl.length() > 0 && relativeUrl.charAt(0) == '#') {
                return baseUrl + relativeUrl;
            }
            if (relativeUrl.length() > 0 && relativeUrl.charAt(0) == '/') {
                return relativeUrl;
            }
            int pos = baseUrl.lastIndexOf(47);
            if (pos > 0) {
                return baseUrl.substring(0, pos + 1) + relativeUrl;
            }
        }
        URI baseURI = URI.create(baseUrl);
        URI resolvedURI = baseURI.resolve(refURI);
        return resolvedURI.toASCIIString();
    }

    public static String canonicalizeRead(String location) {
        try {
            URI refURI = URI.create(location);
            if (refURI.isAbsolute()) {
                return location;
            }
        }
        catch (Exception e) {
            return "file:" + location;
        }
        return location;
    }

    public static String canonicalizeWrite(String location) {
        try {
            URI refURI = URI.create(location);
            if (refURI.isAbsolute()) {
                return location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "file:" + location;
    }

    public static String resolveFile(String baseDir, String filepath) {
        if (baseDir == null) {
            return filepath;
        }
        File file2 = new File(filepath);
        if (file2.isAbsolute()) {
            return filepath;
        }
        return baseDir + filepath;
    }

    private static void test(String uriS) {
        System.out.println(uriS);
        URI uri = URI.create(uriS);
        System.out.println(" scheme=" + uri.getScheme());
        System.out.println(" getSchemeSpecificPart=" + uri.getSchemeSpecificPart());
        System.out.println(" getAuthority=" + uri.getAuthority());
        System.out.println(" getPath=" + uri.getPath());
        System.out.println();
    }

    public static void main2(String[] args) {
        NetworkUtils.test("file:test/dir");
        NetworkUtils.test("file:/test/dir");
        NetworkUtils.test("file://test/dir");
        NetworkUtils.test("file:///test/dir");
        NetworkUtils.test("file:C:/Program Files (x86)/Apache Software Foundation/Tomcat 5.0/content/thredds/cache");
        NetworkUtils.test("file:C:\\Program Files (x86)\\Apache Software Foundation\\Tomcat 5.0\\content\\thredds\\cache");
    }

    private static void testResolve(String base, String rel, String result) {
        System.out.println("\nbase= " + base);
        System.out.println("rel= " + rel);
        System.out.println("resolve= " + NetworkUtils.resolve(base, rel));
        if (result != null) assert (NetworkUtils.resolve(base, rel).equals(result));
    }

    public static void main3(String[] args) {
        NetworkUtils.testResolve("http://test/me/", "wanna", "http://test/me/wanna");
        NetworkUtils.testResolve("http://test/me/", "/wanna", "http://test/wanna");
        NetworkUtils.testResolve("file:/test/me/", "wanna", "file:/test/me/wanna");
        NetworkUtils.testResolve("file:/test/me/", "/wanna", "/wanna");
        NetworkUtils.testResolve("file://test/me/", "http:/wanna", "http:/wanna");
        NetworkUtils.testResolve("file://test/me/", "file:/wanna", "file:/wanna");
        NetworkUtils.testResolve("file://test/me/", "C:/wanna", "C:/wanna");
        NetworkUtils.testResolve("http://test/me/", "file:wanna", "file:wanna");
    }

    public static void main4(String[] args) {
        try {
            URL url = new URL("file:src/test/data/ncml/nc/");
            URI uri = new URI("file:src/test/data/ncml/nc/");
            File file2 = new File(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws URISyntaxException {
        String uriString = "http://dods.coas.oregonstate.edu:8080/dods/dts/test.53.dods?types[0:1:9]";
        URI uri = new URI(uriString);
    }
}

