function data = MT_DemonstrationH_20121129( data, before )
    if nargin < 1, return; end
% 
% extract factors from structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval([[factname,'_p'],'=reshape(','data.factorprops.Concentration(:,i),[ data.cellprops.cellsize]);']);
        eval([[factname,'_i'],'=','data.factorprops.Name2Index.(factname);']);
    end
% insert model in here
%% To run on the cluster
% MTtboxCommandGrace('Name','MT_Paper1_20121121','N_steps',[500:500:2000],...
%       'ORTHO_TOP',1,'modelname',[1,2],'growth_rate',[1:7],'Rescue_rate',[1:4],'Use','Cluster');

%%Begin cluster run stuff
    if (~isfield(data,'noGui') || data.noGui == 0) || data.iterations<0
        rng('shuffle'); % to seed from the same number each time use 1234 instead of 'shuffle'
        %data.userdata.ranges.growth_rate.range{1} = 0.0005; %1
        %data.userdata.ranges.growth_rate.range{2} = 0.001; %1
        %data.userdata.ranges.growth_rate.range{3} = 0.003; %1
        %data.userdata.ranges.growth_rate.index = 2;
        
        %data.userdata.ranges.Rescue_rate.range{1} = 0.5; %2
        %data.userdata.ranges.Rescue_rate.range{2} = 0.3; %2
        %data.userdata.ranges.Rescue_rate.index = 1;
        
        %data.userdata.ranges.shrink_rate.range = num2cell(0.2); %5
        %data.userdata.ranges.shrink_rate.index = 1;
        
        data.userdata.ranges.modelname.range{1} = 'DEFAULT'; %5
        data.userdata.ranges.modelname.range{2} = 'NO_MEMBRANE_COALIGNMENT'; %5
        data.userdata.ranges.modelname.range{3} = 'DELETE_ON_CONTACT_WITH_MEMBRANES'; %5
        data.userdata.ranges.modelname.range{4} = 'DELETE_ON_COLLISION_WITH_MT'; %5
        data.userdata.ranges.modelname.range{5} = 'CROSSOVER_ON_COLLISION_WITH_MT'; %5
        data.userdata.ranges.modelname.range{6} = 'PAUSE_OR_CROSSOVER_ON_COLLISION_WITH_MT'; %5
        data.userdata.ranges.modelname.range{7} = 'DEFAULT_WITH_DIFFUSING_FACTOR_IMPULSE'; %5
        data.userdata.ranges.modelname.range{8} = 'DEFAULT_WITH_DIFFUSING_CLAMPED_FACTOR'; %5
        data.userdata.ranges.modelname.range{9} = 'SPONTANEOUS_NUCLEATION_PROMOTED_BY_FACTOR_IMPULSE'; %5
        data.userdata.ranges.modelname.range{10} = 'MTS_DESTABILISED_BY_DIFFUSING_FACTOR_IMPULSE'; %5
        data.userdata.ranges.modelname.range{11} = 'MTS_NUCLEATED_BY_DIFFUSING_END_FACTORS'; %5
        data.userdata.ranges.modelname.range{12} = 'MTS_STABILISED_AND_NUCLEATED_BY_DIFFUSING_END_FACTORS'; %5
        data.userdata.ranges.modelname.index = 12;
    end
    fields=fieldnames(data.userdata.ranges);
    fprintf(1,'\n');
    if  data.cellprops.sheetmodel
        titlestring=sprintf('%s - sheet\n',data.projectname);
    else
        titlestring=sprintf('%s - volume\n',data.projectname);
    end
    for i=1:length(fields)
        fieldname=fields{i};
        eval(sprintf('%s=(data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index});',fieldname));
        if ischar(data.userdata.ranges.(fieldname).range{1})
            titlestring=[titlestring,' ',sprintf('%s: %s\n ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})];
        else
            titlestring=[titlestring,' ',sprintf('%s: %f\n ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})];
        end
    end
    fprintf(1,'%s\n',titlestring);
    if MT_haveGUI( data )
        singlestep=get(gcbo,'tag');
        if isfield(data,'view_steps') && rem(data.iterations,data.view_steps)==0 || strcmp(singlestep,'pushbutton_step')%rem(data.iterations,1)==0
            if isfield(data.plotprops,'TitleH') && ishandle( data.plotprops.TitleH)
                set(data.plotprops.TitleH,'String',titlestring,'Parent',data.plotprops.AxesH,'interpret','none');
            end
        end
    else % The following is for use on the cluster
        if rem(data.iterations,data.view_steps)==0 
            set(data.plotprops.TitleH,'String',titlestring,'Parent',data.plotprops.AxesH,'interpret','none');
        end
    end
    if data.iterations==0
        %% 
        %%
        %SET time per step
        %data.cellprops.secondsPerStep=7.5; % frame rate in experimental data
        % set default parameters
        data=mtSETMTprops(data,...
            'thicknessMicrons', 0.0250,...
            'minvox',0.0250,...
            'growthrate',0.500,...
            'shrinkrate',0,...
            'shrinkheadrate',5,...
            'catastropherate',5,...
            'maxAlignToSurfAngle',40,...
            'maxZipToMTAngle',20,...
            'bendpriority','membrane',...
            'maxSpawnAngle',40,...
            'maxAge',0,...
            'nuclspont',0.0180,...
            'nuclonMT',0.0150,...
            'probCatastropheWhenHit',0.0200,...
            'probPauseOnCollision',0.8000,...
            'probSpontaneousCatastrophe',0,...
            'backwardBranching',0,...
            'parallelspawnprob',[],...
            'wraparound',0,...
            'FaceColor',[0 0 1],...
            'FaceAlpha',0.4000,...
            'Label',-6,...
            'isLayer',0,...
            'Static',0,...
            'InUse',1     );
        % modify parameters according to the model
        %data=mtSETMTprops(data,'growthrate',0.5);
        switch modelname
            case 'DEFAULT'
            case 'NO_MEMBRANE_COALIGNMENT'
                 data=mtSETMTprops(data,'maxAlignToSurfAngle',0);
            case {'DELETE_ON_CONTACT_WITH_MEMBRANES',...
                    'DELETE_ON_COLLISION_WITH_MT',...
                    'CROSSOVER_ON_COLLISION_WITH_MT',...
                    'PAUSE_OR_CROSSOVER_ON_COLLISION_WITH_MT'}
                 data=mtSETMTprops(data,'maxAlignToSurfAngle',0);
            case {'DEFAULT_WITH_DIFFUSING_FACTOR_IMPULSE',...
                    'DEFAULT_WITH_DIFFUSING_CLAMPED_FACTOR',...
                    'SPONTANEOUS_NUCLEATION_PROMOTED_BY_FACTOR_IMPULSE',...
                    'MTS_DESTABILISED_BY_DIFFUSING_FACTOR_IMPULSE'}
                data=mtSETMTprops(data,'maxAlignToSurfAngle',0);
                % Factors overlaying side and top/bottom edges of cytoplasm
                midx=round(data.cellprops.cellsize(1)/2);
                midy=round(data.cellprops.cellsize(2)/2);
                midz=ceil(data.cellprops.cellsize(3)/2);      
                width=2;
                for i=1:width
                    x=midx-ceil(width/2)+i;
                    for j=1:width
                        y=midy-ceil(width/2)+j;
                        for k=1:width
                            z=midz-ceil(width/2)+k;
                            if data.cellprops.sheetmodel
                                id_a_p(x,y,:)=1; % column to ensure that spot is at intersection with plane
                            else
                                id_a_p(x,y,z)=1;
                            end
                        end
                    end
                end
                s_a_p(:)=0;
                data=setupDiffusion(data,'Factorname','s_a','DiffK',[0.05,0.0],...
                    'RegionLists',{{'cytoplasm'},{'plasma_membrane','microtubules','vacuole','cell_wall'}});
                s_a_p(region(data,id_a_p,'cytoplasm'))=3;% generate impulse
                switch modelname
                    case 'SPONTANEOUS_NUCLEATION_PROMOTED_BY_FACTOR_IMPULSE'
                        data = setFactorRole( data,  'nuclspont' , 'id_a' );
                        data=mtSETMTprops(data,'nuclonMT',0,'nuclspont',0.1);
                    case 'MTS_DESTABILISED_BY_DIFFUSING_FACTOR_IMPULSE'
                        data=mtSETMTprops(data,'nuclonMT',0,'nuclspont',0.1);
                end
            case {'MTS_STABILISED_AND_NUCLEATED_BY_DIFFUSING_END_FACTORS',...
                        'MTS_NUCLEATED_BY_DIFFUSING_END_FACTORS'}
                % Factors overlaying side and top/bottom edges of cytoplasm
                midx=round(data.cellprops.cellsize(1)/2);
                midy=round(data.cellprops.cellsize(2)/2);
                midz=round(data.cellprops.cellsize(3)/2);
                cytoplasm_ind=find(data.cellprops.Vol==data.organelleprops.cytoplasm.Label);
                [xx,yy,zz]=ind2sub(data.cellprops.cellsize,cytoplasm_ind);
                max_cyt_x=max(xx);
                max_cyt_y=max(yy);
                max_cyt_z=max(zz);
                min_cyt_x=min(xx);
                min_cyt_y=min(yy);
                min_cyt_z=min(zz);                
                id_a_p(1:min_cyt_x+1,:,:)=1;
                id_a_p(max_cyt_x-1:end,:,:)=1;
                s_a_p(:)=0;
                data=setupDiffusion(data,'Factorname','s_a','DiffK',[0.02,0.0],...
                    'RegionLists',{{'cytoplasm'},{'plasma_membrane','microtubules','vacuole','cell_wall'}});
                data = setFactorRole( data,  'nuclspont' , 's_a' );
                data=mtSETMTprops(data,'nuclonMT',0,'nuclspont',0.1);
            otherwise
                error('modelname not recognised');
        end  
    else
        %% 
        %%
        %Make changes here
        %% 
        %%
        %  Wrap where needed by creating new MTs that form the wrap
        % data=MT_wrap(data,'run');        
        %
        % plot profiles of factors in the context of the cytoplasm region
        switch modelname
            case {'DEFAULT_WITH_DIFFUSING_FACTOR_IMPULSE',...
                    'SPONTANEOUS_NUCLEATION_PROMOTED_BY_FACTOR_IMPULSE'}
                plotrows=2;
                plotcols=1;
                FactorProfilePlot(data,{'s_a','cytoplasm'},'x',plotrows,plotcols,1);
            case {'DEFAULT_WITH_DIFFUSING_CLAMPED_FACTOR',...
                    'MTS_DESTABILISED_BY_DIFFUSING_FACTOR_IMPULSE'}                
                s_a_p(region(data,id_a_p,'cytoplasm'))=1;% generate (clamp) intersecting with cytoplasm
                s_a_p=s_a_p*(1-0.00); % decay
                plotrows=2;
                plotcols=1;
                FactorProfilePlot(data,{'s_a','cytoplasm'},'x',plotrows,plotcols,1);
            case {'MTS_STABILISED_AND_NUCLEATED_BY_DIFFUSING_END_FACTORS',...
                        'MTS_NUCLEATED_BY_DIFFUSING_END_FACTORS'}                
                s_a_p(region(data,id_a_p,'cytoplasm'))=1;% generate (clamp) intersecting with cytoplasm
                s_a_p=s_a_p*(1-0.03); % decay
                plotrows=2;
                plotcols=1;
                FactorProfilePlot(data,{'s_a','cytoplasm'},'x',plotrows,plotcols,1);
        end
        % _Checking and changes to individual MTs_
        for i_MT=1:length(data.working.dyn.microtubules.Org)
            MT=data.working.dyn.microtubules.Org(i_MT);
            switch modelname
                case {'DEFAULT',...
                        'NO_MEMBRANE_COALIGNMENT',...
                        'DEFAULT_WITH_DIFFUSING_FACTOR_IMPULSE',...
                        'DEFAULT_WITH_DIFFUSING_CLAMPED_FACTOR',...
                        'SPONTANEOUS_NUCLEATION_PROMOTED_BY_FACTOR_IMPULSE'}
                case {'MTS_STABILISED_AND_NUCLEATED_BY_DIFFUSING_END_FACTORS',...
                        'MTS_NUCLEATED_BY_DIFFUSING_END_FACTORS'}
                    if hasHit('MT',MT) % has the MT organelle or MT?
                        MT.Growing=true; % continue growing through the hit MT
                        MT.Hit= struct( 'hitmt', [], ...
                                'hitstatic', [], ...
                                'hitat', [], ...
                                'hitwhen', [] );
                    end
                    [inds,array]=region(data,s_a_p,'cytoplasm');
                    tempMT=round(MT.Verts);
                    % check growing tip only
                    tip_inds=sub2ind(data.cellprops.cellsize,tempMT(end,1),tempMT(end,2),tempMT(end,3));
                    max_s_a_p=max(array(:));
                    value=max(array(tip_inds)/max_s_a_p);
                    switch modelname
                        case 'MTS_STABILISED_AND_NUCLEATED_BY_DIFFUSING_END_FACTORS'
                            if rand>value % delete in absence of s_a_p
                                MT.Alive=false; % ensure that MTs that hit are annihilated
                            end
                        case 'MTS_NUCLEATED_BY_DIFFUSING_END_FACTORS'
                    end
                case 'MTS_DESTABILISED_BY_DIFFUSING_FACTOR_IMPULSE'
                    if hasHit('MT',MT) % has the MT organelle or MT?
                        MT.Growing=true; % continue growing through the hit MT
                        MT.Hit= struct( 'hitmt', [], ...
                                'hitstatic', [], ...
                                'hitat', [], ...
                                'hitwhen', [] );
                    end
                    [inds,array]=region(data,s_a_p,'cytoplasm');
                    tempMT=round(MT.Verts);
                    % check whole MT for maximum exposure (could be average etc.)
                    tip_inds=sub2ind(data.cellprops.cellsize,tempMT(:,1),tempMT(:,2),tempMT(:,3));
                    max_s_a_p=max(array(:));
                    value=max(array(tip_inds)/max_s_a_p);
                    if rand<value
                        MT.Alive=false; % ensure that MTs that hit are annihilated
                    end                        
                case 'DELETE_ON_CONTACT_WITH_MEMBRANES'
                    if hasHit('Static',MT) % has the MT hit a static organelle?
                        MT.Alive=false; % ensure that MTs that hit are annihilated
                    end
                case 'DELETE_ON_COLLISION_WITH_MT'
                    if hasHit('Static',MT) || hasHit('MT',MT) % has the MT organelle or MT?
                        MT.Alive=false; % ensure that MTs that hit are annihilated
                    end
                case 'CROSSOVER_ON_COLLISION_WITH_MT'
                    if hasHit('Static',MT) 
                        MT.Alive=false; % ensure that MTs that hit are annihilated
                    end
                    if hasHit('MT',MT) % has the MT organelle or MT?
                        MT.Growing=true; % continue growing through the hit MT
                        MT.Hit= struct( 'hitmt', [], ...
                                'hitstatic', [], ...
                                'hitat', [], ...
                                'hitwhen', [] );
                    end
                case 'PAUSE_OR_CROSSOVER_ON_COLLISION_WITH_MT'
                    if hasHit('Static',MT) 
                        MT.Alive=false; % ensure that MTs that hit are annihilated
                    end
                    if hasHit('MT',MT) % has the MT organelle or MT?
                        if rand<(1-rate2prob(data,MT.Props.probPauseOnCollision)) %CHECK THIS PROBABILITY
                            MT.Growing=true; % restart after a collision with an MT
                            MT.IgnoreColliders = MT.Hit(end).hitmt;
                            MT.Hit= struct( 'hitmt', [], ...
                                'hitstatic', [], ...
                                'hitat', [], ...
                                'hitwhen', [] );
                        end
                    end
                otherwise
                    error('modelname not recognised')
            end
            %%
            % _Keep the following_
            % Clear flags from collision detector
            MT.BoundPLM=false;
            MT.BoundMic=false;
            MT.BoundVac=false;
            MT.BoundWll=false;
            data.working.dyn.microtubules.Org(i_MT)=MT;
        end
        %MTStats(data); % Plot distributions and other stats
        %%
    end

% put factors back into structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval(['data.factorprops.Concentration(:,i)=',[factname,'_p(:);']]);
    end    
%% 
%%
% _Parameters initialised when the project was first created._

end

% This space intentionally left blank.
% Default factor parameters
% Default organelle parameters

%      cell_wall.size          =0.000000
%      cell_wall.offset        =0.500000
%      cell_wall.micronthick   =0.100000
%      cell_wall.minvox        =1.000000
%      cell_wall.FaceColor     =[1.000000,0.000000,1.000000,]
%      cell_wall.FaceAlpha     =0.200000
%      cell_wall.Label         =-5.000000
%      cell_wall.isLayer       =1.000000
%      cell_wall.Static        =1.000000
%      cell_wall.InUse         =1.000000

%plasma_membrane.size          =0.000000
%plasma_membrane.offset        =0.500000
%plasma_membrane.micronthick   =0.010000
%plasma_membrane.minvox        =3.000000
%plasma_membrane.FaceColor     =[1.000000,1.000000,0.000000,]
%plasma_membrane.FaceAlpha     =0.200000
%plasma_membrane.Label         =-4.000000
%plasma_membrane.isLayer       =1.000000
%plasma_membrane.Static        =1.000000
%plasma_membrane.InUse         =1.000000

%      cytoplasm.size          =0.000000
%      cytoplasm.offset        =0.500000
%      cytoplasm.micronthick   =1.000000
%      cytoplasm.minvox        =3.000000
%      cytoplasm.FaceColor     =[0.000000,1.000000,0.000000,]
%      cytoplasm.FaceAlpha     =0.200000
%      cytoplasm.Label         =0.000000
%      cytoplasm.isLayer       =1.000000
%      cytoplasm.Static        =1.000000
%      cytoplasm.InUse         =1.000000

%   microtubules.thicknessMicrons=0.025000
%   microtubules.minvox        =0.025000
%   microtubules.growthrate    =0.500000
%   microtubules.shrinkrate    =0.000000
%   microtubules.shrinkheadrate=5.000000
%   microtubules.catastropherate=5.000000
%   microtubules.maxAlignToSurfAngle=40.000000
%   microtubules.maxZipToMTAngle=20.000000
%   microtubules.bendpriority  =[109.000000,101.000000,109.000000,98.000000,114.000000,97.000000,110.000000,101.000000,]
%   microtubules.maxSpawnAngle =40.000000
%   microtubules.maxAge        =0.000000
%   microtubules.nuclspont     =0.018000
%   microtubules.nuclonMT      =0.025000
%   microtubules.probCatastropheWhenHit=0.300000
%   microtubules.probPauseOnCollision=0.980000
%   microtubules.probSpontaneousCatastrophe=0.000000
%   microtubules.backwardBranching=0.000000
%   microtubules.parallelspawnprob=
%   microtubules.wraparound    =0.000000
%   microtubules.FaceColor     =[0.000000,0.000000,1.000000,]
%   microtubules.FaceAlpha     =0.400000
%   microtubules.Label         =-6.000000
%   microtubules.isLayer       =0.000000
%   microtubules.Static        =0.000000
%   microtubules.InUse         =1.000000

%        vacuole.size          =0.200000
%        vacuole.offset        =0.500000
%        vacuole.micronthick   =1.000000
%        vacuole.minvox        =0.000000
%        vacuole.FaceColor     =[1.000000,1.000000,0.000000,]
%        vacuole.FaceAlpha     =0.300000
%        vacuole.Label         =-3.000000
%        vacuole.isLayer       =0.000000
%        vacuole.Static        =1.000000
%        vacuole.InUse         =1.000000
% Default cell parameters
% cellprops.shape          ='Rect:1:0.5:0.0002'
% cellprops.sheetmodel     =1
% cellprops.secondsPerStep =1
% cellprops.maxLengthMicrons=20
% cellprops.widthMicrons   =10.212766
% cellprops.heightMicrons  =5.957447
% cellprops.micronsPerVoxelEdge=0.425532
% cellprops.cubicMicronsPerVoxel=0.077054
% cellprops.cellsize       =[47,24,14,]
% cellprops.sheetLevel     =7.500000
% cellprops.colourType     =1
% cellprops.Vol            =[-1,-1,-1,-1, ... ]
% cellprops.Smooth         ='None'
% cellprops.bound_distance =5
% cellprops.collide_distance=10
% cellprops.projectedCytAreaPixels=468
% cellprops.% cell_wall.EdgeVol=struct
% cell_wall.plotsurface=struct
% cell_wall.plotnormals=struct
% cellprops.% plasma_membrane.EdgeVol=struct
% plasma_membrane.plotsurface=struct
% plasma_membrane.plotnormals=struct
% cellprops.% cytoplasm.EdgeVol=struct
% cytoplasm.plotsurface=struct
% cytoplasm.plotnormals=struct
% cytoplasm.Indexes=struct
% cellprops.% vacuole.EdgeVol=struct
% vacuole.plotsurface=struct
% vacuole.plotnormals=struct
% cellprops.sheetPlaneNormal=[0,0,1,]
