function data = MT_FiniteResources_20121209( data, before )
    if nargin < 1, return; end
% 
% extract factors from structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval([[factname,'_p'],'=reshape(','data.factorprops.Concentration(:,i),[ data.cellprops.cellsize]);']);
        eval([[factname,'_i'],'=','data.factorprops.Name2Index.(factname);']);
    end
% insert model in here
%% To run on the cluster
% MTtboxCommandGrace('Name','MT_Paper1_20121121','N_steps',[500:500:2000],...
%       'ORTHO_TOP',1,'modelname',[1,2],'growth_rate',[1:7],'Rescue_rate',[1:4],'Use','Cluster');

%%Begin cluster run stuff
    if (~isfield(data,'noGui') || data.noGui == 0) || data.iterations<0
        rng('shuffle'); % to seed from the same number each time use 1234 instead of 'shuffle'
        
        data.userdata.ranges.modelname.range{1} = 'MODEL1'; %5
        data.userdata.ranges.modelname.range{2} = 'MODEL2'; %5
        data.userdata.ranges.modelname.index = 1;
    end
    % == Do not change the following
    fields=fieldnames(data.userdata.ranges);
    fprintf(1,'\n');
     titlestring=sprintf('%s -\n',data.projectname);
    for i=1:length(fields)
        fieldname=fields{i};
        eval(sprintf('%s=(data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index});',fieldname));
        if ischar(data.userdata.ranges.(fieldname).range{1})
            titlestring=[titlestring,' ',sprintf('%s: %s\n ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})];
        else
            titlestring=[titlestring,' ',sprintf('%s: %f\n ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})];
        end
    end
    fprintf(1,'%s\n',titlestring);
    if MT_haveGUI( data )
        singlestep=get(gcbo,'tag');
        if isfield(data,'view_steps') && rem(data.iterations,data.plotoptions.view_steps)==0 || strcmp(singlestep,'pushbutton_step')
            if isfield(data.plotprops,'TitleH') && ishandle( data.plotprops.TitleH)
                set(data.plotprops.TitleH,'String',titlestring,'Parent',data.plotprops.AxesH,'interpret','none');
            end
        end
    else % The following is for use on the cluster
        if rem(data.iterations,data.plotoptions.view_steps)==0 
            set(data.plotprops.TitleH,'String',titlestring,'Parent',data.plotprops.AxesH,'interpret','none');
        end
    end
    % == End of do not change
    verbose=1;
    nextstepAllMTlength=0;
    if data.iterations==0
        %% 
        %%
        %SET time per step
        %data.cellprops.secondsPerStep=7.5; % frame rate in experimental data
        % set default parameters
        data=mtSETMTprops(data,...
            'thicknessMicrons', 0.0250,...
            'minvox',0.0250,...
            'growthrate',0.500,...
            'shrinkrate',0,...
            'shrinkheadrate',5,...
            'catastropherate',5,...
            'maxAlignToSurfAngle',40,...
            'maxZipToMTAngle',20,...
            'bendpriority','membrane',...
            'maxSpawnAngle',40,...
            'maxAge',0,...
            'nuclspont',0.0180,...
            'nuclonMT',0.0150,...
            'probCatastropheWhenHit',0.0200,...
            'probPauseOnCollision',0.8000,...
            'probSpontaneousCatastrophe',0,...
            'backwardBranching',0,...
            'parallelspawnprob',[],...
            'wraparound',0,...
            'FaceColor',[0 0 1],...
            'FaceAlpha',0.4000,...
            'Label',-6,...
            'isLayer',0,...
            'Static',0,...
            'InUse',1     );
        % modify parameters according to the model
        %Change MT properties (from those shown at the bottom of the file)
        %(For a full list of properties click on help for this function.)
        data=mtSETMTprops(data,...
            'growthrate',0.5,...
            'shrinkrate',0.05,... 0.005,... %3,...
            'maxAlignToSurfAngle',0,...
            'parallelspawnprob',0.5);
        %
        % Allard et al parameters for 21 degree wildtype
        data.userdata.fgp=0.2/60;
        data.userdata.fgs=0.17/60;
        data.userdata.fpg=2.01/60;
        data.userdata.fps=1.02/60;
        data.userdata.fsg=1.0/60;
        data.userdata.fsp=0.31/60;

        data.userdata.volume=data.cellprops.widthMicrons*...
            data.cellprops.maxLengthMicrons*...
            data.cellprops.heightMicrons*10^-(5*3);

        data.userdata.StartingNumberBranchMols=50;
        data.userdata.StartingNumbertubulinMols=1000;
        data.userdata.MolsPerMicron=10;

        data.userdata.numberBranchMols=data.userdata.StartingNumberBranchMols;
        data.userdata.numberTubulinMols=data.userdata.StartingNumbertubulinMols;
        switch modelname
            case 'MODEL1'
            case 'MODEL2'
        end
        MTlength=0;
        totalAllMTlengths=0;
        totalTubulin=totalAllMTlengths*data.organelleprops.microtubules.growthrate+data.userdata.numberTubulinMols;
        totalBranch=data.userdata.numberBranchMols+size(data.working.dyn.microtubules.Org,1);
        delete(findobj(data.plotprops.AxesH,'tag','branch'));
        delete(findobj(data.plotprops.AxesH,'tag','tubulin'));
        delete(findobj(data.plotprops.AxesH,'tag','Start'));
        hold(data.plotprops.AxesH,'on')
        plot(0,2*totalBranch*10/data.userdata.StartingNumberBranchMols,'dm','tag','Start','parent',data.plotprops.AxesH);
        plot(2,2*totalTubulin*10/data.userdata.StartingNumbertubulinMols,'db','tag','Start','parent',data.plotprops.AxesH);
    else
%         data=mtSETMTprops(data,...
%             'growthrate',0.5,...
%             'shrinkrate',0.05,... 0.005,... %3,...
%             'nuclonMT',00150,...
%             'maxAlignToSurfAngle',0,...
%             'parallelspawnprob',0.5);
        %% 
        %%
        totalAllMTlengths=0;
        nextstepAllMTlength=0;
        for i_MT=1:length(data.working.dyn.microtubules.Org)
            MT=data.working.dyn.microtubules.Org(i_MT);
            % Because we approximate shrinkage (catastrophe) by deleting the MT there are only three
            % options at this point: to be deleted, growing and paused
            % Growth logic
            if MT.Growing % is growing and could either be deleted or pause
                R=rand;
                if R<rate2prob(data,data.userdata.fgs) % approximation to catastrophic shrink rate
                    MT.Alive=false; % delete
                elseif R<(rate2prob(data,data.userdata.fgs)+rate2prob(data,data.userdata.fgp)) % pause
                    MT.Growing=false; % pause
                end
            else % is not growing and could either be deleted or continue growing across whatever
                R=rand;
                if R<rate2prob(data,data.userdata.fps) % approximation to catastrophic shrink rate
                    MT.Alive=false; % delete
                elseif R<(rate2prob(data,data.userdata.fpg)+rate2prob(data,data.userdata.fps)) % or start growing
                    %MT.Growing=true;% continue growing
                end
            end
            if hasHit('Static',MT)
                MT.Growing=false; % will only be deleted when shrinking catches up or above condition is met
            end
            
%             % Debug
%             if MT.Alive  % clear all consumption of materials
%                 MT.Alive=false;
%                 MT.Growing=false;
%             end

          
            % update the molecule amounts depending on the logical state of...
            % NewMT, MT.Alive, MT.Growing, MT.Shrinking, 
            % MTlength,
            % data.userdata.numberTubulinMols
            % data.userdata.numberBranchMols
            % MT.Props.growthrate
            % MT.Props.shrinkrat
            % data.cellprops.secondsPerStep
            % data.userdata.MolsPerMicron
            %AvailableTubulin=data.userdata.numberTubulinMols;
            %AvailableBranch=data.userdata.numberBranchMols;
            [MT,data.userdata.numberTubulinMols,data.userdata.numberBranchMols,totalAllMTlengths,nextstepAllMTlength]=ConsumeReleaseMols(...
                data,MT,...
                data.userdata.numberTubulinMols,data.userdata.numberBranchMols,...
                totalAllMTlengths,nextstepAllMTlength);

            
            % report current state of free branch and tubulin molecules
            concTubulin=data.userdata.numberTubulinMols...
                /length(data.cellprops.cytoplasm.Indexes);
            concBranch=data.userdata.numberBranchMols...
                /length(data.cellprops.cytoplasm.Indexes);
            s_tubulin_p(data.cellprops.cytoplasm.Indexes)=concTubulin;
            s_branch_p(data.cellprops.cytoplasm.Indexes)=concBranch;
            if verbose
                delete(findobj(data.plotprops.AxesH,'tag','branch'));
                delete(findobj(data.plotprops.AxesH,'tag','tubulin'));
                plot([0,0],[0,2* data.userdata.numberBranchMols*10/data.userdata.StartingNumberBranchMols],...
                    '-m','linewidth',10,'tag','branch','parent',data.plotprops.AxesH);
                plot([2,2],[0,2* data.userdata.numberTubulinMols*10/data.userdata.StartingNumbertubulinMols],...
                    '-b','linewidth',10,'tag','tubulin','parent',data.plotprops.AxesH);
            end
            % _Keep the following_
            % Clear flags from collision detector
            MT.BoundPLM=false;
            MT.BoundMic=false;
            MT.BoundVac=false;
            MT.BoundWll=false;
            data.working.dyn.microtubules.Org(i_MT)=MT;
        end
        %MTStats(data); % Plot distributions and other stats
        %%
    end
    if verbose
        if isfield(data,'userdata') && isfield(data.userdata,'numberTubulinMols')
            totalTubulin=(totalAllMTlengths+nextstepAllMTlength)...% added the the step that is about to be made
                *data.cellprops.secondsPerStep...
                *data.userdata.MolsPerMicron...
                +data.userdata.numberTubulinMols;
            totalBranch=data.userdata.numberBranchMols+length(data.working.dyn.microtubules.Org);
            plot(0,2*totalBranch*10/data.userdata.StartingNumberBranchMols,'*r','tag','branch','parent',data.plotprops.AxesH);
            plot(2,2*totalTubulin*10/data.userdata.StartingNumbertubulinMols,'*k','tag','tubulin','parent',data.plotprops.AxesH);
            plot(0,20,'dm','tag','branch','parent',data.plotprops.AxesH);
            plot(2,20,'db','tag','tubulin','parent',data.plotprops.AxesH);
        end
    end
% put factors back into structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval(['data.factorprops.Concentration(:,i)=',[factname,'_p(:);']]);
    end    
%% 
%%
% _Parameters initialised when the project was first created._

end

% This space intentionally left blank.
% Default factor parameters
% Default organelle parameters

%      cell_wall.size          =0.000000
%      cell_wall.offset        =0.500000
%      cell_wall.micronthick   =0.100000
%      cell_wall.minvox        =1.000000
%      cell_wall.FaceColor     =[1.000000,0.000000,1.000000,]
%      cell_wall.FaceAlpha     =0.200000
%      cell_wall.Label         =-5.000000
%      cell_wall.isLayer       =1.000000
%      cell_wall.Static        =1.000000
%      cell_wall.InUse         =1.000000

%plasma_membrane.size          =0.000000
%plasma_membrane.offset        =0.500000
%plasma_membrane.micronthick   =0.010000
%plasma_membrane.minvox        =3.000000
%plasma_membrane.FaceColor     =[1.000000,1.000000,0.000000,]
%plasma_membrane.FaceAlpha     =0.200000
%plasma_membrane.Label         =-4.000000
%plasma_membrane.isLayer       =1.000000
%plasma_membrane.Static        =1.000000
%plasma_membrane.InUse         =1.000000

%      cytoplasm.size          =0.000000
%      cytoplasm.offset        =0.500000
%      cytoplasm.micronthick   =1.000000
%      cytoplasm.minvox        =3.000000
%      cytoplasm.FaceColor     =[0.000000,1.000000,0.000000,]
%      cytoplasm.FaceAlpha     =0.200000
%      cytoplasm.Label         =0.000000
%      cytoplasm.isLayer       =1.000000
%      cytoplasm.Static        =1.000000
%      cytoplasm.InUse         =1.000000

%   microtubules.thicknessMicrons=0.025000
%   microtubules.minvox        =0.025000
%   microtubules.growthrate    =0.500000
%   microtubules.shrinkrate    =0.000000
%   microtubules.shrinkheadrate=5.000000
%   microtubules.catastropherate=5.000000
%   microtubules.maxAlignToSurfAngle=40.000000
%   microtubules.maxZipToMTAngle=20.000000
%   microtubules.bendpriority  =[109.000000,101.000000,109.000000,98.000000,114.000000,97.000000,110.000000,101.000000,]
%   microtubules.maxSpawnAngle =40.000000
%   microtubules.maxAge        =0.000000
%   microtubules.nuclspont     =0.018000
%   microtubules.nuclonMT      =0.025000
%   microtubules.probCatastropheWhenHit=0.300000
%   microtubules.probPauseOnCollision=0.980000
%   microtubules.probSpontaneousCatastrophe=0.000000
%   microtubules.backwardBranching=0.000000
%   microtubules.parallelspawnprob=
%   microtubules.wraparound    =0.000000
%   microtubules.FaceColor     =[0.000000,0.000000,1.000000,]
%   microtubules.FaceAlpha     =0.400000
%   microtubules.Label         =-6.000000
%   microtubules.isLayer       =0.000000
%   microtubules.Static        =0.000000
%   microtubules.InUse         =1.000000

%        vacuole.size          =0.200000
%        vacuole.offset        =0.500000
%        vacuole.micronthick   =1.000000
%        vacuole.minvox        =0.000000
%        vacuole.FaceColor     =[1.000000,1.000000,0.000000,]
%        vacuole.FaceAlpha     =0.300000
%        vacuole.Label         =-3.000000
%        vacuole.isLayer       =0.000000
%        vacuole.Static        =1.000000
%        vacuole.InUse         =1.000000
% Default cell parameters
% cellprops.shape          ='Rect:1:0.5:0.0002'
% cellprops.sheetmodel     =1
% cellprops.sheetPlaneNormal=[0,0,1,]
% cellprops.secondsPerStep =1
% cellprops.maxLengthMicrons=20
% cellprops.widthMicrons   =10.212766
% cellprops.heightMicrons  =5.957447
% cellprops.micronsPerVoxelEdge=0.425532
% cellprops.cubicMicronsPerVoxel=0.077054
% cellprops.cellsize       =[47,24,14,]
% cellprops.sheetLevel     =8
% cellprops.colourType     =1
% cellprops.Vol            =[-1,-1,-1,-1, ... ]
% cellprops.Smooth         ='None'
% cellprops.bound_distance =5
% cellprops.collide_distance=10
% cellprops.projectedCytAreaPixels=468
% cellprops.% cell_wall.EdgeVol=struct
% cell_wall.plotsurface=struct
% cell_wall.plotnormals=struct
% cellprops.% plasma_membrane.EdgeVol=struct
% plasma_membrane.plotsurface=struct
% plasma_membrane.plotnormals=struct
% cellprops.% cytoplasm.EdgeVol=struct
% cytoplasm.plotsurface=struct
% cytoplasm.plotnormals=struct
% cytoplasm.Indexes=struct
% cellprops.% vacuole.EdgeVol=struct
% vacuole.plotsurface=struct
% vacuole.plotnormals=struct
