/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.ConnectionI;
import Ice.ContextHelper;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.ImplicitContextI;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownReplyStatusException;
import Ice.UnknownUserException;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.LocalExceptionWrapper;
import IceInternal.OutgoingMessageCallback;
import IceInternal.Protocol;
import IceInternal.RequestHandler;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Outgoing
implements OutgoingMessageCallback {
    private RequestHandler _handler;
    private BasicStream _is;
    private BasicStream _os;
    private boolean _sent = false;
    private LocalException _exception;
    private static final int StateUnsent = 0;
    private static final int StateInProgress = 1;
    private static final int StateOK = 2;
    private static final int StateUserException = 3;
    private static final int StateLocalException = 4;
    private static final int StateFailed = 5;
    private int _state = 0;
    public Outgoing next;

    public Outgoing(RequestHandler handler, String operation, OperationMode mode, Map<String, String> context) throws LocalExceptionWrapper {
        this._handler = handler;
        Instance instance = this._handler.getReference().getInstance();
        this._is = new BasicStream(instance);
        this._os = new BasicStream(instance);
        this.writeHeader(operation, mode, context);
    }

    public void reset(RequestHandler handler, String operation, OperationMode mode, Map<String, String> context) throws LocalExceptionWrapper {
        this._state = 0;
        this._exception = null;
        this._sent = false;
        this._handler = handler;
        this.writeHeader(operation, mode, context);
    }

    public void reclaim() {
        this._is.reset();
        this._os.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke() throws LocalExceptionWrapper {
        assert (this._state == 0);
        this._os.endWriteEncaps();
        switch (this._handler.getReference().getMode()) {
            case 0: {
                this._state = 1;
                ConnectionI connection = this._handler.sendRequest(this);
                assert (connection != null);
                boolean timedOut = false;
                Outgoing outgoing = this;
                synchronized (outgoing) {
                    while (this._state != 5 && !this._sent) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                    int timeout = connection.timeout();
                    while (this._state == 1 && !timedOut) {
                        try {
                            if (timeout >= 0) {
                                this.wait(timeout);
                                if (this._state != 1) continue;
                                timedOut = true;
                                continue;
                            }
                            this.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (timedOut) {
                    connection.exception(new TimeoutException());
                    outgoing = this;
                    synchronized (outgoing) {
                        while (this._state == 1) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ex) {}
                        }
                    }
                }
                if (this._exception != null) {
                    this._exception.fillInStackTrace();
                    if (!this._sent || this._exception instanceof CloseConnectionException || this._exception instanceof ObjectNotExistException) {
                        throw this._exception;
                    }
                    throw new LocalExceptionWrapper(this._exception, false);
                }
                if (this._state == 3) {
                    return false;
                }
                assert (this._state == 2);
                return true;
            }
            case 1: 
            case 3: {
                this._state = 1;
                if (this._handler.sendRequest(this) != null) {
                    Outgoing outgoing = this;
                    synchronized (outgoing) {
                        while (this._state != 5 && !this._sent) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this._exception != null) {
                            assert (!this._sent);
                            throw this._exception;
                        }
                    }
                }
                return true;
            }
            case 2: 
            case 4: {
                this._state = 1;
                this._handler.finishBatchRequest(this._os);
                return true;
            }
        }
        assert (false);
        return false;
    }

    public void abort(LocalException ex) throws LocalExceptionWrapper {
        assert (this._state == 0);
        int mode = this._handler.getReference().getMode();
        if (mode == 2 || mode == 4) {
            this._handler.abortBatchRequest();
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sent(boolean async) {
        if (async) {
            Outgoing outgoing = this;
            synchronized (outgoing) {
                this._sent = true;
                this.notify();
            }
        } else {
            this._sent = true;
        }
    }

    public synchronized void finished(BasicStream is) {
        assert (this._handler.getReference().getMode() == 0);
        assert (this._state <= 1);
        this._is.swap(is);
        byte replyStatus = this._is.readByte();
        switch (replyStatus) {
            case 0: {
                this._state = 2;
                break;
            }
            case 1: {
                this._state = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                RequestFailedException ex = null;
                switch (replyStatus) {
                    case 2: {
                        ex = new ObjectNotExistException();
                        break;
                    }
                    case 3: {
                        ex = new FacetNotExistException();
                        break;
                    }
                    case 4: {
                        ex = new OperationNotExistException();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                ex.id = new Identity();
                ex.id.__read(this._is);
                String[] facetPath = this._is.readStringSeq();
                if (facetPath.length > 0) {
                    if (facetPath.length > 1) {
                        throw new MarshalException();
                    }
                    ex.facet = facetPath[0];
                } else {
                    ex.facet = "";
                }
                ex.operation = this._is.readString();
                this._exception = ex;
                this._state = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                UnknownException ex = null;
                switch (replyStatus) {
                    case 7: {
                        ex = new UnknownException();
                        break;
                    }
                    case 5: {
                        ex = new UnknownLocalException();
                        break;
                    }
                    case 6: {
                        ex = new UnknownUserException();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                ex.unknown = this._is.readString();
                this._exception = ex;
                this._state = 4;
                break;
            }
            default: {
                this._exception = new UnknownReplyStatusException();
                this._state = 4;
            }
        }
        this.notify();
    }

    @Override
    public synchronized void finished(LocalException ex) {
        assert (this._state <= 1);
        this._state = 5;
        this._exception = ex;
        this.notify();
    }

    public BasicStream is() {
        return this._is;
    }

    public BasicStream os() {
        return this._os;
    }

    public void throwUserException() throws UserException {
        try {
            this._is.startReadEncaps();
            this._is.throwException();
        }
        catch (UserException ex) {
            this._is.endReadEncaps();
            throw ex;
        }
    }

    private void writeHeader(String operation, OperationMode mode, Map<String, String> context) throws LocalExceptionWrapper {
        switch (this._handler.getReference().getMode()) {
            case 0: 
            case 1: 
            case 3: {
                this._os.writeBlob(Protocol.requestHdr);
                break;
            }
            case 2: 
            case 4: {
                this._handler.prepareBatchRequest(this._os);
            }
        }
        try {
            this._handler.getReference().getIdentity().__write(this._os);
            String facet = this._handler.getReference().getFacet();
            if (facet == null || facet.length() == 0) {
                this._os.writeStringSeq(null);
            } else {
                String[] facetPath = new String[]{facet};
                this._os.writeStringSeq(facetPath);
            }
            this._os.writeString(operation);
            this._os.writeByte((byte)mode.value());
            if (context != null) {
                ContextHelper.write(this._os, context);
            } else {
                ImplicitContextI implicitContext = this._handler.getReference().getInstance().getImplicitContext();
                Map<String, String> prxContext = this._handler.getReference().getContext();
                if (implicitContext == null) {
                    ContextHelper.write(this._os, prxContext);
                } else {
                    implicitContext.write(prxContext, this._os);
                }
            }
            this._os.startWriteEncaps();
        }
        catch (LocalException ex) {
            this.abort(ex);
        }
    }
}

