/*
 * Decompiled with CFR 0.152.
 */
package omero;

import Ice.Communicator;
import Ice.Current;
import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.ApiUsageException;
import omero.ClientError;
import omero.Internal;
import omero.RArray;
import omero.RBool;
import omero.RClass;
import omero.RDouble;
import omero.RFloat;
import omero.RInt;
import omero.RInternal;
import omero.RList;
import omero.RLong;
import omero.RMap;
import omero.RObject;
import omero.RSet;
import omero.RString;
import omero.RTime;
import omero.RType;
import omero.model.IObject;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class rtypes {
    private static final RBool rtrue = new RBoolI(true);
    private static final RBool rfalse = new RBoolI(false);
    private static final RLong rlong0 = new RLongI(0L);
    private static final RInt rint0 = new RIntI(0);
    private static final RString remptystr = new RStringI("");
    private static final RClass remptyclass = new RClassI("");
    private static final RInternal rnullinternal = new RInternalI(null);
    private static final RObject rnullobject = new RObjectI(null);
    public static final Map<Class, ObjectFactory> ObjectFactories;

    public static RType rtype(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof RType) {
            return (RType)obj;
        }
        if (obj instanceof Boolean) {
            return rtypes.rbool((Boolean)obj);
        }
        if (obj instanceof Double) {
            return rtypes.rdouble((Double)obj);
        }
        if (obj instanceof Float) {
            return rtypes.rfloat(((Float)obj).floatValue());
        }
        if (obj instanceof Long) {
            return rtypes.rlong((Long)obj);
        }
        if (obj instanceof Integer) {
            return rtypes.rint((Integer)obj);
        }
        if (obj instanceof String) {
            return rtypes.rstring((String)obj);
        }
        if (obj instanceof IObject) {
            return rtypes.robject((IObject)obj);
        }
        if (obj instanceof Internal) {
            return rtypes.rinternal((Internal)obj);
        }
        if (obj instanceof Date) {
            return rtypes.rtime(((Date)obj).getTime());
        }
        if (obj instanceof List) {
            return rtypes.rlist((List)obj);
        }
        if (obj instanceof Set) {
            return rtypes.rset((Set)obj);
        }
        if (obj instanceof Map) {
            return rtypes.rmap((Map)obj);
        }
        throw new ClientError("Cannot handle conversion from: " + obj.getClass());
    }

    public static RBool rbool(boolean val) {
        return val ? rtrue : rfalse;
    }

    public static RDouble rdouble(double val) {
        return new RDoubleI(val);
    }

    public static RFloat rfloat(float val) {
        return new RFloatI(val);
    }

    public static RInt rint(int val) {
        if (val == 0) {
            return rint0;
        }
        return new RIntI(val);
    }

    public static RLong rlong(long val) {
        if (val == 0L) {
            return rlong0;
        }
        return new RLongI(val);
    }

    public static RTime rtime(long val) {
        return new RTimeI(val);
    }

    public static RTime rtime(Date date) {
        return date == null ? null : new RTimeI(date.getTime());
    }

    public static RTime rtime_min() {
        String tstr = "0001-01-01 00:00:00";
        return rtypes.rtime_str(tstr);
    }

    public static RTime rtime_max() {
        String tstr = "9999-12-31 23:59:59";
        return rtypes.rtime_str(tstr);
    }

    public static RTime rtime_str(String tstr) {
        Timestamp t = Timestamp.valueOf(tstr);
        return rtypes.rtime(t.getTime());
    }

    public static RInternal rinternal(Internal val) {
        if (val == null) {
            return rnullinternal;
        }
        return new RInternalI(val);
    }

    public static RObject robject(IObject val) {
        if (val == null) {
            return rnullobject;
        }
        return new RObjectI(val);
    }

    public static RClass rclass(String val) {
        if (val == null || val.length() == 0) {
            return remptyclass;
        }
        return new RClassI(val);
    }

    public static RString rstring(String val) {
        if (val == null || val.length() == 0) {
            return remptystr;
        }
        return new RStringI(val);
    }

    public static RArray rarray(RType ... val) {
        return new RArrayI(val);
    }

    public static RArray rarray(Collection<RType> val) {
        return new RArrayI(val);
    }

    public static RList rlist(RType ... val) {
        return new RListI(val);
    }

    public static RList rlist(Collection<RType> val) {
        return new RListI(val);
    }

    public static RSet rset(RType ... val) {
        return new RSetI(val);
    }

    public static RSet rset(Collection<RType> val) {
        return new RSetI(val);
    }

    public static RMap rmap() {
        return new RMapI(null);
    }

    public static RMap rmap(Map<String, RType> val) {
        return new RMapI(val);
    }

    public static RMap rmap(String key, RType val) {
        RMap map = rtypes.rmap(null);
        map.put(key, val);
        return map;
    }

    static {
        HashMap<Class, ObjectFactory> factories = new HashMap<Class, ObjectFactory>();
        factories.put(RBool.class, new ObjectFactory(RBool.ice_staticId()){

            public RType rtype() {
                return new RBoolI(false);
            }
        });
        factories.put(RDouble.class, new ObjectFactory(RDouble.ice_staticId()){

            public RType rtype() {
                return new RDoubleI(0.0);
            }
        });
        factories.put(RFloat.class, new ObjectFactory(RFloat.ice_staticId()){

            public RType rtype() {
                return new RFloatI(0.0f);
            }
        });
        factories.put(RInt.class, new ObjectFactory(RInt.ice_staticId()){

            public RType rtype() {
                return new RIntI(0);
            }
        });
        factories.put(RLong.class, new ObjectFactory(RLong.ice_staticId()){

            public RType rtype() {
                return new RLongI(0L);
            }
        });
        factories.put(RTime.class, new ObjectFactory(RTime.ice_staticId()){

            public RType rtype() {
                return new RTimeI(0L);
            }
        });
        factories.put(RClass.class, new ObjectFactory(RClass.ice_staticId()){

            public RType rtype() {
                return new RClassI("");
            }
        });
        factories.put(RString.class, new ObjectFactory(RString.ice_staticId()){

            public RType rtype() {
                return new RStringI("");
            }
        });
        factories.put(RInternal.class, new ObjectFactory(RInternal.ice_staticId()){

            public RType rtype() {
                return new RInternalI(null);
            }
        });
        factories.put(RObject.class, new ObjectFactory(RObjectI.ice_staticId()){

            public RType rtype() {
                return new RObjectI(null);
            }
        });
        factories.put(RArray.class, new ObjectFactory(RArray.ice_staticId()){

            public RType rtype() {
                return new RArrayI(new RType[0]);
            }
        });
        factories.put(RList.class, new ObjectFactory(RList.ice_staticId()){

            public RType rtype() {
                return new RListI(new RType[0]);
            }
        });
        factories.put(RSet.class, new ObjectFactory(RSet.ice_staticId()){

            public RType rtype() {
                return new RSetI(new RType[0]);
            }
        });
        factories.put(RMap.class, new ObjectFactory(RMap.ice_staticId()){

            public RType rtype() {
                return new RMapI(null);
            }
        });
        ObjectFactories = factories;
    }

    public static abstract class ObjectFactory
    implements Ice.ObjectFactory {
        private final String id;

        public ObjectFactory(String id) {
            this.id = id;
        }

        public abstract RType rtype();

        public void register(Communicator ic) {
            ic.addObjectFactory(this, this.id);
        }

        public Ice.Object create(String arg0) {
            return this.rtype();
        }

        public void destroy() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Conversion {
        public Class<?> type();

        public Object convert(IceMapper var1) throws ApiUsageException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RMapI
    extends RMap
    implements Conversion {
        private RMapI(Map<String, RType> arg) {
            this.val = arg == null || arg.size() == 0 ? new HashMap() : new HashMap<String, RType>(arg);
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Map.class;
        }

        @Override
        public Object convert(IceMapper mapper) throws ApiUsageException {
            return mapper.reverse(this.val);
        }

        @Override
        public Map<String, RType> getValue(Current __current) {
            return this.val;
        }

        @Override
        public RType get(String key, Current __current) {
            return (RType)this.val.get(key);
        }

        @Override
        public void put(String key, RType value, Current __current) {
            this.val.put(key, value);
        }

        @Override
        public int size(Current __current) {
            return this.val.size();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RMap)) {
                return false;
            }
            RMap rval = (RMap)obj;
            return this.val == rval.val || this.val != null && ((Object)this.val).equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : ((Object)this.val).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RSetI
    extends RSet
    implements Conversion {
        private RSetI(RType ... arg) {
            this.val = arg == null || arg.length == 0 ? new ArrayList() : Arrays.asList(arg);
        }

        private RSetI(Collection<RType> arg) {
            this.val = arg == null || arg.size() == 0 ? new ArrayList() : new ArrayList<RType>(arg);
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Set.class;
        }

        @Override
        public Object convert(IceMapper mapper) throws ApiUsageException {
            return mapper.reverse(this.val, Set.class);
        }

        @Override
        public List<RType> getValue(Current __current) {
            return this.val;
        }

        @Override
        public RType get(int index, Current current) {
            return (RType)this.val.get(index);
        }

        @Override
        public int size(Current current) {
            return this.val.size();
        }

        @Override
        public void add(RType value, Current current) {
            this.val.add(value);
        }

        @Override
        public void addAll(List<RType> value, Current current) {
            this.val.addAll(value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RSet)) {
                return false;
            }
            RSet rval = (RSet)obj;
            return this.val == rval.val || this.val != null && ((Object)this.val).equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : ((Object)this.val).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RListI
    extends RList
    implements Conversion {
        private RListI(RType ... arg) {
            this.val = arg == null || arg.length == 0 ? new ArrayList() : Arrays.asList(arg);
        }

        private RListI(Collection<RType> arg) {
            this.val = arg == null || arg.size() == 0 ? new ArrayList() : new ArrayList<RType>(arg);
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return List.class;
        }

        @Override
        public Object convert(IceMapper mapper) throws ApiUsageException {
            return mapper.reverse(this.val, List.class);
        }

        @Override
        public List<RType> getValue(Current __current) {
            return this.val;
        }

        @Override
        public RType get(int index, Current current) {
            return (RType)this.val.get(index);
        }

        @Override
        public int size(Current current) {
            return this.val.size();
        }

        @Override
        public void add(RType value, Current current) {
            this.val.add(value);
        }

        @Override
        public void addAll(List<RType> value, Current current) {
            this.val.addAll(value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RList)) {
                return false;
            }
            RList rval = (RList)obj;
            return this.val == rval.val || this.val != null && ((Object)this.val).equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : ((Object)this.val).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RArrayI
    extends RArray
    implements Conversion {
        private RArrayI(RType ... arg) {
            this.val = arg == null || arg.length == 0 ? new ArrayList() : Arrays.asList(arg);
        }

        private RArrayI(Collection<RType> arg) {
            this.val = arg == null || arg.size() == 0 ? new ArrayList() : new ArrayList<RType>(arg);
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return RType[].class;
        }

        @Override
        public Object convert(IceMapper mapper) throws ApiUsageException {
            Collection reversed = mapper.reverse(this.val);
            RType first = (RType)this.val.get(0);
            if (first instanceof Conversion) {
                Conversion conv = (Conversion)((Object)first);
                Class<?> k = conv.type();
                Object[] rv = Array.newInstance(k, this.val.size());
                rv = reversed.toArray((Object[])rv);
                return rv;
            }
            throw new ApiUsageException(null, null, "First argument not convertible");
        }

        @Override
        public List<RType> getValue(Current __current) {
            return this.val;
        }

        @Override
        public RType get(int index, Current current) {
            return (RType)this.val.get(index);
        }

        @Override
        public int size(Current current) {
            return this.val.size();
        }

        @Override
        public void add(RType value, Current current) {
            this.val.add(value);
        }

        @Override
        public void addAll(List<RType> value, Current current) {
            this.val.addAll(value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RArray) {
                return false;
            }
            RArray rval = (RArray)obj;
            return this.val == rval.val || this.val != null && ((Object)this.val).equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : ((Object)this.val).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RClassI
    extends RClass
    implements Conversion {
        private RClassI(String value) {
            super(value);
        }

        @Override
        public String getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Class.class;
        }

        @Override
        public Object convert(IceMapper mapper) throws ApiUsageException {
            return IceMapper.omeroClass(this.val, true);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RClass)) {
                return false;
            }
            RClass rval = (RClass)obj;
            return this.val == rval.val || this.val != null && this.val.equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : this.val.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RStringI
    extends RString
    implements Conversion {
        private RStringI(String value) {
            super(value);
        }

        @Override
        public String getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return String.class;
        }

        @Override
        public Object convert(IceMapper mapper) throws ApiUsageException {
            return this.val;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RString)) {
                return false;
            }
            RString rval = (RString)obj;
            return this.val == rval.val || this.val != null && this.val.equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : this.val.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RObjectI
    extends RObject
    implements Conversion {
        private RObjectI(IObject value) {
            super(value);
        }

        @Override
        public IObject getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return IObject.class;
        }

        @Override
        public Object convert(IceMapper mapper) throws ApiUsageException {
            return mapper.reverse(this.val);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RObject)) {
                return false;
            }
            RObject rval = (RObject)obj;
            return this.val == rval.val || this.val != null && this.val.equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : this.val.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RInternalI
    extends RInternal
    implements Conversion {
        private RInternalI(Internal value) {
            super(value);
        }

        @Override
        public Internal getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return RInternal.class;
        }

        @Override
        public Object convert(IceMapper mapper) {
            return this;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RInternal)) {
                return false;
            }
            RInternal rval = (RInternal)obj;
            return this.val == rval.val || this.val != null && this.val.equals(rval.val);
        }

        public int hashCode() {
            return this.val == null ? 0 : this.val.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RTimeI
    extends RTime
    implements Conversion {
        private RTimeI(long value) {
            super(value);
        }

        @Override
        public long getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Timestamp.class;
        }

        @Override
        public Object convert(IceMapper mapper) {
            return IceMapper.convert(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RTime)) {
                return false;
            }
            RTime rval = (RTime)obj;
            return rval.val == this.val;
        }

        public int hashCode() {
            return (int)(this.val ^ this.val >>> 32);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RLongI
    extends RLong
    implements Conversion {
        private RLongI(long value) {
            super(value);
        }

        @Override
        public long getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Long.class;
        }

        @Override
        public Object convert(IceMapper mapper) {
            return this.val;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RLong)) {
                return false;
            }
            RLong rval = (RLong)obj;
            return rval.val == this.val;
        }

        public int hashCode() {
            return (int)(this.val ^ this.val >>> 32);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RIntI
    extends RInt
    implements Conversion {
        private RIntI(int value) {
            super(value);
        }

        @Override
        public int getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Integer.class;
        }

        @Override
        public Object convert(IceMapper mapper) {
            return this.val;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RInt)) {
                return false;
            }
            RInt rval = (RInt)obj;
            return rval.val == this.val;
        }

        public int hashCode() {
            return this.val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RFloatI
    extends RFloat
    implements Conversion {
        private RFloatI(float value) {
            super(value);
        }

        @Override
        public float getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Float.class;
        }

        @Override
        public Object convert(IceMapper mapper) {
            return Float.valueOf(this.val);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RFloat)) {
                return false;
            }
            RFloat rval = (RFloat)obj;
            return Float.compare(rval.val, this.val) == 0;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RDoubleI
    extends RDouble
    implements Conversion {
        private RDoubleI(double value) {
            super(value);
        }

        @Override
        public double getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Double.class;
        }

        @Override
        public Object convert(IceMapper mapper) {
            return this.val;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RDouble)) {
                return false;
            }
            RDouble rval = (RDouble)obj;
            return Double.compare(rval.val, this.val) == 0;
        }

        public int hashCode() {
            long f = Double.doubleToLongBits(this.val);
            return (int)(f ^ f >>> 32);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RBoolI
    extends RBool
    implements Conversion {
        private RBoolI(boolean value) {
            super(value);
        }

        @Override
        public boolean getValue(Current __current) {
            return this.val;
        }

        @Override
        public int compare(RType rhs, Current current) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> type() {
            return Boolean.class;
        }

        @Override
        public Object convert(IceMapper mapper) {
            return this.val;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RBool)) {
                return false;
            }
            RBool rval = (RBool)obj;
            return rval.val == this.val;
        }

        public int hashCode() {
            return this.val ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
        }
    }
}

