/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import omero.RString;
import omero.model.Polygon;
import omero.model.PolygonI;
import omero.model.Shape;
import omero.rtypes;
import pojos.ShapeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonData
extends ShapeData {
    public PolygonData(Shape shape) {
        super(shape);
    }

    public PolygonData() {
        this(new ArrayList<Point2D.Double>(), new ArrayList<Point2D.Double>(), new ArrayList<Point2D.Double>(), new ArrayList<Integer>());
    }

    public PolygonData(List<Point2D.Double> points, List<Point2D.Double> points1, List<Point2D.Double> points2, List<Integer> maskList) {
        super(new PolygonI(), true);
        this.setPoints(points, points1, points2, maskList);
    }

    public String getText() {
        Polygon shape = (Polygon)this.asIObject();
        RString value = shape.getTextValue();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setText(String text) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Polygon shape = (Polygon)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTextValue(rtypes.rstring(text));
    }

    public List<Point2D.Double> getPoints() {
        String pts = this.fromPoints("points");
        return this.parsePointsToPoint2DList(pts);
    }

    public List<Point2D.Double> getPoints1() {
        String pts = this.fromPoints("points1");
        return this.parsePointsToPoint2DList(pts);
    }

    public List<Point2D.Double> getPoints2() {
        String pts = this.fromPoints("points2");
        return this.parsePointsToPoint2DList(pts);
    }

    public List<Integer> getMaskPoints() {
        String pts = this.fromPoints("mask");
        return this.parsePointsToIntegerList(pts);
    }

    public void setPoints(List<Point2D.Double> points, List<Point2D.Double> points1, List<Point2D.Double> points2, List<Integer> maskList) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Polygon shape = (Polygon)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        String pointsValues = PolygonData.toPoints(points.toArray(new Point2D.Double[points.size()]));
        String points1Values = PolygonData.toPoints(points1.toArray(new Point2D.Double[points1.size()]));
        String points2Values = PolygonData.toPoints(points2.toArray(new Point2D.Double[points2.size()]));
        String maskValues = "";
        for (int i = 0; i < maskList.size() - 1; ++i) {
            maskValues = maskValues + maskList.get(i) + ",";
        }
        if (maskList.size() != 0) {
            maskValues = maskValues + maskList.get(maskList.size() - 1) + "";
        }
        String pts = "points[" + pointsValues + "] ";
        pts = pts + "points1[" + points1Values + "] ";
        pts = pts + "points2[" + points2Values + "] ";
        pts = pts + "mask[" + maskValues + "] ";
        shape.setPoints(rtypes.rstring(pts));
    }
}

