/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AMI_Locator_findAdapterById;
import Ice.AMI_Locator_findObjectById;
import Ice.AdapterNotFoundException;
import Ice.BooleanHolder;
import Ice.CollocationOptimizationException;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorRegistryPrx;
import Ice.LocatorRegistryPrxHelper;
import Ice.NotRegisteredException;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.UserException;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorTable;
import IceInternal.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocatorInfo {
    private final LocatorPrx _locator;
    private LocatorRegistryPrx _locatorRegistry;
    private final LocatorTable _table;
    private final boolean _background;
    private Map<String, Request> _adapterRequests = new HashMap<String, Request>();
    private Map<Identity, Request> _objectRequests = new HashMap<Identity, Request>();

    LocatorInfo(LocatorPrx locator, LocatorTable table, boolean background) {
        this._locator = locator;
        this._table = table;
        this._background = background;
    }

    public synchronized void destroy() {
        this._locatorRegistry = null;
        this._table.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocatorInfo) {
            return this._locator.equals(((LocatorInfo)obj)._locator);
        }
        return false;
    }

    public LocatorPrx getLocator() {
        return this._locator;
    }

    public synchronized LocatorRegistryPrx getLocatorRegistry() {
        if (this._locatorRegistry == null) {
            this._locatorRegistry = this._locator.getRegistry();
            this._locatorRegistry = LocatorRegistryPrxHelper.uncheckedCast(this._locatorRegistry.ice_locator(null));
        }
        return this._locatorRegistry;
    }

    public EndpointI[] getEndpoints(Reference ref, int ttl, BooleanHolder cached) {
        return this.getEndpoints(ref, null, ttl, cached);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EndpointI[] getEndpoints(Reference ref, Reference wellKnownRef, int ttl, BooleanHolder cached) {
        assert (ref.isIndirect());
        EndpointI[] endpoints = null;
        cached.value = false;
        if (!ref.isWellKnown()) {
            endpoints = this._table.getAdapterEndpoints(ref.getAdapterId(), ttl, cached);
            if (!cached.value) {
                if (!this._background || endpoints == null) return this.getAdapterRequest(ref).getEndpoints(ref, wellKnownRef, ttl, cached);
                this.getAdapterRequest(ref).addCallback(ref, wellKnownRef, ttl, null);
            }
        } else {
            Reference r = this._table.getObjectReference(ref.getIdentity(), ttl, cached);
            if (!cached.value) {
                if (!this._background || r == null) return this.getObjectRequest(ref).getEndpoints(ref, null, ttl, cached);
                this.getObjectRequest(ref).addCallback(ref, null, ttl, null);
            }
            if (!r.isIndirect()) {
                endpoints = r.getEndpoints();
            } else if (!r.isWellKnown()) {
                return this.getEndpoints(r, ref, ttl, cached);
            }
        }
        assert (endpoints != null);
        cached.value = true;
        if (ref.getInstance().traceLevels().location < 1) return endpoints;
        this.getEndpointsTrace(ref, endpoints, true);
        return endpoints;
    }

    public void getEndpoints(Reference ref, int ttl, GetEndpointsCallback callback) {
        this.getEndpoints(ref, null, ttl, callback);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getEndpoints(Reference ref, Reference wellKnownRef, int ttl, GetEndpointsCallback callback) {
        assert (ref.isIndirect());
        EndpointI[] endpoints = null;
        BooleanHolder cached = new BooleanHolder();
        if (!ref.isWellKnown()) {
            endpoints = this._table.getAdapterEndpoints(ref.getAdapterId(), ttl, cached);
            if (!cached.value) {
                if (this._background && endpoints != null) {
                    this.getAdapterRequest(ref).addCallback(ref, wellKnownRef, ttl, null);
                } else {
                    this.getAdapterRequest(ref).addCallback(ref, wellKnownRef, ttl, callback);
                    return;
                }
            }
        } else {
            Reference r = this._table.getObjectReference(ref.getIdentity(), ttl, cached);
            if (!cached.value) {
                if (this._background && r != null) {
                    this.getObjectRequest(ref).addCallback(ref, null, ttl, null);
                } else {
                    this.getObjectRequest(ref).addCallback(ref, null, ttl, callback);
                    return;
                }
            }
            if (!r.isIndirect()) {
                endpoints = r.getEndpoints();
            } else if (!r.isWellKnown()) {
                this.getEndpoints(r, ref, ttl, callback);
                return;
            }
        }
        assert (endpoints != null);
        if (ref.getInstance().traceLevels().location >= 1) {
            this.getEndpointsTrace(ref, endpoints, true);
        }
        if (callback != null) {
            callback.setEndpoints(endpoints, true);
        }
    }

    public void clearCache(Reference ref) {
        assert (ref.isIndirect());
        if (!ref.isWellKnown()) {
            EndpointI[] endpoints = this._table.removeAdapterEndpoints(ref.getAdapterId());
            if (endpoints != null && ref.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table\n", ref, endpoints);
            }
        } else {
            Reference r = this._table.removeObjectReference(ref.getIdentity());
            if (r != null) {
                if (!r.isIndirect()) {
                    if (ref.getInstance().traceLevels().location >= 2) {
                        this.trace("removed endpoints from locator table", ref, r.getEndpoints());
                    }
                } else if (!r.isWellKnown()) {
                    this.clearCache(r);
                }
            }
        }
    }

    private void trace(String msg, Reference ref, EndpointI[] endpoints) {
        assert (ref.isIndirect());
        StringBuilder s = new StringBuilder(128);
        s.append(msg);
        s.append("\n");
        if (!ref.isWellKnown()) {
            s.append("adapter = ");
            s.append(ref.getAdapterId());
            s.append("\n");
        } else {
            s.append("object = ");
            s.append(ref.getInstance().identityToString(ref.getIdentity()));
            s.append("\n");
        }
        s.append("endpoints = ");
        int sz = endpoints.length;
        for (int i = 0; i < sz; ++i) {
            s.append(endpoints[i].toString());
            if (i + 1 >= sz) continue;
            s.append(":");
        }
        ref.getInstance().initializationData().logger.trace(ref.getInstance().traceLevels().locationCat, s.toString());
    }

    private void getEndpointsException(Reference ref, Exception exc) {
        assert (ref.isIndirect());
        try {
            throw exc;
        }
        catch (AdapterNotFoundException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("adapter not found\n");
                s.append("adapter = ");
                s.append(ref.getAdapterId());
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object adapter";
            e.id = ref.getAdapterId();
            throw e;
        }
        catch (ObjectNotFoundException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("object not found\n");
                s.append("object = ");
                s.append(instance.identityToString(ref.getIdentity()));
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object";
            e.id = instance.identityToString(ref.getIdentity());
            throw e;
        }
        catch (NotRegisteredException ex) {
            throw ex;
        }
        catch (LocalException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("couldn't contact the locator to retrieve adapter endpoints\n");
                if (ref.getAdapterId().length() > 0) {
                    s.append("adapter = ");
                    s.append(ref.getAdapterId());
                    s.append("\n");
                } else {
                    s.append("object = ");
                    s.append(instance.identityToString(ref.getIdentity()));
                    s.append("\n");
                }
                s.append("reason = " + ex);
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            throw ex;
        }
        catch (Exception ex) {
            assert (false);
            return;
        }
    }

    private void getEndpointsTrace(Reference ref, EndpointI[] endpoints, boolean cached) {
        if (endpoints != null && endpoints.length > 0) {
            if (cached) {
                this.trace("found endpoints in locator table", ref, endpoints);
            } else {
                this.trace("retrieved endpoints from locator, adding to locator table", ref, endpoints);
            }
        } else {
            Instance instance = ref.getInstance();
            StringBuilder s = new StringBuilder(128);
            s.append("no endpoints configured for ");
            if (ref.getAdapterId().length() > 0) {
                s.append("adapter\n");
                s.append("adapter = ");
                s.append(ref.getAdapterId());
                s.append("\n");
            } else {
                s.append("object\n");
                s.append("object = ");
                s.append(instance.identityToString(ref.getIdentity()));
                s.append("\n");
            }
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
        }
    }

    private synchronized Request getAdapterRequest(Reference ref) {
        Request request;
        if (ref.getInstance().traceLevels().location >= 1) {
            Instance instance = ref.getInstance();
            StringBuilder s = new StringBuilder(128);
            s.append("searching for adapter by id\n");
            s.append("adapter = ");
            s.append(ref.getAdapterId());
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
        }
        if ((request = this._adapterRequests.get(ref.getAdapterId())) != null) {
            return request;
        }
        request = new AdapterRequest(this, ref);
        this._adapterRequests.put(ref.getAdapterId(), request);
        return request;
    }

    private synchronized Request getObjectRequest(Reference ref) {
        Request request;
        if (ref.getInstance().traceLevels().location >= 1) {
            Instance instance = ref.getInstance();
            StringBuilder s = new StringBuilder(128);
            s.append("searching for object by id\n");
            s.append("object = ");
            s.append(instance.identityToString(ref.getIdentity()));
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
        }
        if ((request = this._objectRequests.get(ref.getIdentity())) != null) {
            return request;
        }
        request = new ObjectRequest(this, ref);
        this._objectRequests.put(ref.getIdentity(), request);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRequest(Reference ref, List<Reference> wellKnownRefs, ObjectPrx proxy, boolean notRegistered) {
        LocatorInfo locatorInfo;
        if (proxy == null || ((ObjectPrxHelperBase)proxy).__reference().isIndirect()) {
            for (Reference r : wellKnownRefs) {
                this._table.removeObjectReference(r.getIdentity());
            }
        }
        if (!ref.isWellKnown()) {
            if (proxy != null && !((ObjectPrxHelperBase)proxy).__reference().isIndirect()) {
                this._table.addAdapterEndpoints(ref.getAdapterId(), ((ObjectPrxHelperBase)proxy).__reference().getEndpoints());
            } else if (notRegistered) {
                this._table.removeAdapterEndpoints(ref.getAdapterId());
            }
            locatorInfo = this;
            synchronized (locatorInfo) {
                assert (this._adapterRequests.get(ref.getAdapterId()) != null);
                this._adapterRequests.remove(ref.getAdapterId());
            }
        }
        if (proxy != null && !((ObjectPrxHelperBase)proxy).__reference().isWellKnown()) {
            this._table.addObjectReference(ref.getIdentity(), ((ObjectPrxHelperBase)proxy).__reference());
        } else if (notRegistered) {
            this._table.removeObjectReference(ref.getIdentity());
        }
        locatorInfo = this;
        synchronized (locatorInfo) {
            assert (this._objectRequests.get(ref.getIdentity()) != null);
            this._objectRequests.remove(ref.getIdentity());
        }
    }

    private class AdapterRequest
    extends Request {
        public AdapterRequest(LocatorInfo locatorInfo2, Reference reference) {
            super(locatorInfo2, reference);
            assert (reference.isIndirect());
        }

        protected void send(boolean async) {
            try {
                if (async) {
                    this._locatorInfo.getLocator().findAdapterById_async(new AMI_Locator_findAdapterById(){

                        public void ice_response(ObjectPrx proxy) {
                            AdapterRequest.this.response(proxy);
                        }

                        public void ice_exception(UserException ex) {
                            AdapterRequest.this.exception(ex);
                        }

                        public void ice_exception(LocalException ex) {
                            AdapterRequest.this.exception(ex);
                        }
                    }, this._ref.getAdapterId());
                } else {
                    this.response(this._locatorInfo.getLocator().findAdapterById(this._ref.getAdapterId()));
                }
            }
            catch (Exception ex) {
                this.exception(ex);
            }
        }
    }

    private class ObjectRequest
    extends Request {
        public ObjectRequest(LocatorInfo locatorInfo2, Reference reference) {
            super(locatorInfo2, reference);
            assert (reference.isWellKnown());
        }

        protected void send(boolean async) {
            try {
                if (async) {
                    this._locatorInfo.getLocator().findObjectById_async(new AMI_Locator_findObjectById(){

                        public void ice_response(ObjectPrx proxy) {
                            ObjectRequest.this.response(proxy);
                        }

                        public void ice_exception(UserException ex) {
                            ObjectRequest.this.exception(ex);
                        }

                        public void ice_exception(LocalException ex) {
                            ObjectRequest.this.exception(ex);
                        }
                    }, this._ref.getIdentity());
                } else {
                    this.response(this._locatorInfo.getLocator().findObjectById(this._ref.getIdentity()));
                }
            }
            catch (Exception ex) {
                this.exception(ex);
            }
        }
    }

    private abstract class Request {
        protected final LocatorInfo _locatorInfo;
        protected final Reference _ref;
        private List<RequestCallback> _callbacks = new ArrayList<RequestCallback>();
        private List<Reference> _wellKnownRefs = new ArrayList<Reference>();
        private boolean _sent;
        private boolean _response;
        private ObjectPrx _proxy;
        private Exception _exception;

        public synchronized void addCallback(Reference ref, Reference wellKnownRef, int ttl, GetEndpointsCallback cb) {
            RequestCallback callback = new RequestCallback(ref, ttl, cb);
            if (this._response) {
                callback.response(this._locatorInfo, this._proxy);
            } else if (this._exception != null) {
                callback.exception(this._locatorInfo, this._exception);
            } else {
                this._callbacks.add(callback);
                if (wellKnownRef != null) {
                    this._wellKnownRefs.add(wellKnownRef);
                }
                if (!this._sent) {
                    this._sent = true;
                    this.send(true);
                }
            }
        }

        synchronized EndpointI[] getEndpoints(Reference ref, Reference wellKnownRef, int ttl, BooleanHolder cached) {
            if (!this._response || this._exception == null) {
                if (wellKnownRef != null) {
                    this._wellKnownRefs.add(wellKnownRef);
                }
                if (!this._sent) {
                    this._sent = true;
                    this.send(true);
                }
                while (!this._response && this._exception == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            if (this._exception != null) {
                this._locatorInfo.getEndpointsException(ref, this._exception);
            }
            assert (this._response);
            EndpointI[] endpoints = null;
            if (this._proxy != null) {
                Reference r = ((ObjectPrxHelperBase)this._proxy).__reference();
                if (!r.isIndirect()) {
                    endpoints = r.getEndpoints();
                } else if (ref.isWellKnown() && !r.isWellKnown()) {
                    return this._locatorInfo.getEndpoints(r, ref, ttl, cached);
                }
            }
            cached.value = false;
            if (this._ref.getInstance().traceLevels().location >= 1) {
                this._locatorInfo.getEndpointsTrace(ref, endpoints, false);
            }
            return endpoints == null ? new EndpointI[]{} : endpoints;
        }

        Request(LocatorInfo locatorInfo2, Reference ref) {
            this._locatorInfo = locatorInfo2;
            this._ref = ref;
            this._sent = false;
            this._response = false;
        }

        protected synchronized void response(ObjectPrx proxy) {
            this._locatorInfo.finishRequest(this._ref, this._wellKnownRefs, proxy, false);
            this._response = true;
            this._proxy = proxy;
            for (RequestCallback callback : this._callbacks) {
                callback.response(this._locatorInfo, proxy);
            }
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exception(Exception ex) {
            if (ex instanceof CollocationOptimizationException) {
                this.send(false);
                return;
            }
            Request request = this;
            synchronized (request) {
                this._locatorInfo.finishRequest(this._ref, this._wellKnownRefs, null, ex instanceof UserException);
                this._exception = ex;
                for (RequestCallback callback : this._callbacks) {
                    callback.exception(this._locatorInfo, ex);
                }
                this.notifyAll();
            }
        }

        protected abstract void send(boolean var1);
    }

    private class RequestCallback {
        final Reference _ref;
        final int _ttl;
        final GetEndpointsCallback _callback;

        public void response(LocatorInfo locatorInfo, ObjectPrx proxy) {
            EndpointI[] endpoints = null;
            if (proxy != null) {
                Reference r = ((ObjectPrxHelperBase)proxy).__reference();
                if (!r.isIndirect()) {
                    endpoints = r.getEndpoints();
                } else if (this._ref.isWellKnown() && !r.isWellKnown()) {
                    locatorInfo.getEndpoints(r, this._ref, this._ttl, this._callback);
                    return;
                }
            }
            if (this._ref.getInstance().traceLevels().location >= 1) {
                locatorInfo.getEndpointsTrace(this._ref, endpoints, false);
            }
            if (this._callback != null) {
                this._callback.setEndpoints(endpoints == null ? new EndpointI[]{} : endpoints, false);
            }
        }

        public void exception(LocatorInfo locatorInfo, Exception exc) {
            block2: {
                try {
                    locatorInfo.getEndpointsException(this._ref, exc);
                }
                catch (LocalException ex) {
                    if (this._callback == null) break block2;
                    this._callback.setException(ex);
                }
            }
        }

        RequestCallback(Reference ref, int ttl, GetEndpointsCallback cb) {
            this._ref = ref;
            this._ttl = ttl;
            this._callback = cb;
        }
    }

    static interface GetEndpointsCallback {
        public void setEndpoints(EndpointI[] var1, boolean var2);

        public void setException(LocalException var1);
    }
}

