/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EndpointSelectionType;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.RouterInfo;
import IceUtilInternal.StringUtil;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reference
implements Cloneable {
    public static final int ModeTwoway = 0;
    public static final int ModeOneway = 1;
    public static final int ModeBatchOneway = 2;
    public static final int ModeDatagram = 3;
    public static final int ModeBatchDatagram = 4;
    public static final int ModeLast = 4;
    protected int _hashValue;
    protected boolean _hashInitialized;
    private static Map<String, String> _emptyContext = new HashMap<String, String>();
    private final Instance _instance;
    private final Communicator _communicator;
    private int _mode;
    private boolean _secure;
    private Identity _identity;
    private Map<String, String> _context;
    private String _facet;
    protected boolean _overrideCompress;
    protected boolean _compress;

    public final int getMode() {
        return this._mode;
    }

    public final boolean getSecure() {
        return this._secure;
    }

    public final Identity getIdentity() {
        return this._identity;
    }

    public final String getFacet() {
        return this._facet;
    }

    public final Instance getInstance() {
        return this._instance;
    }

    public final Map<String, String> getContext() {
        return this._context;
    }

    public final Reference defaultContext() {
        Reference r = this._instance.referenceFactory().copy(this);
        r._context = this._instance.getDefaultContext();
        return r;
    }

    public final Communicator getCommunicator() {
        return this._communicator;
    }

    public abstract EndpointI[] getEndpoints();

    public abstract String getAdapterId();

    public abstract RouterInfo getRouterInfo();

    public abstract LocatorInfo getLocatorInfo();

    public abstract boolean getCollocationOptimized();

    public abstract boolean getCacheConnection();

    public abstract boolean getPreferSecure();

    public abstract EndpointSelectionType getEndpointSelection();

    public abstract int getLocatorCacheTimeout();

    public final Reference changeContext(Map<String, String> newContext) {
        if (newContext == null) {
            newContext = _emptyContext;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._context = newContext.isEmpty() ? _emptyContext : new HashMap<String, String>(newContext);
        return r;
    }

    public final Reference changeMode(int newMode) {
        if (newMode == this._mode) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._mode = newMode;
        return r;
    }

    public Reference changeSecure(boolean newSecure) {
        if (newSecure == this._secure) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._secure = newSecure;
        return r;
    }

    public final Reference changeIdentity(Identity newIdentity) {
        if (newIdentity.equals(this._identity)) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._identity = (Identity)newIdentity.clone();
        return r;
    }

    public final Reference changeFacet(String newFacet) {
        if (newFacet.equals(this._facet)) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._facet = newFacet;
        return r;
    }

    public Reference changeCompress(boolean newCompress) {
        if (this._overrideCompress && this._compress == newCompress) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._compress = newCompress;
        r._overrideCompress = true;
        return r;
    }

    public abstract Reference changeAdapterId(String var1);

    public abstract Reference changeEndpoints(EndpointI[] var1);

    public abstract Reference changeLocator(LocatorPrx var1);

    public abstract Reference changeRouter(RouterPrx var1);

    public abstract Reference changeCollocationOptimized(boolean var1);

    public abstract Reference changeCacheConnection(boolean var1);

    public abstract Reference changePreferSecure(boolean var1);

    public abstract Reference changeEndpointSelection(EndpointSelectionType var1);

    public abstract Reference changeLocatorCacheTimeout(int var1);

    public abstract Reference changeTimeout(int var1);

    public abstract Reference changeConnectionId(String var1);

    public synchronized int hashCode() {
        if (this._hashInitialized) {
            return this._hashValue;
        }
        int h = this._mode;
        h = 5 * h + this._identity.hashCode();
        h = 5 * h + ((Object)this._context).hashCode();
        h = 5 * h + this._facet.hashCode();
        this._hashValue = h = 5 * h + (this._secure ? 1 : 0);
        this._hashInitialized = true;
        return h;
    }

    public abstract boolean isIndirect();

    public abstract boolean isWellKnown();

    public void streamWrite(BasicStream s) {
        if (this._facet.length() == 0) {
            s.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{this._facet};
            s.writeStringSeq(facetPath);
        }
        s.writeByte((byte)this._mode);
        s.writeBool(this._secure);
    }

    public String toString() {
        StringBuilder s = new StringBuilder(128);
        String id = this._instance.identityToString(this._identity);
        if (StringUtil.findFirstOf(id, " \t\n\r:@") != -1) {
            s.append('\"');
            s.append(id);
            s.append('\"');
        } else {
            s.append(id);
        }
        if (this._facet.length() > 0) {
            s.append(" -f ");
            String fs = StringUtil.escapeString(this._facet, "");
            if (StringUtil.findFirstOf(fs, " \t\n\r:@") != -1) {
                s.append('\"');
                s.append(fs);
                s.append('\"');
            } else {
                s.append(fs);
            }
        }
        switch (this._mode) {
            case 0: {
                s.append(" -t");
                break;
            }
            case 1: {
                s.append(" -o");
                break;
            }
            case 2: {
                s.append(" -O");
                break;
            }
            case 3: {
                s.append(" -d");
                break;
            }
            case 4: {
                s.append(" -D");
            }
        }
        if (this._secure) {
            s.append(" -s");
        }
        return s.toString();
    }

    public abstract ConnectionI getConnection(BooleanHolder var1);

    public abstract void getConnection(GetConnectionCallback var1);

    public boolean equals(Object obj) {
        Reference r = (Reference)obj;
        if (this._mode != r._mode) {
            return false;
        }
        if (this._secure != r._secure) {
            return false;
        }
        if (!this._identity.equals(r._identity)) {
            return false;
        }
        if (!((Object)this._context).equals(r._context)) {
            return false;
        }
        if (!this._facet.equals(r._facet)) {
            return false;
        }
        if (this._overrideCompress != r._overrideCompress) {
            return false;
        }
        return !this._overrideCompress || this._compress == r._compress;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    protected Reference(Instance instance, Communicator communicator, Identity identity, Map<String, String> context, String facet, int mode, boolean secure) {
        assert (identity.name != null);
        assert (identity.category != null);
        assert (facet != null);
        this._instance = instance;
        this._communicator = communicator;
        this._mode = mode;
        this._secure = secure;
        this._identity = identity;
        this._context = context == null ? _emptyContext : context;
        this._facet = facet;
        this._hashInitialized = false;
        this._overrideCompress = false;
        this._compress = false;
    }

    public static interface GetConnectionCallback {
        public void setConnection(ConnectionI var1, boolean var2);

        public void setException(LocalException var1);
    }
}

