/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointIHolder;
import IceInternal.EndpointI_connectors;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceInternal.UdpConnector;
import IceInternal.UdpTransceiver;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UdpEndpointI
extends EndpointI {
    static final short TYPE = 3;
    private Instance _instance;
    private String _host;
    private int _port;
    private String _mcastInterface = "";
    private int _mcastTtl = -1;
    private byte _protocolMajor;
    private byte _protocolMinor;
    private byte _encodingMajor;
    private byte _encodingMinor;
    private boolean _connect;
    private String _connectionId = "";
    private boolean _compress;
    private int _hashCode;

    public UdpEndpointI(Instance instance, String ho, int po, String mif, int mttl, byte pma, byte pmi, byte ema, byte emi, boolean conn, String conId, boolean co) {
        this._instance = instance;
        this._host = ho;
        this._port = po;
        this._mcastInterface = mif;
        this._mcastTtl = mttl;
        this._protocolMajor = pma;
        this._protocolMinor = pmi;
        this._encodingMajor = ema;
        this._encodingMinor = emi;
        this._connect = conn;
        this._connectionId = conId;
        this._compress = co;
        this.calcHashValue();
    }

    public UdpEndpointI(Instance instance, String str, boolean oaEndpoint) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._protocolMajor = 1;
        this._protocolMinor = 0;
        this._encodingMajor = 1;
        this._encodingMinor = 0;
        this._connect = false;
        this._compress = false;
        String[] arr = str.split("[ \t\n\r]+");
        int i = 0;
        while (i < arr.length) {
            int minVersion;
            int majVersion;
            String minStr;
            String majStr;
            int pos;
            String option;
            if (arr[i].length() == 0) {
                ++i;
                continue;
            }
            if ((option = arr[i++]).charAt(0) != '-') {
                throw new EndpointParseException("udp " + str);
            }
            String argument = null;
            if (i < arr.length && arr[i].charAt(0) != '-' && (argument = arr[i++]).charAt(0) == '\"' && argument.charAt(argument.length() - 1) == '\"') {
                argument = argument.substring(1, argument.length() - 1);
            }
            if (option.equals("-v")) {
                if (argument == null) {
                    throw new EndpointParseException("udp " + str);
                }
                pos = argument.indexOf(46);
                if (pos == -1) {
                    throw new EndpointParseException("udp " + str);
                }
                majStr = argument.substring(0, pos);
                minStr = argument.substring(pos + 1, argument.length());
                try {
                    majVersion = Integer.parseInt(majStr);
                    minVersion = Integer.parseInt(minStr);
                }
                catch (NumberFormatException ex) {
                    throw new EndpointParseException("udp " + str);
                }
                if (majVersion < 1 || majVersion > 255 || minVersion < 0 || minVersion > 255) {
                    throw new EndpointParseException("udp " + str);
                }
                if (majVersion != 1) {
                    UnsupportedProtocolException e = new UnsupportedProtocolException();
                    e.badMajor = majVersion < 0 ? majVersion + 255 : majVersion;
                    e.badMinor = minVersion < 0 ? minVersion + 255 : minVersion;
                    e.major = 1;
                    e.minor = 0;
                    throw e;
                }
                this._protocolMajor = (byte)majVersion;
                this._protocolMinor = (byte)minVersion;
                continue;
            }
            if (option.equals("-e")) {
                if (argument == null) {
                    throw new EndpointParseException("udp " + str);
                }
                pos = argument.indexOf(46);
                if (pos == -1) {
                    throw new EndpointParseException("udp " + str);
                }
                majStr = argument.substring(0, pos);
                minStr = argument.substring(pos + 1, argument.length());
                try {
                    majVersion = Integer.parseInt(majStr);
                    minVersion = Integer.parseInt(minStr);
                }
                catch (NumberFormatException ex) {
                    throw new EndpointParseException("udp " + str);
                }
                if (majVersion < 1 || majVersion > 255 || minVersion < 0 || minVersion > 255) {
                    throw new EndpointParseException("udp " + str);
                }
                if (majVersion != 1) {
                    UnsupportedEncodingException e = new UnsupportedEncodingException();
                    e.badMajor = majVersion < 0 ? majVersion + 255 : majVersion;
                    e.badMinor = minVersion < 0 ? minVersion + 255 : minVersion;
                    e.major = 1;
                    e.minor = 0;
                    throw e;
                }
                this._encodingMajor = (byte)majVersion;
                this._encodingMinor = (byte)minVersion;
                continue;
            }
            if (option.equals("-h")) {
                if (argument == null) {
                    throw new EndpointParseException("udp " + str);
                }
                this._host = argument;
                continue;
            }
            if (option.equals("-p")) {
                if (argument == null) {
                    throw new EndpointParseException("udp " + str);
                }
                try {
                    this._port = Integer.parseInt(argument);
                }
                catch (NumberFormatException ex) {
                    throw new EndpointParseException("udp " + str);
                }
                if (this._port >= 0 && this._port <= 65535) continue;
                throw new EndpointParseException("udp " + str);
            }
            if (option.equals("-c")) {
                if (argument != null) {
                    throw new EndpointParseException("udp " + str);
                }
                this._connect = true;
                break;
            }
            if (option.equals("-z")) {
                if (argument != null) {
                    throw new EndpointParseException("udp " + str);
                }
                this._compress = true;
                break;
            }
            if (option.equals("--interface")) {
                if (argument == null) {
                    throw new EndpointParseException("udp " + str);
                }
                this._mcastInterface = argument;
                continue;
            }
            if (option.equals("--ttl")) {
                if (argument == null) {
                    throw new EndpointParseException("udp " + str);
                }
                try {
                    this._mcastTtl = Integer.parseInt(argument);
                }
                catch (NumberFormatException ex) {
                    throw new EndpointParseException("udp " + str);
                }
                if (this._mcastTtl >= 0) continue;
                throw new EndpointParseException("udp " + str);
            }
            throw new EndpointParseException("udp " + str);
        }
        if (this._host == null) {
            this._host = this._instance.defaultsAndOverrides().defaultHost;
        } else if (this._host.equals("*")) {
            if (oaEndpoint) {
                this._host = null;
            } else {
                throw new EndpointParseException("udp " + str);
            }
        }
        if (this._host == null) {
            this._host = "";
        }
        this.calcHashValue();
    }

    public UdpEndpointI(BasicStream s) {
        this._instance = s.instance();
        s.startReadEncaps();
        this._host = s.readString();
        this._port = s.readInt();
        this._protocolMajor = s.readByte();
        this._protocolMinor = s.readByte();
        this._encodingMajor = s.readByte();
        this._encodingMinor = s.readByte();
        if (this._protocolMajor != 1) {
            UnsupportedProtocolException e = new UnsupportedProtocolException();
            e.badMajor = this._protocolMajor < 0 ? this._protocolMajor + 255 : this._protocolMajor;
            e.badMinor = this._protocolMinor < 0 ? this._protocolMinor + 255 : this._protocolMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        if (this._encodingMajor != 1) {
            UnsupportedEncodingException e = new UnsupportedEncodingException();
            e.badMajor = this._encodingMajor < 0 ? this._encodingMajor + 255 : this._encodingMajor;
            e.badMinor = this._encodingMinor < 0 ? this._encodingMinor + 255 : this._encodingMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        this._connect = false;
        this._compress = s.readBool();
        s.endReadEncaps();
        this.calcHashValue();
    }

    @Override
    public void streamWrite(BasicStream s) {
        s.writeShort((short)3);
        s.startWriteEncaps();
        s.writeString(this._host);
        s.writeInt(this._port);
        s.writeByte(this._protocolMajor);
        s.writeByte(this._protocolMinor);
        s.writeByte(this._encodingMajor);
        s.writeByte(this._encodingMinor);
        s.writeBool(this._compress);
        s.endWriteEncaps();
    }

    @Override
    public String _toString() {
        String s = "udp";
        if (this._protocolMajor != 1 || this._protocolMinor != 0) {
            s = s + " -v " + (this._protocolMajor < 0 ? this._protocolMajor + 255 : this._protocolMajor) + "." + (this._protocolMinor < 0 ? this._protocolMinor + 255 : this._protocolMinor);
        }
        if (this._encodingMajor != 1 || this._encodingMinor != 0) {
            s = s + " -e " + (this._encodingMajor < 0 ? this._encodingMajor + 255 : this._encodingMajor) + "." + (this._encodingMinor < 0 ? this._encodingMinor + 255 : this._encodingMinor);
        }
        if (this._host != null && this._host.length() > 0) {
            boolean addQuote;
            s = s + " -h ";
            boolean bl = addQuote = this._host.indexOf(58) != -1;
            if (addQuote) {
                s = s + "\"";
            }
            s = s + this._host;
            if (addQuote) {
                s = s + "\"";
            }
        }
        s = s + " -p " + this._port;
        if (this._mcastInterface.length() != 0) {
            s = s + " --interface " + this._mcastInterface;
        }
        if (this._mcastTtl != -1) {
            s = s + " --ttl " + this._mcastTtl;
        }
        if (this._connect) {
            s = s + " -c";
        }
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    @Override
    public short type() {
        return 3;
    }

    @Override
    public int timeout() {
        return -1;
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, this._port, this._mcastInterface, this._mcastTtl, this._protocolMajor, this._protocolMinor, this._encodingMajor, this._encodingMinor, this._connect, this._connectionId, compress);
    }

    @Override
    public EndpointI connectionId(String connectionId) {
        if (connectionId.equals(this._connectionId)) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, this._port, this._mcastInterface, this._mcastTtl, this._protocolMajor, this._protocolMinor, this._encodingMajor, this._encodingMinor, this._connect, connectionId, this._compress);
    }

    @Override
    public EndpointI timeout(int timeout) {
        return this;
    }

    @Override
    public boolean datagram() {
        return true;
    }

    @Override
    public boolean secure() {
        return false;
    }

    @Override
    public boolean unknown() {
        return false;
    }

    @Override
    public Transceiver transceiver(EndpointIHolder endpoint) {
        UdpTransceiver p = new UdpTransceiver(this._instance, this._host, this._port, this._mcastInterface, this._connect);
        endpoint.value = new UdpEndpointI(this._instance, this._host, p.effectivePort(), this._mcastInterface, this._mcastTtl, this._protocolMajor, this._protocolMinor, this._encodingMajor, this._encodingMinor, this._connect, this._connectionId, this._compress);
        return p;
    }

    @Override
    public List<Connector> connectors() {
        return this.connectors(Network.getAddresses(this._host, this._port, this._instance.protocolSupport()));
    }

    @Override
    public void connectors_async(EndpointI_connectors callback) {
        this._instance.endpointHostResolver().resolve(this._host, this._port, this, callback);
    }

    @Override
    public Acceptor acceptor(EndpointIHolder endpoint, String adapterName) {
        endpoint.value = this;
        return null;
    }

    @Override
    public List<EndpointI> expand() {
        ArrayList<EndpointI> endps = new ArrayList<EndpointI>();
        ArrayList<String> hosts = Network.getHostsForEndpointExpand(this._host, this._instance.protocolSupport());
        if (hosts == null || hosts.isEmpty()) {
            endps.add(this);
        } else {
            Iterator<String> p = hosts.iterator();
            while (p.hasNext()) {
                endps.add(new UdpEndpointI(this._instance, p.next(), this._port, this._mcastInterface, this._mcastTtl, this._protocolMajor, this._protocolMinor, this._encodingMajor, this._encodingMinor, this._connect, this._connectionId, this._compress));
            }
        }
        return endps;
    }

    @Override
    public boolean equivalent(EndpointI endpoint) {
        UdpEndpointI udpEndpointI = null;
        try {
            udpEndpointI = (UdpEndpointI)endpoint;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return udpEndpointI._host.equals(this._host) && udpEndpointI._port == this._port;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            return this.compareTo((EndpointI)obj) == 0;
        }
        catch (ClassCastException ee) {
            assert (false);
            return false;
        }
    }

    @Override
    public int compareTo(EndpointI obj) {
        UdpEndpointI p = null;
        try {
            p = (UdpEndpointI)obj;
        }
        catch (ClassCastException ex) {
            return this.type() < obj.type() ? -1 : 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._port < p._port) {
            return -1;
        }
        if (p._port < this._port) {
            return 1;
        }
        if (!this._connect && p._connect) {
            return -1;
        }
        if (!p._connect && this._connect) {
            return 1;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return this._connectionId.compareTo(p._connectionId);
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        if (this._protocolMajor < p._protocolMajor) {
            return -1;
        }
        if (p._protocolMajor < this._protocolMajor) {
            return 1;
        }
        if (this._protocolMinor < p._protocolMinor) {
            return -1;
        }
        if (p._protocolMinor < this._protocolMinor) {
            return 1;
        }
        if (this._encodingMajor < p._encodingMajor) {
            return -1;
        }
        if (p._encodingMajor < this._encodingMajor) {
            return 1;
        }
        if (this._encodingMinor < p._encodingMinor) {
            return -1;
        }
        if (p._encodingMinor < this._encodingMinor) {
            return 1;
        }
        if (this._mcastTtl < p._mcastTtl) {
            return -1;
        }
        if (p._mcastTtl < this._mcastTtl) {
            return 1;
        }
        int rc = this._mcastInterface.compareTo(p._mcastInterface);
        if (rc != 0) {
            return rc;
        }
        return this._host.compareTo(p._host);
    }

    @Override
    public List<Connector> connectors(List<InetSocketAddress> addresses) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        Iterator<InetSocketAddress> p = addresses.iterator();
        while (p.hasNext()) {
            connectors.add(new UdpConnector(this._instance, p.next(), this._mcastInterface, this._mcastTtl, this._protocolMajor, this._protocolMinor, this._encodingMajor, this._encodingMinor, this._connectionId));
        }
        return connectors;
    }

    private void calcHashValue() {
        this._hashCode = this._host.hashCode();
        this._hashCode = 5 * this._hashCode + this._port;
        this._hashCode = 5 * this._hashCode + this._mcastInterface.hashCode();
        this._hashCode = 5 * this._hashCode + this._mcastTtl;
        this._hashCode = 5 * this._hashCode + (this._connect ? 1 : 0);
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
        this._hashCode = 5 * this._hashCode + (this._compress ? 1 : 0);
    }
}

