/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class SaveAction
extends DataBrowserAction {
    private static final String DESCRIPTION = "Save the displayed thumbnails in a Microsoft Excel file.";

    protected void onStateChange() {
        if (this.model.getState() == 3) {
            this.setEnabled(this.model.isImagesModel());
        } else {
            this.setEnabled(false);
        }
    }

    public SaveAction(DataBrowser model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(36));
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        ExcelFilter filter = new ExcelFilter();
        filterList.add(filter);
        JFrame frame = DataBrowserAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(frame, 1, "Save thumbnails", "Save the thumbnails", filterList);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(39));
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                chooser.setCurrentDirectory(f);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        int option = chooser.centerDialog();
        if (option != 0) {
            return;
        }
        File file = chooser.getFormattedSelectedFile();
        if (file != null) {
            this.model.saveThumbnails(file);
        }
    }
}

