/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.ImageData;

public class SendFeedbackAction
extends DataBrowserAction {
    private static final String NAME = "Send Feedback...";
    private static final String DESCRIPTION = "Send feedback about the selected image.";

    protected void onDisplayChange(ImageDisplay node) {
        if (node == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getBrowser();
        Collection l = browser.getSelectedDisplays();
        if (l != null && l.size() == 1) {
            Object object = node.getHierarchyObject();
            this.setEnabled(object instanceof ImageData);
        } else {
            this.setEnabled(false);
        }
    }

    public SendFeedbackAction(DataBrowser model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(51));
    }

    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getBrowser();
        Collection l = browser.getSelectedDisplays();
        if (l != null && l.size() == 1) {
            Iterator i = l.iterator();
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            ExperimenterData exp = DataBrowserAgent.getUserDetails();
            while (i.hasNext()) {
                ImageDisplay node = (ImageDisplay)i.next();
                Object object = node.getHierarchyObject();
                if (!(object instanceof ImageData)) continue;
                ImageData image = (ImageData)object;
                String text = "Image Name: " + image.getName();
                un.submitMessage(exp.getEmail(), text);
            }
        }
    }
}

