/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.layout;

import org.openmicroscopy.shoola.agents.dataBrowser.layout.FlatLayout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.PlateLayout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.SquaryLayout;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;

public class LayoutFactory {
    public static final int SQUARY_LAYOUT = 1;
    public static final int FLAT_LAYOUT = 2;
    public static final int PLATE_LAYOUT = 3;

    public static Layout createLayout(int type, ViewerSorter sorter, int itemsPerRow) {
        if (sorter == null) {
            throw new IllegalArgumentException("Invalid argument.");
        }
        switch (type) {
            case 1: {
                return new SquaryLayout(sorter, itemsPerRow);
            }
            case 2: {
                return new FlatLayout(sorter);
            }
            case 3: {
                return new PlateLayout();
            }
        }
        throw new IllegalArgumentException("Unsupported layout type: " + type + ".");
    }

    public static Layout createPlateLayout() {
        return new PlateLayout();
    }

    public static Layout getDefaultLayout(ViewerSorter sorter, int itemsPerRow) {
        return LayoutFactory.createLayout(LayoutFactory.getDefaultLayoutIndex(), sorter, itemsPerRow);
    }

    public static Layout getDefaultLayout(ViewerSorter sorter) {
        return LayoutFactory.createLayout(LayoutFactory.getDefaultLayoutIndex(), sorter, 10);
    }

    public static int getDefaultLayoutIndex() {
        return 1;
    }

    public static String getLayoutDescription(int type) {
        switch (type) {
            case 1: {
                return "Recursively lays out all nodes in a container display in a square grid. The size of each cell in the grid is that of the largest child in the container.";
            }
            case 2: {
                return "Layout the images in a square grid.";
            }
            case 3: {
                return "Layout the plate.";
            }
        }
        return "";
    }
}

