/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.layout;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutUtils;
import pojos.WellSampleData;

public class PlateLayout
implements Layout {
    static final String DESCRIPTION = "Layout the plate.";
    private Set oldNodes;

    public void doLayout() {
    }

    public void visit(ImageNode node) {
    }

    public void visit(ImageSet node) {
        if (node.getParentDisplay() != null) {
            return;
        }
        if (this.oldNodes == null || this.oldNodes.size() == 0) {
            Dimension d;
            Set nodes = node.getChildrenDisplay();
            Iterator i = nodes.iterator();
            ArrayList<ImageDisplay> l = new ArrayList<ImageDisplay>();
            ArrayList<CellDisplay> col = new ArrayList<CellDisplay>();
            ArrayList<CellDisplay> row = new ArrayList<CellDisplay>();
            while (i.hasNext()) {
                ImageDisplay n = (ImageDisplay)i.next();
                if (n instanceof CellDisplay) {
                    CellDisplay cell = (CellDisplay)n;
                    if (cell.getType() == 1) {
                        col.add(cell);
                        continue;
                    }
                    row.add(cell);
                    continue;
                }
                l.add(n);
            }
            Dimension maxDim = new Dimension(0, 0);
            for (ImageDisplay child : l) {
                WellSampleData wsd = (WellSampleData)child.getHierarchyObject();
                if (wsd.getId() < 0L) continue;
                maxDim = LayoutUtils.max(maxDim, child.getPreferredSize());
            }
            int height = 10;
            int width = 10;
            if (col.size() > 0) {
                d = ((ImageDisplay)col.get(0)).getPreferredSize();
                height = d.height;
            }
            if (row.size() > 0) {
                d = ((ImageDisplay)row.get(0)).getPreferredSize();
                width = d.width + 15;
            }
            for (CellDisplay cell : col) {
                d = cell.getPreferredSize();
                cell.setBounds(width + cell.getIndex() * maxDim.width, 0, maxDim.width, d.height);
            }
            for (CellDisplay cell : row) {
                d = cell.getPreferredSize();
                cell.setBounds(0, height + cell.getIndex() * maxDim.height, width, maxDim.height);
            }
            for (WellSampleNode wellSampleNode : l) {
                int r = wellSampleNode.getRow();
                int c = wellSampleNode.getColumn();
                d = wellSampleNode.getPreferredSize();
                wellSampleNode.setBounds(width + c * maxDim.width, height + r * maxDim.height, d.width, d.height);
            }
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getIndex() {
        return 3;
    }

    public void setOldNodes(Set oldNodes) {
        this.oldNodes = oldNodes;
    }

    public void setImagesPerRow(int number) {
    }

    public int getImagesPerRow() {
        return 0;
    }
}

