/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.layout;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutUtils;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import pojos.DataObject;
import pojos.ImageData;

class SquaryLayout
implements Layout {
    static final String DESCRIPTION = "Recursively lays out all nodes in a container display in a square grid. The size of each cell in the grid is that of the largest child in the container.";
    private ViewerSorter sorter;
    private static int browserWidth;
    private Set oldNodes;
    private int itemsPerRow;

    private void setBrowserSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        browserWidth = 7 * (screenSize.width / 10);
    }

    private void visitContainerNode(ImageSet node) {
        Dimension d;
        if (node.getChildrenDisplay().size() == 0) {
            LayoutUtils.noChildLayout(node);
            return;
        }
        Object[] children = this.sorter.sortAsArray(node.getChildrenDisplay());
        int maxY = 0;
        int x = 0;
        int y = 0;
        for (int i = 0; i < children.length; ++i) {
            ImageDisplay child = (ImageDisplay)children[i];
            d = child.getPreferredSize();
            child.setBounds(x, y, d.width, d.height);
            child.setCollapsed(false);
            x = 0;
            y = maxY == 0 ? (y += d.height) : (y += maxY);
            maxY = 0;
        }
        Rectangle bounds = node.getContentsBounds();
        d = bounds.getSize();
        node.getInternalDesktop().setSize(d);
        node.getInternalDesktop().setPreferredSize(d);
        node.setCollapsed(false);
    }

    private Set getOldChildren(ImageSet n) {
        Object object = n.getHierarchyObject();
        if (!(object instanceof DataObject)) {
            ImageDisplay element;
            Iterator i;
            boolean image = false;
            if (this.oldNodes != null && (i = this.oldNodes.iterator()).hasNext() && (element = (ImageDisplay)i.next()).getHierarchyObject() instanceof ImageData) {
                image = true;
            }
            if (image) {
                return this.oldNodes;
            }
            return n.getChildrenDisplay();
        }
        DataObject ho = (DataObject)object;
        Class<?> klass = ho.getClass();
        long id = ho.getId();
        for (ImageDisplay child : this.oldNodes) {
            Object oho = child.getHierarchyObject();
            if (!(oho instanceof DataObject) || ((DataObject)oho).getId() != id || !klass.equals(oho.getClass())) continue;
            return child.getChildrenDisplay();
        }
        return new HashSet(0);
    }

    private ImageDisplay getOldNode(ImageDisplay n) {
        if (n.getParentDisplay() == null) {
            for (ImageDisplay child : this.oldNodes) {
                if (child.getParentDisplay() != null) continue;
                return child;
            }
        }
        Object object = n.getHierarchyObject();
        DataObject ho = (DataObject)object;
        Class<?> klass = object.getClass();
        long id = ho.getId();
        for (ImageDisplay child : this.oldNodes) {
            Object oho = child.getHierarchyObject();
            if (!(oho instanceof DataObject) || ((DataObject)oho).getId() != id || !klass.equals(oho.getClass())) continue;
            return child;
        }
        return null;
    }

    SquaryLayout(ViewerSorter sorter, int itemsPerRow) {
        this.setBrowserSize();
        this.sorter = sorter;
        this.itemsPerRow = itemsPerRow;
    }

    static int getBrowserWidth() {
        return browserWidth;
    }

    public void visit(ImageSet node) {
        if (this.oldNodes == null || this.oldNodes.size() == 0) {
            node.restoreDisplay();
            if (node.isSingleViewMode()) {
                return;
            }
            if (node.getChildrenDisplay().size() == 0) {
                LayoutUtils.noChildLayout(node);
                return;
            }
            if (node.containsImages()) {
                LayoutUtils.doSquareGridLayout(node, this.sorter, this.itemsPerRow);
            } else {
                this.visitContainerNode(node);
            }
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getIndex() {
        return 1;
    }

    public void visit(ImageNode node) {
    }

    public void doLayout() {
    }

    public void setOldNodes(Set oldNodes) {
        this.oldNodes = oldNodes;
    }

    public void setImagesPerRow(int number) {
        this.itemsPerRow = number;
    }

    public int getImagesPerRow() {
        return this.itemsPerRow;
    }
}

